/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.jib;

public class JibCommandPacket {
    public static final int SEND_APDU = 137;
    private int commandType;
    private int groupID = 0;
    private int[] data = null;
    int execTimeMS = 0;

    public JibCommandPacket(int n) {
        this.commandType = n;
    }

    public JibCommandPacket(int n, int n2) {
        this.commandType = n;
        this.groupID = n2;
    }

    public void appendData(int n) {
        if (this.data != null) {
            int[] nArray = this.data;
            this.data = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
            this.data[this.data.length - 1] = (byte)n;
        } else {
            this.data = new int[1];
            this.data[0] = n;
        }
    }

    public void appendData(String string) {
        if (this.data != null) {
            int[] nArray = this.data;
            this.data = new int[nArray.length + string.length()];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
            int n = 0;
            while (n < string.length()) {
                this.data[nArray.length + n] = string.charAt(n);
                ++n;
            }
        } else {
            this.data = new int[string.length()];
            int n = 0;
            while (n < string.length()) {
                this.data[n] = string.charAt(n);
                ++n;
            }
        }
    }

    public void appendData(byte[] byArray) {
        if (this.data != null) {
            int[] nArray = this.data;
            this.data = new int[nArray.length + byArray.length];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
            int n = 0;
            while (n < byArray.length) {
                this.data[nArray.length + n] = byArray[n] & 0xFF;
                ++n;
            }
        } else {
            this.data = new int[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                this.data[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
    }

    public void appendData(char[] cArray) {
        if (this.data != null) {
            int[] nArray = this.data;
            this.data = new int[nArray.length + cArray.length];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
            int n = 0;
            while (n < cArray.length) {
                this.data[nArray.length + n] = cArray[n];
                ++n;
            }
        } else {
            this.data = new int[cArray.length];
            int n = 0;
            while (n < cArray.length) {
                this.data[n] = cArray[n];
                ++n;
            }
        }
    }

    public void appendData(int[] nArray) {
        if (this.data != null) {
            int[] nArray2 = this.data;
            this.data = new int[nArray2.length + nArray.length];
            System.arraycopy(nArray2, 0, this.data, 0, nArray2.length);
            System.arraycopy(nArray, 0, this.data, nArray2.length, nArray.length);
        } else {
            this.data = new int[nArray.length];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        }
    }

    public int getExecTime() {
        return this.execTimeMS;
    }

    public int[] getRawData() {
        if (this.data == null) {
            this.data = new int[0];
        }
        int[] nArray = new int[this.data.length + 3];
        System.arraycopy(this.data, 0, nArray, 3, this.data.length);
        nArray[0] = this.data.length + 2;
        nArray[1] = this.commandType;
        nArray[2] = this.groupID;
        return nArray;
    }

    public void setExecTime(int n) {
        this.execTimeMS = n;
    }
}

