/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.cib;

public class CibReturnPacket {
    int csb;
    int groupID;
    int[] data;
    public static final int CSB_OK = 0;
    public static final int CMD_OK = 0;
    public static final int ERR_BAD_comMON_PIN = 129;
    public static final int ERR_BAD_GROUP_PIN = 130;
    public static final int ERR_BAD_PIN_LENGTH = 131;
    public static final int ERR_BAD_NAME_LENGTH = 133;
    public static final int ERR_INSUFFICIENT_RAM = 134;
    public static final int ERR_CIB_LOCKED = 135;
    public static final int ERR_CIB_NOT_LOCKED = 136;
    public static final int ERR_GROUP_LOCKED = 137;
    public static final int ERR_BAD_OBJECT_TYPE = 138;
    public static final int ERR_BAD_OBJECT_ATTR = 139;
    public static final int ERR_BAD_SIZE = 140;
    public static final int ERR_BAD_GROUP_ID = 141;
    public static final int ERR_BAD_OBJECT_ID = 142;
    public static final int ERR_OBJECT_LOCKED = 144;
    public static final int ERR_OBJECT_PRIVATE = 145;
    public static final int ERR_MAX_GROUPS = 146;
    public static final int ERR_MAX_OBJECTS = 147;
    public static final int ERR_NOT_SCRIPT_ID = 148;
    public static final int ERR_OPEN_GROUP = 149;
    public static final int ERR_BAD_GROUP_CRC = 150;
    public static final int ERR_BAD_PACKET_LEN = 151;
    public static final int ERR_GROUP_NOT_FOUND = 152;
    public static final int ERR_NO_KEY_GENERATION = 153;
    public static final int ERR_BAD_MODULUS_SIZE = 154;
    public static final int ERR_KEY_GEN_DISABLED = 155;
    public static final int ERR_EXP_NOT_REL_PRIME = 156;
    public static final int ERR_EXP_SIZE = 157;
    public static final int ERR_RNG_MONOBIT_TEST = 158;
    public static final int ERR_RNG_POKER_TEST = 159;
    public static final int ERR_RNG_RUNS_TEST = 160;
    public static final int ERR_RNG_LONG_RUNS_TEST = 161;
    public static final int ERR_RNG_ERR_STATE = 162;
    public static final int ERR_KAT_FAILURE = 163;
    public static final int ERR_ROM_CRC = 164;
    public static final int ERR_KEY_CONSISTENCY = 165;

    public CibReturnPacket(int n, int n2, int[] nArray) {
        this.csb = n;
        this.groupID = n2;
        if (nArray != null) {
            this.data = new int[nArray.length];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        }
    }

    public CibReturnPacket(int[] nArray) {
        this.csb = nArray[0];
        this.groupID = nArray[1];
        this.data = new int[nArray.length - 3];
        System.arraycopy(nArray, 3, this.data, 0, nArray.length - 3);
    }

    public int getCSB() {
        return this.csb;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public byte[] getReturnBytes() {
        byte[] byArray = new byte[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            byArray[n] = (byte)this.data[n];
            ++n;
        }
        return byArray;
    }

    public char[] getReturnChars() {
        char[] cArray = new char[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            cArray[n] = (char)this.data[n];
            ++n;
        }
        return cArray;
    }

    public char[] getReturnChars(int n, int n2) {
        char[] cArray = new char[this.data.length - n];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)this.data[n3 + n];
            ++n3;
        }
        return cArray;
    }

    public int getReturnInteger() {
        return this.getReturnInteger(0);
    }

    public int getReturnInteger(int n) {
        return this.data[n];
    }

    public int[] getReturnInts() {
        return this.data;
    }

    public int getReturnShort() {
        return this.getReturnShort(0);
    }

    public int getReturnShort(int n) {
        return this.data[n];
    }

    public String getReturnString() {
        return new String(this.getReturnChars());
    }
}

