/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.cib;

import com.ibutton.cib.CibButton;
import com.ibutton.cib.CibCommandInterpreterException;
import com.ibutton.cib.CibCommandPacket;
import com.ibutton.cib.CibKeySet;
import com.ibutton.cib.CibObject;
import com.ibutton.cib.CibPIN;
import com.ibutton.cib.CibReturnPacket;

public class CibGroup {
    CibPIN groupPIN = null;
    CibButton button;
    int id;
    String name;
    int attrib;
    CibReturnPacket lastReturn;

    public CibGroup(CibButton cibButton, int n, String string) {
        this.button = cibButton;
        this.id = n;
        this.name = string;
    }

    public CibGroup(CibButton cibButton, int n, String string, CibPIN cibPIN, int n2) {
        this.button = cibButton;
        this.id = n;
        this.name = string;
        this.groupPIN = cibPIN;
        this.attrib = n2;
    }

    public void changePIN(CibPIN cibPIN) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(4, this.id);
        int n = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(cibPIN.getPINLength());
        cibCommandPacket.appendData(cibPIN.getPIN());
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
        this.setPIN(cibPIN);
    }

    public void checkGroupCRC() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(20, this.id);
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }

    public CibObject createCiBObject(int n, int n2, char[] cArray) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(5, this.id);
        int n3 = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n3);
        if (n3 > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(n);
        cibCommandPacket.appendData(n2);
        cibCommandPacket.appendData(cArray.length);
        if (cArray != null) {
            cibCommandPacket.appendData(cArray);
        }
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return new CibObject(this, cibReturnPacket.getReturnInteger(), n, n2, cArray);
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public void deleteGroup() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(15, this.id);
        int n = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }

    public CibKeySet generateRSAKeySet(int n) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(26, this.id);
        int n2 = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n2);
        if (n2 > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(n);
        cibCommandPacket.setExecTime(4000);
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return new CibKeySet(cibReturnPacket.getReturnShort(0), cibReturnPacket.getReturnShort(1), cibReturnPacket.getReturnShort(2));
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public CibKeySet generateRSAKeySetNP(int n) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(28, this.id);
        int n2 = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n2);
        if (n2 > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(n);
        cibCommandPacket.setExecTime(4000);
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return new CibKeySet(cibReturnPacket.getReturnInteger(0), cibReturnPacket.getReturnInteger(1), cibReturnPacket.getReturnInteger(2));
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public CibKeySet generateRSAModAndExp(int n, int n2) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(27, this.id);
        int n3 = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n3);
        if (n3 > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(n);
        cibCommandPacket.appendData(n2);
        cibCommandPacket.setExecTime(4000);
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return new CibKeySet(cibReturnPacket.getReturnInteger(0), n2, cibReturnPacket.getReturnInteger(1));
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public int generateRandomExponent(int n) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(30, this.id);
        int n2 = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n2);
        if (n2 > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        cibCommandPacket.appendData(n);
        cibCommandPacket.setExecTime(250);
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return cibReturnPacket.getReturnInteger();
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public int getGroupID() {
        return this.id;
    }

    public CibReturnPacket getLastReturn() {
        return this.lastReturn;
    }

    public CibObject getObject(int n) {
        CibObject cibObject = new CibObject(this, n);
        return cibObject;
    }

    public void lockGroup() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(10, this.id);
        int n = this.groupPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.groupPIN.getPIN());
        }
        this.lastReturn = cibReturnPacket = this.button.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }

    public void setPIN(CibPIN cibPIN) {
        this.groupPIN = cibPIN;
    }
}

