/*
 * Decompiled with CFR 0.152.
 */
package com.ibutton.cib;

import com.ibutton.Access;
import com.ibutton.cib.CibCommandInterpreterException;
import com.ibutton.cib.CibCommandPacket;
import com.ibutton.cib.CibGroup;
import com.ibutton.cib.CibMessage;
import com.ibutton.cib.CibPIN;
import com.ibutton.cib.CibReturnPacket;
import com.ibutton.iButton;

public class CibButton
extends iButton {
    public static final int PIN_TO_ERASE = 1;
    public static final int PIN_TO_CREATE = 2;
    CibPIN commonPIN;
    int flags;
    int groupNum;
    CibReturnPacket lastReturn;

    public CibButton(Access access, int[] nArray) {
        super(access, nArray);
    }

    public void changePIN(CibPIN cibPIN, int n) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(1);
        int n2 = this.commonPIN.getPINLength();
        cibCommandPacket.appendData(n2);
        if (n2 > 0) {
            cibCommandPacket.appendData(this.commonPIN.getPIN());
        }
        cibCommandPacket.appendData(cibPIN.getPINLength());
        cibCommandPacket.appendData(cibPIN.getPIN());
        cibCommandPacket.appendData(n);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
        this.setPIN(cibPIN);
    }

    public CibGroup createTransactionGroup(String string, CibPIN cibPIN, int n) throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(3);
        int n2 = this.commonPIN.getPINLength();
        cibCommandPacket.appendData(n2);
        if (n2 > 0) {
            cibCommandPacket.appendData(this.commonPIN.getPIN());
        }
        cibCommandPacket.appendData(string.length());
        cibCommandPacket.appendData(string);
        int n3 = cibPIN.getPINLength();
        cibCommandPacket.appendData(n3);
        if (n3 > 0) {
            cibCommandPacket.appendData(cibPIN.getPIN());
        }
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return new CibGroup(this, cibReturnPacket.getGroupID(), string, cibPIN, n);
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public void disableKeySetGeneration() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(25);
        int n = this.commonPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.commonPIN.getPIN());
        }
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }

    public CibReturnPacket dispatchCommand(CibCommandPacket cibCommandPacket) {
        this.sendMessage(cibCommandPacket.getRawData(), cibCommandPacket.getExecTime());
        CibMessage cibMessage = this.receiveMessage();
        return new CibReturnPacket(cibMessage.getRawData());
    }

    public CibGroup getGroup(int n) {
        CibGroup cibGroup = new CibGroup(this, n, this.queryGroupName(n));
        return cibGroup;
    }

    public CibGroup getGroup(String string) {
        CibGroup cibGroup = new CibGroup(this, this.queryGroupID(string), string);
        return cibGroup;
    }

    public int getGroupCount() {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(17);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
        return cibReturnPacket.getReturnInteger();
    }

    public CibReturnPacket getLastReturn() {
        return this.lastReturn;
    }

    public char[] initializeJiB() {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(136);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return cibReturnPacket.getReturnChars();
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public void lockButton() throws CibCommandInterpreterException {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(9);
        int n = this.commonPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.commonPIN.getPIN());
        }
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }

    public void masterErase() {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(2);
        int n = this.commonPIN.getPINLength();
        cibCommandPacket.appendData(n);
        if (n > 0) {
            cibCommandPacket.appendData(this.commonPIN.getPIN());
        }
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
        this.setPIN(null);
    }

    public int queryGroupID(String string) {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(16);
        cibCommandPacket.appendData(string.length());
        cibCommandPacket.appendData(string);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return cibReturnPacket.getGroupID();
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public String queryGroupName(int n) {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(14, n);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            if (Character.isLetterOrDigit(cibReturnPacket.getReturnString().charAt(0))) {
                return cibReturnPacket.getReturnString();
            }
            return cibReturnPacket.getReturnString().substring(1);
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public String readFirmwareVersionID() {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(22);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return cibReturnPacket.getReturnString();
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public int readFreeRAM() {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(23);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
        return cibReturnPacket.getReturnInteger(1) << 8 | cibReturnPacket.getReturnInteger(0);
    }

    public byte[] readRandomBytes(int n) {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(21);
        cibCommandPacket.appendData(n);
        cibCommandPacket.setExecTime(250);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() == 0) {
            return cibReturnPacket.getReturnBytes();
        }
        throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
    }

    public int readRealTimeClock() {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(18);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
        return cibReturnPacket.getReturnInteger(3) << 24 | cibReturnPacket.getReturnInteger(2) << 16 | cibReturnPacket.getReturnInteger(1) << 8 | cibReturnPacket.getReturnInteger(0);
    }

    public CibMessage receiveMessage() {
        CibMessage cibMessage = new CibMessage(this.getAccess());
        int n = cibMessage.receive(2048);
        return cibMessage;
    }

    public void sendMessage(int[] nArray, int n) {
        this.sendMessage(nArray, nArray.length, n);
    }

    public void sendMessage(int[] nArray, int n, int n2) {
        CibMessage cibMessage = new CibMessage(this.getAccess(), nArray, n, n2);
        cibMessage.send();
    }

    public void setPIN(CibPIN cibPIN) {
        if (cibPIN != null) {
            this.commonPIN = cibPIN;
        } else {
            this.commonPIN.setPIN(null);
        }
    }

    public void testRNG() {
        CibReturnPacket cibReturnPacket;
        CibCommandPacket cibCommandPacket = new CibCommandPacket(31);
        cibCommandPacket.setExecTime(4000);
        this.lastReturn = cibReturnPacket = this.dispatchCommand(cibCommandPacket);
        if (cibReturnPacket.getCSB() != 0) {
            throw new CibCommandInterpreterException(cibReturnPacket.getCSB());
        }
    }
}

