/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.ResourceFactory;
import com.symantec.itools.javax.swing.models.StringComboBoxModel;
import java.io.CharArrayReader;
import java.io.StreamTokenizer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.JComboBox;

class TimeConverter {
    static ResourceBundle resource = ResourceFactory.getResources();
    static final String HOUR_STRING = resource.getString("Hour");
    static final String MINUTE_STRING = resource.getString("Minute");
    static final String SECOND_STRING = resource.getString("Second");
    static final String INFINITE_TIME_STRING = resource.getString("Always On");
    static final String MORNING_STRING = "AM";
    static final String AFTERNOON_STRING = "PM";
    static final int INFINITE_TIME = Integer.MAX_VALUE;
    static final int NO_VALUE = -1;
    int hours;
    int minutes;
    int seconds;
    int totalSeconds;
    int totalMinutes;
    boolean isInfinite;
    boolean isMorning;

    TimeConverter() {
    }

    String construct12HourTime(int minutesSinceMidnight) {
        int hours = minutesSinceMidnight / 60 % 24;
        int minutes = minutesSinceMidnight % 60;
        return this.construct12HourTime(hours, minutes);
    }

    String construct12HourTime(int hours, int minutes) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(11, hours);
        gc.set(12, minutes);
        DateFormat df = DateFormat.getTimeInstance(3);
        return df.format(gc.getTime());
    }

    String construct24HourTime(int hr, int min) {
        return String.valueOf(hr) + ":" + TimeConverter.formatMinutes(min);
    }

    static String constructDuration(int sec) {
        if (sec == Integer.MAX_VALUE) {
            return INFINITE_TIME_STRING;
        }
        int hr = sec / 3600;
        if (sec - hr * 60 * 60 == 0) {
            return String.valueOf(hr) + " " + HOUR_STRING;
        }
        int min = sec / 60;
        if (sec - min * 60 == 0) {
            return String.valueOf(min) + " " + MINUTE_STRING;
        }
        return String.valueOf(sec) + " " + SECOND_STRING;
    }

    static int convert12HourTimeToMinutesSinceMidnight(int hr, int min, boolean isMorning) {
        if (hr == 12) {
            hr -= 12;
        }
        if (!isMorning) {
            hr += 12;
        }
        return hr * 60 + min;
    }

    void convertMinutesSinceMidnightTo12HourTime(int minSinceMidnight) {
        this.hours = minSinceMidnight / 60;
        if (this.hours < 12) {
            this.isMorning = true;
            if (this.hours == 0) {
                this.hours = 12;
            }
        } else {
            this.isMorning = false;
            if (this.hours > 12) {
                this.hours -= 12;
            }
        }
        this.minutes = minSinceMidnight % 60;
    }

    static String formatMinutes(int min) {
        DecimalFormat fmt = new DecimalFormat();
        fmt.setMinimumIntegerDigits(2);
        return fmt.format(min);
    }

    private boolean isSpecialTimeString(String s) {
        return s.equals(INFINITE_TIME_STRING);
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            TimeConverter tc = new TimeConverter();
            if (tc.parseDuration(args[i])) {
                if (tc.isInfinite) {
                    System.out.println(String.valueOf(args[i]) + " = Infinite");
                } else {
                    System.out.println(String.valueOf(args[i]) + " = " + tc.totalSeconds + " seconds");
                }
            } else {
                System.out.println(String.valueOf(args[i]) + " is not a valid duration");
            }
            ++i;
        }
    }

    boolean parse24HourTime(String time) {
        return false;
    }

    boolean parseDuration(String time) {
        this.totalMinutes = 0;
        this.totalSeconds = 0;
        this.isInfinite = this.isSpecialTimeString(time);
        if (this.isInfinite) {
            this.totalSeconds = Integer.MAX_VALUE;
            return true;
        }
        StreamTokenizer st = new StreamTokenizer(new CharArrayReader(time.toCharArray()));
        double magnitude = 0.0;
        String unitString = null;
        try {
            int token = -1;
            token = st.nextToken();
            if (token != -2) {
                return false;
            }
            magnitude = st.nval;
            if (magnitude < 0.0) {
                return false;
            }
            token = st.nextToken();
            if (token != -3) {
                return false;
            }
            unitString = st.sval;
        }
        catch (Exception exception) {
            return false;
        }
        if (unitString.equals(HOUR_STRING)) {
            this.totalSeconds = new Double(magnitude * 3600.0).intValue();
        } else if (unitString.equals(MINUTE_STRING)) {
            this.totalSeconds = new Double(magnitude * 60.0).intValue();
        } else if (unitString.equals(SECOND_STRING)) {
            this.totalSeconds = new Double(magnitude).intValue();
        } else {
            return false;
        }
        this.totalMinutes = this.totalSeconds / 60;
        return true;
    }

    void setComboDuration(int seconds, JComboBox cbox) {
        int count = cbox.getItemCount();
        int i = 0;
        while (i < count) {
            String durationString = (String)cbox.getItemAt(i);
            this.parseDuration(durationString);
            if (seconds == Integer.MAX_VALUE && this.isInfinite || seconds == this.totalSeconds) break;
            ++i;
        }
        if (i < count) {
            cbox.setSelectedIndex(i);
        } else {
            ((StringComboBoxModel)cbox.getModel()).addElement((Object)TimeConverter.constructDuration(seconds));
            cbox.setSelectedIndex(i);
        }
    }
}

