/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.ConfigFileParser;
import com.sun.dt.dtpower.ConfigFileWriter;
import com.sun.dt.dtpower.DevDB;
import com.sun.dt.dtpower.Device;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

class PowerStateChanger {
    static final String TMP_CONFIG_BASENAME = "power.conf";
    static final String TMP_CONFIG_DIR = "/tmp";
    static final String CONFIG_PROGRAM_CMD = "/usr/sbin/pmconfig -f ";
    File tmpConfigFile = File.createTempFile("power.conf", null, new File("/tmp"));
    ConfigFileWriter cfw;
    Vector lines;
    Vector otherDevs;
    StringBuffer errMessages;

    PowerStateChanger() throws IOException {
        this.tmpConfigFile.deleteOnExit();
        this.cfw = new ConfigFileWriter(this.tmpConfigFile.getPath());
        this.lines = new Vector();
        this.otherDevs = new Vector();
        this.errMessages = new StringBuffer(1000);
    }

    void changePowerState(DevDB db) throws IOException, InterruptedException {
        int aByte;
        this.saveOtherLines("/etc/power.conf", db);
        int i = 0;
        while (i < this.lines.size()) {
            this.cfw.writeLine((String)this.lines.elementAt(i));
            ++i;
        }
        this.cfw.writeLine(this.cfw.buildAutopmCommand(db.isAutopmEnabled()));
        if (db.isSystemThresholdModified()) {
            this.cfw.writeLine(this.cfw.buildSysThresholdCommand(db.getSystemThreshold()));
        }
        this.cfw.writeLine(this.cfw.buildAutoshutdownCommand(db));
        int systemThreshold = db.getSystemThreshold();
        Device[] devs = db.getDriveDevices();
        int i2 = 0;
        while (i2 < devs.length) {
            if (devs[i2].thresholdBasis == 1) {
                this.cfw.writeLine(this.cfw.buildDeviceThresholdsCommand(db, devs[i2]));
                int j = 0;
                while (j < this.otherDevs.size()) {
                    if (((Device)this.otherDevs.elementAt(j)).getPhysicalName().equals(devs[i2].getPhysicalName())) {
                        this.otherDevs.remove(j);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.otherDevs.size()) {
            this.cfw.writeLine(this.cfw.buildDeviceThresholdsCommand(db, (Device)this.otherDevs.elementAt(i3)));
            ++i3;
        }
        this.cfw.close();
        Process helper = Runtime.getRuntime().exec(CONFIG_PROGRAM_CMD + this.tmpConfigFile.getPath());
        BufferedInputStream errStream = new BufferedInputStream(helper.getErrorStream());
        while ((aByte = errStream.read()) != -1) {
            this.errMessages.append((char)aByte);
        }
        if (this.errMessages.length() > 0 || helper.waitFor() != 0) {
            throw new IOException("pmconfig failed");
        }
    }

    private void saveOtherLines(String path, DevDB db) {
        ConfigFileParser cfp = null;
        try {
            cfp = new ConfigFileParser(path);
            block11: while (true) {
                int cmdType = cfp.identifyNext();
                switch (cmdType) {
                    default: {
                        continue block11;
                    }
                    case 7: {
                        this.lines.addElement(cfp.getLine());
                        continue block11;
                    }
                    case 8: {
                        this.lines.addElement(cfp.getLine());
                        continue block11;
                    }
                    case 2: {
                        cfp.parseDevThresholds(cfp.getLine());
                        Device confDev = cfp.getDevice();
                        Device dev = db.getDevice(confDev.getPhysicalName());
                        if (dev == null) continue block11;
                        this.otherDevs.addElement(dev);
                        continue block11;
                    }
                    case 6: {
                        this.lines.addElement(cfp.getLine());
                        continue block11;
                    }
                    case 10: {
                        this.lines.addElement(cfp.getLine());
                        continue block11;
                    }
                    case 4: {
                        this.lines.addElement(cfp.getLine());
                        continue block11;
                    }
                    case 63: {
                        return;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Error reading/parsing " + path + " on following line:");
            System.out.println(cfp.getLine());
            System.exit(2);
            return;
        }
    }
}

