/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.Xsession;
import com.sun.dt.dtpower.Autoshutdown;
import com.sun.dt.dtpower.ConfigFileParser;
import com.sun.dt.dtpower.DevDB;
import com.sun.dt.dtpower.Device;
import com.sun.dt.dtpower.DtpowerException;
import com.sun.dt.dtpower.PowerStateChanger;
import com.sun.dt.dtpower.ResourceFactory;
import com.sun.dt.dtpower.SystemInterrogator;
import com.sun.dt.dtpower.TimeConverter;
import com.symantec.itools.awt.GridBagConstraintsD;
import com.symantec.itools.javax.swing.borders.TitledBorder;
import com.symantec.itools.javax.swing.models.StringComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.ParseException;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import symantec.itools.awt.shape.HorizontalLine;

public class Dtpower
extends JFrame {
    static final String LINK_DIRECTORY = "/var/dt/dtpower";
    static final String SCHEME_DIRECTORY = "/var/dt/dtpower/schemes";
    static final String SCHEME_LINK_FILE = "_current_scheme";
    static final String CUSTOM_SCHEME = "*Customized*";
    static final String blankShutdownLabel = "                                                                                         ";
    DevDB db;
    DevDB dbSystem;
    DevDB dbScheme;
    File schemeDir;
    Autoshutdown shutdown;
    SystemInterrogator sysint;
    SymAction lSymAction;
    String currentScheme;
    File schemeLinkFile;
    File currentSchemeFile;
    File selectedSchemeFile;
    String selectedScheme;
    JTextField systemSleepTextField;
    JTextField drivesTextField;
    JTextField monitorsTextField;
    boolean monitorsCustomizationSet = false;
    boolean monitorsClassEnabled = false;
    boolean monitorsEdited = false;
    boolean drivesClassEnabled = false;
    boolean schemeOverridden = false;
    boolean startup = true;
    boolean edited = false;
    TimeConverter tc = null;
    private static final String HELPSET = "help/PwrGUI.hs";
    private static HelpBroker helpBroker;
    static ResourceBundle resource;
    boolean expandedScreenRequested = false;
    String displayString = null;
    Rectangle bounds;
    boolean frameSizeAdjusted = false;
    JPanel basicPanel = new JPanel();
    KeyedComboBox schemeComboBox = new KeyedComboBox();
    JLabel schemeDescriptionLabel = new JLabel();
    JLabel autoshutdownLabel = new JLabel();
    JPanel JPanel2 = new JPanel();
    JButton moreLessButton = new JButton();
    JPanel JPanel3 = new JPanel();
    JPanel JPanel5 = new JPanel();
    JPanel JPanel6 = new JPanel();
    HorizontalLine horizontalLine2 = new HorizontalLine();
    JTabbedPane JTabbedPane1 = new JTabbedPane();
    JPanel JPanel8 = new JPanel();
    JPanel JPanel10 = new JPanel();
    JLabel systemSleepLabel = new JLabel();
    JComboBox systemSleepComboBox = new JComboBox();
    JPanel JPanel11 = new JPanel();
    JLabel JLabel3 = new JLabel();
    JCheckBox monitorsCheckBox = new JCheckBox();
    JComboBox monitorsComboBox = new JComboBox();
    JCheckBox drivesCheckBox = new JCheckBox();
    JComboBox drivesComboBox = new JComboBox();
    JPanel JPanel12 = new JPanel();
    JPanel JPanel7 = new JPanel();
    JCheckBox shutdownCheckBox = new JCheckBox();
    JButton shutdownEditButton = new JButton();
    JPanel JPanel4 = new JPanel();
    HorizontalLine horizontalLine1 = new HorizontalLine();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JButton helpButton = new JButton();
    TitledBorder titledBorder1 = new TitledBorder();
    StringComboBoxModel stringComboBoxModel1 = new StringComboBoxModel();
    StringComboBoxModel stringComboBoxModel2 = new StringComboBoxModel();
    StringComboBoxModel stringComboBoxModel3 = new StringComboBoxModel();
    StringComboBoxModel stringComboBoxModel4 = new StringComboBoxModel();

    static {
        resource = ResourceFactory.getResources();
    }

    public Dtpower() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setSize(405, 564);
        ((Component)this).setVisible(false);
        this.basicPanel.setBorder((Border)this.titledBorder1);
        this.basicPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.basicPanel, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.basicPanel.add((Component)this.schemeComboBox, new GridBagConstraintsD(-1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.schemeDescriptionLabel.setText("Scheme Description Label");
        this.basicPanel.add((Component)this.schemeDescriptionLabel, new GridBagConstraintsD(-1, -1, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.schemeDescriptionLabel.setForeground(Color.black);
        this.schemeDescriptionLabel.setFont(new Font("SansSerif", 0, 12));
        this.autoshutdownLabel.setText(" ");
        this.getContentPane().add((Component)this.autoshutdownLabel, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        this.autoshutdownLabel.setForeground(Color.black);
        this.autoshutdownLabel.setFont(new Font("SansSerif", 0, 12));
        this.JPanel2.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.JPanel2, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.moreLessButton.setText(resource.getString("More Button"));
        this.moreLessButton.setActionCommand("More");
        this.JPanel2.add((Component)this.moreLessButton, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.JPanel3.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.JPanel3, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.JPanel5.setLayout(new GridBagLayout());
        this.JPanel3.add((Component)this.JPanel5, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.JPanel6.setLayout(new GridBagLayout());
        this.JPanel5.add((Component)this.JPanel6, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        try {
            this.horizontalLine2.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.JPanel6.add((Component)this.horizontalLine2, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.JPanel6.add((Component)this.JTabbedPane1, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.JPanel8.setLayout(new GridBagLayout());
        this.JTabbedPane1.add(this.JPanel8);
        this.JPanel10.setLayout(new GridBagLayout());
        this.JPanel8.add((Component)this.JPanel10, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.systemSleepLabel.setText(resource.getString("Device Idle Time Before Power Saving Starts:"));
        this.JPanel10.add((Component)this.systemSleepLabel, new GridBagConstraintsD(-1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.systemSleepComboBox.setModel(this.stringComboBoxModel2);
        this.systemSleepComboBox.setEditable(true);
        this.JPanel10.add((Component)this.systemSleepComboBox, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.JPanel11.setLayout(new GridBagLayout());
        this.JPanel8.add((Component)this.JPanel11, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.JLabel3.setText(resource.getString("Override Device Idle Time For:"));
        this.JPanel11.add((Component)this.JLabel3, new GridBagConstraintsD(-1, -1, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.monitorsCheckBox.setText(resource.getString("Displays"));
        this.monitorsCheckBox.setActionCommand("Displays Sleep After Idling For:");
        this.JPanel11.add((Component)this.monitorsCheckBox, new GridBagConstraintsD(-1, -1, 1, 1, 0.4, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.monitorsComboBox.setModel(this.stringComboBoxModel3);
        this.monitorsComboBox.setEditable(true);
        this.monitorsComboBox.setEnabled(false);
        this.JPanel11.add((Component)this.monitorsComboBox, new GridBagConstraintsD(-1, -1, 0, 1, 0.1, 0.0, 13, 2, new Insets(0, 5, 5, 15), 0, 0));
        this.drivesCheckBox.setText(resource.getString("Disks"));
        this.drivesCheckBox.setActionCommand("Disk Drives Sleep After Idling For:");
        this.JPanel11.add((Component)this.drivesCheckBox, new GridBagConstraintsD(-1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.drivesComboBox.setModel(this.stringComboBoxModel4);
        this.drivesComboBox.setEditable(true);
        this.drivesComboBox.setEnabled(false);
        this.JPanel11.add((Component)this.drivesComboBox, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 15), 0, 0));
        this.JPanel12.setLayout(new GridBagLayout());
        this.JPanel8.add((Component)this.JPanel12, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.JTabbedPane1.setSelectedIndex(0);
        this.JTabbedPane1.setSelectedComponent(this.JPanel8);
        try {
            this.JTabbedPane1.setTitleAt(0, resource.getString("Quick Edit"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.JPanel7.setLayout(new GridBagLayout());
        this.JPanel5.add((Component)this.JPanel7, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.shutdownCheckBox.setText(resource.getString("Autoshutdown Enabled"));
        this.shutdownCheckBox.setActionCommand("Enabled");
        this.JPanel7.add((Component)this.shutdownCheckBox, new GridBagConstraintsD(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.shutdownEditButton.setText(resource.getString("Edit Button"));
        this.shutdownEditButton.setActionCommand("Edit");
        this.shutdownEditButton.setEnabled(false);
        this.JPanel7.add((Component)this.shutdownEditButton, new GridBagConstraintsD(1, 1, -1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.JPanel4.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.JPanel4, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        try {
            this.horizontalLine1.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.JPanel4.add((Component)this.horizontalLine1, new GridBagConstraintsD(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.okButton.setText(resource.getString("OK Button"));
        this.okButton.setActionCommand("OK");
        this.JPanel4.add((Component)this.okButton, new GridBagConstraintsD(-1, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText(resource.getString("Cancel Button"));
        this.cancelButton.setActionCommand("Cancel");
        this.JPanel4.add((Component)this.cancelButton, new GridBagConstraintsD(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.helpButton.setText(resource.getString("Help Button"));
        this.helpButton.setActionCommand("Help");
        this.JPanel4.add((Component)this.helpButton, new GridBagConstraintsD(-1, -1, 0, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.titledBorder1.setTitle(resource.getString("Current Power Saving Scheme"));
        String[] tempString = new String[]{"15 " + TimeConverter.MINUTE_STRING, "30 " + TimeConverter.MINUTE_STRING, "1 " + TimeConverter.HOUR_STRING, "2 " + TimeConverter.HOUR_STRING, "4 " + TimeConverter.HOUR_STRING, TimeConverter.INFINITE_TIME_STRING};
        this.stringComboBoxModel2.setItems(tempString);
        String[] tempString2 = new String[]{"15 " + TimeConverter.MINUTE_STRING, "30 " + TimeConverter.MINUTE_STRING, "1 " + TimeConverter.HOUR_STRING, "2 " + TimeConverter.HOUR_STRING, TimeConverter.INFINITE_TIME_STRING};
        this.stringComboBoxModel3.setItems(tempString2);
        String[] tempString3 = new String[]{"15 " + TimeConverter.MINUTE_STRING, "30 " + TimeConverter.MINUTE_STRING, "1 " + TimeConverter.HOUR_STRING, "2 " + TimeConverter.HOUR_STRING, TimeConverter.INFINITE_TIME_STRING};
        this.stringComboBoxModel4.setItems(tempString3);
        this.lSymAction = new SymAction();
        this.moreLessButton.addActionListener(this.lSymAction);
        this.shutdownEditButton.addActionListener(this.lSymAction);
        this.monitorsCheckBox.addActionListener(this.lSymAction);
        this.drivesCheckBox.addActionListener(this.lSymAction);
        this.shutdownCheckBox.addActionListener(this.lSymAction);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.monitorsComboBox.addActionListener(this.lSymAction);
        this.systemSleepComboBox.addActionListener(this.lSymAction);
        this.okButton.addActionListener(this.lSymAction);
        this.cancelButton.addActionListener(this.lSymAction);
        this.helpButton.addActionListener(this.lSymAction);
        this.tc = new TimeConverter();
        ComboBoxEditor cbEditor = this.systemSleepComboBox.getEditor();
        cbEditor.addActionListener(this.lSymAction);
        this.systemSleepTextField = (JTextField)cbEditor.getEditorComponent();
        cbEditor = this.drivesComboBox.getEditor();
        cbEditor.addActionListener(this.lSymAction);
        this.drivesTextField = (JTextField)cbEditor.getEditorComponent();
        cbEditor = this.monitorsComboBox.getEditor();
        cbEditor.addActionListener(this.lSymAction);
        this.monitorsTextField = (JTextField)cbEditor.getEditorComponent();
        ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().getImage("icons/SDtpowermgr.48.gif"));
        try {
            this.dbSystem = new DevDB(1);
        }
        catch (DtpowerException e) {
            JOptionPane.showMessageDialog(this, resource.getString(e.getMessage()));
            System.exit(1);
        }
        this.db = this.dbSystem;
        this.initializeSchemeList();
        SchemeComboBox_startupListener listener = new SchemeComboBox_startupListener();
        this.schemeComboBox.addActionListener(listener);
        this.processInitialScheme();
        this.schemeComboBox.removeActionListener(listener);
        this.schemeComboBox.addActionListener(new SchemeComboBox_actionListener());
        this.systemSleepComboBox.setEnabled(this.db.isPmEditable());
        this.drivesCheckBox.setEnabled(this.db.isPmEditable());
        this.shutdownCheckBox.setEnabled(this.db.isCprEditable() && this.db.isShutdownCapable());
        this.shutdownEditButton.setEnabled(this.db.isCprEditable() && this.db.isShutdownCapable());
        this.configureComponents();
        this.setEdited(this.schemeOverridden);
        this.startup = false;
    }

    public Dtpower(String sTitle) {
        this();
        this.setTitle(sTitle);
    }

    void Dtpower_windowClosing(WindowEvent event) {
        if (this.isEdited() || this.shutdown != null && this.shutdown.isEdited()) {
            JOptionPane.showMessageDialog(this, resource.getString("Unsaved edits Dialog"));
        } else {
            this.exitApplication();
        }
    }

    void acceptChanges() {
        Device displayDevice;
        FileWriter wtr = null;
        if (this.db.isPmEditable() || this.db.isCprEditable()) {
            try {
                PowerStateChanger changer = new PowerStateChanger();
                changer.changePowerState(this.db);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, resource.getString("Error encountered changing power state."));
                System.exit(1);
            }
        }
        if ((displayDevice = this.db.getDisplayDevice()) != null && this.monitorsEdited) {
            try {
                this.db.setDisplayThresholds(displayDevice);
            }
            catch (DtpowerException e) {
                JOptionPane.showMessageDialog(this, resource.getString(e.getMessage()));
                System.exit(1);
            }
        }
        if (this.isEdited()) {
            this.selectedScheme = "";
        }
        if (CUSTOM_SCHEME.equals(this.selectedScheme)) {
            this.selectedScheme = "";
        }
        try {
            wtr = new FileWriter(this.schemeLinkFile.getPath());
            wtr.write(this.selectedScheme);
            wtr.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, String.valueOf(resource.getString("Error writing ")) + "/etc/power.conf" + ": " + e.getMessage());
            System.exit(1);
        }
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar menuBar = this.getRootPane().getJMenuBar();
        int menuBarHeight = 0;
        if (menuBar != null) {
            menuBarHeight = menuBar.getPreferredSize().height;
        }
        ((Component)this).setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    void applyShutdownEdits() {
        this.db.setShutdownIdleMin(this.shutdown.getIdleMinutes());
        this.db.setShutdownPeriodStart(this.shutdown.getStartMinutes());
        this.db.setShutdownPeriodEnd(this.shutdown.getEndMinutes());
        this.db.setStatefileDirectory(this.shutdown.getStatefileDirectory());
        this.db.enableWakeup(this.shutdown.isWakeupEnabled());
        if (this.shutdown.isWakeupEnabled() && !this.shutdownCheckBox.isSelected()) {
            this.shutdownCheckBox.setSelected(true);
        }
        if (!this.startup) {
            this.setEdited(true);
        }
    }

    private String buildShutdownNotice(int startTime, int endTime) {
        return String.valueOf(resource.getString("Autoshutdown enabled between ")) + this.tc.construct12HourTime(startTime) + resource.getString(" and ") + this.tc.construct12HourTime(endTime) + "     ";
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.exitApplication();
    }

    void configureComponents() {
        int systemThreshold = this.db.getSystemThreshold();
        int comboTime = -1;
        if (this.db.isSystemThresholdEnabled()) {
            comboTime = systemThreshold;
            this.tc.setComboDuration(systemThreshold, this.systemSleepComboBox);
        } else {
            comboTime = Integer.MAX_VALUE;
            this.tc.setComboDuration(comboTime, this.systemSleepComboBox);
            this.db.setSystemThreshold(systemThreshold);
        }
        Device displayDevice = this.db.getDisplayDevice();
        boolean selectCheckbox = false;
        int threshold = systemThreshold;
        int deviceThreshold = -1;
        if (displayDevice == null) {
            this.monitorsCheckBox.setEnabled(false);
        } else {
            deviceThreshold = displayDevice.getThreshold();
            if (comboTime == Integer.MAX_VALUE) {
                if (displayDevice.isEnabled()) {
                    if (deviceThreshold == 0) {
                        threshold = systemThreshold;
                    } else {
                        selectCheckbox = true;
                        threshold = deviceThreshold;
                    }
                } else {
                    threshold = deviceThreshold == 0 ? Integer.MAX_VALUE : Integer.MAX_VALUE;
                }
            } else if (displayDevice.isEnabled()) {
                if (deviceThreshold == 0) {
                    selectCheckbox = true;
                    threshold = Integer.MAX_VALUE;
                } else if (deviceThreshold == systemThreshold) {
                    threshold = deviceThreshold;
                } else {
                    selectCheckbox = true;
                    threshold = deviceThreshold;
                }
            } else if (deviceThreshold == 0) {
                selectCheckbox = true;
                threshold = Integer.MAX_VALUE;
            } else if (deviceThreshold == systemThreshold) {
                selectCheckbox = true;
                threshold = Integer.MAX_VALUE;
            } else {
                selectCheckbox = true;
                threshold = Integer.MAX_VALUE;
            }
        }
        this.monitorsCheckBox.setSelected(selectCheckbox);
        this.monitorsComboBox.setEnabled(selectCheckbox);
        this.tc.setComboDuration(threshold, this.monitorsComboBox);
        this.monitorsCustomizationSet = true;
        boolean drivesClassExists = this.db.isDrivesClassEnabled();
        deviceThreshold = this.db.getDrivesThreshold();
        selectCheckbox = false;
        if (!drivesClassExists) {
            this.drivesCheckBox.setEnabled(this.db.isPmEditable() && this.db.getDriveDevices().length != 0);
            this.tc.setComboDuration(systemThreshold, this.drivesComboBox);
            this.drivesComboBox.setEnabled(false);
            this.drivesCheckBox.setSelected(false);
            this.drivesCheckBox_actionPerformed(new ActionEvent(this.drivesCheckBox, 1001, "dummy"));
            this.drivesComboBox.addActionListener(this.lSymAction);
        } else {
            if (!this.db.isAutopmEnabled()) {
                threshold = systemThreshold != Integer.MAX_VALUE ? (deviceThreshold != Integer.MAX_VALUE ? deviceThreshold : systemThreshold) : (deviceThreshold != Integer.MAX_VALUE ? deviceThreshold : systemThreshold);
            } else if (systemThreshold != Integer.MAX_VALUE) {
                if (deviceThreshold != Integer.MAX_VALUE) {
                    selectCheckbox = true;
                    threshold = deviceThreshold;
                } else {
                    selectCheckbox = true;
                    threshold = deviceThreshold;
                }
            } else if (deviceThreshold != Integer.MAX_VALUE) {
                selectCheckbox = true;
                threshold = deviceThreshold;
            } else {
                threshold = systemThreshold;
            }
            this.drivesCheckBox.setSelected(selectCheckbox);
            this.drivesCheckBox.setEnabled(this.db.isPmEditable());
            this.drivesComboBox.setEnabled(this.db.isPmEditable());
            this.drivesComboBox.addActionListener(this.lSymAction);
            this.tc.setComboDuration(threshold, this.drivesComboBox);
        }
        this.shutdownCheckBox.setSelected(this.db.isShutdownEnabled());
        this.autoshutdownLabel.setText(this.db.isShutdownEnabled() ? this.buildShutdownNotice(this.db.getShutdownPeriodStart(), this.db.getShutdownPeriodEnd()) : blankShutdownLabel);
    }

    void drivesCheckBox_actionPerformed(ActionEvent event) {
        boolean selected;
        this.drivesClassEnabled = selected = this.drivesCheckBox.isSelected();
        this.drivesComboBox.setEnabled(selected);
        if (selected) {
            if (this.db.getDrivesThreshold() != Integer.MAX_VALUE) {
                this.db.enableAutopm(true);
            }
            this.drivesComboBox_actionPerformed(new ActionEvent(this.drivesComboBox, 1001, "comboBoxChanged"));
        } else {
            if (this.db.getSystemThreshold() == Integer.MAX_VALUE) {
                this.db.enableAutopm(false);
            }
            this.db.unsetDrivesThreshold();
        }
        if (!this.startup) {
            this.setEdited(true);
        }
    }

    void drivesComboBox_actionPerformed(ActionEvent event) {
        String drivesThresholdString = (String)this.drivesComboBox.getSelectedItem();
        if (!this.tc.parseDuration(drivesThresholdString)) {
            JOptionPane.showMessageDialog(this, resource.getString("Invalid format for duration"));
            return;
        }
        this.db.setDrivesThreshold(this.tc.totalSeconds);
        if (!this.startup) {
            this.setEdited(true);
        }
    }

    void exitApplication() {
        if (this.shutdown != null) {
            ((Component)this.shutdown).setVisible(false);
            this.shutdown.dispose();
        }
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }

    int getSchemeOverrideChoice() {
        return JOptionPane.showConfirmDialog(this, resource.getString("Scheme Confirm Message"), resource.getString("Scheme Override Confirmation"), 0, 3);
    }

    void helpButton_actionPerformed(ActionEvent event) {
        if (helpBroker == null) {
            try {
                URL helpURL = HelpSet.findHelpSet(null, (String)HELPSET);
                HelpSet helpSet = new HelpSet(null, helpURL);
                helpBroker = helpSet.createHelpBroker();
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(resource.getString("Could not find help set file: ")) + HELPSET);
                System.exit(3);
            }
        }
        helpBroker.setDisplayed(true);
    }

    void initializeSchemeList() {
        this.schemeDir = new File(SCHEME_DIRECTORY);
        if (!(this.schemeDir.exists() && this.schemeDir.isDirectory() && this.schemeDir.canRead())) {
            JOptionPane.showMessageDialog(this, String.valueOf(resource.getString("Missing or unreadable scheme directory: ")) + SCHEME_DIRECTORY);
            System.exit(1);
        }
        this.schemeLinkFile = new File(LINK_DIRECTORY, SCHEME_LINK_FILE);
        if (!this.schemeLinkFile.exists() || !this.schemeLinkFile.canRead()) {
            JOptionPane.showMessageDialog(this, resource.getString("Scheme link file missing.  Pleast contact system administrator."));
            System.exit(1);
        }
        try {
            LineNumberReader rdr = new LineNumberReader(new FileReader(this.schemeLinkFile.getPath()));
            this.currentScheme = rdr.readLine();
            rdr.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, resource.getString("I/O error reading scheme directory or file."));
            System.exit(1);
        }
        String[] fileList = new File(SCHEME_DIRECTORY).list();
        Vector<String> schemeVector = new Vector<String>();
        int i = 0;
        while (i < fileList.length) {
            String name = fileList[i];
            if (this.isSchemePermitted(name) || name.equals(this.currentScheme)) {
                schemeVector.addElement(name);
            }
            ++i;
        }
        String[] comboList = new String[schemeVector.size()];
        schemeVector.toArray(comboList);
        int i2 = 0;
        while (i2 < comboList.length) {
            String translatedName = null;
            String listName = comboList[i2];
            try {
                translatedName = resource.getString(listName);
            }
            catch (MissingResourceException missingResourceException) {
                translatedName = listName;
            }
            this.schemeComboBox.addItem(listName, translatedName);
            ++i2;
        }
        this.schemeComboBox.setSelectedIndex(-1);
    }

    private boolean isEdited() {
        return this.edited;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isSchemePermitted(String schemeName) {
        try {
            File schemeFile = new File(SCHEME_DIRECTORY, schemeName);
            ConfigFileParser cfp = new ConfigFileParser(schemeFile.getPath());
            block8: while (true) {
                int cmd = cfp.parseNext();
                switch (cmd) {
                    default: {
                        continue block8;
                    }
                    case 0: 
                    case 2: 
                    case 5: {
                        if (this.db.isPmEditable()) continue block8;
                        return false;
                    }
                    case 1: {
                        if (this.db.isPmEditable() || "monitors".equals(cfp.getString())) continue block8;
                        return false;
                    }
                    case 3: {
                        boolean shutdownEnabled;
                        if (this.db.isCprEditable()) continue block8;
                        boolean bl = shutdownEnabled = cfp.getBehavior() == 0 ? this.db.isShutdownDefault() : cfp.isEnabled1();
                        if (this.db.isShutdownEnabled() != shutdownEnabled || this.db.getShutdownPeriodStart() != cfp.getTime1() || this.db.getShutdownPeriodEnd() != cfp.getTime2() || this.db.getShutdownIdleMin() != cfp.getThreshold() || this.db.isWakeupEnabled() != cfp.isEnabled2()) return false;
                        continue block8;
                    }
                    case 63: 
                }
                break;
            }
            return true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, String.valueOf(resource.getString("Error processing scheme file: ")) + schemeName);
            System.exit(2);
            return true;
        }
    }

    public static void main(String[] args) {
        Dtpower pwr = null;
        try {
            pwr = new Dtpower(resource.getString("Dtpower Title"));
        }
        catch (InternalError e) {
            System.out.println(resource.getString("dtpower could not be started due to an internal error."));
            String errmsg = e.getLocalizedMessage();
            if (errmsg != null) {
                System.out.println(e);
            }
            System.exit(1);
        }
        try {
            pwr.parseOptions(args);
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(pwr, e.getMessage());
            System.exit(1);
        }
        if (pwr.expandedScreenRequested) {
            pwr.moreLessButton.setText(resource.getString("Less Button"));
            pwr.showExpandedScreen();
        } else {
            pwr.showBasicScreen();
        }
        ((Component)pwr).setVisible(true);
        Xsession.WMcommand((Frame)pwr, (String)"/usr/dt/bin/dtpower");
    }

    void monitorsCheckBox_actionPerformed(ActionEvent event) {
        boolean selected = this.monitorsCheckBox.isSelected();
        Device displayDevice = this.db.getDisplayDevice();
        this.monitorsClassEnabled = selected;
        displayDevice.setCustomized(selected);
        this.monitorsComboBox.setEnabled(selected);
        if (selected) {
            this.monitorsComboBox_actionPerformed(new ActionEvent(this.monitorsComboBox, 1001, "comboBoxChanged"));
        } else {
            String duration = (String)this.systemSleepComboBox.getSelectedItem();
            this.tc.parseDuration(duration);
            this.db.setMonitorsThreshold(this.tc.totalSeconds, this.startup ^ true);
        }
        if (!this.startup) {
            this.setEdited(true);
        }
    }

    void monitorsComboBox_actionPerformed(ActionEvent event) {
        String monitorsThresholdString = (String)this.monitorsComboBox.getSelectedItem();
        if (!this.tc.parseDuration(monitorsThresholdString)) {
            JOptionPane.showMessageDialog(this, resource.getString("Invalid format for duration"));
            return;
        }
        this.db.setMonitorsThreshold(this.tc.totalSeconds, this.startup ^ true);
        if (!this.startup) {
            this.setEdited(true);
            this.monitorsEdited = true;
        }
    }

    void moreLessButton_actionPerformed(ActionEvent event) {
        if (this.moreLessButton.getText().equals(resource.getString("More Button"))) {
            this.moreLessButton.setText(resource.getString("Less Button"));
            this.showExpandedScreen();
        } else {
            this.moreLessButton.setText(resource.getString("More Button"));
            this.showBasicScreen();
        }
    }

    void okButton_actionPerformed(ActionEvent event) {
        if (this.shutdown != null && this.shutdown.isEdited()) {
            this.applyShutdownEdits();
        }
        if (this.isEdited() || !this.currentScheme.equals(this.selectedScheme) || this.schemeOverridden) {
            this.acceptChanges();
        }
        this.exitApplication();
    }

    void parseOptions(String[] options) throws ArrayIndexOutOfBoundsException, ParseException {
        Object optionArg = null;
        String geometryString = null;
        int i = 0;
        while (i < options.length) {
            String anOption = options[i];
            int count = anOption.length();
            if (anOption.equals("-e")) {
                this.expandedScreenRequested = true;
            } else if (anOption.equals("-geometry")) {
                geometryString = options[++i];
                this.bounds = new GeometryParser(this).calculateGeometry(geometryString);
            } else {
                throw new ParseException(String.valueOf(resource.getString("Unrecognized option ")) + anOption, 0);
            }
            ++i;
        }
    }

    void processInitialScheme() {
        Object rdr = null;
        try {
            int i = 0;
            if (this.currentScheme == null) {
                this.currentScheme = CUSTOM_SCHEME;
                String translatedScheme = resource.getString(this.currentScheme);
                this.schemeComboBox.insertItemAt(this.currentScheme, translatedScheme, i);
            } else {
                this.currentSchemeFile = new File(SCHEME_DIRECTORY, this.currentScheme);
                int count = this.schemeComboBox.getItemCount();
                i = 0;
                while (i < count) {
                    if (this.currentScheme.equals((String)this.schemeComboBox.getKeyAt(i))) break;
                    ++i;
                }
                if (i == count) {
                    JOptionPane.showMessageDialog(this, resource.getString("Unrecognized scheme.  Please contact system administrator."));
                    System.exit(1);
                }
                this.selectedSchemeFile = this.currentSchemeFile;
            }
            this.selectedScheme = this.currentScheme;
            this.schemeComboBox.setSelectedIndex(i);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, resource.getString("I/O error reading scheme directory or file."));
            System.exit(1);
        }
    }

    void schemeComboBox_common(ActionEvent event) {
        int index = this.schemeComboBox.getSelectedIndex();
        this.selectedScheme = (String)this.schemeComboBox.getKeyAt(index);
        if (this.selectedScheme.equals(CUSTOM_SCHEME)) {
            this.db = this.dbScheme = this.dbSystem;
        } else {
            this.selectedSchemeFile = new File(SCHEME_DIRECTORY, this.selectedScheme);
            try {
                this.dbScheme = new DevDB(this.selectedSchemeFile.getPath());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, String.valueOf(resource.getString("Error processing scheme file: ")) + this.selectedSchemeFile.getPath());
                System.exit(1);
            }
        }
        this.setSchemeDescriptionLabel(this.dbScheme.getDescription());
    }

    private void setEdited(boolean edited) {
        this.edited = edited;
    }

    void setSchemeDescriptionLabel(String desc) {
        String translatedDesc = null;
        try {
            translatedDesc = resource.getString(desc);
        }
        catch (MissingResourceException missingResourceException) {
            translatedDesc = desc;
        }
        this.schemeDescriptionLabel.setText(translatedDesc);
        this.schemeDescriptionLabel.revalidate();
    }

    private void showBasicScreen() {
        this.JPanel3.remove(this.JPanel5);
        this.horizontalLine1.setSize(this.horizontalLine1.getMinimumSize());
        this.pack();
        if (!this.expandedScreenRequested && this.bounds != null) {
            ((Component)this).setBounds(this.bounds);
        }
    }

    private void showExpandedScreen() {
        this.JPanel3.add(this.JPanel5);
        this.pack();
        if (this.expandedScreenRequested && this.bounds != null) {
            ((Component)this).setBounds(this.bounds);
        }
    }

    void shutdownCheckBox_actionPerformed(ActionEvent event) {
        if (this.shutdownCheckBox.isSelected()) {
            this.db.enableShutdown(true);
            this.autoshutdownLabel.setText(this.buildShutdownNotice(this.db.getShutdownPeriodStart(), this.db.getShutdownPeriodEnd()));
        } else {
            this.db.enableShutdown(false);
            this.autoshutdownLabel.setText(blankShutdownLabel);
        }
        if (!this.startup) {
            this.setEdited(true);
        }
        this.basicPanel.repaint(this.basicPanel.getBounds());
    }

    void shutdownEditButton_actionPerformed(ActionEvent event) {
        if (this.shutdown != null) {
            return;
        }
        this.shutdown = new Autoshutdown(this.db.getShutdownPeriodStart(), this.db.getShutdownPeriodEnd(), this.db.getShutdownIdleMin(), this.db.getStatefileDirectory(), this.db.isWakeupEnabled(), this.db.isWakeupCapable());
        this.shutdown.addWindowListener(new ShutdownWindowHandler());
        this.shutdown.pack();
        this.shutdown.pack();
        ((Component)this.shutdown).setVisible(true);
    }

    void systemSleepComboBox_actionPerformed(ActionEvent event) {
        Device displayDevice;
        String systemThresholdString = (String)this.systemSleepComboBox.getSelectedItem();
        if (!this.tc.parseDuration(systemThresholdString)) {
            JOptionPane.showMessageDialog(this, resource.getString("Invalid format for duration"));
            return;
        }
        this.db.setSystemThreshold(this.tc.totalSeconds);
        if (this.tc.totalSeconds == Integer.MAX_VALUE) {
            if (!this.monitorsCheckBox.isEnabled() && !this.drivesCheckBox.isEnabled()) {
                this.db.enableAutopm(false);
            }
        } else {
            this.db.enableAutopm(true);
        }
        if ((displayDevice = this.db.getDisplayDevice()) != null && this.monitorsCustomizationSet && !displayDevice.isCustomized()) {
            this.db.setMonitorsThreshold(this.tc.totalSeconds, this.startup ^ true);
        }
        if (!this.startup) {
            this.setEdited(true);
            this.monitorsEdited = true;
        }
    }

    void textField_actionPerformed(ActionEvent event) {
        JTextField textField = (JTextField)event.getSource();
        if (textField == this.systemSleepTextField) {
            this.updateComboTime(this.systemSleepComboBox, textField, this.db.getSystemThreshold());
        } else if (textField == this.drivesTextField) {
            this.updateComboTime(this.drivesComboBox, textField, this.db.getDrivesThreshold());
        } else if (textField == this.monitorsTextField) {
            this.updateComboTime(this.monitorsComboBox, textField, this.db.getMonitorsThreshold());
        }
    }

    void updateComboTime(JComboBox cbox, JTextField timeText, int oldSeconds) {
        if (!this.tc.parseDuration(timeText.getText())) {
            timeText.setText(TimeConverter.constructDuration(oldSeconds));
            JOptionPane.showMessageDialog(this, resource.getString("Invalid format for duration"));
            return;
        }
        if (this.tc.totalSeconds != oldSeconds) {
            this.tc.setComboDuration(this.tc.totalSeconds, cbox);
            if (!this.startup) {
                this.setEdited(true);
            }
        }
    }

    class KeyedComboBox
    extends JComboBox {
        Vector keys = new Vector();

        KeyedComboBox() {
        }

        public void addItem(Object aKey, Object anObject) {
            this.keys.addElement(aKey);
            super.addItem(anObject);
        }

        public Object getKeyAt(int index) {
            return this.keys.elementAt(index);
        }

        public Object getSelectedKey() {
            return this.keys.elementAt(super.getSelectedIndex());
        }

        public void insertItemAt(Object aKey, Object anObject, int index) {
            this.keys.insertElementAt(aKey, index);
            super.insertItemAt(anObject, index);
        }
    }

    private class GeometryParser {
        JFrame frame;
        boolean xOffsetExists;
        boolean xOffsetPositive;
        boolean yOffsetExists;
        boolean yOffsetPositive;
        boolean widthExists;
        boolean heightExists;
        int xOffset;
        int yOffset;
        int width;
        int height;

        GeometryParser(JFrame frame) {
            this.frame = frame;
        }

        Rectangle calculateGeometry(String geometryString) {
            Dimension preferredSize;
            Dimension maxSize = this.frame.getMaximumSize();
            Dimension minSize = this.frame.getMinimumSize();
            Dimension screenSize = this.frame.getToolkit().getScreenSize();
            Dimension newSize = preferredSize = this.frame.getPreferredSize();
            Point newLocation = new Point();
            maxSize.width = Math.min(maxSize.width, screenSize.width);
            maxSize.height = Math.min(maxSize.height, screenSize.height);
            this.parseGeometryString(geometryString);
            if (this.widthExists) {
                newSize.width = this.width < minSize.width ? minSize.width : (this.width > maxSize.width ? maxSize.width : this.width);
                newSize.width = Math.min(newSize.width, screenSize.width);
            }
            if (this.heightExists) {
                newSize.height = this.height < minSize.height ? minSize.height : (this.height > maxSize.height ? maxSize.height : this.height);
                newSize.height = Math.min(newSize.height, screenSize.height);
            }
            if (this.xOffsetExists) {
                newLocation.x = this.xOffsetPositive ? this.xOffset : screenSize.width - newSize.width - this.xOffset;
                if (newLocation.x < 0) {
                    newLocation.x = 0;
                } else if (newLocation.x + newSize.width > screenSize.width) {
                    newLocation.x = screenSize.width - newSize.width;
                }
            }
            if (this.yOffsetExists) {
                newLocation.y = this.yOffsetPositive ? this.yOffset : screenSize.height - newSize.height - this.yOffset;
                if (newLocation.y < 0) {
                    newLocation.y = 0;
                } else if (newLocation.y + newSize.height > screenSize.height) {
                    newLocation.y = screenSize.height - newSize.height;
                }
            }
            return new Rectangle(newLocation, newSize);
        }

        void clearExistenceValues() {
            this.heightExists = false;
            this.widthExists = false;
            this.yOffsetExists = false;
            this.xOffsetExists = false;
        }

        void parseGeometryString(String s) {
            if (s == null || s.equals("")) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(s, "=+-xX", true);
            String token = null;
            try {
                token = tokenizer.nextToken();
                if (token.equals("=")) {
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                    } else {
                        return;
                    }
                }
                if (!(token.equals("+") || token.equals("-") || token.equals("x"))) {
                    this.width = Integer.parseInt(token);
                    this.widthExists = true;
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                    } else {
                        return;
                    }
                }
                if (token.equals("x") || token.equals("X")) {
                    token = tokenizer.nextToken();
                    this.height = Integer.parseInt(token);
                    this.heightExists = true;
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                    } else {
                        return;
                    }
                }
                if (token.equals("+") || token.equals("-")) {
                    this.xOffsetPositive = token.equals("+");
                    token = tokenizer.nextToken();
                    this.xOffset = Integer.parseInt(token);
                    this.xOffsetExists = true;
                    if (tokenizer.hasMoreTokens()) {
                        token = tokenizer.nextToken();
                    } else {
                        return;
                    }
                }
                if (token.equals("+") || token.equals("-")) {
                    this.yOffsetPositive = token.equals("+");
                    token = tokenizer.nextToken();
                    this.yOffset = Integer.parseInt(token);
                    this.yOffsetExists = true;
                }
                if (tokenizer.hasMoreTokens()) {
                    this.clearExistenceValues();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.clearExistenceValues();
            }
            catch (NumberFormatException numberFormatException) {
                this.clearExistenceValues();
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == Dtpower.this.moreLessButton) {
                Dtpower.this.moreLessButton_actionPerformed(event);
            } else if (object == Dtpower.this.shutdownEditButton) {
                Dtpower.this.shutdownEditButton_actionPerformed(event);
            } else if (object == Dtpower.this.monitorsCheckBox) {
                Dtpower.this.monitorsCheckBox_actionPerformed(event);
            } else if (object == Dtpower.this.drivesCheckBox) {
                Dtpower.this.drivesCheckBox_actionPerformed(event);
            } else if (object == Dtpower.this.shutdownCheckBox) {
                Dtpower.this.shutdownCheckBox_actionPerformed(event);
            } else if (object == Dtpower.this.monitorsComboBox) {
                Dtpower.this.monitorsComboBox_actionPerformed(event);
            } else if (object == Dtpower.this.drivesComboBox) {
                Dtpower.this.drivesComboBox_actionPerformed(event);
            } else if (object == Dtpower.this.systemSleepComboBox) {
                Dtpower.this.systemSleepComboBox_actionPerformed(event);
            } else if (object == Dtpower.this.okButton) {
                Dtpower.this.okButton_actionPerformed(event);
            } else if (object == Dtpower.this.cancelButton) {
                Dtpower.this.cancelButton_actionPerformed(event);
            } else if (object == Dtpower.this.helpButton) {
                Dtpower.this.helpButton_actionPerformed(event);
            } else if (object instanceof JTextField) {
                Dtpower.this.textField_actionPerformed(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == Dtpower.this) {
                Dtpower.this.Dtpower_windowClosing(event);
            }
        }
    }

    class ShutdownWindowHandler
    extends WindowAdapter {
        ShutdownWindowHandler() {
        }

        public void windowClosed(WindowEvent event) {
            Object object = event.getSource();
            if (object == Dtpower.this.shutdown) {
                if (Dtpower.this.shutdown.acceptEdits()) {
                    Dtpower.this.applyShutdownEdits();
                }
                Dtpower.this.shutdown = null;
            }
        }
    }

    class SchemeComboBox_startupListener
    implements ActionListener {
        SchemeComboBox_startupListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Dtpower.this.schemeComboBox_common(event);
            if (!Dtpower.this.db.equals(Dtpower.this.dbScheme)) {
                if (Dtpower.this.getSchemeOverrideChoice() != 0) {
                    Dtpower.this.db = Dtpower.this.dbScheme;
                    Dtpower.this.monitorsEdited = true;
                    Dtpower.this.acceptChanges();
                    Dtpower.this.drivesComboBox.removeActionListener(Dtpower.this.lSymAction);
                } else {
                    String translatedName = Dtpower.CUSTOM_SCHEME;
                    try {
                        translatedName = resource.getString(Dtpower.CUSTOM_SCHEME);
                    }
                    catch (MissingResourceException missingResourceException) {
                        translatedName = Dtpower.CUSTOM_SCHEME;
                    }
                    Dtpower.this.schemeComboBox.insertItemAt(Dtpower.CUSTOM_SCHEME, translatedName, 0);
                    Dtpower.this.schemeComboBox.setSelectedIndex(0);
                    Dtpower.this.setSchemeDescriptionLabel(Dtpower.this.dbScheme.getDescription());
                    Dtpower.this.schemeOverridden = true;
                }
            }
        }
    }

    class SchemeComboBox_actionListener
    implements ActionListener {
        SchemeComboBox_actionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Dtpower.this.monitorsCustomizationSet = false;
            Dtpower.this.schemeComboBox_common(event);
            Dtpower.this.db = Dtpower.this.dbScheme;
            Dtpower.this.drivesComboBox.removeActionListener(Dtpower.this.lSymAction);
            Dtpower.this.configureComponents();
            Dtpower.this.setEdited(false);
        }
    }
}

