/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.Cmpt;
import java.util.Vector;

class Device
implements Cloneable {
    static final int DEVICE_DISABLED = 1;
    static final int DEVICE_CUSTOMIZED = 2;
    static final int DEVICE_FBPM_NOT_SUPPORTED = 4;
    static final String DISK_TYPE = "disk";
    static final String DISPLAY_TYPE = "display";
    static final int DEFAULT_BASIS = 0;
    static final int DEVICE_BASIS = 1;
    static final int COMPONENT_BASIS = 2;
    String name = "";
    String longName = "";
    String deviceType = "";
    Cmpt[] cmpts = null;
    int threshold = Integer.MAX_VALUE;
    int thresholdBasis = 0;
    int state = 0;

    Device() {
    }

    Device(String longName) {
        this();
        this.longName = longName;
    }

    Device(String nm, String lnm, int deviceThreshold) {
        this(lnm);
        this.name = "";
        this.threshold = deviceThreshold;
    }

    Device(String nm, String lnm, Vector cmpVec) {
        this(nm, lnm, (Cmpt[])cmpVec.toArray());
    }

    Device(String nm, String lnm, Cmpt[] c) {
        this(lnm);
        this.name = nm;
        this.cmpts = c;
    }

    Device(String nm, String lnm, Cmpt[] c, int t, int b) {
        this(nm, lnm, c);
        this.threshold = t;
        this.thresholdBasis = b;
    }

    Device(String nm, String lnm, Cmpt[] c, int t, int b, String devType) {
        this(nm, lnm, c, t, b);
        this.deviceType = devType;
    }

    public Object clone() {
        Device dev = null;
        try {
            dev = (Device)super.clone();
            int length = this.cmpts.length;
            Cmpt[] cmpts = new Cmpt[length];
            int i = 0;
            while (i < length) {
                cmpts[i] = (Cmpt)this.cmpts[i].clone();
                ++i;
            }
            dev.cmpts = cmpts;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return dev;
    }

    public boolean equals(Object obj) {
        Device other = (Device)obj;
        if (!this.longName.equals(other.longName)) {
            return false;
        }
        if (this.cmpts.length != other.cmpts.length) {
            return false;
        }
        int i = 0;
        while (i < this.cmpts.length) {
            if (!this.cmpts[i].equals(other.cmpts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    String getDeviceType() {
        return this.deviceType;
    }

    String getLogicalName() {
        return this.name;
    }

    String getPhysicalName() {
        return this.longName;
    }

    int getThreshold() {
        return this.threshold;
    }

    int getThresholdBasis() {
        return this.thresholdBasis;
    }

    boolean isCustomized() {
        return (this.state & 2) != 0;
    }

    boolean isEnabled() {
        return (this.state & 1) == 0;
    }

    void setCustomized(boolean b) {
        this.state = b ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    void setEnabled(boolean enable) {
        this.state = enable ? (this.state &= 0xFFFFFFFE) : (this.state |= 1);
    }

    public String toString() {
        String out = "device: " + this.name + " " + this.longName + " " + this.cmpts.length + " components type: " + this.deviceType + " thr: " + this.threshold + " basis: " + this.thresholdBasis + " state " + this.state + " \n";
        int i = 0;
        while (i < this.cmpts.length) {
            out = String.valueOf(out) + this.cmpts[i].toString("  ");
            ++i;
        }
        return out;
    }
}

