/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.Cmpt;
import com.sun.dt.dtpower.ConfigFileParser;
import com.sun.dt.dtpower.Device;
import com.sun.dt.dtpower.DtpowerException;
import com.sun.dt.dtpower.PowerManagementBehaviors;
import com.sun.dt.dtpower.SystemInterrogator;
import java.io.File;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

class DevDB
implements PowerManagementBehaviors {
    static final String CONFIG_FILE_PATH = "/etc/power.conf";
    static final String STATEFILE_DEFAULT = "/.CPR";
    static final String NO_LOGICAL_NAME = "<none>";
    static final String newLine = System.getProperty("line.separator");
    static Device[] allDevs;
    static Device[] driveDevices;
    static SystemInterrogator sysint;
    static boolean hasCprPerm;
    static boolean hasPmPerm;
    static boolean autopmDefault;
    static boolean shutdownCapable;
    static boolean shutdownDefault;
    static boolean wakeupCapable;
    static int systemThresholdDefault;
    static Device systemDisplayDevice;
    String description;
    boolean autopmEnabled;
    Autopm autopm;
    Shutdown shutdown;
    GlobalThresholds thresholds;
    boolean debugEquals;
    Device displayDevice;

    DevDB() {
    }

    DevDB(int dummy) throws DtpowerException {
        sysint = new SystemInterrogator();
        this.description = "Save power as customized by user";
        this.shutdown = new Shutdown();
        this.autopm = new Autopm(new Device[0]);
        systemThresholdDefault = sysint.getSystemThresholdDefault();
        this.autopmEnabled = sysint.isAutopmEnabled();
        autopmDefault = sysint.isAutopmDefault();
        shutdownCapable = sysint.isShutdownCapable();
        shutdownDefault = sysint.isShutdownDefault();
        wakeupCapable = sysint.isWakeupCapable();
        allDevs = sysint.getDevices();
        Vector<Device> devs = new Vector<Device>();
        int i = 0;
        while (i < allDevs.length) {
            Device dev = allDevs[i];
            if (dev.isCustomized() && !"display".equals(dev.getDeviceType())) {
                devs.addElement(dev);
            }
            ++i;
        }
        Device[] devArray = new Device[devs.size()];
        devs.toArray(devArray);
        this.autopm = new Autopm(devArray);
        this.displayDevice = null;
        systemDisplayDevice = null;
        int i2 = 0;
        while (i2 < allDevs.length) {
            if (DevDB.allDevs[i2].deviceType != null && DevDB.allDevs[i2].deviceType.equals("display")) {
                systemDisplayDevice = this.displayDevice = allDevs[i2];
                break;
            }
            ++i2;
        }
        boolean systemEnabled = this.autopmEnabled;
        int system = sysint.getSystemThreshold();
        boolean monitorsEnabled = this.calculateMonitorsEnabled(this.displayDevice);
        int monitors = this.calculateMonitorsThreshold(this.displayDevice, monitorsEnabled, system);
        boolean drivesEnabled = this.calculateDrivesEnabled();
        int drives = this.calculateDrivesThreshold(drivesEnabled, system);
        this.thresholds = new GlobalThresholds(systemEnabled, system, monitorsEnabled, monitors, drivesEnabled, drives);
        this.shutdown = new Shutdown(sysint.isShutdownEnabled(), sysint.isWakeupEnabled(), sysint.getShutdownPeriodStart(), sysint.getShutdownPeriodEnd(), sysint.getShutdownIdleMin(), sysint.getStatefileDirectory(), sysint.getStatefileName());
        hasCprPerm = sysint.isCprEditable();
        hasPmPerm = sysint.isPmEditable();
    }

    DevDB(String schemePath) throws Exception {
        this.shutdown = new Shutdown();
        this.autopm = new Autopm(new Device[0]);
        String statefile = null;
        if (systemDisplayDevice != null) {
            this.displayDevice = (Device)systemDisplayDevice.clone();
            if (this.displayDevice != null) {
                this.displayDevice.setCustomized(false);
                this.displayDevice.setEnabled(true);
                int numLevels = this.displayDevice.cmpts[0].levels.length;
                this.displayDevice.cmpts[0].levels[numLevels - 1].threshold = (this.displayDevice.state & 4) != 0 ? 0 : 1;
                numLevels = this.displayDevice.cmpts[1].levels.length;
                this.displayDevice.cmpts[1].levels[numLevels - 1].threshold = 1;
                this.displayDevice.threshold = this.getSystemThresholdDefault();
                this.displayDevice.thresholdBasis = 0;
            }
        }
        boolean monitorsEnabled = this.calculateMonitorsEnabled(this.displayDevice);
        this.thresholds = new GlobalThresholds(monitorsEnabled, this.calculateMonitorsThreshold(this.displayDevice, monitorsEnabled, this.getSystemThresholdDefault()));
        if (this.displayDevice != null) {
            this.setMonitorsThreshold(this.getSystemThresholdDefault(), true);
        }
        Vector<Device> devices = new Vector<Device>();
        ConfigFileParser cfp = new ConfigFileParser(schemePath);
        block10: while (true) {
            int cmdType = cfp.parseNext();
            switch (cmdType) {
                case 5: {
                    this.autopmEnabled = cfp.getBehavior() == 5 ? autopmDefault : cfp.isEnabled1();
                    this.thresholds.enableSystemThreshold(this.autopmEnabled);
                    continue block10;
                }
                case 2: {
                    devices.addElement(cfp.getDevice());
                    continue block10;
                }
                case 0: {
                    this.setSystemThreshold(cfp.getThreshold());
                    continue block10;
                }
                case 1: {
                    if (cfp.getString().equals("monitors")) {
                        if (this.displayDevice != null) {
                            this.thresholds.enableMonitorsClass(true);
                            this.setMonitorsThreshold(cfp.getThreshold(), true);
                            this.displayDevice.setCustomized(true);
                            continue block10;
                        }
                        this.thresholds.enableMonitorsClass(false);
                        continue block10;
                    }
                    if (cfp.getString().equals("drives")) {
                        this.thresholds.enableDrivesClass(true);
                        this.setDrivesThreshold(cfp.getThreshold());
                        continue block10;
                    }
                    throw new InternalError();
                }
                case 3: {
                    boolean shutdownEnabled = cfp.getBehavior() == 0 ? shutdownDefault : cfp.isEnabled1();
                    this.shutdown = new Shutdown(shutdownEnabled, cfp.isEnabled2(), cfp.getTime1(), cfp.getTime2(), cfp.getThreshold());
                    continue block10;
                }
                case 11: {
                    this.description = cfp.getString();
                    continue block10;
                }
                case 4: {
                    statefile = cfp.getString();
                    continue block10;
                }
                default: {
                    throw new ParseException("Unrecognized commanand in scheme file.", 0);
                }
                case 63: 
            }
            break;
        }
        if (this.shutdown != null && statefile != null) {
            this.setStatefilePath(statefile);
        }
        Device[] devArray = new Device[devices.size()];
        devices.toArray(devArray);
        this.autopm = new Autopm(devArray);
    }

    private boolean calculateDrivesEnabled() {
        Device[] devs = this.autopm.getDriveDevices();
        if (devs.length == 0) {
            return false;
        }
        int firstThreshold = devs[0].threshold;
        if (devs[0].thresholdBasis != 1) {
            return false;
        }
        int i = 1;
        while (i < devs.length) {
            if (devs[i].thresholdBasis != 1 || devs[i].threshold != firstThreshold) {
                return false;
            }
            ++i;
        }
        return true;
    }

    int calculateDrivesThreshold(boolean enabled, int defThreshold) {
        if (!enabled) {
            return defThreshold;
        }
        Device[] devs = this.getDriveDevices();
        return devs[0].threshold;
    }

    private boolean calculateMonitorsEnabled(Device dev) {
        if (!this.isDisplayPresentAndWellFormed(dev)) {
            return false;
        }
        dev.setCustomized(dev.thresholdBasis != 0);
        return dev.isCustomized() || dev.isEnabled() && !this.autopmEnabled;
    }

    private int calculateMonitorsThreshold(Device dev, boolean enabled, int defThreshold) {
        if (!this.isDisplayPresentAndWellFormed(dev)) {
            return 0;
        }
        if (!enabled) {
            return dev.threshold;
        }
        return dev.isEnabled() ? dev.threshold : Integer.MAX_VALUE;
    }

    Enumeration devices() {
        return this.autopm.devices();
    }

    void enableAutopm(boolean enable) {
        this.autopmEnabled = enable;
    }

    void enableDrivesClass(boolean enable) {
        this.thresholds.enableDrivesClass(enable);
    }

    void enableShutdown(boolean enable) {
        this.shutdown.enableShutdown(enable);
    }

    void enableSystemThreshold(boolean enable) {
        this.thresholds.enableSystemThreshold(enable);
    }

    void enableWakeup(boolean enable) {
        this.shutdown.enableWakeup(enable);
    }

    public boolean equals(Object obj) {
        DevDB other = (DevDB)obj;
        if (this.debugEquals) {
            System.out.println("equals 1");
        }
        if (this.autopmEnabled != other.autopmEnabled) {
            return false;
        }
        if (this.debugEquals) {
            System.out.println("equals 2");
        }
        if (this.shutdown.isShutdownEnabled() != other.shutdown.isShutdownEnabled()) {
            return false;
        }
        if (this.debugEquals) {
            System.out.println("equals 3");
        }
        if (!this.shutdown.equals(other.shutdown)) {
            return false;
        }
        if (this.debugEquals) {
            System.out.println("equals 4");
        }
        if (!this.thresholds.equals(other.thresholds)) {
            return false;
        }
        if (this.debugEquals) {
            System.out.println("equals 5");
        }
        if (!this.autopm.equals(other.autopm)) {
            return false;
        }
        if (this.debugEquals) {
            System.out.println("equals 6");
        }
        return true;
    }

    int getAutopmBehavior() {
        return this.autopm.getBehavior();
    }

    Device[] getCustomizedDevices() {
        return this.autopm.getCustomizedDevices();
    }

    String getDescription() {
        return this.description;
    }

    Device getDevice(String physName) {
        return this.autopm.getDevice(physName);
    }

    Device getDisplayDevice() {
        return this.displayDevice;
    }

    Device[] getDriveDevices() {
        return this.autopm.getDriveDevices();
    }

    int getDrivesThreshold() {
        return this.thresholds.getDrivesThreshold();
    }

    int getMonitorsThreshold() {
        return this.thresholds.getMonitorsThreshold();
    }

    int getShutdownIdleMin() {
        return this.shutdown.getIdleThresholdMin();
    }

    int getShutdownPeriodEnd() {
        return this.shutdown.getEndTime();
    }

    int getShutdownPeriodStart() {
        return this.shutdown.getStartTime();
    }

    String getStatefileDirectory() {
        return this.shutdown.getStatefileDirectory();
    }

    String getStatefilePath() {
        return this.shutdown.getStatefilePath();
    }

    int getSystemThreshold() {
        return this.thresholds.getSystemThreshold();
    }

    int getSystemThresholdDefault() {
        return systemThresholdDefault;
    }

    boolean isAutopmDefault() {
        return autopmDefault;
    }

    boolean isAutopmEnabled() {
        return this.autopmEnabled;
    }

    boolean isCprEditable() {
        return hasCprPerm;
    }

    private boolean isDisplayPresentAndWellFormed(Device dev) {
        return dev != null && dev.cmpts.length == 2 && dev.cmpts[1].levels.length == 4;
    }

    boolean isDrivesClassEnabled() {
        return this.thresholds.isDrivesClassEnabled();
    }

    boolean isMonitorsClassEnabled() {
        return this.thresholds.isMonitorsClassEnabled();
    }

    boolean isPmEditable() {
        return hasPmPerm;
    }

    boolean isShutdownCapable() {
        return shutdownCapable;
    }

    boolean isShutdownDefault() {
        return shutdownDefault;
    }

    boolean isShutdownEnabled() {
        return this.shutdown.isShutdownEnabled();
    }

    boolean isSystemThresholdEnabled() {
        return this.thresholds.isSystemThresholdEnabled();
    }

    boolean isSystemThresholdModified() {
        return this.thresholds.isSystemThresholdModified();
    }

    boolean isWakeupCapable() {
        return wakeupCapable;
    }

    boolean isWakeupEnabled() {
        return this.shutdown.isWakeupEnabled();
    }

    void setAutopmBehavior(int behavior) {
        this.autopm.setBehavior(behavior);
    }

    void setDescription(String desc) {
        this.description = desc;
    }

    void setDisplayThresholds(Device d) throws DtpowerException {
        sysint.setDisplayThresholds(d);
    }

    void setDrivesThreshold(int seconds) {
        this.thresholds.setDrivesThreshold(seconds);
    }

    void setMonitorsEnabled(boolean enable) {
        this.thresholds.enableMonitorsClass(enable);
    }

    void setMonitorsThreshold(int seconds, boolean recalc) {
        this.thresholds.setMonitorsThreshold(seconds, recalc);
    }

    void setShutdownIdleMin(int minutes) {
        this.shutdown.setIdleThresholdMin(minutes);
    }

    void setShutdownPeriodEnd(int seconds) {
        this.shutdown.setEndTime(seconds);
    }

    void setShutdownPeriodStart(int seconds) {
        this.shutdown.setStartTime(seconds);
    }

    void setStatefileDirectory(String directory) {
        this.shutdown.setStatefileDirectory(directory);
    }

    void setStatefilePath(String path) {
        this.shutdown.setStatefilePath(path);
    }

    void setSystemThreshold(int seconds) {
        this.thresholds.setSystemThreshold(seconds);
    }

    public String toString() {
        StringBuffer theString = new StringBuffer();
        theString.append("[start of DevDB]");
        theString.append(newLine);
        theString.append("description: " + this.description);
        theString.append(newLine);
        theString.append("autopmEnabled: " + this.autopmEnabled);
        theString.append(newLine);
        theString.append(this.thresholds.toString());
        theString.append(newLine);
        if (this.shutdown != null) {
            theString.append(this.shutdown.toString());
        }
        theString.append("[end of DevDB]");
        return new String(theString);
    }

    void unsetDrivesThreshold() {
        this.thresholds.unsetDrivesThreshold();
    }

    private class Autopm {
        Device[] customizedDevices;
        int behavior;

        Autopm() {
            this.customizedDevices = new Device[0];
            this.behavior = -1;
        }

        Autopm(Device[] devArray) {
            this.customizedDevices = devArray;
            Arrays.sort(this.customizedDevices, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Device)o1).longName.compareTo(((Device)o2).longName);
                }

                public boolean equals(Object o1, Object o2) {
                    return ((Device)o1).longName.equals(((Device)o2).longName);
                }
            });
            this.behavior = -1;
        }

        Enumeration devices() {
            return new Enumeration(){
                int cursor;
                {
                    this.cursor = 0;
                }

                public boolean hasMoreElements() {
                    return allDevs != null && this.cursor < allDevs.length;
                }

                public Object nextElement() throws NoSuchElementException {
                    if (!this.hasMoreElements()) {
                        throw new NoSuchElementException();
                    }
                    return allDevs[this.cursor++];
                }
            };
        }

        public boolean equals(Object obj) {
            Device[] otherDevs = ((Autopm)obj).customizedDevices;
            int count = this.customizedDevices.length;
            if (DevDB.this.debugEquals) {
                System.out.println("equals 21");
            }
            if (count != otherDevs.length) {
                return false;
            }
            if (DevDB.this.debugEquals) {
                System.out.println("equals 22");
            }
            int i = 0;
            while (i < count) {
                Device customDev = this.customizedDevices[i];
                Device otherDev = otherDevs[i];
                if (DevDB.this.debugEquals) {
                    System.out.println("equals 23");
                }
                if (!customDev.getPhysicalName().equals(otherDev.getPhysicalName())) {
                    return false;
                }
                if (DevDB.this.debugEquals) {
                    System.out.println("equals 24");
                }
                if (customDev.thresholdBasis != otherDev.thresholdBasis) {
                    return false;
                }
                if (DevDB.this.debugEquals) {
                    System.out.println("equals 25");
                }
                if (customDev.getThreshold() != otherDev.getThreshold()) {
                    return false;
                }
                ++i;
            }
            if (DevDB.this.debugEquals) {
                System.out.println("equals 26");
            }
            return true;
        }

        int getBehavior() {
            return this.behavior;
        }

        Device[] getCustomizedDevices() {
            return this.customizedDevices;
        }

        Device getDevice(String physName) {
            int i = 0;
            while (i < allDevs.length) {
                if (DevDB.allDevs[i].longName.equals(physName)) {
                    return allDevs[i];
                }
                ++i;
            }
            return null;
        }

        Device[] getDriveDevices() {
            Vector<Device> vec = new Vector<Device>();
            if (driveDevices == null) {
                int i = -1;
                i = 0;
                while (i < allDevs.length) {
                    if ("disk".equals(DevDB.allDevs[i].deviceType)) {
                        vec.addElement(allDevs[i]);
                    }
                    ++i;
                }
                driveDevices = new Device[vec.size()];
                vec.toArray(driveDevices);
            }
            return driveDevices;
        }

        void setBehavior(int behavior) {
            this.behavior = behavior;
        }

        public String toString() {
            StringBuffer devString = new StringBuffer(1000);
            int i = 0;
            while (i < allDevs.length) {
                devString.append(allDevs[i]);
                ++i;
            }
            return new String(devString);
        }
    }

    class GlobalThresholds {
        boolean systemEnabled;
        int systemThreshold;
        boolean monitorsEnabled;
        int monitorsThreshold;
        boolean drivesEnabled;
        int drivesThreshold;

        GlobalThresholds() {
            this.systemThreshold = systemThresholdDefault;
            this.monitorsThreshold = systemThresholdDefault;
            this.drivesThreshold = systemThresholdDefault;
            this.drivesEnabled = false;
            this.monitorsEnabled = false;
            this.systemEnabled = false;
        }

        GlobalThresholds(boolean monitorsEnabled, int monitorsThreshold) {
            this();
            this.monitorsEnabled = monitorsEnabled;
            this.monitorsThreshold = monitorsThreshold;
        }

        GlobalThresholds(boolean systemEnabled, int sys, boolean monitorsEnabled, int monitors, boolean drivesEnabled, int drives) {
            this.systemEnabled = systemEnabled;
            this.systemThreshold = sys;
            this.monitorsEnabled = monitorsEnabled;
            this.monitorsThreshold = monitors;
            this.drivesEnabled = drivesEnabled;
            this.drivesThreshold = drives;
        }

        void enableDrivesClass(boolean enable) {
            this.drivesEnabled = enable;
        }

        void enableMonitorsClass(boolean enable) {
            this.monitorsEnabled = enable;
        }

        void enableSystemThreshold(boolean enable) {
            this.systemEnabled = enable;
        }

        public boolean equals(Object obj) {
            GlobalThresholds other = (GlobalThresholds)obj;
            if (DevDB.this.debugEquals) {
                System.out.println("equals 10");
            }
            if (this.systemEnabled != other.systemEnabled) {
                return false;
            }
            if (DevDB.this.debugEquals) {
                System.out.println("equals 11");
            }
            if (this.systemEnabled && this.systemThreshold != other.systemThreshold) {
                return false;
            }
            if (DevDB.this.debugEquals) {
                System.out.println("equals 12");
            }
            Device display = this.getDisplayDevice();
            Device otherDisplay = other.getDisplayDevice();
            if (display != null && otherDisplay != null) {
                if (display.isEnabled() != otherDisplay.isEnabled()) {
                    return false;
                }
                if (DevDB.this.debugEquals) {
                    System.out.println("equals 13");
                }
                if (display.isEnabled()) {
                    if (display.getThreshold() != otherDisplay.getThreshold()) {
                        return false;
                    }
                    if (!display.equals(otherDisplay)) {
                        return false;
                    }
                }
            }
            if (DevDB.this.debugEquals) {
                System.out.println("equals 14");
            }
            return this.drivesEnabled == other.drivesEnabled || this.drivesThreshold == other.drivesThreshold;
        }

        Device getDisplayDevice() {
            return DevDB.this.displayDevice;
        }

        int getDrivesThreshold() {
            return this.drivesThreshold;
        }

        int getMonitorsThreshold() {
            return this.monitorsThreshold;
        }

        int getSystemThreshold() {
            return this.systemThreshold;
        }

        boolean isDrivesClassEnabled() {
            return this.drivesEnabled;
        }

        boolean isMonitorsClassEnabled() {
            return this.monitorsEnabled;
        }

        boolean isSystemThresholdEnabled() {
            return this.systemEnabled;
        }

        boolean isSystemThresholdModified() {
            return this.systemThreshold != systemThresholdDefault;
        }

        void setComponentThresholdsFromDeviceThreshold(Device dev, int seconds) {
            float[] thresholdFactors = new float[]{0.8f, 0.1f, 0.1f};
            int[] times = new int[3];
            if (!DevDB.this.isDisplayPresentAndWellFormed(dev)) {
                return;
            }
            Cmpt c = dev.cmpts[0];
            c.levels[0].threshold = 0;
            int intThreshold = seconds;
            c = dev.cmpts[1];
            int sum = 0;
            float floatThreshold = intThreshold;
            int i = 0;
            while (i < c.levels.length - 1) {
                times[i] = (int)(floatThreshold * thresholdFactors[i]);
                sum += times[i];
                ++i;
            }
            int difference = intThreshold - sum;
            int count = c.levels.length;
            if (difference > 0) {
                times[0] = times[0] + difference;
            }
            int i2 = 0;
            while (i2 < count - 1) {
                c.levels[i2].threshold = times[i2];
                ++i2;
            }
        }

        void setDrivesThreshold(int seconds) {
            this.drivesThreshold = seconds;
            Device[] drives = DevDB.this.autopm.getDriveDevices();
            int i = 0;
            while (i < drives.length) {
                drives[i].thresholdBasis = 1;
                drives[i].threshold = seconds;
                ++i;
            }
        }

        void setMonitorsThreshold(int seconds, boolean recalc) {
            this.monitorsThreshold = seconds;
            Device dev = this.getDisplayDevice();
            if (!DevDB.this.isDisplayPresentAndWellFormed(dev)) {
                return;
            }
            dev.setEnabled(this.monitorsThreshold != Integer.MAX_VALUE);
            dev.threshold = seconds;
            dev.thresholdBasis = 1;
            if (dev.threshold != Integer.MAX_VALUE && recalc) {
                this.setComponentThresholdsFromDeviceThreshold(dev, seconds);
            }
        }

        void setSystemThreshold(int seconds) {
            this.systemThreshold = seconds;
        }

        public String toString() {
            return "Thresholds: system " + this.systemEnabled + "/" + this.systemThreshold + " monitors " + this.monitorsEnabled + "/" + this.monitorsThreshold + " drives " + this.drivesEnabled + "/" + this.drivesThreshold;
        }

        void unsetDrivesThreshold() {
            Device[] drives = DevDB.this.autopm.getDriveDevices();
            int i = 0;
            while (i < drives.length) {
                drives[i].thresholdBasis = 0;
                drives[i].threshold = this.getSystemThreshold();
                drives[i].setCustomized(false);
                ++i;
            }
        }
    }

    class Shutdown {
        boolean shutdownEnabled;
        boolean wakeupEnabled;
        int startTime;
        int endTime;
        int idleThresholdMin;
        File statefile;

        Shutdown() {
            this.shutdownEnabled = false;
            this.wakeupEnabled = false;
            this.startTime = 1080;
            this.endTime = 480;
            this.idleThresholdMin = 30;
            this.statefile = new File("/", ".CPR");
        }

        Shutdown(boolean enabled, boolean wakeup, int start, int end, int idle) {
            this.shutdownEnabled = enabled;
            this.wakeupEnabled = wakeup;
            this.startTime = start;
            this.endTime = end;
            this.idleThresholdMin = idle;
            this.statefile = new File(DevDB.STATEFILE_DEFAULT);
        }

        Shutdown(boolean shutdownEnabled, boolean wakeupEnabled, int startTime, int endTime, int idleThresholdMin, String statefileDirectory, String statefileName) {
            this.shutdownEnabled = shutdownEnabled;
            this.wakeupEnabled = wakeupEnabled;
            this.startTime = startTime;
            this.endTime = endTime;
            this.idleThresholdMin = idleThresholdMin;
            this.statefile = new File(statefileDirectory, statefileName);
        }

        void enableShutdown(boolean enable) {
            this.shutdownEnabled = enable;
            if (!enable) {
                this.wakeupEnabled = false;
            }
        }

        void enableWakeup(boolean enable) {
            this.wakeupEnabled = enable;
        }

        public boolean equals(Object obj) {
            Shutdown other = (Shutdown)obj;
            return this.shutdownEnabled == other.shutdownEnabled && this.wakeupEnabled == other.wakeupEnabled && this.startTime == other.startTime && this.endTime == other.endTime && this.idleThresholdMin == other.idleThresholdMin;
        }

        int getEndTime() {
            return this.endTime;
        }

        int getIdleThresholdMin() {
            return this.idleThresholdMin;
        }

        int getStartTime() {
            return this.startTime;
        }

        String getStatefileDirectory() {
            return this.statefile.getParent();
        }

        String getStatefilePath() {
            return this.statefile.getPath();
        }

        boolean isShutdownEnabled() {
            return this.shutdownEnabled;
        }

        boolean isWakeupEnabled() {
            return this.wakeupEnabled;
        }

        void setEndTime(int seconds) {
            this.endTime = seconds;
        }

        void setIdleThresholdMin(int minutes) {
            this.idleThresholdMin = minutes;
        }

        void setStartTime(int seconds) {
            this.startTime = seconds;
        }

        void setStatefileDirectory(String directory) {
            String name = this.statefile.getName();
            this.statefile = new File(directory, name);
        }

        void setStatefilePath(String path) {
            this.statefile = new File(path);
        }

        public String toString() {
            return "shutdown: enabled " + this.shutdownEnabled + " autowakeup " + this.wakeupEnabled + " start " + this.startTime + " end " + this.endTime + " idle " + this.idleThresholdMin + newLine;
        }
    }
}

