/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.SliceUseStep;
import com.sun.admin.diskmgr.client.SliceWizard;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SliceNumEqualStep
extends VWizardCard {
    public static final String NAME = "SliceNumEqualStep";
    public static final int HELP_CACHE_SIZE = 5;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    DiskData diskData;
    ResourceBundle bundle;
    SliceWizard wizard;
    VDiskMgr theApp;
    SliceUseStep useStep = null;
    ActionString actionString;
    JLabel numLabel = new JLabel();
    JComboBox numCombo;
    Vector vNum;
    JLabel sizeLabel = new JLabel();
    SelectableLabel sizeField;
    JCheckBox backupChk;
    JLabel capacityLabel = new JLabel();
    SelectableLabel capacityField;

    public SliceNumEqualStep(VDiskMgr vDiskMgr, SliceWizard sliceWizard) {
        this.theApp = vDiskMgr;
        this.wizard = sliceWizard;
        this.diskData = sliceWizard.getDiskData();
        this.bundle = vDiskMgr.getResourceBundle();
        this.infoPanel = new GenInfoPanel((VOptionPane)sliceWizard);
        this.helpCache = new Vector(5);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "disk_wiz_equal");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizNumStep"));
        this.constructStep();
    }

    private void constructStep() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizNumEqualPartitions"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)3, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)3, (int)6, (int)3);
        this.initLabel(this.numLabel, "SliceWizNumPartitions");
        Constraints.constrain((Container)jPanel, (Component)this.numLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)12, (int)6, (int)3);
        this.vNum = new Vector(8);
        int n = 1;
        while (n < 8) {
            this.vNum.addElement(Integer.toString(n));
            ++n;
        }
        this.numCombo = new JComboBox(this.vNum);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_equal_number");
        this.theApp.addHelpListener(this.helpListener, this.numCombo);
        this.numLabel.setLabelFor(this.numCombo);
        this.numCombo.setSelectedIndex(-1);
        this.numCombo.addItemListener(new ComboListener());
        Constraints.constrain((Container)jPanel, (Component)this.numCombo, (int)1, (int)1, (int)2, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)6, (int)3);
        this.initLabel(this.sizeLabel, "SliceWizNumSizePartition");
        Constraints.constrain((Container)jPanel, (Component)this.sizeLabel, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)12, (int)6, (int)3);
        this.sizeField = new SelectableLabel("", 6);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_equal_size");
        this.theApp.addHelpListener(this.helpListener, (Component)this.sizeField);
        this.sizeLabel.setLabelFor((Component)this.sizeField);
        Constraints.constrain((Container)jPanel, (Component)this.sizeField, (int)1, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)6, (int)3);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"MB"));
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)2, (int)2, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)3, (int)6, (int)3);
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JSeparator jSeparator = new JSeparator();
        Constraints.constrain((Container)jPanel2, (Component)jSeparator, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)3, (int)6, (int)3);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceWizNumBackupLabel"));
        Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)3, (int)6, (int)3);
        this.backupChk = new JCheckBox();
        this.actionString = new ActionString(this.bundle, "SliceWizNumBackup");
        this.backupChk.setText(this.actionString.getString());
        this.backupChk.setMnemonic(this.actionString.getMnemonic());
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_equal_backup");
        this.theApp.addHelpListener(this.helpListener, this.backupChk);
        this.backupChk.setSelected(true);
        this.backupChk.addActionListener(new ChkListener());
        Constraints.constrain((Container)jPanel2, (Component)this.backupChk, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)3, (int)3);
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.initLabel(this.capacityLabel, "SliceWizNumCapacity");
        Constraints.constrain((Container)jPanel3, (Component)this.capacityLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)3, (int)6, (int)3);
        this.capacityField = new SelectableLabel(this.diskData.getSolarisDiskCapacity(), 6);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "disk_wiz_equal_capacity");
        this.theApp.addHelpListener(this.helpListener, (Component)this.capacityField);
        this.capacityLabel.setLabelFor((Component)this.capacityField);
        Constraints.constrain((Container)jPanel3, (Component)this.capacityField, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)6, (int)6, (int)3);
        jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"MB"));
        Constraints.constrain((Container)jPanel3, (Component)jLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)3, (int)6, (int)3);
        Constraints.constrain((Container)((Object)this), (Component)jPanel3, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel4 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel4, (int)0, (int)3, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    public boolean isSubStep() {
        return true;
    }

    public void reset() {
    }

    public void start() {
        super.start();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        if (this.numCombo.getSelectedIndex() == -1) {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        }
    }

    public boolean stop(boolean bl) {
        this.getManager().setPrevious(NAME, "SliceGenStep");
        this.getManager().setNext(NAME, "SliceUseStep");
        if (bl) {
            this.wizard.setNumSlices(this.numCombo.getSelectedIndex() + 1);
            if (this.useStep == null) {
                this.useStep = new SliceUseStep(this.theApp, this.wizard);
                this.wizard.addCard("SliceUseStep", this.useStep);
            }
        }
        return true;
    }

    class ComboListener
    implements ItemListener {
        ComboListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (SliceNumEqualStep.this.getProperty("vwp.canmoveforward").equals("vwp.false")) {
                SliceNumEqualStep.this.setProperty("vwp.canmoveforward", "vwp.true");
            }
            if (SliceNumEqualStep.this.numCombo.getSelectedIndex() != -1) {
                float f = SliceNumEqualStep.this.diskData.computeDiskCapacity() / (long)(SliceNumEqualStep.this.numCombo.getSelectedIndex() + 1) / 1000000L;
                SliceNumEqualStep.this.sizeField.setText(Float.toString(f));
            } else {
                SliceNumEqualStep.this.sizeField.setText("");
            }
        }
    }

    class ChkListener
    implements ActionListener {
        ChkListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SliceNumEqualStep.this.wizard.createBackup(SliceNumEqualStep.this.backupChk.isSelected());
            if (SliceNumEqualStep.this.backupChk.isSelected() && SliceNumEqualStep.this.numCombo.getItemCount() == 8) {
                if (SliceNumEqualStep.this.numCombo.getSelectedIndex() == 7) {
                    SliceNumEqualStep.this.numCombo.setSelectedIndex(-1);
                    SliceNumEqualStep.this.setProperty("vwp.canmoveforward", "vwp.false");
                }
                SliceNumEqualStep.this.numCombo.removeItemAt(7);
            } else {
                SliceNumEqualStep.this.numCombo.addItem(Integer.toString(8));
            }
            SliceData sliceData = (SliceData)SliceNumEqualStep.this.wizard.getSlices().elementAt(2);
            if (SliceNumEqualStep.this.backupChk.isSelected()) {
                sliceData.setTag((short)5);
            } else {
                sliceData.setTag((short)0);
                sliceData.setStartCylinder(0);
                sliceData.setEndCylinder(0);
            }
        }
    }
}

