/*
 * Copyright (c) 1998-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_APPTRACE_IMPL_H
#define	_APPTRACE_IMPL_H

#pragma ident	"@(#)apptrace_impl.h	1.3	00/08/10 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct abisym {
	void	*a_real;
	int	a_vflag;
	int	a_tflag;
} abisym_t;

/*
 * From the apptrace auditing object
 */
extern FILE *__abi_outfile;
extern struct liblist *__abi_pflib_list;

extern sigset_t abisigset;

/*
 * With the addition of the /usr/lib/lwp/libthread, the possibility exists
 * that we may be threaded but with a different libthread than was previously
 * assumed.  We'll need to be able to remember which libthread we're running
 * with.
 */
enum whichthreads {
	NOTHREADS = 0x0,
	USE_2LEVEL = 0x1,
	USE_PTHREADS = 0x2,
	USE_LIBLWP = 0x4
};

#ifdef	__STDC__

extern void abilock_init(enum whichthreads);
extern void abilock(sigset_t *);
extern void abiunlock(sigset_t *);

extern size_t	strnlen(char const *, size_t);
extern int	is_empty_string(char const *);

extern int (*abi_thr_main)(void);
extern thread_t (*abi_thr_self)(void);
extern int (*abi_sigsetmask)(int, const sigset_t *, sigset_t *);
extern int (*abi_sigaction)(int, const struct sigaction *, struct sigaction *);
extern int (*abi_mutex_lock)(mutex_t *);
extern int (*abi_mutex_unlock)(mutex_t *);

#else	/* __STDC__ */

extern void abilock_init();
extern void abilock();
extern void abiunlock();
extern size_t	strnlen();
extern int	is_empty_string();
extern int (*abi_thr_main)();
extern thread_t (*abi_thr_self)();
extern int (*abi_sigsetmask)();
extern int (*abi_sigaction)();
extern int (*abi_mutex_lock)();
extern int (*abi_mutex_unlock)();

#endif	/* __STDC__ */

#ifdef	__cplusplus
}
#endif

#endif	/* _APPTRACE_IMPL_H */
