/*
 * Decompiled with CFR 0.152.
 */
package com.sun.audiocontrol.SDtAudioControl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class GeneralClassLoader
extends ClassLoader {
    public static final String urlPrefix = "SIMPLE";
    private static boolean debug = false;
    private static boolean keepLoading = true;
    private String cookie;
    private static Hashtable loaders = new Hashtable();
    public static GeneralClassLoader ourLoader;
    private String localResourceDirectory;
    private Hashtable localOverrides = new Hashtable();
    private Hashtable resourceHash = new Hashtable();
    private Hashtable mimeHash = new Hashtable();
    private Hashtable rawClasses = new Hashtable();

    static {
        Properties newP = new Properties(System.getProperties());
        System.setProperties(newP);
        ourLoader = GeneralClassLoader.createLoader("BeanBox", null);
    }

    private GeneralClassLoader(String cookie, String dir) {
        this.cookie = cookie;
        this.localResourceDirectory = dir;
        loaders.put(cookie, this);
    }

    private Class applyDefinition(String name, boolean resolve) {
        byte[] buf = (byte[])this.rawClasses.get(name);
        this.rawClasses.remove(name);
        if (buf == null) {
            return null;
        }
        Class<?> c = null;
        try {
            c = super.defineClass(null, buf, 0, buf.length);
            if (c != null && resolve) {
                this.resolveClass(c);
            }
        }
        catch (ClassFormatError classFormatError) {
            System.err.println("The definition for " + name + " in the JAR file");
            System.err.println("has a format error.");
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        if (!c.getName().equals(name)) {
            System.err.println("\nWARNING: file name versus class name mismatch");
            String fname = String.valueOf(name.replace('.', '/')) + ".class";
            System.err.println("    JAR entry \"" + fname + "\" was expected " + "to contain class \"" + name + "\"");
            System.err.println("    but instead contained class \"" + c.getName() + "\"");
            System.err.println("    This may cause future class-loading problems.\n");
        }
        return c;
    }

    public synchronized boolean applyDefinitions(Vector classList) {
        boolean back = true;
        Enumeration k = classList.elements();
        while (k.hasMoreElements()) {
            String classname = (String)k.nextElement();
            Class c = this.findLoadedClass(classname);
            if (c != null || (c = this.applyDefinition(classname, true)) != null) continue;
            if (back) {
                System.err.println("NOTE: There are classes that cannot be defined in this JAR file");
                System.err.println("    Some of these classes will cause the failure of defining or linking ");
                System.err.println("    other classes that depend on them.");
                if (keepLoading) {
                    System.err.println("NOTE: To simplify debugging JAR files, we will proceed loading classes");
                    System.err.println("    although this may lead eventually to an UnknownError or the like");
                    System.err.println();
                }
            }
            System.err.println("Class " + classname + " could not be defined from JAR file");
            back = false;
        }
        return back;
    }

    public static GeneralClassLoader createLoader(String cookie, String dir) {
        GeneralClassLoader back = GeneralClassLoader.getLoader(cookie);
        if (back != null) {
            if (!back.localResourceDirectory.equals(dir)) {
                throw new Error("internal error!");
            }
            return back;
        }
        return new GeneralClassLoader(cookie, dir);
    }

    private static void debug(String msg) {
        if (debug) {
            System.err.println("GeneralClassLoader:: " + msg);
        }
    }

    public void defineClassFromBytes(String name, byte[] buf) {
        this.rawClasses.put(name, buf);
    }

    private static GeneralClassLoader getLoader(String cookie) {
        return (GeneralClassLoader)loaders.get(cookie);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl == null) {
            cl = this.applyDefinition(name, resolve);
        }
        if (cl == null) {
            try {
                cl = this.findSystemClass(name);
                return cl;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (cl == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }
}

