/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.Cmpt;
import com.sun.dt.dtpower.DevDB;
import com.sun.dt.dtpower.Device;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;

class ConfigFileWriter {
    BufferedOutputStream out = null;
    byte lineSeparator = (byte)10;

    ConfigFileWriter() {
    }

    ConfigFileWriter(String path) throws IOException {
        this();
        this.out = new BufferedOutputStream(new FileOutputStream(path));
    }

    String buildAutopmCommand(boolean enable) {
        return "autopm\t\t" + (enable ? "enable" : "disable");
    }

    String buildAutoshutdownCommand(DevDB db) {
        StringBuffer outputLine = new StringBuffer("autoshutdown\t");
        outputLine.append(String.valueOf(String.valueOf(db.getShutdownIdleMin())) + "\t\t");
        int minutes = db.getShutdownPeriodStart();
        outputLine.append(String.valueOf(String.valueOf(minutes / 60)) + ":");
        DecimalFormat fmt = new DecimalFormat();
        fmt.setMinimumIntegerDigits(2);
        outputLine.append(fmt.format(minutes %= 60));
        outputLine.append(' ');
        minutes = db.getShutdownPeriodEnd();
        outputLine.append(String.valueOf(String.valueOf(minutes / 60)) + ":");
        outputLine.append(fmt.format(minutes %= 60));
        outputLine.append('\t');
        String behavior = null;
        behavior = db.isWakeupEnabled() ? "autowakeup" : (db.isShutdownEnabled() ? "shutdown" : "noshutdown");
        outputLine.append(behavior);
        return outputLine.toString();
    }

    String buildDeviceThresholdsCommand(DevDB db, Device dev) {
        if (dev.thresholdBasis == 0) {
            return null;
        }
        StringBuffer outputLine = new StringBuffer("device-thresholds\t");
        outputLine.append(dev.getPhysicalName());
        if (!dev.isEnabled()) {
            outputLine.append("\tdisabled");
            return outputLine.toString();
        }
        if (dev.thresholdBasis == 1) {
            outputLine.append('\t');
            outputLine.append(this.buildThreshold(dev.threshold));
        } else if (dev.thresholdBasis == 2) {
            int c = 0;
            while (c < dev.cmpts.length) {
                Cmpt cmpt = dev.cmpts[c];
                outputLine.append('(');
                int lvl = 1;
                while (lvl < cmpt.levels.length) {
                    outputLine.append(this.buildThreshold(cmpt.levels[lvl].threshold));
                    if (lvl < cmpt.levels.length - 1) {
                        outputLine.append(' ');
                    }
                    ++lvl;
                }
                outputLine.append(')');
                if (c < dev.cmpts.length - 1) {
                    outputLine.append(' ');
                }
                ++c;
            }
        }
        return outputLine.toString();
    }

    String buildSysThresholdCommand(int seconds) {
        return "system-threshold\t\t" + this.buildThreshold(seconds);
    }

    String buildThreshold(int seconds) {
        return seconds == Integer.MAX_VALUE ? "always-on" : String.valueOf(String.valueOf(seconds)) + "s";
    }

    void close() throws IOException {
        this.out.close();
    }

    private void write(String s) throws IOException {
        byte[] bytes = s.getBytes();
        this.out.write(bytes);
        this.out.write(this.lineSeparator);
    }

    void writeLine(String s) throws IOException {
        this.write(s);
    }
}

