/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dt.dtpower;

import com.sun.dt.dtpower.Cmpt;
import com.sun.dt.dtpower.ConfigFileParser;
import com.sun.dt.dtpower.Device;
import com.sun.dt.dtpower.Level;
import com.sun.dt.dtpower.PowerManagementBehaviors;
import java.io.CharArrayReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class ConfigFileParser
implements PowerManagementBehaviors {
    static final int SYSTEM_THRESHOLD = 0;
    static final int CLASS_THRESHOLD = 1;
    static final int DEVICE_THRESHOLDS = 2;
    static final int AUTOSHUTDOWN = 3;
    static final int STATEFILE = 4;
    static final int AUTOPM = 5;
    static final int DEVICE_NAME = 6;
    static final int DEVICE_DEPENDENCY = 7;
    static final int DEVICE_DEPENDENCY_PROPERTY = 8;
    static final int COMMENT = 9;
    static final int UNKNOWN = 10;
    static final int DESCRIPTION = 11;
    static final int EOF = 63;
    static CommandFinder finder = new ConfigFileParser().new CommandFinder();
    static final String MONITORS_CLASS = "monitors";
    static final String DRIVES_CLASS = "drives";
    static char[] whiteSpaceChars = new char[]{' ', '\t'};
    static String whiteSpace = new String(whiteSpaceChars);
    static int[] unitMultipliers = new int[]{1, 60, 3600, 1};
    LineNumberReader rdr;
    int lineNumber = 0;
    private int threshold;
    private boolean enabled1;
    private boolean enabled2;
    private int time1;
    private int time2;
    private Device device;
    private String string;
    private String theLine;
    private int behavior;
    private int cursor;

    ConfigFileParser() {
    }

    ConfigFileParser(String path) throws IOException {
        this.rdr = new LineNumberReader(new FileReader(path));
    }

    static /* synthetic */ int access$0(ConfigFileParser $0) {
        return $0.cursor;
    }

    static /* synthetic */ void access$1(ConfigFileParser $0, int $1) {
        $0.cursor = $1;
    }

    int getBehavior() {
        return this.behavior;
    }

    Device getDevice() {
        return this.device;
    }

    String getLine() {
        return this.theLine;
    }

    String getString() {
        return this.string;
    }

    int getThreshold() {
        return this.threshold;
    }

    int getTime1() {
        return this.time1;
    }

    int getTime2() {
        return this.time2;
    }

    int identifyNext() throws IOException, StringIndexOutOfBoundsException {
        String cmd = null;
        this.theLine = this.rdr.readLine();
        if (this.theLine == null) {
            this.rdr.close();
            return 63;
        }
        this.lineNumber = this.rdr.getLineNumber();
        if (this.theLine.length() == 0 || this.theLine.charAt(0) == '#') {
            cmd = "#";
        } else if (this.theLine.charAt(0) == '/') {
            cmd = "/";
        } else {
            StringTokenizer tok = new StringTokenizer(this.theLine, whiteSpace);
            try {
                cmd = tok.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new StringIndexOutOfBoundsException();
            }
        }
        return finder.getCommandNumber(cmd);
    }

    boolean isEnabled1() {
        return this.enabled1;
    }

    boolean isEnabled2() {
        return this.enabled2;
    }

    public static void main(String[] args) {
        ConfigFileParser cfp = new ConfigFileParser();
        if (args.length == 0) {
            System.out.println("Usage: ConfigFileParser <power.conf line>");
            System.exit(1);
        }
        int result = cfp.parseDevThresholds(args[0]);
        System.out.println("ConfigFileParser: result = " + result);
        System.out.println(cfp.getDevice());
    }

    int parseAutopm(String line) {
        block7: {
            String errorMsg = "invalid syntax";
            StreamTokenizer st = new StreamTokenizer(new CharArrayReader(line.toCharArray()));
            try {
                st.nextToken();
                if (st.nextToken() != -3) {
                    throw new StringIndexOutOfBoundsException(errorMsg);
                }
                if (st.sval.compareTo("enable") == 0) {
                    this.behavior = 8;
                    this.enabled1 = true;
                    break block7;
                }
                if (st.sval.compareTo("disable") == 0) {
                    this.behavior = 7;
                    this.enabled1 = false;
                    break block7;
                }
                if (st.sval.compareTo("default") == 0) {
                    this.behavior = 5;
                    this.enabled1 = false;
                    break block7;
                }
                if (st.sval.compareTo("unconfigured") == 0) {
                    this.behavior = 6;
                    this.enabled1 = false;
                    break block7;
                }
                throw new StringIndexOutOfBoundsException(errorMsg);
            }
            catch (IOException iOException) {
                throw new StringIndexOutOfBoundsException(errorMsg);
            }
        }
        return 5;
    }

    int parseAutoshutdown(String line) throws StringIndexOutOfBoundsException {
        char[] chars = line.toCharArray();
        boolean tokType = false;
        StreamTokenizer st = new StreamTokenizer(new CharArrayReader(chars));
        st.ordinaryChar(45);
        StringIndexOutOfBoundsException e = new StringIndexOutOfBoundsException();
        try {
            st.nextToken();
            if (st.nextToken() != -2) {
                throw e;
            }
            int idleTime = new Double(st.nval).intValue();
            if (st.nextToken() != -2) {
                throw e;
            }
            int startHour = new Double(st.nval).intValue();
            if (st.nextToken() != 58) {
                throw e;
            }
            if (st.nextToken() != -2) {
                throw e;
            }
            int startMinute = new Double(st.nval).intValue();
            if (st.nextToken() != -2) {
                throw e;
            }
            int endHour = new Double(st.nval).intValue();
            if (st.nextToken() != 58) {
                throw e;
            }
            if (st.nextToken() != -2) {
                throw e;
            }
            int endMinute = new Double(st.nval).intValue();
            if (st.nextToken() != -3) {
                throw e;
            }
            String shutdownPrefString = st.sval;
            if (shutdownPrefString.compareTo("default") == 0) {
                this.behavior = 0;
            } else if (shutdownPrefString.compareTo("shutdown") == 0) {
                this.behavior = 1;
            } else if (shutdownPrefString.compareTo("autowakeup") == 0) {
                this.behavior = 2;
            } else if (shutdownPrefString.compareTo("noshutdown") == 0) {
                this.behavior = 3;
            } else if (shutdownPrefString.compareTo("unconfigured") == 0) {
                this.behavior = 4;
            } else {
                throw e;
            }
            this.time1 = startHour * 60 + startMinute;
            this.time2 = endHour * 60 + endMinute;
            this.threshold = idleTime;
            this.enabled1 = this.behavior == 1 || this.behavior == 2;
            this.enabled2 = this.behavior == 2;
        }
        catch (IOException iOException) {
            throw e;
        }
        return 3;
    }

    int parseClassThreshold(String line) throws StringIndexOutOfBoundsException {
        StringTokenizer stok = new StringTokenizer(line);
        stok.nextToken();
        if (!stok.hasMoreTokens()) {
            throw new StringIndexOutOfBoundsException("invalid syntax");
        }
        String token = stok.nextToken();
        if (!token.equals(MONITORS_CLASS) && !token.equals(DRIVES_CLASS)) {
            throw new StringIndexOutOfBoundsException("unrecognized class");
        }
        this.string = token;
        this.threshold = this.parseThreshold(line, 2);
        return 1;
    }

    int parseComment(String line) {
        return 9;
    }

    int parseDescription(String line) throws StringIndexOutOfBoundsException {
        char[] chars = line.toCharArray();
        int index = "description".length() + 1;
        this.string = new String(chars, index, line.length() - index);
        return 11;
    }

    int parseDevName(String line) {
        return 6;
    }

    /*
     * Unable to fully structure code
     */
    int parseDevThresholds(String line) throws StringIndexOutOfBoundsException {
        tp = new .ThresholdParser(this);
        index = "device-thresholds".length();
        c = line.charAt(index);
        if (c != ' ' && c != '\t') {
            throw new StringIndexOutOfBoundsException();
        }
        this.cursor = index;
        while ((c = line.charAt(this.cursor)) == ' ' || c == '\t') {
            ++this.cursor;
        }
        if (line.charAt(this.cursor) != '/') {
            throw new StringIndexOutOfBoundsException();
        }
        index = this.cursor;
        while ((c = line.charAt(this.cursor)) != ' ' && c != '\t') {
            ++this.cursor;
        }
        devName = line.substring(index, this.cursor);
        index = this.cursor;
        while ((c = line.charAt(this.cursor)) == ' ' || c == '\t') {
            ++this.cursor;
        }
        if (line.indexOf("always-on", this.cursor) == this.cursor) {
            if (line.length() != this.cursor + "always-on".length()) {
                throw new StringIndexOutOfBoundsException();
            }
            this.device = new Device(devName);
            this.enabled1 = false;
            return 2;
        }
        this.enabled1 = true;
        index = this.cursor;
        if (Character.isDigit(line.charAt(this.cursor))) {
            cmpts = new Cmpt[]{new Cmpt()};
            this.device = new Device("", devName, cmpts, tp.convertThreshold(line), 1);
            return 2;
        }
        if (line.charAt(this.cursor) != '(') {
            throw new StringIndexOutOfBoundsException();
        }
        components = new Vector<Cmpt>();
        while (line.charAt(this.cursor++) == '(') {
            c = line.charAt(this.cursor);
            if (!Character.isDigit(c)) {
                throw new StringIndexOutOfBoundsException();
            }
            count = 0;
            levels = new Vector<Level>();
            while (line.charAt(this.cursor) != ')') {
                lvl = new Level(tp.convertThreshold(line));
                levels.addElement(lvl);
                ++count;
                while ((c = line.charAt(this.cursor)) == ' ' || c == '\t') {
                    ++this.cursor;
                }
            }
            cmpt = new Cmpt(levels);
            components.addElement(cmpt);
            ++this.cursor;
            if (this.cursor != line.length()) ** GOTO lbl56
            break;
lbl-1000:
            // 1 sources

            {
                ++this.cursor;
lbl56:
                // 2 sources

                ** while ((c = line.charAt((int)this.cursor)) == ' ' || c == '\t')
            }
lbl57:
            // 1 sources

        }
        this.device = new Device("", devName, components);
        return 2;
    }

    int parseNext() throws IOException, StringIndexOutOfBoundsException {
        int nextId = this.identifyNext();
        switch (nextId) {
            case 0: {
                return this.parseSysThreshold(this.theLine);
            }
            case 1: {
                return this.parseClassThreshold(this.theLine);
            }
            case 2: {
                return this.parseDevThresholds(this.theLine);
            }
            case 3: {
                return this.parseAutoshutdown(this.theLine);
            }
            case 4: {
                return this.parseStatefile(this.theLine);
            }
            case 5: {
                return this.parseAutopm(this.theLine);
            }
            case 6: {
                return this.parseDevName(this.theLine);
            }
            case 9: {
                return this.parseComment(this.theLine);
            }
            case 11: {
                return this.parseDescription(this.theLine);
            }
            case 63: {
                return 63;
            }
            case 10: {
                return 10;
            }
        }
        return 10;
    }

    int parseStatefile(String line) throws StringIndexOutOfBoundsException {
        StreamTokenizer st = new StreamTokenizer(new CharArrayReader(line.toCharArray()));
        st.wordChars(45, 57);
        st.wordChars(95, 95);
        StringIndexOutOfBoundsException e = new StringIndexOutOfBoundsException();
        try {
            st.nextToken();
            if (st.nextToken() != -3) {
                throw e;
            }
            String path = st.sval;
            if (st.nextToken() != -1) {
                throw e;
            }
            this.string = path;
        }
        catch (IOException iOException) {
            throw e;
        }
        return 4;
    }

    int parseSysThreshold(String line) throws StringIndexOutOfBoundsException {
        this.threshold = this.parseThreshold(line, 1);
        return 0;
    }

    int parseThreshold(String line, int skipTokens) throws StringIndexOutOfBoundsException {
        StreamTokenizer st = new StreamTokenizer(new CharArrayReader(line.toCharArray()));
        try {
            int token = -1;
            st.wordChars(45, 45);
            int i = 0;
            while (i < skipTokens) {
                st.nextToken();
                ++i;
            }
            token = st.nextToken();
            if (token == -3 && st.sval.equals("always-on")) {
                return Integer.MAX_VALUE;
            }
            if (token != -2) {
                throw new StringIndexOutOfBoundsException();
            }
            int timeMagnitude = (int)st.nval;
            if (st.nextToken() != -3) {
                throw new StringIndexOutOfBoundsException();
            }
            int timeUnitIndex = -1;
            if (st.sval.length() != 1 || (timeUnitIndex = "smh".indexOf(st.sval.charAt(0))) == -1) {
                throw new StringIndexOutOfBoundsException("invalid time unit");
            }
            this.threshold = timeMagnitude * unitMultipliers[timeUnitIndex];
            return this.threshold;
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException("invalid syntax");
        }
    }

    private class CommandDescriptor {
        String cmdName;
        int cmdNumber;

        CommandDescriptor(String cmdName, int cmdNumber) {
            this.cmdName = cmdName;
            this.cmdNumber = cmdNumber;
        }
    }

    private class CommandFinder {
        CommandDescriptor[] descriptors = new CommandDescriptor[11];

        CommandFinder() {
            ConfigFileParser configFileParser = ConfigFileParser.this;
            configFileParser.getClass();
            this.descriptors[0] = configFileParser.new CommandDescriptor("description", 11);
            ConfigFileParser configFileParser2 = ConfigFileParser.this;
            configFileParser2.getClass();
            this.descriptors[1] = configFileParser2.new CommandDescriptor("class-threshold", 1);
            ConfigFileParser configFileParser3 = ConfigFileParser.this;
            configFileParser3.getClass();
            this.descriptors[2] = configFileParser3.new CommandDescriptor("device-thresholds", 2);
            ConfigFileParser configFileParser4 = ConfigFileParser.this;
            configFileParser4.getClass();
            this.descriptors[3] = configFileParser4.new CommandDescriptor("#", 9);
            ConfigFileParser configFileParser5 = ConfigFileParser.this;
            configFileParser5.getClass();
            this.descriptors[4] = configFileParser5.new CommandDescriptor("system-threshold", 0);
            ConfigFileParser configFileParser6 = ConfigFileParser.this;
            configFileParser6.getClass();
            this.descriptors[5] = configFileParser6.new CommandDescriptor("autopm", 5);
            ConfigFileParser configFileParser7 = ConfigFileParser.this;
            configFileParser7.getClass();
            this.descriptors[6] = configFileParser7.new CommandDescriptor("statefile", 4);
            ConfigFileParser configFileParser8 = ConfigFileParser.this;
            configFileParser8.getClass();
            this.descriptors[7] = configFileParser8.new CommandDescriptor("autoshutdown", 3);
            ConfigFileParser configFileParser9 = ConfigFileParser.this;
            configFileParser9.getClass();
            this.descriptors[8] = configFileParser9.new CommandDescriptor("/", 6);
            ConfigFileParser configFileParser10 = ConfigFileParser.this;
            configFileParser10.getClass();
            this.descriptors[9] = configFileParser10.new CommandDescriptor("device-dependency", 7);
            ConfigFileParser configFileParser11 = ConfigFileParser.this;
            configFileParser11.getClass();
            this.descriptors[10] = configFileParser11.new CommandDescriptor("device-dependency-property", 8);
        }

        int getCommandNumber(String cmdName) {
            int i = 0;
            while (i < this.descriptors.length) {
                if (this.descriptors[i].cmdName.equals(cmdName)) break;
                ++i;
            }
            if (i >= this.descriptors.length) {
                return 10;
            }
            return this.descriptors[i].cmdNumber;
        }
    }
}

