/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.client;

import com.sun.admin.pm.client.BST;
import com.sun.admin.pm.client.pmHelpContent;
import com.sun.admin.pm.client.pmHelpException;
import com.sun.admin.pm.client.pmHelpItem;
import com.sun.admin.pm.client.pmUtility;
import com.sun.admin.pm.server.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

final class pmHelpRepository {
    private static Hashtable helpItemDB = null;
    private static Hashtable helpKeywordDB = null;
    private static BST helpTitleDB = null;
    private static final String ignoreKeyTitleWords = pmUtility.getResource("help.ignore.words");

    pmHelpRepository() {
    }

    public static String getResource(String string) {
        String string2 = null;
        ResourceBundle resourceBundle = null;
        Debug.message((String)("HELP:  getResource(" + string + ")"));
        try {
            try {
                try {
                    resourceBundle = ResourceBundle.getBundle("com.sun.admin.pm.client.pmHelpResources");
                }
                catch (MissingResourceException missingResourceException) {
                    Debug.fatal((String)"HELP:  Could not load pmHelpResources file");
                }
                try {
                    string2 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = String.valueOf(resourceBundle.getString("Missing:")) + string;
                    Debug.error((String)("HELP:  Missing: " + string));
                }
            }
            catch (Exception exception) {
                Debug.error((String)("HELP:  getResource(" + string + ") : " + exception));
            }
        }
        catch (Throwable throwable) {}
        return string2;
    }

    public static pmHelpItem helpItemForTag(String string) {
        if (helpItemDB == null || string == null) {
            return null;
        }
        return (pmHelpItem)helpItemDB.get(string);
    }

    public static Vector helpItemsForKeyword(String string) {
        if (helpKeywordDB == null) {
            return null;
        }
        return (Vector)helpKeywordDB.get(string.toLowerCase());
    }

    public static Vector helpItemsForString(String string) throws pmHelpException {
        Debug.info((String)("HELP:  helpItemsForString: " + string));
        if (helpTitleDB == null) {
            return new Vector();
        }
        Vector vector = new Vector();
        helpTitleDB.traverse_find_vector(vector, string);
        Debug.info((String)("HELP:  helpItemsForString: vector contains " + vector.size() + " items"));
        return vector;
    }

    public static void loadHelpItemDB() {
        Debug.message((String)"HELP:  Starting help item load");
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.sun.admin.pm.client.pmHelpResources");
        }
        catch (MissingResourceException missingResourceException) {
            Debug.fatal((String)"HELP:  Could not load pmHelpResources file");
            return;
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = enumeration.nextElement();
            if (!string2.endsWith(".tag")) continue;
            String string3 = null;
            try {
                string3 = resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                Debug.warning((String)("HELP:  Unable to find tag for " + string2));
                continue;
            }
            Debug.message((String)("HELP:  Making new item " + string3));
            pmHelpItem pmHelpItem2 = new pmHelpItem(string3);
            String string4 = pmHelpRepository.getResource(String.valueOf(string3) + ".title");
            pmHelpItem2.setTitle(string4);
            pmHelpItem2.setContent(new pmHelpContent(pmHelpRepository.getResource(String.valueOf(string3) + ".content")));
            Vector<String> vector = null;
            StringTokenizer stringTokenizer = null;
            String string5 = pmHelpRepository.getResource(String.valueOf(string3) + ".seealso");
            if (string5 != null) {
                vector = new Vector<String>();
                stringTokenizer = new StringTokenizer(string5);
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                }
                pmHelpItem2.setSeeAlso(vector);
            }
            vector = new Vector();
            string5 = pmHelpRepository.getResource(String.valueOf(string3) + ".keywords");
            if (string5 != null) {
                stringTokenizer = new StringTokenizer(string5);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    String string6 = string.replace('\"', ' ');
                    vector.addElement(string6.trim());
                }
            } else {
                Debug.warning((String)("HELP:  Item " + string3 + " keywords is empty"));
            }
            stringTokenizer = new StringTokenizer(string4);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().toLowerCase();
                if (ignoreKeyTitleWords.indexOf(string) != -1) {
                    Debug.message((String)("HELP:  ignoring " + string + " from " + string4));
                    continue;
                }
                Debug.message((String)("HELP:  adding " + string + " from " + string4));
                vector.addElement(string);
            }
            pmHelpItem2.setKeywords(vector);
            Debug.message((String)("HELP:  New item: " + pmHelpItem2));
            helpItemDB.put(pmHelpItem2.tag, pmHelpItem2);
        }
    }

    static void populateHelpItemDB() {
        helpItemDB = new Hashtable();
        pmHelpRepository.loadHelpItemDB();
    }

    static void populateHelpKeywordDB() {
        if (helpItemDB == null) {
            return;
        }
        helpKeywordDB = new Hashtable();
        Vector<pmHelpItem> vector = null;
        Enumeration enumeration = helpItemDB.elements();
        while (enumeration.hasMoreElements()) {
            pmHelpItem pmHelpItem2 = (pmHelpItem)enumeration.nextElement();
            Enumeration enumeration2 = pmHelpItem2.keywords.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                vector = (Vector<pmHelpItem>)helpKeywordDB.get(string);
                if (vector == null) {
                    vector = new Vector<pmHelpItem>();
                    helpKeywordDB.put(string, vector);
                }
                vector.addElement(pmHelpItem2);
            }
        }
    }

    static void populateHelpTitleDB() {
        if (helpItemDB == null) {
            return;
        }
        helpTitleDB = new BST();
        Enumeration enumeration = helpItemDB.elements();
        while (enumeration.hasMoreElements()) {
            pmHelpItem pmHelpItem2 = (pmHelpItem)enumeration.nextElement();
            helpTitleDB.insert(pmHelpItem2.title, pmHelpItem2);
        }
    }
}

