/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.query;

import com.sun.wbem.query.FromExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLExp;
import com.sun.wbem.query.WQLParser;
import java.io.ByteArrayInputStream;

public class SelectExp
extends WQLExp {
    private SelectList attList;
    private QueryExp whereClause;
    private FromExp fromExp;

    public SelectExp() {
    }

    public SelectExp(SelectList selectList, FromExp fromExp) {
        this.attList = selectList;
        this.fromExp = fromExp;
    }

    public SelectExp(SelectList selectList, FromExp fromExp, QueryExp queryExp) {
        this.attList = selectList;
        this.fromExp = fromExp;
        this.whereClause = queryExp;
    }

    public SelectExp(String string) {
        WQLParser wQLParser = new WQLParser(new ByteArrayInputStream(string.getBytes()));
        SelectExp selectExp = null;
        try {
            selectExp = (SelectExp)wQLParser.querySpecification();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
        this.attList = selectExp.attList;
        this.whereClause = selectExp.whereClause;
        this.fromExp = selectExp.fromExp;
    }

    public FromExp getFromClause() {
        return this.fromExp;
    }

    public SelectList getSelectList() {
        return this.attList;
    }

    public QueryExp getWhereClause() {
        return this.whereClause;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ").append(this.attList).append(" from ").append(this.fromExp);
        if (this.whereClause != null) {
            stringBuffer.append(" where ").append(this.whereClause);
        }
        return stringBuffer.toString();
    }
}

