/*
 * Copyright (c) 1999, 2001 by Sun Microsystems, Inc.
 * All rights reserved.
 *
 * Open Card Framework (OCF) Core Card Services header file
 */

#ifndef	_OCF_CORE_CARDSERVICES_H
#define	_OCF_CORE_CARDSERVICES_H

#pragma ident	"@(#)ocf_core_cardservices.h	1.18	01/04/18 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * OCF_SignatureCardService
 */
uint32_t OCF_SignatureCardService(OCF_CardServiceMethod_t,
					OCF_ClientHandle_t,
					OCF_CardHandle_t,
					OCF_CardServiceParams_t,
					OCF_CardServiceReturn_t);

typedef uint8_t * OCF_KEYREF_t;
typedef uint8_t * OCF_ALGO_t;
typedef uint8_t * OCF_KEY_t;
typedef uint8_t * OCF_KEYINFO_t;
typedef uint8_t * OCF_CERTREF_t;

typedef struct signData_t {
	OCF_KEYREF_t	privateKeyRef;
	OCF_ALGO_t	algorithm;
	OCF_Any_t	dataToBeSigned;
	OCF_Any_t	signedData;
} signData_t;

typedef struct signHash_t {
	OCF_KEYREF_t	privateKeyRef;
	OCF_ALGO_t	algorithm;
	OCF_Any_t	hashedData;
	OCF_Any_t	signedData;
} signHash_t;

typedef struct verifySignedData_t {
	OCF_KEYREF_t	publicKeyRef;
	OCF_ALGO_t 	algorithm;
	OCF_Any_t 	originalData;
	OCF_Any_t	signature;
	OCF_Boolean_t	status;
} verifySignedData_t;

typedef struct verifySignedHash_t {
	OCF_KEYREF_t	publicKeyRef;
	OCF_ALGO_t	algorithm;
	OCF_Any_t	hashedData;
	OCF_Any_t	signature;
	OCF_Boolean_t	status;
} verifySignedHash_t;

typedef struct generateKey_t {
	OCF_KEYREF_t	privateDesitnation;
	OCF_KEYREF_t	publicDesitnation;
	int32_t		strength;
	OCF_ALGO_t	algorithm;
} generateKey_t;

typedef struct readKey_t {
	OCF_KEYREF_t	publicKeyRef;
	OCF_ALGO_t	algorithm;
	OCF_KEY_t	publicKey;
} readKey_t;

/*
 * OCF_KeyImportCardService
 */
uint32_t OCF_KeyImportCardService(OCF_CardServiceMethod_t,
					OCF_ClientHandle_t,
					OCF_CardHandle_t,
					OCF_CardServiceParams_t,
					OCF_CardServiceReturn_t);

typedef struct importCertificate_t {
	OCF_CERTREF_t	destination;
	OCF_Any_t	certificate;
} importCertificate_t;

/*
 * OCF_FileAccessCardService
 */
uint32_t OCF_FileAccessCardService(OCF_CardServiceMethod_t,
					OCF_ClientHandle_t,
					OCF_CardHandle_t,
					OCF_CardServiceParams_t,
					OCF_CardServiceReturn_t);

typedef uint8_t * OCF_File_t;
typedef uint8_t * OCF_FileID_t;

typedef struct appendRecord_t {
	OCF_File_t	file;
	OCF_Any_t	data;
} appendRecord_t;

typedef struct existsRecord_t {
	OCF_File_t	file;
	OCF_Boolean_t	status;
} existsRecord_t;

typedef struct getFileInfo_t {
	OCF_File_t	file;
	OCF_FileID_t	fileID;
	int32_t		fileLength;
	int32_t		recordSize;
	OCF_Any_t	fileHeader;
	int32_t		fileType;
} getFileInfo_t;

typedef struct getRoot_t {
	OCF_File_t	path;
} getRoot_t;

typedef struct readFile_t {
	OCF_File_t	filename;
	int32_t		offset;
	int32_t		length;
	OCF_Any_t	dataRead;
} readFile_t;

typedef struct readRecord_t {
	OCF_File_t	filename;
	int32_t		recordNumber;
	OCF_Any_t	dataRead;
} readRecord_t;

typedef struct readRecords_t {
	OCF_File_t	filename;
	int32_t		numberOfRecords;
	OCF_Any_t	*dataRead;
} readRecords_t;

typedef struct writeFilePartialArray_t {
	OCF_File_t	filename;
	int32_t		foffset;
	int32_t		soffset;
	OCF_Any_t	dataSource;
	int32_t		length;
} writeFilePartialArray_t;

typedef struct writeFile_t {
	OCF_File_t	filename;
	int32_t		offset;
	OCF_Any_t	dataSource;
} writeFile_t;

typedef struct writeRecord_t {
	OCF_File_t	filename;
	int32_t		recordNumber;
	OCF_Any_t	data;
} writeRecord_t;

/*
 * OCF_PINCardService
 */
typedef uint8_t * OCF_PIN_t;

typedef struct changePIN_t {
	OCF_PIN_t	oldPIN;
	OCF_PIN_t	newPIN;
} changePIN_t;

/* PIN card service methods */
#define	OCF_PINCardService_ValidatePin		(uchar_t *) "validatePin"
#define	OCF_PINCardService_ChangePin		(uchar_t *) "changePin"
#define	OCF_PINCardService_ValidateAndUnlock	(uchar_t *) "validateAndUnlock"
#define	OCF_PINCardService_Lock			(uchar_t *) "lock"
#define	OCF_PINCardService_IsLocked		(uchar_t *) "isLocked"

uint32_t OCF_PINCardService(OCF_CardServiceMethod_t,
    OCF_ClientHandle_t,	OCF_CardHandle_t, OCF_CardServiceParams_t,
    OCF_CardServiceReturn_t);

/*
 * OCF_PassThruCardService
 */
/* PassThru card service methods */
#define OCF_PassThruCardService_sendCommandAPDU	(uchar_t *) "sendCommandAPDU"

uint32_t OCF_PassThruCardService(OCF_CardServiceMethod_t,
    OCF_ClientHandle_t, OCF_CardHandle_t, uint8_t *, size_t,
    uint8_t **, size_t *);

typedef uint8_t * OCF_APDU_t;

/*
 * OCF_UserInfoCardService
 */
typedef struct getUserInfo_t {
	int8_t *	type;
	int8_t *	userName;
} getUserInfo_t;

typedef struct getUserPasswordInfo_t {
	int8_t *	type;
	int8_t *	password;
} getUserPasswordInfo_t;

typedef struct setUserInfo_t {
	int8_t *	type;
	int8_t *	userName;
} setUserInfo_t;

typedef struct setUserPassword_t {
	int8_t *	type;
	int8_t *	password;
} setUserPassword_t;

/* User info method names */
#define	OCF_UserInfoCardService_GetUserInfo	(uchar_t *) "getUserInfo"
#define	OCF_UserInfoCardService_GetUserPassword	(uchar_t *) "getUserPassword"
#define	OCF_UserInfoCardService_SetUserInfo	(uchar_t *) "setUserInfo"
#define	OCF_UserInfoCardService_SetUserPassword	(uchar_t *) "setUserPassword"
#define	OCF_UserInfoCardService_DeleteUserInfo	(uchar_t *) "deleteUserInfo"

uint32_t OCF_UserInfoCardService(OCF_CardServiceMethod_t,
    OCF_ClientHandle_t, OCF_CardHandle_t, OCF_CardServiceParams_t,
    OCF_CardServiceReturn_t);

/*
 * OCF_CardletAdminCardService
 */
uint32_t OCF_CardletAdminCardService(OCF_CardServiceMethod_t,
						OCF_ClientHandle_t,
						OCF_CardHandle_t,
						OCF_CardServiceParams_t,
						OCF_CardServiceReturn_t);

/*
 * OCF_CardPropertyCardService
 */
uint32_t OCF_CardPropertyCardService(OCF_CardServiceMethod_t,
						OCF_ClientHandle_t,
						OCF_CardHandle_t,
						OCF_CardServiceParams_t,
						OCF_CardServiceReturn_t);

/*
 * OCF_CardService
 */
uint32_t OCF_CardService(OCF_CardServiceClass_t, OCF_CardServiceMethod_t,
    OCF_ClientHandle_t, OCF_CardHandle_t, OCF_CardServiceParams_t,
    OCF_CardServiceReturn_t);

#ifdef	__cplusplus
}
#endif

#endif	/* _OCF_CORE_CARDSERVICES_H */
