/*
 * Copyright (c) 1995,1998-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_SPITREGS_H
#define	_SYS_SPITREGS_H

#pragma ident	"@(#)spitregs.h	1.28	01/02/14 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This file is cpu dependent.
 */

/*
 * LSU Control Register
 *
 * +------+----+----+----+----+----+----+-----+------+----+----+----+---+
 * | Resv | PM | VM | PR | PW | VR | VW | Rsv |  FM  | DM | IM | DC | IC|
 * +------+----+----+----+----+----+----+-----+------+----+----+----+---+
 *  63  41   33   25   24   23	 22   21   20  19   4	3    2	  1   0
 *
 */

#define	LSU_IC		0x00000001	/* icache enable */
#define	LSU_DC		0x00000002	/* dcache enable */
#define	LSU_IM		0x00000004	/* immu enable */
#define	LSU_DM		0x00000008	/* dmmu enable */
#define	LSU_FM		0x000FFFF0	/* parity mask */
#define	LSU_VW		0x00200000	/* virtual watchpoint write enable */
#define	LSU_VR		0x00400000	/* virtual watchpoint read enable */
#define	LSU_PW		0x00800000	/* phys watchpoint write enable */
#define	LSU_PR		0x01000000	/* phys watchpoint read enable */

/*
 * Defines for the different types of dcache_flush
 * it is stored in dflush_type
 */
#define	FLUSHALL_TYPE	0x0		/* blasts all cache lines */
#define	FLUSHMATCH_TYPE	0x1		/* flush entire cache but check each */
					/* each line for a match */
#define	FLUSHPAGE_TYPE	0x2		/* flush only one page and check */
					/* each line for a match */

/*
 * D-Cache Tag Data Register
 *
 * +----------+--------+----------+
 * | Reserved | DC_Tag | DC_Valid |
 * +----------+--------+----------+
 *  63	    30 29    2	1	 0
 *
 */
#ifdef STINGRAY
#define	ICACHE_FLUSHSZ	0x40	/* one line in i$ */
#else /* STINGRAY */
#define	ICACHE_FLUSHSZ	0x20	/* one line in i$ */
#endif /* STINGRAY */
#define	DC_PTAG_SHIFT	34
#define	DC_LINE_SHIFT	30
#define	SF_DC_VBIT_SHIFT 2
#define	SF_DC_VBIT_MASK	0x3
#define	IC_LINE_SHIFT	3
#define	IC_LINE		512
#define	INDEX_BIT_SHIFT	13

/*
 * Definitions of sun4u cpu implementations as specified in version register
 */
#define	SPITFIRE_IMPL	0x10
#define	IS_SPITFIRE(impl)	((impl) == SPITFIRE_IMPL)
#define	SPITFIRE_MAJOR_VERSION(rev)	(((rev) >> 4) & 0xf)
#define	SPITFIRE_MINOR_VERSION(rev)	((rev) & 0xf)

#define	BLACKBIRD_IMPL	0x11
#define	IS_BLACKBIRD(impl)	((impl) == BLACKBIRD_IMPL)
#define	BLACKBIRD_MAJOR_VERSION(rev)	(((rev) >> 4) & 0xf)
#define	BLACKBIRD_MINOR_VERSION(rev)	((rev) & 0xf)

#define	SABRE_IMPL	0x12
#define	HUMMBRD_IMPL	0x13

/*
 * Bits of Spitfire Asynchronous Fault Status Register
 */
#define	P_AFSR_STICKY	0x00000001FFF00000ULL /* mask for all sticky bits */
#define	P_AFSR_ERRS	0x000000001EE00000ULL /* mask for remaining errors */
#define	P_AFSR_ME	0x0000000100000000ULL /* errors > 1, same type!=CE */
#define	P_AFSR_PRIV	0x0000000080000000ULL /* priv/supervisor access */
#define	P_AFSR_ISAP	0x0000000040000000ULL /* incoming system addr. parity */
#define	P_AFSR_ETP	0x0000000020000000ULL /* ecache tag parity */
#define	P_AFSR_IVUE	0x0000000010000000ULL /* interrupt vector with UE */
#define	P_AFSR_TO	0x0000000008000000ULL /* bus timeout */
#define	P_AFSR_BERR	0x0000000004000000ULL /* bus error */
#define	P_AFSR_LDP	0x0000000002000000ULL /* data parity error from SDB */
#define	P_AFSR_CP	0x0000000001000000ULL /* copyout parity error */
#define	P_AFSR_WP	0x0000000000800000ULL /* writeback ecache data parity */
#define	P_AFSR_EDP	0x0000000000400000ULL /* ecache data parity */
#define	P_AFSR_UE	0x0000000000200000ULL /* uncorrectable ECC error */
#define	P_AFSR_CE	0x0000000000100000ULL /* correctable ECC error */
#define	P_AFSR_ETS	0x00000000000F0000ULL /* cache tag parity syndrome */
#define	P_AFSR_P_SYND	0x000000000000FFFFULL /* data parity syndrome */
#ifdef STINGRAY
#define	P_AFSR_TL1	0x0000000040000000ULL /* incoming system addr. parity */
#endif STINGRAY

/*
 * Shifts for Spitfire Asynchronous Fault Status Register
 */
#define	P_AFSR_D_SIZE_SHIFT	(57)
#define	P_AFSR_ETS_SHIFT	(16)

/*
 * Bits of Spitfire Asynchronous Fault Status Register
 */
#define	S_AFSR_MASK	0x00000001FFFFFFFFULL /* <33:0>: valid AFSR bits */

/*
 * Bits of Spitfire Asynchronous Fault Address Register
 * The Sabre AFAR includes more bits since it only has a UDBH, no UDBL
 */
#define	S_AFAR_PA	0x000001FFFFFFFFF0ULL /* PA<40:4>: physical address */
#define	SABRE_AFAR_PA	0x000001FFFFFFFFF8ULL /* PA<40:3>: physical address */

/*
 * Bits of Spitfire/Sabre/Hummingbird Error Enable Registers
 */
#define	EER_EPEN	0x00000000000000010ULL /* enable ETP, EDP, WP, CP */
#define	EER_UEEN	0x00000000000000008ULL /* enable UE */
#define	EER_ISAPEN	0x00000000000000004ULL /* enable ISAP */
#define	EER_NCEEN	0x00000000000000002ULL /* enable the other errors */
#define	EER_CEEN	0x00000000000000001ULL /* enable CE */
#define	EER_DISABLE	0x00000000000000000ULL /* no errors enabled */
#define	EER_ECC_DISABLE	(EER_EPEN|EER_UEEN|EER_ISAPEN)
#define	EER_CE_DISABLE	(EER_EPEN|EER_UEEN|EER_ISAPEN|EER_NCEEN)
#define	EER_ENABLE	(EER_EPEN|EER_UEEN|EER_ISAPEN|EER_NCEEN|EER_CEEN)

/*
 * Bits and vaddrs of Spitfire Datapath Error Registers
 */
#define	P_DER_UE	0x00000000000000200ULL	/* UE has occurred */
#define	P_DER_CE	0x00000000000000100ULL	/* CE has occurred */
#define	P_DER_E_SYND	0x000000000000000FFULL	/* SYND<7:0>: ECC syndrome */
#define	P_DER_H		0x0			/* datapath error reg upper */
#define	P_DER_L		0x18			/* datapath error reg upper */

/*
 * Bits of Spitfire Datapath Control Register
 */
#define	P_DCR_VER	0x000001E00		/* datapath version */
#define	P_DCR_F_MODE	0x000000100		/* send FCB<7:0> */
#define	P_DCR_FCB	0x0000000FF		/* ECC check bits to force */
#define	P_DCR_H		0x20			/* datapath control reg upper */
#define	P_DCR_L		0x38			/* datapath control reg lower */

/*
 * Bits and shifts for the Spitfire (S), Sabre (SB) and Hummingbird (HB)
 * Ecache tag data
 */
#define	S_ECTAG_MASK	0x000000000003FFFFFULL	/* spitfire ecache tag mask */
#define	SB_ECTAG_MASK	0x00000000000000FFFULL	/* sabre ecache tag mask */
#define	HB_ECTAG_MASK	0x0000000000000FFFFULL	/* hbird ecache tag mask */
#define	S_ECSTATE_MASK	0x00000000001C00000ULL	/* spitfire tag state mask */
#define	SB_ECSTATE_MASK 0x0000000000000C000ULL	/* sabre tag state mask */
#define	HB_ECSTATE_MASK 0x00000000000030000ULL	/* hbird tag state mask */
#define	S_ECPAR_MASK	0x0000000001E000000ULL	/* spitfire tag parity mask */
#define	SB_ECPAR_MASK	0x00000000000030000ULL	/* sabre tag parity mask */
#define	HB_ECPAR_MASK	0x00000000000300000ULL	/* hbird tag parity mask */
#define	S_ECTAG_SHIFT		19		/* spitfire ecache tag shift */
#define	SB_ECTAG_SHIFT		18		/* sabre ecache tag shift */
#define	HB_ECTAG_SHIFT		16		/* hbird ecache tag shift */
#define	S_ECSTATE_SHIFT		22		/* spitfire tag state shift */
#define	SB_ECSTATE_SHIFT	14		/* sabre tag state shift */
#define	HB_ECSTATE_SHIFT	16		/* hbird tag state shift */
#define	S_ECPAR_SHIFT		25		/* spitfire tag parity shift */
#define	SB_ECPAR_SHIFT		16		/* sabre tag parity shift */
#define	HB_ECPAR_SHIFT		20		/* hbird tag parity shift */

/*
 * Constants representing the complete Spitfire (S), Sabre (SB) and Hummingbird
 * (HB) tag state:
 */
#define	S_ECSTATE_SHR		0x1		/* shared */
#define	S_ECSTATE_EXL		0x3		/* exclusive */
#define	S_ECSTATE_OWN		0x5		/* owner */
#define	S_ECSTATE_MOD		0x7		/* modified */
#define	SB_ECSTATE_EXL		0x2		/* exclusive */
#define	SB_ECSTATE_MOD		0x3		/* modified */
#define	HB_ECSTATE_EXL		0x2		/* exclusive */
#define	HB_ECSTATE_MOD		0x3		/* modified */

/*
 * Constants representing the individual Spitfire (S), Sabre (SB) and
 * Hummingbird (HB) state bits:
 */
#define	S_ECSTATE_VALID		0x1		/* line is valid */
#define	S_ECSTATE_DIRTY		0x4		/* line is dirty */
#define	SB_ECSTATE_VALID	0x2		/* line is valid */
#define	SB_ECSTATE_DIRTY	0x1		/* line is dirty */
#define	HB_ECSTATE_VALID	0x2		/* line is valid */
#define	HB_ECSTATE_DIRTY	0x1		/* line is dirty */

#ifdef HUMMINGBIRD

#define	HB_ESTAR_MODE		INT64_C(0x1FE0000F080)	/* estar mode reg */
#define	HB_MEM_CNTRL0		INT64_C(0x1FE0000F010)	/* mem control0 reg */
#define	HB_REFRESH_COUNT_MASK	0x7F00			/* mc0<14:8>: ref cnt */
#define	HB_REFRESH_COUNT_SHIFT	8			/* bits to shift */
#define	HB_REFRESH_INTERVAL	INT64_C(7800)		/* 7800 nsecs memory */
							/* refresh interval */
							/* works for all DIMM */
							/* same value as OBP */
#define	HB_REFRESH_CLOCKS_PER_COUNT	INT64_C(64)	/* cpu clks per count */
#define	HB_SELF_REFRESH_MASK	0x10000			/* mc0<16>: self ref */
#define	HB_SELF_REFRESH_SHIFT	16			/* bits to shift */
#define	HB_SELF_REFRESH_DISABLE	0			/* disable self ref */
#define	HB_SELF_REFRESH_ENABLE	1			/* enable self ref */

#define	HB_ECLK_1	INT64_C(0x0000000000000000) 	/* 1/1 clock */
#define	HB_ECLK_2	INT64_C(0x0000000000000001) 	/* 1/2 clock */
#define	HB_ECLK_4	INT64_C(0x0000000000000003) 	/* 1/4 clock */
#define	HB_ECLK_6	INT64_C(0x0000000000000002) 	/* 1/6 clock */
#define	HB_ECLK_8	INT64_C(0x0000000000000004) 	/* 1/8 clock */
#define	HB_ECLK_MASK	(HB_ECLK_1|HB_ECLK_2|HB_ECLK_4|HB_ECLK_6|HB_ECLK_8)


/*
 * UPA Configuration Register
 *
 * +--------------+----+------+------+----------+------+-------------+
 * |     Resv     | RR |  DM  | ELIM |   PCON   | MID  |     PCAP    |
 * +--------------+----+------+------+----------+------+-------------+
 *  63          39  38  37..36 35..33 32......22 21..17 16..........0
 *
 */

#define	HB_UPA_DMAP_DATA_BIT	36	/* loads and stores direct mapped */
#define	HB_UPA_DMAP_INSTR_BIT	37	/* instruction misses direct mapped */
#define	HB_UPA_RR_BIT		38	/* reset rand generator */

#endif /* HUMMINGBIRD */

#ifdef _KERNEL

#ifndef _ASM

void	get_udb_errors(uint64_t *udbh, uint64_t *udbl);

#endif /* !_ASM */

#ifdef STINGRAY

/*
 * Stingray additions.
 */

#define IFTYPE_UTLB_MULTIPLE_HIT	0x1
#define IFTYPE_MTLB_PARITY_ERROR	0x2
#define IFTYPE_MTLB_MULTIPLE_HIT	0x3
#define IFTYPE_I1_TAG_PARITY_ERROR	0x4
#define IFTYPE_I1_TAG_MULTIPLE_HIT	0x5
#define IFTYPE_I1_ECC_SINGLE		0x6
#define IFTYPE_I1_ECC_MULTI		0x7
#define IFTYPE_UPA_BUS_ERROR		0x8
#define IFTYPE_UPA_TIMEOUT		0x9
#define IFTYPE_I0_TAG_PARITY_ERROR	0xe
#define IFTYPE_I0_DATA_PARITY_ERROR	0xf

#define DFTYPE_UTLB_MULTIPLE_HIT	0x1
#define DFTYPE_MTLB_PARITY_ERROR	0x2
#define DFTYPE_MTLB_MULTIPLE_HIT	0x3
#define DFTYPE_D1_TAG_PARITY_ERROR	0x4
#define DFTYPE_D1_TAG_MULTIPLE_HIT	0x5
#define DFTYPE_D1_ECC_SINGLE		0x6
#define DFTYPE_D1_ECC_MULTI		0x7
#define DFTYPE_UPA_BUS_ERROR		0x8
#define DFTYPE_UPA_TIMEOUT		0x9

#ifdef _ASM
#define	scr	asr31		/* hack so %scr will work till we get assembler support */
#define	hwmode	asr18		/* hack so %hwmode will work till we get assembler support */
#define	iftype	asr24		/* instruction fault type register */
#define	dfaddr	asr28		/* data fault address register */
#define	dftype	asr29		/* data fault type register */
#endif

/*
 * State Control Register Bits
 */
#define	SCR_SEQ_MODE		0x0000000000000001 /* sequential mode */
#define	SCR_INVALIDATE_I0	0x0000000000000002 /* blow i-cache, level 0 */
#define	SCR_PIPELINE_MODE	0x0000000000000004 /* one instr per cycle */

						   /* [3:6] reserved */

#define	SCR_SW_TRIGGER		0x0000000000000080 /* software trigger */

						   /* [8:10] watchdog timer value */
#define	SCR_WATCHDOG_TMR1	0x0000000000000000 /* timer = 2^12 */
#define	SCR_WATCHDOG_TMR2	0x0000000000000100 /* timer = 2^16 */
#define	SCR_WATCHDOG_TMR3	0x0000000000000200 /* timer = 2^18 */
#define	SCR_WATCHDOG_TMR4	0x0000000000000300 /* timer = 2^20 */
#define	SCR_WATCHDOG_TMR5	0x0000000000000400 /* timer = 2^22 */
#define	SCR_WATCHDOG_TMR6	0x0000000000000500 /* timer = 2^24 */
#define	SCR_WATCHDOG_TMR7	0x0000000000000600 /* timer = 2^28 */
#define	SCR_WATCHDOG_TMR8	0x0000000000000700 /* timer = 2^30 */
#define	SCR_WATCHDOG_TMR_MASK	0x0000000000000700 /* mask for timer bits */

						   /* [11:12] watchdog enable */
#define	SCR_WATCHDOG_ENA_NEVER	0x0000000000000000 /* watchdog trap never occurs */
#define	SCR_WATCHDOG_ENA_UNDEF	0x0000000000000800 /* undefined */
#define	SCR_WATCHDOG_ENA_EXEC	0x0000000000001000 /* trap processed in exec state */
#define	SCR_WATCHDOG_ENA_RED	0x0000000000001800 /* trap processed in RED state */
#define	SCR_WATCHDOG_ENA_MASK	0x0000000000001800 /* mask for enable bits */

#define	SCR_PERF_MON_U_ACCESS	0x0000000000002000 /* allow non-privileged access to
						      the performance monitor registers */
						   /* [14:15] Performance */
						   /* monitoring mode select */
#define	SCR_PMEN_SEL_U_ONLY	0x0000000000004000 /* Update Perf. Monitor */
						   /* counters for User Mode */
						   /* execution only */
#define	SCR_PMEN_SEL_S_ONLY	0x0000000000008000 /* Update Perf. Monitor */
						   /* counters for Supervisor */
						   /* Mode execution only */
#define	SCR_PMEN_SEL_MASK	0x000000000000C000 /* Performance Monitoring */
						   /* ENable SELection mask */

						   /* [16:17] global view for debug bus */
#define	SCR_DEBUG_GL_VIEW_HI	0x0000000000000000 /* Highlite view */
#define	SCR_DEBUG_GL_VIEW_CPU	0x0000000000010000 /* CPU view */
#define	SCR_DEBUG_GL_VIEW_TR	0x0000000000020000 /* address translation view */
#define	SCR_DEBUG_GL_VIEW_UC	0x0000000000030000 /* UC view (E$) */
#define	SCR_DEBUG_GL_VIEW_MASK	0x0000000000030000 /* mask debug global view bits */

						   /* [18:19] cpu view for debug bus */
#define	SCR_DEBUG_CPU_VIEW_IT	0x0000000000000000 /* instruction tracking bus */
#define	SCR_DEBUG_CPU_VIEW_IF	0x0000000000040000 /* instruction fetch bus */
#define	SCR_DEBUG_CPU_VIEW_LS	0x0000000000080000 /* load/store bus */
#define	SCR_DEBUG_CPU_VIEW_INT	0x00000000000C0000 /* internal bus */
#define	SCR_DEBUG_CPU_VIEW_MASK	0x00000000000C0000 /* mask debug cpu view bits */

#define	SCR_CONSV_STORE_EXEC	0x0000000000100000 /* stores delayed until all instructions
							except load/stores have completed */

						   /* [21:26] reserved */

						   /* [27:52] disable hardware features
						   	for debug/bringup/workarounds	*/
#define	SCR_DISABLE_UITLB	0x0000000008000000 /* disable uITLB */
#define	SCR_DISABLE_UDTLB	0x0000000010000000 /* disable uDTLB */
#define	SCR_DISABLE_MITLB	0x0000000020000000 /* disable instr MTLB */
#define	SCR_DISABLE_MDTLB	0x0000000040000000 /* disable data MTLB */
#define	SCR_DISABLE_UPA_AD_PAR	0x0000000080000000 /* disable UP address parity check */
#define	SCR_DISABLE_IC_WAY0	0x0000000100000000 /* I1 cache disable way 0 */
#define	SCR_DISABLE_IC_WAY1	0x0000000200000000 /* I1 cache disable way 1 */
#define	SCR_DISABLE_IC_WAY2	0x0000000400000000 /* I1 cache disable way 2 */
#define	SCR_DISABLE_IC_WAY3	0x0000000800000000 /* I1 cache disable way 3 */
#define	SCR_DISABLE_DC_WAY0	0x0000001000000000 /* D1 cache disable way 0 */
#define	SCR_DISABLE_DC_WAY1	0x0000002000000000 /* D1 cache disable way 1 */
#define	SCR_DISABLE_DC_WAY2	0x0000004000000000 /* D1 cache disable way 2 */
#define	SCR_DISABLE_DC_WAY3	0x0000008000000000 /* D1 cache disable way 3 */
#define	SCR_DISABLE_I0_PAR	0x0000010000000000 /* disable I0 cache parity check */
#define	SCR_DISABLE_I1_PAR	0x0000020000000000 /* disable I1 cache tag parity check */
#define	SCR_DISABLE_D1_PAR	0x0000040000000000 /* disable D1 cache tag parity check */
#define	SCR_DISABLE_UC_PAR	0x0000080000000000 /* disable UC (E$) cache tag parity */
#define	SCR_DISABLE_UITLB_HIT	0x0000100000000000 /* disable multiple uITLB hit check */
#define	SCR_DISABLE_UDTLB_HIT	0x0000200000000000 /* disable multiple uDTLB hit check */
#define	SCR_DISABLE_MDTLB_PAR	0x0000400000000000 /* disable MTLB parity check */
#define	SCR_DISABLE_UPA_ECC	0x0000800000000000 /* disable UPA ECC error check */
#define	SCR_DISABLE_I1_ECC	0x0001000000000000 /* disable I1 cache ECC error check */
#define	SCR_DISABLE_D1_ECC	0x0002000000000000 /* disable D1 cache ECC error check */
#define	SCR_DISABLE_UC_ECC	0x0004000000000000 /* disable UC (E$) cache ECC error check */
#define	SCR_DISABLE_ASYNC_ERR	0x0008000000000000 /* disable asynchronous error traps */
#define	SCR_DISABLE_ASYNC_ECC	0x0010000000000000 /* disable asynchronous single ECC
						   	error traps	*/

						   /* [53:63] reserved */

#define SCR_DISABLE_DC_SHIFT    36                 /* for checking D$ status */
#define SCR_DISABLE_DC_ALL     (SCR_DISABLE_DC_WAY0 | SCR_DISABLE_DC_WAY1 \
				 | SCR_DISABLE_DC_WAY2 | SCR_DISABLE_DC_WAY3 )
#define SCR_DISABLE_DC_BITS    (SCR_DISABLE_DC_ALL >> SCR_DISABLE_DC_SHIFT)

#define SCR_DISABLE_IC_SHIFT    32                 /* for checking I$ status */
#define SCR_DISABLE_IC_ALL     (SCR_DISABLE_IC_WAY0 | SCR_DISABLE_IC_WAY1 \
				 | SCR_DISABLE_IC_WAY2 | SCR_DISABLE_IC_WAY3 )
#define SCR_DISABLE_IC_BITS    (SCR_DISABLE_IC_ALL >> SCR_DISABLE_IC_SHIFT)

#define SCR_DISABLE_DIC_SHIFT    32                 /* for checking I$ status */
#define SCR_DISABLE_DIC_ALL     (SCR_DISABLE_DC_ALL | SCR_DISABLE_IC_ALL)
#define SCR_DISABLE_DIC_BITS    (SCR_DISABLE_DIC_ALL >> SCR_DISABLE_DIC_SHIFT)

/*
 * Hardware mode register bits.
 */

/* V9 memory model to Stingray memory model mapping [5:0] */
#define	HWM_TSO_SEL_HLSO	0x000
#define	HWM_TSO_SEL_HTSO	0x001
#define	HWM_TSO_SEL_HSTO	0x002
#define	HWM_TSO_SEL_RESV	0x003	/* reserved */
#define	HWM_PSO_SEL_HLSO	0x000
#define	HWM_PSO_SEL_HTSO	0x004
#define	HWM_PSO_SEL_HSTO	0x008
#define	HWM_PSO_SEL_RESV	0x00C	/* reserved */
#define	HWM_RMO_SEL_HLSO	0x000
#define	HWM_RMO_SEL_HTSO	0x010
#define	HWM_RMO_SEL_HSTO	0x020
#define	HWM_RMO_SEL_RESV	0x030	/* reserved */
#define	HWM_MM_SEL_BITS		0x03F

/* Reserved [7:6] */

/* Branch prediction [9:8] */
#define	HWM_BRM_2LVL_ADAP	0x000	/* two-level adaptive */
#define	HWM_BRM_CONV_2BIT	0x100	/* conventional 2-bit scheme */
#define	HWM_BRM_RESERVED	0x200	/* reserved */
#define	HWM_BRM_USE_PBIT	0x300	/* use instruction branch prediction bits */
#define	HWM_BRM_BITS		0x300	/* all branch prediction bits */

#define	HWM_DPREFETCH_ENA	0x400	/* data prefetch enable */

#define READ_FADDR(faddr, tstat)		\
	rd	%dfaddr, faddr			;\
	rdpr	%tstate, tstat			;\
	andcc	tstat, TSTATE_AM, tstat		;\
	bne,a	%xcc, 1f			;\
	 srl	faddr, 0, faddr			;\
1:

#define MASK_UP32BIT(reg1, reg2, reg3)		\
	andcc	reg3, TSTATE_AM, %g0		;\
	be,a	%xcc, 1f			;\
	 nop					;\
	srl	reg1, 0, reg1			;\
	srl	reg2, 0, reg2			;\
1:

#define FJ_PA_MASK_UPPER        0x000001FF /* PA address mask upper */
#define FJ_PA_MASK_LOWER        0xFFFFFFF0 /* PA address mask lower */
#define DISABLE_ERROR_TRAP      0x7FF00 /* except for SECC and MECC */
#define DISABLE_UE_TRAP         0x80000 /* disable UE Error */

#define FJ_ERR_CNT_MASK         0xFFF   /* Error CNT MASK */
#define MTLB_CNT_MASK           0x0F	/* MTLB CNT MASK */
#define L1_CNT_SHIFT            4
#define L1_CNT_MASK             0xF0    /* L1-Cache CNT MASK */
#define L0_CNT_SHIFT            8
#define L0_CNT_MASK             0x0F00  /* L0-Cache CNT MASK */
#define U2_LINESZ_SHIFT         16
#define U2_LINESZ               0x40
#define U2_SZ_SHIFT             32
#define PIO_ACCESS		0x10000000000
#define ERR_LOG_SZ              (NCPU*16)
#define NEXTLOG                 0x8
#define UE_UNKNOWN              0x0
#define UE_UPA                  0x1
#define UE_U2                   0x2
#define UE_D1                   0x3
#define UE_IV                   0x4
#define FJSV_ICU 		0x1
#define FJSV_TDU 		0x2
#define	FJSV_DC			0x4
#define	FJSV_CE_ERROR		0x1
#define FJSV_UE_ERROR		0x2
#define FJSV_L1_ERROR		0x3
#define	FJSV_STNGRY		0x3
#define FJSV_KILAUEA		0x4
				
#define	SCR0			0	/* %scratch0 */
#define	SCR1			1	/* %scratch1 */
#define	SCR2			2	/* %scratch2 */
#define	SCR3			3	/* %scratch3 */
#define	G0_REG			0	/* %g0 */
#define	G1_REG			1	/* %g1 */
#define	G2_REG			2	/* %g2 */
#define	G3_REG			3	/* %g3 */
#define	G4_REG			4	/* %g4 */
#define	G5_REG			5	/* %g5 */
#define	G6_REG			6	/* %g6 */
#define	G7_REG			7	/* %g7 */

#define	OPCODE_WR_SCRASR	0xB3800000	/* template */
#define	OPCODE_RD_SCRASR	0x81464000	/* template */
#define	WR_SCR_ASR(REG, SCR)	\
	.section ".text"	;\
	.align 4		;\
	.word	(OPCODE_WR_SCRASR | ((SCR)<<8) | ((REG)<<14))
#define	RD_SCR_ASR(SCR, REG)	\
	.section ".text"	;\
	.align 4		;\
	.word	(OPCODE_RD_SCRASR | ((SCR)<<8) | ((REG)<<25))

#endif /* STINGRAY */
#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SPITREGS_H */
