/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.logviewer.client.ContentEvent;
import com.sun.admin.logviewer.client.ContentListener;
import com.sun.admin.logviewer.client.LogActionsListener;
import com.sun.admin.logviewer.client.VLogViewer;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;

public abstract class Content {
    private static Vector instances = new Vector();
    private Vector listeners = new Vector();
    protected boolean bRefresh = false;
    protected boolean bRefreshInProgress = false;
    protected boolean bLocked = false;
    protected VScopeNode treeNode = null;
    protected VScopeNode rootNode = null;
    protected Vector vDataCache = new Vector();
    protected VConsoleProperties properties = null;
    protected VDisplayModel displayModel = null;
    protected VLogViewer theApp;

    public Content(VLogViewer vLogViewer) {
        this.theApp = vLogViewer;
        instances.addElement(this);
    }

    public synchronized void addContentListener(ContentListener contentListener) {
        this.listeners.addElement(contentListener);
    }

    public abstract void backUpFile();

    public static void broadcastUpdate(Object object, Object object2, boolean bl) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object2 == null && !bl) {
            return;
        }
        int n = 0;
        while (n < instances.size()) {
            Content content = (Content)instances.elementAt(n);
            if (!content.isRefreshed()) {
                // empty if block
            }
            ++n;
        }
    }

    public abstract void clear(boolean var1);

    public void clearSelection() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        this.displayModel.clearSelection();
        this.fireItemPressed(0);
    }

    protected String[][] constructColumnHeaders(Object[][] objectArray) {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        int n = objectArray.length;
        String[][] stringArray = new String[n][3];
        JLabel jLabel = new JLabel();
        jLabel.setFont(ResourceManager.labelFont);
        FontMetrics fontMetrics = ((Component)jLabel).getFontMetrics(ResourceManager.labelFont);
        jLabel.setFont(ResourceManager.bodyFont);
        FontMetrics fontMetrics2 = ((Component)jLabel).getFontMetrics(ResourceManager.labelFont);
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectArray[n2][0];
            stringArray[n2][0] = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string);
            int n3 = fontMetrics.stringWidth(stringArray[n2][0]);
            int n4 = fontMetrics2.stringWidth("A");
            stringArray[n2][1] = new String(String.valueOf(Math.max(n3 += fontMetrics.stringWidth("AAAA"), n4 *= ((Integer)objectArray[n2][1]).intValue())));
            ++n2;
        }
        return stringArray;
    }

    public abstract Vector createNodes(Vector var1);

    public abstract void deleteSelected();

    public void die() {
        instances.removeElement(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.die();
    }

    protected void fireItemPressed(int n) {
        ContentEvent contentEvent = new ContentEvent(this, n, this.getSortAttribute(), null);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ContentListener contentListener = (ContentListener)this.listeners.elementAt(n2);
            contentListener.itemPressed(contentEvent);
            ++n2;
        }
    }

    protected abstract String[][] getColumnHeaders();

    public Vector getDataCache() {
        return this.vDataCache;
    }

    public VFilter getFilterControl() {
        return null;
    }

    public static Content getInstance(int n) {
        if (n < 0 || n >= instances.size()) {
            return null;
        }
        return (Content)instances.elementAt(n);
    }

    public VScopeNode getInternalRoot() {
        return this.rootNode;
    }

    public static int getNumInstances() {
        return instances.size();
    }

    public int getNumSelections() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        return this.displayModel.getSelectedNodes().size();
    }

    public Vector getSelected() {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        return this.displayModel.getSelectedNodes();
    }

    public VScopeNode getSelectedNode() {
        Vector vector = this.getSelected();
        if (vector.size() > 0) {
            return (VScopeNode)vector.firstElement();
        }
        return null;
    }

    protected abstract String getSortAttribute();

    public VScopeNode getTreeNode() {
        return this.treeNode;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public synchronized boolean isLocked() {
        return this.bLocked;
    }

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    public boolean isShowByTypeSupported() {
        return false;
    }

    public void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "Details");
        LogActionsListener logActionsListener = new LogActionsListener(this.theApp);
        logActionsListener.actionPerformed(actionEvent);
    }

    public void onSelection(Vector vector) {
        this.fireItemPressed(vector.size());
    }

    public abstract void openFile();

    public void openSelected() {
    }

    public abstract void preFilter();

    public abstract void refresh();

    public synchronized void removeContentListener(ContentListener contentListener) {
        this.listeners.removeElement(contentListener);
    }

    protected abstract void saveSortPreferences();

    public abstract void setDefaultColumnHeader();

    protected void setDisplayModel() {
        this.properties = this.theApp.getProperties();
        this.displayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
        this.setDefaultColumnHeader();
    }

    public void setSelected(Vector vector) {
        if (this.displayModel == null) {
            this.setDisplayModel();
        }
        this.displayModel.setSelectedNodes(vector);
        this.onSelection(vector);
    }

    public void setTreeNode(VScopeNode vScopeNode) {
        this.treeNode = vScopeNode;
    }

    public void showByType() {
    }

    public void showFilteredStatus() {
        boolean bl = this.theApp.getFilterPanel().getIsFilterEnabled();
        if (!bl) {
            this.theApp.getProperties().setProperty("vconsole.filteredstate", "false");
        } else {
            this.theApp.getProperties().setProperty("vconsole.filteredstate", "true");
        }
    }

    protected abstract void updateInfoBar();

    protected abstract void updateSortPreferences();

    protected abstract void updateStatusBar(int var1);

    public abstract void viewDetails();

    public abstract void viewSettings();

    public abstract String whatAmI();
}

