/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhcpconfig;

import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.DhcpCliOptions;
import com.sun.dhcpmgr.cli.common.DhcpCliPrint;
import com.sun.dhcpmgr.cli.common.DhcpCliProgram;
import com.sun.dhcpmgr.cli.common.GetOpt;
import com.sun.dhcpmgr.cli.dhcpconfig.ConfigureBootp;
import com.sun.dhcpmgr.cli.dhcpconfig.ConfigureDhcp;
import com.sun.dhcpmgr.cli.dhcpconfig.ConfigureNetwork;
import com.sun.dhcpmgr.cli.dhcpconfig.ConvertDataStore;
import com.sun.dhcpmgr.cli.dhcpconfig.DhcpCfgFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.ExportData;
import com.sun.dhcpmgr.cli.dhcpconfig.ImportData;
import com.sun.dhcpmgr.cli.dhcpconfig.ResourceStrings;
import com.sun.dhcpmgr.cli.dhcpconfig.UnconfigureDhcp;
import java.text.MessageFormat;

public class DhcpCfg
extends DhcpCliProgram {
    public static final String SIGNATURE = "dhcpconfig: ";
    private static String optString = "DUCnfxbkh;I:R:N:X:r:p:u:l:d:a:m:t:y:s:o:";
    private static final int CONFIGURE_DHCP = 68;
    private static final int CONFIGURE_BOOTP = 82;
    private static final int UNCONFIGURE_DHCP = 85;
    private static final int CONFIGURE_NETWORK = 78;
    private static final int CONVERT_DATA_STORE = 67;
    private static final int EXPORT_DATA = 88;
    private static final int IMPORT_DATA = 73;
    public static final int NON_NEGOTIABLE_LEASE = 110;
    public static final int FORCE = 102;
    public static final int DELETE_DATA = 120;
    public static final int DELETE_TABLES = 120;
    public static final int KEEP_TABLES = 107;
    public static final int POINT_TO_POINT = 98;
    public static final int HOSTS_RESOURCE = 104;
    public static final int DELETE_HOSTS = 104;
    public static final int RESOURCE = 114;
    public static final int RESOURCE_CONFIG = 117;
    public static final int PATH = 112;
    public static final int LEASE_LENGTH = 108;
    public static final int DNS_DOMAIN = 100;
    public static final int DNS_ADDRESSES = 97;
    public static final int NIS_ADDRESSES = 97;
    public static final int NETWORK_ADDRESSES = 97;
    public static final int SUBNET_MASK = 109;
    public static final int MACRO_LIST = 109;
    public static final int OPTION_LIST = 111;
    public static final int ROUTER_ADDRESSES = 116;
    public static final int NIS_DOMAIN = 121;
    public static final int HOSTS_DOMAIN = 121;
    private DhcpCfgFunction function = null;
    private DhcpCliOptions options = new DhcpCliOptions();
    private String[] args = null;

    public DhcpCfg(String[] stringArray) {
        this.args = stringArray;
    }

    public int execute() {
        int n = 0;
        GetOpt getOpt = new GetOpt(this.args, optString);
        try {
            int n2;
            while ((n2 = getOpt.getNextOption()) != -1) {
                this.processArg(n2, getOpt.getOptionArg());
            }
            int n3 = getOpt.getNextOptionIndex();
            if (this.args.length != n3) {
                Object[] objectArray = new Object[]{this.args[n3]};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("dhcpcfg_invalid_arg"));
                throw new IllegalArgumentException(messageFormat.format(objectArray));
            }
            if (this.function == null) {
                String string = this.getString("dhcpcfg_no_function_error");
                throw new IllegalArgumentException(string);
            }
            this.function.setOptions(this.options);
            this.function.setStandardOptions();
            n = this.function.execute();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
            stringBuffer.append(DhcpCliFunction.getMessage(illegalArgumentException));
            DhcpCliPrint.printErrMessage(stringBuffer.toString());
            DhcpCliPrint.printErrMessage("");
            this.usage();
            n = -1;
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer(SIGNATURE);
            stringBuffer.append(DhcpCliFunction.getMessage(throwable));
            DhcpCliPrint.printErrMessage(stringBuffer.toString());
            n = -1;
        }
        return n;
    }

    public String getManPage() {
        return "dhcpconfig(1M)";
    }

    public String getString(String string) {
        return ResourceStrings.getString(string);
    }

    public static void main(String[] stringArray) {
        DhcpCfg dhcpCfg = new DhcpCfg(stringArray);
        int n = -1;
        if (dhcpCfg.isValidUser()) {
            n = dhcpCfg.execute();
        }
        System.exit(n);
    }

    public void processArg(int n, String string) throws IllegalArgumentException {
        switch (n) {
            case 68: {
                this.function = new ConfigureDhcp();
                break;
            }
            case 82: {
                this.function = new ConfigureBootp(string);
                break;
            }
            case 85: {
                this.function = new UnconfigureDhcp();
                break;
            }
            case 78: {
                this.function = new ConfigureNetwork(string);
                break;
            }
            case 67: {
                this.function = new ConvertDataStore();
                break;
            }
            case 88: {
                this.function = new ExportData(string);
                break;
            }
            case 73: {
                this.function = new ImportData(string);
                break;
            }
            default: {
                this.options.setOption(n, string);
            }
        }
    }

    public void usage() {
        DhcpCliPrint.printErrMessage(this.getString("dhcpcfg_usage"));
    }
}

