/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.data;

import com.sun.dhcpmgr.data.AsciiOptionValue;
import com.sun.dhcpmgr.data.BogusOptionValue;
import com.sun.dhcpmgr.data.BooleanOptionValue;
import com.sun.dhcpmgr.data.IPOptionValue;
import com.sun.dhcpmgr.data.IncludeOptionValue;
import com.sun.dhcpmgr.data.NumberOptionValue;
import com.sun.dhcpmgr.data.OctetOptionValue;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.data.ValidationException;

public class OptionValueFactory {
    private static OptionsTable optionsTable = OptionsTable.getTable();

    public static OptionValue newOptionValue(String string) {
        if (string.length() == 0) {
            return new BogusOptionValue(string);
        }
        Option option = optionsTable.get(string);
        if (option == null) {
            if (string.equals("Include")) {
                return new IncludeOptionValue();
            }
            return new BogusOptionValue(string);
        }
        byte by = option.getType();
        if (by == Option.types[Option.ASCII].getCode()) {
            return new AsciiOptionValue(string);
        }
        if (by == Option.types[Option.BOOLEAN].getCode()) {
            return new BooleanOptionValue(string);
        }
        if (by == Option.types[Option.IP].getCode()) {
            return new IPOptionValue(string);
        }
        if (by == Option.types[Option.OCTET].getCode()) {
            return new OctetOptionValue(string);
        }
        if (by == Option.types[Option.NUMBER].getCode() || by == Option.types[Option.UNUMBER8].getCode() || by == Option.types[Option.UNUMBER16].getCode() || by == Option.types[Option.UNUMBER32].getCode() || by == Option.types[Option.UNUMBER64].getCode() || by == Option.types[Option.SNUMBER8].getCode() || by == Option.types[Option.SNUMBER16].getCode() || by == Option.types[Option.SNUMBER32].getCode() || by == Option.types[Option.SNUMBER64].getCode()) {
            return new NumberOptionValue(string);
        }
        return new BogusOptionValue(string);
    }

    public static OptionValue newOptionValue(String string, Object object) {
        OptionValue optionValue;
        try {
            optionValue = OptionValueFactory.newOptionValue(string);
            optionValue.setValue(object);
        }
        catch (ValidationException validationException) {
            optionValue = new BogusOptionValue(string, object);
        }
        return optionValue;
    }
}

