/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import opencard.tests.UseCaseException;

public abstract class UseCase {
    public static final String ENDL = "\n";
    protected static String d_name;
    protected static String d_description;
    protected static String d_src;
    protected PrintStream d_ps;

    public UseCase(PrintStream printStream) {
        this.d_ps = printStream;
    }

    protected void begin() {
        this.printHeader();
        try {
            this.execute();
        }
        catch (UseCaseException useCaseException) {
            this.d_ps.println("------------------------------------------------------------");
            this.d_ps.println("use case exception! " + useCaseException.getMessage());
            this.d_ps.println("Exception: " + useCaseException.getMessage());
            useCaseException.printStackTrace();
            this.d_ps.println("------------------------------------------------------------");
        }
    }

    protected void end() {
        this.printFooter();
    }

    protected abstract void execute() throws UseCaseException;

    public static String getDescription() {
        return d_description;
    }

    public static String getName() {
        return d_name;
    }

    public PrintStream getPrintStream() {
        return this.d_ps;
    }

    public static String getSource() {
        return d_src;
    }

    protected void printFooter() {
        this.d_ps.println("");
        this.d_ps.println("finished use case " + UseCase.getName());
        this.d_ps.println("------------------------------------------------------------");
    }

    protected void printHeader() {
        this.d_ps.println("------------------------------------------------------------");
        this.d_ps.println("start use case " + UseCase.getName());
        this.d_ps.println("");
    }

    public static void runUseCase(UseCase useCase) {
        useCase.begin();
        useCase.end();
    }

    public void setPrintStream(PrintStream printStream) {
        this.d_ps = printStream;
    }
}

