/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.tests.UseCase;

public class InsertRemoveCard
extends UseCase
implements CTListener {
    private boolean d_finish = false;

    static {
        UseCase.d_name = "insertion/removal of cards";
        UseCase.d_description = "notifies user when a card is being inserted or removed";
    }

    public InsertRemoveCard(PrintStream printStream) {
        super(printStream);
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) {
        this.d_ps.println("card inserted");
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) {
        this.d_ps.println("card removed");
    }

    public void execute() {
        try {
            SmartCard.start();
            CardTerminalRegistry.getRegistry().addCTListener(this);
            while (!this.d_finish) {
            }
            SmartCard.shutdown();
        }
        catch (OpenCardPropertyLoadingException openCardPropertyLoadingException) {
            this.d_ps.println("OpenCardPropertyLoadingException: ");
            this.d_ps.println(openCardPropertyLoadingException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.d_ps.println("OpenCardClassNotFoundException: ");
            this.d_ps.println(classNotFoundException.getMessage());
        }
        catch (CardTerminalException cardTerminalException) {
            this.d_ps.println("OpenCardLibraryLoadingException: ");
            this.d_ps.println(cardTerminalException.getMessage());
        }
        catch (CardServiceException cardServiceException) {
            this.d_ps.println("OpenCardInitializationException: ");
            this.d_ps.println(cardServiceException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        InsertRemoveCard insertRemoveCard = new InsertRemoveCard(printStream);
        UseCase.runUseCase(insertRemoveCard);
    }
}

