/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import java.util.Properties;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.tests.UseCase;

public class GetProperties
extends UseCase {
    static {
        UseCase.d_name = "get system properties";
        UseCase.d_description = "get system properties (which should include OpenCard specific ones)";
    }

    public GetProperties(PrintStream printStream) {
        super(printStream);
    }

    public void execute() {
        PrintStream printStream = this.getPrintStream();
        try {
            SmartCard.start();
            if (SmartCard.isStarted()) {
                printStream.println("configuration was done.");
            }
            Properties properties = System.getProperties();
            printStream.println("\nlist properties: \n");
            properties.list(printStream);
            SmartCard.shutdown();
        }
        catch (ClassNotFoundException classNotFoundException) {
            printStream.println("ClassNotFoundException: ");
            printStream.println(classNotFoundException.getMessage());
        }
        catch (OpenCardPropertyLoadingException openCardPropertyLoadingException) {
            printStream.println("OpenCardPropertyLoadingException: ");
            printStream.println(openCardPropertyLoadingException.getMessage());
        }
        catch (CardTerminalException cardTerminalException) {
            printStream.println("OpenCardLibraryLoadingException: ");
            printStream.println(cardTerminalException.getMessage());
        }
        catch (CardServiceException cardServiceException) {
            printStream.println("OpenCardInitializationException: ");
            printStream.println(cardServiceException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        GetProperties getProperties = new GetProperties(printStream);
        UseCase.runUseCase(getProperties);
    }
}

