/*
 * Decompiled with CFR 0.152.
 */
package opencard.tests;

import java.io.PrintStream;
import opencard.core.service.CardRequest;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.util.HexString;
import opencard.tests.UseCase;

public class GetCardID
extends UseCase {
    static {
        UseCase.d_name = "get a card id";
        UseCase.d_description = "wait until a card is being inserted into one of the slots of one of the terminals and get a card id";
    }

    public GetCardID(PrintStream printStream) {
        super(printStream);
    }

    private void appendBitAdjust(StringBuffer stringBuffer, byte by) {
        double[] dArray = new double[]{-1.0, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0, -1.0, 12.0, 20.0, 0.5, 0.25, 0.125, 0.0625, 0.03125, 0.015625};
        int n = by & 0xF;
        stringBuffer.append("bit rate adjustment ");
        if (dArray[n] < 0.0) {
            stringBuffer.append("???");
        } else {
            stringBuffer.append(dArray[n]);
        }
        stringBuffer.append('\n');
    }

    private void appendClockrate(StringBuffer stringBuffer, byte by) {
        double[] dArray = new double[]{-1.0, 5.0, 6.0, 8.0, 12.0, 16.0, 20.0, -1.0, 5.0, 7.5, 10.0, 15.0, 20.0, -1.0, -1.0, -1.0};
        int[] nArray = new int[]{-2, 372, 558, 744, 1116, 1488, 1860, -1, 512, 768, 1024, 1536, 2048, -1, -1, -1};
        int n = by >> 4 & 0xF;
        double d = dArray[n];
        int n2 = nArray[n];
        stringBuffer.append("Clock speed ");
        if (d < 0.0) {
            stringBuffer.append("???");
        } else {
            stringBuffer.append(d);
        }
        stringBuffer.append(" MHz, divided by ");
        if (n2 < 0) {
            stringBuffer.append("???");
        } else {
            stringBuffer.append(n2);
        }
        stringBuffer.append('\n');
    }

    private void appendHistoricals(StringBuffer stringBuffer, CardID cardID) {
        byte[] byArray = cardID.getHistoricals();
        stringBuffer.append("Historicals: ");
        if (byArray == null) {
            stringBuffer.append("none\n");
        } else {
            stringBuffer.append(HexString.hexify(byArray)).append('\n');
            stringBuffer.append("as a string: ");
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append(byArray[n] < 32 ? (char)' ' : (char)byArray[n]);
                ++n;
            }
            stringBuffer.append('\n');
        }
    }

    private void appendProgCurr(StringBuffer stringBuffer, byte by) {
        int[] nArray = new int[]{25, 50, 100, -1};
        int n = by >> 5 & 3;
        stringBuffer.append("max prog current ");
        if (by < 0) {
            stringBuffer.append("???");
        } else {
            stringBuffer.append(nArray[n]).append(" mA");
        }
        stringBuffer.append('\n');
    }

    private void appendT0(StringBuffer stringBuffer, byte by) {
        stringBuffer.append("TS = ").append(HexString.hexify(by)).append("    ");
        this.binify(stringBuffer, by);
        stringBuffer.append('\n');
    }

    private void appendTS(StringBuffer stringBuffer, byte by) {
        stringBuffer.append("TS = ").append(HexString.hexify(by)).append("    ");
        stringBuffer.append(by == 59 ? "direct" : "inverse").append(" convention\n");
    }

    private void binify(StringBuffer stringBuffer, byte by) {
        int n = 0;
        while (n < 8) {
            stringBuffer.append(by < 0 ? (char)'1' : '0');
            by = (byte)(by << 1);
            ++n;
        }
    }

    public void execute() {
        try {
            SmartCard.start();
            CardRequest cardRequest = new CardRequest();
            cardRequest.setWaitBehavior(1);
            SmartCard smartCard = SmartCard.waitForCard(cardRequest);
            if (smartCard != null) {
                CardID cardID = smartCard.getCardID();
                this.printCardID(cardID);
            } else {
                this.d_ps.println("did not get a SmartCard object!");
            }
            SmartCard.shutdown();
        }
        catch (Exception exception) {
            exception.printStackTrace(this.d_ps);
        }
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        GetCardID getCardID = new GetCardID(printStream);
        UseCase.runUseCase(getCardID);
    }

    public void printCardID(CardID cardID) {
        StringBuffer stringBuffer = new StringBuffer("Obtained the following CardID:\n\n");
        byte[] byArray = cardID.getATR();
        stringBuffer.append(HexString.hexify(byArray)).append('\n');
        this.appendHistoricals(stringBuffer, cardID);
        this.d_ps.println(stringBuffer);
    }
}

