/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ATR {
    public static final int DIRECT = 59;
    public static final int INVERSE = 63;
    public byte[] buf;
    public byte[] historical;
    public byte TS;
    public byte T0;
    public int F;
    public double D;
    public double Fs;
    public int I;
    public double P;
    public int N;
    public int W;
    private static final int TA_MASK = 16;
    private static final int TB_MASK = 32;
    private static final int TC_MASK = 64;
    private static final int TD_MASK = 128;
    private static final int RFU = -1;
    private static final int[] clockRateFactor;
    private static final double[] clockRateFreq;
    private static final double[] bitRateFactor;
    private static final int[] currentFactor;

    static {
        int[] nArray = new int[16];
        nArray[1] = 372;
        nArray[2] = 558;
        nArray[3] = 744;
        nArray[4] = 1116;
        nArray[5] = 1488;
        nArray[6] = 1860;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = 512;
        nArray[10] = 768;
        nArray[11] = 1024;
        nArray[12] = 1536;
        nArray[13] = 2048;
        nArray[14] = -1;
        nArray[15] = -1;
        clockRateFactor = nArray;
        double[] dArray = new double[16];
        dArray[1] = 5.0;
        dArray[2] = 6.0;
        dArray[3] = 8.0;
        dArray[4] = 12.0;
        dArray[5] = 16.0;
        dArray[6] = 20.0;
        dArray[7] = -1.0;
        dArray[8] = -1.0;
        dArray[9] = 5.0;
        dArray[10] = 7.5;
        dArray[11] = 10.0;
        dArray[12] = 15.0;
        dArray[13] = 20.0;
        dArray[14] = -1.0;
        dArray[15] = -1.0;
        clockRateFreq = dArray;
        bitRateFactor = new double[]{-1.0, 1.0, 2.0, 4.0, 8.0, 16.0, -1.0, -1.0, -1.0, -1.0, 0.5, 0.25, 0.125, 0.0625, 0.03125, 0.015625};
        currentFactor = new int[]{25, 50, 100, -1};
    }

    private ATR() {
    }

    public int interfaceChar(char c, int n) {
        try {
            byte by = this.T0;
            int n2 = 2;
            int[] nArray = new int[4];
            int n3 = 0;
            while (n3 < n) {
                nArray[0] = (by & 0x10) != 0 ? this.buf[n2++] & 0xFF : -1;
                nArray[1] = (by & 0x20) != 0 ? this.buf[n2++] & 0xFF : -1;
                nArray[2] = (by & 0x40) != 0 ? this.buf[n2++] & 0xFF : -1;
                if ((by & 0x80) == 0) {
                    return -1;
                }
                by = this.buf[n2++];
                nArray[3] = by & 0xFF;
                ++n3;
            }
            return nArray[c - 65];
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static ATR parse(byte[] byArray) {
        try {
            return ATR.read(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] protocols() {
        byte[] byArray = new byte[32];
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.interfaceChar('D', n + 1)) < 0) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                return byArray2;
            }
            byArray[n] = (byte)(n2 & 0xF);
            ++n;
        }
    }

    public static ATR read(InputStream inputStream) throws IOException {
        try {
            int n;
            byte by;
            byte[] byArray = new byte[64];
            int n2 = inputStream.read();
            if (n2 < 0) {
                return null;
            }
            byte by2 = (byte)n2;
            if (by2 != 59 && by2 != 63) {
                return null;
            }
            byArray[0] = by2;
            n2 = inputStream.read();
            if (n2 < 0) {
                return null;
            }
            byArray[1] = by = (byte)n2;
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            int n6 = 5;
            boolean bl = false;
            int n7 = 0;
            int n8 = 10;
            int n9 = by & 0xF0;
            int n10 = by & 0xF;
            boolean bl2 = false;
            int n11 = 2;
            int n12 = 1;
            while (n9 != 0) {
                int n13;
                if ((n9 & 0x10) != 0) {
                    n13 = inputStream.read();
                    if (n13 < 0) {
                        return null;
                    }
                    if (n12 == 1) {
                        n3 = n13 >> 4 & 0xF;
                        n4 = n13 & 0xF;
                    }
                    byArray[n11++] = (byte)n13;
                }
                if ((n9 & 0x20) != 0) {
                    n13 = inputStream.read();
                    if (n13 < 0) {
                        return null;
                    }
                    if (n12 == 1) {
                        n5 = n13 >> 5 & 3;
                        n6 = n13 & 0x1F;
                    }
                    byArray[n11++] = (byte)n13;
                }
                if ((n9 & 0x40) != 0) {
                    n13 = inputStream.read();
                    if (n13 < 0) {
                        return null;
                    }
                    if (n12 == 1) {
                        n7 = n13 & 0xFF;
                    } else if (n12 == 2) {
                        n8 = n13 & 0xFF;
                    }
                    byArray[n11++] = (byte)n13;
                }
                if ((n9 & 0x80) != 0) {
                    n13 = inputStream.read();
                    if (n13 < 0) {
                        return null;
                    }
                    n9 = n13 & 0xF0;
                    n = n13 & 0xF;
                    if (n != 0) {
                        bl2 = true;
                    }
                    byArray[n11++] = (byte)n13;
                } else {
                    n9 = 0;
                }
                ++n12;
            }
            byte[] byArray2 = new byte[n10];
            n = 0;
            while (n < n10) {
                n2 = inputStream.read();
                if (n2 < 0) {
                    return null;
                }
                byArray2[n] = (byte)n2;
                byArray[n11++] = (byte)n2;
                ++n;
            }
            if (bl2) {
                n2 = inputStream.read();
                if (n2 < 0) {
                    return null;
                }
                byArray[n11++] = (byte)n2;
                byte by3 = 0;
                int n14 = 0;
                while (n14 < n11) {
                    by3 = (byte)(by3 ^ byArray[n14]);
                    ++n14;
                }
                if (by3 != 0) {
                    return null;
                }
            }
            byte[] byArray3 = new byte[n11];
            System.arraycopy(byArray, 0, byArray3, 0, n11);
            byArray = byArray3;
            ATR aTR = new ATR();
            aTR.buf = byArray;
            aTR.historical = byArray2;
            aTR.TS = by2;
            aTR.T0 = by;
            aTR.F = clockRateFactor[n3];
            aTR.Fs = clockRateFreq[n3];
            aTR.D = bitRateFactor[n4];
            aTR.I = currentFactor[n5];
            aTR.P = bl ? (float)bl * 0.1f : (float)n6;
            aTR.N = n7;
            aTR.W = (int)(960.0 * aTR.D * (double)n8);
            return aTR;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }
}

