/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.ocf;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFException;
import com.sun.opencard.common.OCFGlobals;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.ocf.CTListeningService;
import com.sun.opencard.utils.OCFUtils;
import java.util.Enumeration;
import java.util.StringTokenizer;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.terminal.CardID;

public class OCFService {
    static {
        OCFUtils.initializeExistingCardATRProperties();
    }

    public String deleteCardProperty(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle, String string) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (oCFCardHandle.deleteProperty(string) == null) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOSUCH_PROPERTY);
        }
        return oCFReturnValues.getReturnValues();
    }

    public String deleteClientProperty(OCFClientHandle oCFClientHandle, String string) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (string.startsWith(OCFConstants.OCF_ROOT) && !OCFGlobals.getCurrentUID().equals(OCFConstants.ROOT_USER) && !OCFGlobals.getCurrentUID().equals(OCFConstants.NO_UID_AVAILABLE)) {
            oCFReturnValues.setStatus(OCFConstants.OCF_UNAUTHORIZED_ACCESS);
            return oCFReturnValues.getReturnValues();
        }
        string = String.valueOf(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) + oCFClientHandle.getName() + "." + string;
        if (OCFUtils.deleteProperty(string) == null) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOSUCH_PROPERTY);
        }
        return oCFReturnValues.getReturnValues();
    }

    public String deleteProperty(String string) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (!OCFGlobals.getCurrentUID().equals(OCFConstants.ROOT_USER) && !OCFGlobals.getCurrentUID().equals(OCFConstants.NO_UID_AVAILABLE)) {
            oCFReturnValues.setStatus(OCFConstants.OCF_UNAUTHORIZED_ACCESS);
            return oCFReturnValues.getReturnValues();
        }
        if (!string.startsWith(OCFConstants.OCF_OPENCARD_PROPERTY_PREFIX)) {
            string = String.valueOf(OCFConstants.OCF_SERVER_PROPERTY_PREFIX) + string;
        }
        if (OCFUtils.deleteProperty(string) == null) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOSUCH_PROPERTY);
        }
        return oCFReturnValues.getReturnValues();
    }

    public String deregister(OCFClientHandle oCFClientHandle) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        OCFServer.removeClientHandle(oCFClientHandle);
        CTListeningService.listener.deregister(oCFClientHandle);
        return oCFReturnValues.getReturnValues();
    }

    public String getCardName(OCFCardHandle oCFCardHandle) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        oCFReturnValues.addReturnParam("cardname", oCFCardHandle.getCardName());
        return oCFReturnValues.getReturnValues();
    }

    public String getCardProperty(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle, String string) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        Object object = oCFCardHandle.getProperty(string);
        if (object == null) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOSUCH_PROPERTY);
        } else {
            oCFReturnValues.addReturnParam("value", String.valueOf(object));
        }
        return oCFReturnValues.getReturnValues();
    }

    public String getClientProperty(OCFClientHandle oCFClientHandle, String string) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        string = String.valueOf(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) + oCFClientHandle.getName() + "." + string;
        try {
            oCFReturnValues.addReturnParam("value", OCFUtils.getProperty(string, null));
        }
        catch (OCFException oCFException) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOSUCH_PROPERTY);
        }
        return oCFReturnValues.getReturnValues();
    }

    public String getProperty(String string) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (!OCFGlobals.getCurrentUID().equals(OCFConstants.ROOT_USER) && !OCFGlobals.getCurrentUID().equals(OCFConstants.NO_UID_AVAILABLE)) {
            oCFReturnValues.setStatus(OCFConstants.OCF_UNAUTHORIZED_ACCESS);
            return oCFReturnValues.getReturnValues();
        }
        if (!string.startsWith(OCFConstants.OCF_OPENCARD_PROPERTY_PREFIX)) {
            string = String.valueOf(OCFConstants.OCF_SERVER_PROPERTY_PREFIX) + string;
        }
        try {
            oCFReturnValues.addReturnParam("value", OCFUtils.getProperty(string, null));
        }
        catch (OCFException oCFException) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOSUCH_PROPERTY);
        }
        return oCFReturnValues.getReturnValues();
    }

    public String getReaderName(OCFCardHandle oCFCardHandle) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        oCFReturnValues.addReturnParam("readerName", oCFCardHandle.getReaderName());
        return oCFReturnValues.getReturnValues();
    }

    public String getSlotID(OCFCardHandle oCFCardHandle) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        oCFReturnValues.addReturnParam("slotid", String.valueOf(oCFCardHandle.getSlotID()));
        return oCFReturnValues.getReturnValues();
    }

    public String isCardPresent(OCFClientHandle oCFClientHandle, String string, String string2) throws Exception {
        CTListeningService cTListeningService = new CTListeningService();
        return cTListeningService.isCardPresent(oCFClientHandle, string, string2);
    }

    public String isValidCard(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        String string = OCFUtils.getProperty(String.valueOf(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) + oCFClientHandle.getName() + ".validcards", null);
        OCFDebug.debugln("CardName = " + oCFCardHandle.getCardName());
        if (string.indexOf(oCFCardHandle.getCardName()) == -1) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOT_VALID_CARD);
        }
        return oCFReturnValues.getReturnValues();
    }

    public String listCardAuthMechanisms(String string) throws Exception {
        OCFDebug.debugln("OCFService::listCardAuthMechanisms");
        Class clazz = null;
        String string2 = "";
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        String string3 = OCFUtils.getProperty(String.valueOf(OCFConstants.OCF_SERVER_PROPERTY_PREFIX) + "authmechanism", null);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            OCFDebug.debugln("listCardAuthMechanisms: curAuth = " + string4);
            try {
                clazz = OCFUtils.getClass(String.valueOf(string) + string4 + "CardService", "authservicelocations", "." + string.toLowerCase());
            }
            catch (ClassNotFoundException classNotFoundException) {
                OCFDebug.debugln("listCardAuthMechanisms: not supp = " + string4);
                continue;
            }
            OCFDebug.debugln("listCardAuthMechanisms: supp = " + string4);
            string2 = String.valueOf(string2) + string4;
            string2 = String.valueOf(string2) + " ";
        }
        oCFReturnValues.addReturnParam("list", string2);
        return oCFReturnValues.getReturnValues();
    }

    public String listCardProperties(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        String string = "";
        Enumeration enumeration = oCFCardHandle.listProperties();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement() + " ";
        }
        oCFReturnValues.addReturnParam("list", string);
        return oCFReturnValues.getReturnValues();
    }

    public String listCardServices(String string) throws Exception {
        OCFDebug.debugln("OCFService::listCardServices");
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        Enumeration enumeration = null;
        CardID cardID = null;
        Enumeration enumeration2 = CardServiceRegistry.getRegistry().getCardServiceFactories();
        String string2 = "";
        while (enumeration2.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration2.nextElement();
            if (!cardServiceFactory.getName().equals(string)) continue;
            enumeration = cardServiceFactory.cardServiceClasses(cardID);
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                string2 = String.valueOf(string2) + clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
                string2 = String.valueOf(string2) + " ";
            }
        }
        if (string2.equals("")) {
            oCFReturnValues.setStatus(OCFConstants.OCF_CARD_NOT_SUPPORTED);
        } else {
            oCFReturnValues.addReturnParam("list", string2);
        }
        return oCFReturnValues.getReturnValues();
    }

    public String listCardsConfigured() throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        String string = "";
        Enumeration enumeration = OCFServer.listSupportedCards();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + enumeration.nextElement();
            string = String.valueOf(string) + " ";
        }
        oCFReturnValues.addReturnParam("list", string);
        return oCFReturnValues.getReturnValues();
    }

    public String listClientProperties(OCFClientHandle oCFClientHandle) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        String string = "";
        Enumeration enumeration = OCFUtils.listPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(String.valueOf(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) + oCFClientHandle.getName())) continue;
            int n = OCFConstants.OCF_CLIENT_PROPERTY_PREFIX.length() + oCFClientHandle.getName().length() + 1;
            String string3 = string2.substring(n);
            string = String.valueOf(string) + string3 + " ";
        }
        oCFReturnValues.addReturnParam("list", string);
        return oCFReturnValues.getReturnValues();
    }

    public String listClients() throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        OCFDebug.debugln("OCFService::listClients");
        String string = "";
        Enumeration enumeration = OCFUtils.listPropertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) || string.indexOf(string2 = (string3 = string3.substring(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX.length(), string3.length())).substring(0, n = string3.indexOf("."))) != -1) continue;
            string = String.valueOf(string) + string2 + " ";
        }
        oCFReturnValues.addReturnParam("list", string);
        return oCFReturnValues.getReturnValues();
    }

    public String listProperties() throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        OCFDebug.debugln("OCFService::listProperties");
        String string = "";
        if (!OCFGlobals.getCurrentUID().equals(OCFConstants.ROOT_USER) && !OCFGlobals.getCurrentUID().equals(OCFConstants.NO_UID_AVAILABLE)) {
            oCFReturnValues.setStatus(OCFConstants.OCF_UNAUTHORIZED_ACCESS);
            return oCFReturnValues.getReturnValues();
        }
        Enumeration enumeration = OCFUtils.listPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.startsWith(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX)) continue;
            string = string2.startsWith(OCFConstants.OCF_SERVER_PROPERTY_PREFIX) ? String.valueOf(string) + string2.substring(OCFConstants.OCF_SERVER_PROPERTY_PREFIX.length()) + " " : String.valueOf(string) + string2 + " ";
        }
        oCFReturnValues.addReturnParam("list", string);
        return oCFReturnValues.getReturnValues();
    }

    public String listReadersConfigured() throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        String string = "";
        Enumeration enumeration = OCFServer.listSupportedReaders();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + enumeration.nextElement();
            string = String.valueOf(string) + " ";
        }
        oCFReturnValues.addReturnParam("list", string);
        return oCFReturnValues.getReturnValues();
    }

    public String lock(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws Exception {
        OCFDebug.debugln("OCFService::lock");
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        try {
            OCFServer.lock(oCFClientHandle, oCFCardHandle);
        }
        catch (OCFException oCFException) {
            oCFReturnValues.setStatus(OCFConstants.OCF_CARD_LOCKED);
            oCFReturnValues.setMessage(oCFException.getMessage());
            return oCFReturnValues.getReturnValues();
        }
        return oCFReturnValues.getReturnValues();
    }

    public String register(String string, float f) throws Exception {
        OCFDebug.debugln("OCFService::register ");
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (!OCFServer.checkVersion(f)) {
            oCFReturnValues.setStatus(OCFConstants.OCF_INCORRECT_VERSION);
            return oCFReturnValues.getReturnValues();
        }
        long l = OCFServer.createClientHandle(string);
        oCFReturnValues.addReturnParam("clienthandle", String.valueOf(l));
        OCFDebug.debugln("OCFService::register, client handle=" + l);
        return oCFReturnValues.getReturnValues();
    }

    public String restartOCF() throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        OCFServer.shutdownOCF();
        OCFServer.initializeOCF();
        return oCFReturnValues.getReturnValues();
    }

    public String setCardProperty(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle, String string, String string2) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        oCFCardHandle.setProperty(string, string2);
        return oCFReturnValues.getReturnValues();
    }

    public String setClientProperty(OCFClientHandle oCFClientHandle, String string, String string2) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (string.startsWith(OCFConstants.OCF_ROOT) && !OCFGlobals.getCurrentUID().equals(OCFConstants.ROOT_USER) && !OCFGlobals.getCurrentUID().equals(OCFConstants.NO_UID_AVAILABLE)) {
            oCFReturnValues.setStatus(OCFConstants.OCF_UNAUTHORIZED_ACCESS);
            return oCFReturnValues.getReturnValues();
        }
        string = String.valueOf(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) + oCFClientHandle.getName() + "." + string;
        OCFUtils.setProperty(string, string2);
        return oCFReturnValues.getReturnValues();
    }

    public String setProperty(String string, String string2) throws Exception {
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        if (!OCFGlobals.getCurrentUID().equals(OCFConstants.ROOT_USER) && !OCFGlobals.getCurrentUID().equals(OCFConstants.NO_UID_AVAILABLE)) {
            oCFReturnValues.setStatus(OCFConstants.OCF_UNAUTHORIZED_ACCESS);
            return oCFReturnValues.getReturnValues();
        }
        if (!string.startsWith(OCFConstants.OCF_OPENCARD_PROPERTY_PREFIX)) {
            string = String.valueOf(OCFConstants.OCF_SERVER_PROPERTY_PREFIX) + string;
        }
        OCFUtils.setProperty(string, string2);
        return oCFReturnValues.getReturnValues();
    }

    public String timeSinceValidated(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws Exception {
        OCFDebug.debugln("OCFService::timeSinceValidated");
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        oCFReturnValues.addReturnParam("timeSinceValidated", String.valueOf(oCFCardHandle.getTimeSinceLastValidation()));
        return oCFReturnValues.getReturnValues();
    }

    public String unlock(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws Exception {
        OCFDebug.debugln("OCFService::unlock");
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SUCCESS, null);
        try {
            OCFServer.unlock(oCFClientHandle, oCFCardHandle);
        }
        catch (OCFException oCFException) {
            oCFReturnValues.setStatus(OCFConstants.OCF_CARD_LOCKED_BY_OTHER_APP);
            oCFReturnValues.setMessage(oCFException.getMessage());
            return oCFReturnValues.getReturnValues();
        }
        return oCFReturnValues.getReturnValues();
    }

    public String waitForAnyCardInserted(OCFClientHandle oCFClientHandle) throws Exception {
        CTListeningService cTListeningService = new CTListeningService();
        return cTListeningService.waitForAnyCardInserted(oCFClientHandle);
    }

    public String waitForAnyCardRemoved(OCFClientHandle oCFClientHandle) throws Exception {
        CTListeningService cTListeningService = new CTListeningService();
        return cTListeningService.waitForAnyCardRemoved(oCFClientHandle);
    }

    public String waitForCardInserted(OCFClientHandle oCFClientHandle, String string, String string2, String string3, int n, long l) throws Exception {
        CTListeningService cTListeningService = new CTListeningService();
        return cTListeningService.waitForCardInserted(oCFClientHandle, string, string2, string3, n, l);
    }

    public String waitForCardRemoved(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws Exception {
        CTListeningService cTListeningService = new CTListeningService();
        return cTListeningService.waitForCardRemoved(oCFClientHandle, oCFCardHandle);
    }
}

