/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.ocf;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.ocf.ExistingCardListener;
import com.sun.opencard.service.ocf.OCF_CTListener;
import com.sun.opencard.utils.OCFUtils;
import opencard.core.service.CardServiceFactory;
import opencard.core.terminal.CardTerminalRegistry;

public class CTListeningService {
    private final short CARD_INSERTED = 1;
    private final short CARD_REMOVED = (short)2;
    private final long MAX_BLOCKING_TIME = 900000L;
    private boolean _eventRcvd = false;
    private long _cardHandle = 0L;
    private short _event = 0;
    private String _waitForCard = OCFConstants.OCF_WaitForCardSpec_AnyCard;
    private String _waitForRdr = OCFConstants.OCF_WaitForCardSpec_AnyReader;
    private String _waitForAid = null;
    private OCFCardHandle _waitForCardHandle = null;
    private long _clientHandleValue = 0L;
    static OCF_CTListener listener = new OCF_CTListener();

    static {
        CTListeningService.debug("static init", "installing listener");
        CardTerminalRegistry.getRegistry().addCTListener(listener);
    }

    void cardInserted(long l, String string, String string2, CardServiceFactory cardServiceFactory) {
        if ((this._event & 1) != 0 && (this._waitForRdr.equals(OCFConstants.OCF_WaitForCardSpec_AnyReader) || this._waitForRdr.equals(string2)) && (this._waitForCard.equals(OCFConstants.OCF_WaitForCardSpec_AnyCard) || this._waitForCard.equals(string)) && cardServiceFactory.knows(this._waitForAid)) {
            CTListeningService.debug("cardInserted", "");
            CTListeningService cTListeningService = this;
            synchronized (cTListeningService) {
                this._cardHandle = l;
                this._eventRcvd = true;
                this.notify();
            }
        }
    }

    void cardRemoved(OCFCardHandle oCFCardHandle) {
        if ((this._event & 2) != 0 && (this._waitForCardHandle == null || this._waitForCardHandle.equals(oCFCardHandle))) {
            CTListeningService.debug("cardRemoved", "");
            CTListeningService cTListeningService = this;
            synchronized (cTListeningService) {
                this._cardHandle = oCFCardHandle.getInstance();
                this._eventRcvd = true;
                this.notify();
            }
        }
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln("CTListeningService : <" + string + "> " + string2);
        }
        catch (Exception exception) {}
    }

    void deregister(long l) {
        if (this._clientHandleValue == l) {
            CTListeningService cTListeningService = this;
            synchronized (cTListeningService) {
                this._eventRcvd = true;
                this.notify();
            }
        }
    }

    public static void getATRsOfExistingCards() {
        CTListeningService.debug("updateCurrentATRs", "");
        try {
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            cardTerminalRegistry.createEventsForPresentCards(listener);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getExistingCard() throws Exception {
        CTListeningService.debug("getExistingCard", "");
        ExistingCardListener existingCardListener = new ExistingCardListener(this);
        CardTerminalRegistry.getRegistry().createEventsForPresentCards(existingCardListener);
        return this._eventRcvd ? OCFConstants.OCF_SUCCESS : OCFConstants.OCF_NOCARD;
    }

    public String isCardPresent(OCFClientHandle oCFClientHandle, String string, String string2) throws Exception {
        CTListeningService.debug("isCardPresent", "");
        this._event = 1;
        String string3 = this.setExpectedEvent(oCFClientHandle.getName(), string, string2, null);
        if (string3.equals(OCFConstants.OCF_SUCCESS)) {
            string3 = this.getExistingCard();
        }
        return new OCFReturnValues(string3, null).getReturnValues();
    }

    private String setExpectedEvent(String string, String string2, String string3, String string4) throws Exception {
        CTListeningService.debug("setExpectedEvent", "");
        Thread.currentThread().setPriority(10);
        if (OCFServer.noReadersConfig()) {
            return OCFConstants.OCF_NO_READERS_CONFIGURED;
        }
        if (OCFServer.noCardsConfig()) {
            return OCFConstants.OCF_NO_CARDS_CONFIGURED;
        }
        String string5 = String.valueOf(OCFConstants.OCF_CLIENT_PROPERTY_PREFIX) + string;
        if (string3.equals(OCFConstants.OCF_WaitForCardSpec_DefaultReader)) {
            this._waitForRdr = OCFUtils.getProperty(String.valueOf(string5) + ".defaultreader", OCFConstants.OCF_WaitForCardSpec_AnyReader);
        } else if (string3.equals(OCFConstants.OCF_WaitForCardSpec_AnyReader) || OCFServer.isSupportedReader(string3)) {
            this._waitForRdr = string3;
        } else {
            return OCFConstants.OCF_RDR_NOT_SUPPORTED;
        }
        if (string2.equals(OCFConstants.OCF_WaitForCardSpec_DefaultCard)) {
            this._waitForCard = OCFUtils.getProperty(String.valueOf(string5) + ".defaultcard", OCFConstants.OCF_WaitForCardSpec_AnyCard);
        } else if (string2.equals(OCFConstants.OCF_WaitForCardSpec_AnyCard) || OCFServer.isSupportedCard(string2)) {
            this._waitForCard = string2;
        } else {
            return OCFConstants.OCF_CARD_NOT_SUPPORTED;
        }
        if (string4 != null) {
            if (string4.equals(OCFConstants.OCF_WaitForCardSpec_DefaultAID)) {
                this._waitForAid = OCFUtils.getProperty(String.valueOf(string5) + ".defaultaid", OCFConstants.OCF_WaitForCardSpec_DefaultAID);
            } else if (!string4.equals(OCFConstants.OCF_WaitForCardSpec_AnyAID)) {
                this._waitForAid = string4;
            }
        }
        CTListeningService.debug("setExpectedEvent", "card = " + this._waitForCard + " rdr = " + this._waitForRdr + " aid = " + this._waitForAid);
        return OCFConstants.OCF_SUCCESS;
    }

    private String waitForAnyCardEvent(OCFClientHandle oCFClientHandle, short s) throws Exception {
        this._event = s;
        String string = this.waitForCardEvent(oCFClientHandle, 0L);
        OCFReturnValues oCFReturnValues = new OCFReturnValues(string, null);
        if (this._cardHandle != 0L) {
            oCFReturnValues.addReturnParam("cardhandle", String.valueOf(this._cardHandle));
        }
        return oCFReturnValues.getReturnValues();
    }

    public String waitForAnyCardInserted(OCFClientHandle oCFClientHandle) throws Exception {
        CTListeningService.debug("waitForAnyCardInserted", "");
        return this.waitForAnyCardEvent(oCFClientHandle, (short)1);
    }

    public String waitForAnyCardRemoved(OCFClientHandle oCFClientHandle) throws Exception {
        CTListeningService.debug("waitForAnyCardRemoved", "");
        return this.waitForAnyCardEvent(oCFClientHandle, (short)2);
    }

    private String waitForCardEvent(OCFClientHandle oCFClientHandle, long l) throws Exception {
        CTListeningService.debug("waitForCardEvent", "");
        if (l == 0L) {
            l = 900000L;
        }
        long l2 = listener.addWaitingService(this);
        this._clientHandleValue = oCFClientHandle.getValue();
        CTListeningService cTListeningService = this;
        synchronized (cTListeningService) {
            if (!this._eventRcvd) {
                this.wait(l);
            }
        }
        listener.removeWaitingService(l2);
        return this._eventRcvd ? OCFConstants.OCF_SUCCESS : OCFConstants.OCF_TIMEOUT;
    }

    public String waitForCardInserted(OCFClientHandle oCFClientHandle, String string, String string2, String string3, int n, long l) throws Exception {
        CTListeningService.debug("waitForCardInserted", "timeout=" + l);
        this._event = 1;
        String string4 = this.setExpectedEvent(oCFClientHandle.getName(), string, string2, string3);
        if (string4.equals(OCFConstants.OCF_SUCCESS) && (string4 = this.getExistingCard()).equals(OCFConstants.OCF_NOCARD) && (n & OCFConstants.OCF_NOBLOCK) == 0) {
            string4 = this.waitForCardEvent(oCFClientHandle, l);
        }
        OCFReturnValues oCFReturnValues = new OCFReturnValues(string4, null);
        if (this._cardHandle != 0L) {
            CTListeningService.debug("waitForCardInserted", "returning with :  cardhandle = " + this._cardHandle);
            oCFReturnValues.addReturnParam("cardhandle", String.valueOf(this._cardHandle));
        }
        return oCFReturnValues.getReturnValues();
    }

    public String waitForCardRemoved(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle) throws Exception {
        CTListeningService.debug("waitForCardRemoved", "card handle = " + oCFCardHandle);
        this._event = (short)2;
        this._waitForCardHandle = oCFCardHandle;
        String string = this.waitForCardEvent(oCFClientHandle, 0L);
        return new OCFReturnValues(string, null).getReturnValues();
    }
}

