/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.auth;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.service.auth.OCFAuth;
import com.sun.opencard.service.auth.OCFAuthenticate;
import com.sun.opencard.service.auth.OCFPasswordAuthData;
import com.sun.opencard.service.auth.OCFPinAuthData;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.UserInfo;
import com.sun.opencard.service.common.UserInfoCardService;
import opencard.core.service.SmartCard;

public class OCFPasswordAuth
extends OCFAuth {
    private final int GET_PASSWORD = 0;
    private final int VALIDATE_PASSWORD = 1;

    public String authenticate(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle, String string, String string2, int n) throws Exception {
        OCFDebug.debugln("In OCFPasswordAuth::authenticate");
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCFAUTH_SUCCESS, null);
        OCFAuthenticate oCFAuthenticate = this.getAuth(oCFClientHandle);
        OCFPasswordAuthData oCFPasswordAuthData = (OCFPasswordAuthData)oCFAuthenticate.getAuthData("PASSWORD");
        SmartCard smartCard = oCFCardHandle.getSmartCard();
        if (smartCard == null) {
            oCFReturnValues.setStatus(OCFConstants.OCF_NOCARD);
            oCFAuthenticate.setRetStatus(1);
            return oCFReturnValues.getReturnValues();
        }
        String string3 = oCFCardHandle.getCardName();
        Class<?> clazz = Class.forName("com.sun.opencard.service." + string3.toLowerCase() + "." + string3 + "UserInfoCardService");
        UserInfoCardService userInfoCardService = (UserInfoCardService)smartCard.getCardService(clazz, false);
        if (userInfoCardService == null) {
            oCFReturnValues.setStatus(OCFConstants.OCF_SERVICE_NOT_SUPPORTED);
            oCFAuthenticate.setRetStatus(1);
            smartCard.close();
            return oCFReturnValues.getReturnValues();
        }
        if (oCFPasswordAuthData == null) {
            String string4 = null;
            byte[] byArray = "".getBytes();
            if ((OCFPinAuthData)oCFAuthenticate.getAuthData("PIN") != null) {
                byArray = ((OCFPinAuthData)oCFAuthenticate.getAuthData("PIN")).getPin().getBytes();
            }
            oCFPasswordAuthData = new OCFPasswordAuthData(string, string2, 0);
            try {
                string4 = userInfoCardService.getUserPassword(byArray, string2);
            }
            catch (OCFCardException oCFCardException) {
                if (string3.equals("CyberFlex") || string3.equals("IButton")) {
                    if (oCFCardException.getMessage().indexOf("9101") == -1) {
                        throw oCFCardException;
                    }
                }
                if (string3.equals("PayFlex")) {
                    if (oCFCardException.getMessage().indexOf("6300") == -1) {
                        throw oCFCardException;
                    }
                }
                throw oCFCardException;
            }
            if (string4 == null || string4.equals("")) {
                oCFReturnValues.setStatus(OCFConstants.OCFAUTH_OP);
                oCFReturnValues.addReturnParam("tag", OCFConstants.OCFAUTH_GET_PASSWORD);
                oCFAuthenticate.setRetStatus(2);
                oCFPasswordAuthData.setState(0);
                oCFPasswordAuthData.setTag(string2);
            } else {
                UserInfo userInfo = userInfoCardService.getUserInfo(string2);
                oCFReturnValues.setStatus(OCFConstants.OCFAUTH_OP);
                oCFReturnValues.addReturnParam("tag", OCFConstants.OCFAUTH_VALIDATE_PASSWORD);
                oCFReturnValues.addReturnParam("uitag", string2);
                oCFReturnValues.addReturnParam("username", userInfo.getName());
                oCFReturnValues.addReturnParam("password", string4);
                oCFAuthenticate.setRetStatus(2);
                oCFPasswordAuthData.setState(1);
            }
        } else {
            switch (oCFPasswordAuthData.getState()) {
                case 0: {
                    UserInfo userInfo = userInfoCardService.getUserInfo(oCFPasswordAuthData.getTag());
                    oCFReturnValues.setStatus(OCFConstants.OCFAUTH_OP);
                    oCFReturnValues.addReturnParam("tag", OCFConstants.OCFAUTH_VALIDATE_PASSWORD);
                    oCFReturnValues.addReturnParam("uitag", string2);
                    oCFReturnValues.addReturnParam("username", userInfo.getName());
                    oCFReturnValues.addReturnParam("password", string);
                    oCFAuthenticate.setRetStatus(2);
                    oCFPasswordAuthData.setState(1);
                    break;
                }
                case 1: {
                    if (n == 5) {
                        oCFReturnValues.setStatus(OCFConstants.OCFAUTH_SUCCESS);
                        oCFAuthenticate.setRetStatus(0);
                        oCFPasswordAuthData.setState(0);
                        break;
                    }
                    oCFReturnValues.setStatus(OCFConstants.OCFAUTH_INVALID_PASSWORD);
                    oCFAuthenticate.setRetStatus(1);
                    oCFPasswordAuthData.setState(1);
                    break;
                }
            }
        }
        oCFAuthenticate.setAuthData("PASSWORD", oCFPasswordAuthData);
        this.setAuth(oCFClientHandle, oCFAuthenticate);
        OCFDebug.debugln("PasswordAuth Returing : " + oCFReturnValues);
        return oCFReturnValues.getReturnValues();
    }
}

