/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.auth;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.service.auth.OCFAuthenticate;
import com.sun.opencard.utils.OCFUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class OCFAuthenticationService {
    private final int SUCCESS = 0;
    private final int FAILURE = 1;
    private final int CONTINUE = 2;
    private String NO_AUTH = "NoAuth";
    private final int AUTH_CONT = 5;
    private final int AUTH_ERROR = 6;
    private OCFAuthenticate _auth = null;
    private static Hashtable authTable = new Hashtable();

    public String authenticate(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle, String string, String string2) throws Exception {
        String string3;
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCFAUTH_SUCCESS, null);
        this._auth = (OCFAuthenticate)authTable.get(oCFClientHandle);
        OCFDebug.debugln(" AUTH = " + this._auth);
        OCFDebug.debugln("OCFAuthenticationService::authenticate : " + string);
        if (string.equals("RESET")) {
            if (this._auth != null) {
                authTable.remove(oCFClientHandle);
            }
            return oCFReturnValues.getReturnValues();
        }
        if (string.equals("RETRY")) {
            if (this._auth == null) {
                oCFReturnValues.setStatus(OCFConstants.OCF_PARAMETER_ERROR);
                return oCFReturnValues.getReturnValues();
            }
            this._auth.decCurAuthPos();
            if (this._auth.getGlobalErrorPos() == this._auth.getCurAuthPos()) {
                this._auth.setGlobalErrorPos(-1);
            }
            string3 = this.doAuth(oCFClientHandle, oCFCardHandle, string2, 5);
        } else if (string.equals("AUTH")) {
            if (this._auth == null) {
                String string4 = OCFUtils.getProperty("ocf.client." + oCFClientHandle.getName() + "." + oCFCardHandle.getCardName() + ".authmechanism", null);
                OCFDebug.debugln("OCFAuthenticationService:authMechs = " + string4);
                this._auth = new OCFAuthenticate(string4);
                authTable.put(oCFClientHandle, this._auth);
            }
            string3 = this.doAuth(oCFClientHandle, oCFCardHandle, string2, 5);
        } else if (string.equals("AUTHERROR")) {
            string3 = this.doAuth(oCFClientHandle, oCFCardHandle, string2, 6);
        } else {
            if (string.equals("CONVERROR")) {
                oCFReturnValues.setStatus(OCFConstants.OCFAUTH_FAILURE);
                return oCFReturnValues.getReturnValues();
            }
            oCFReturnValues.setStatus(OCFConstants.OCF_PARAMETER_ERROR);
            return oCFReturnValues.getReturnValues();
        }
        authTable.put(oCFClientHandle, this._auth);
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doAuth(OCFClientHandle oCFClientHandle, OCFCardHandle oCFCardHandle, String string, int n) throws Exception {
        OCFDebug.debugln("OCFAuthenticationService::doAuth : " + string);
        OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCFAUTH_SUCCESS, null);
        String[] stringArray = new String[2];
        String string2 = null;
        if (this._auth.getCurAuthPos() == this._auth.getNumberOfAuth()) {
            return oCFReturnValues.getReturnValues();
        }
        int n2 = this._auth.getCurAuthPos();
        while (n2 < this._auth.getNumberOfAuth()) {
            int n3 = 0;
            Vector vector = this._auth.getAuthStrings();
            String string3 = (String)vector.elementAt(n2);
            OCFDebug.debugln("OCFAuthenticationService::doAuth : processing " + string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n3++] = stringTokenizer.nextToken();
            }
            OCFDebug.debugln("OCFAuthenticationService::doAuth : Auth mech = " + stringArray[0]);
            if (stringArray[0].equalsIgnoreCase(this.NO_AUTH)) {
                return oCFReturnValues.getReturnValues();
            }
            Class clazz = OCFUtils.getClass("OCF" + stringArray[0] + "Auth", "authservicelocations");
            if (clazz == null) {
                oCFReturnValues.setStatus(OCFConstants.OCFAUTH_UNSUPPORTED);
                return oCFReturnValues.getReturnValues();
            }
            Method[] methodArray = clazz.getMethods();
            Object t = clazz.newInstance();
            Object[] objectArray = new Object[]{oCFClientHandle, oCFCardHandle, string, stringArray.length == 2 ? stringArray[1] : null, new Integer(n)};
            n3 = 0;
            while (n3 < methodArray.length) {
                if (methodArray[n3].getName().equals("authenticate")) {
                    try {
                        string2 = (String)methodArray[n3].invoke(t, objectArray);
                        break;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        oCFReturnValues.setStatus(OCFConstants.OCF_EXCEPTION);
                        oCFReturnValues.setMessage(invocationTargetException.getTargetException().toString());
                        return oCFReturnValues.getReturnValues();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        oCFReturnValues.setStatus(OCFConstants.OCF_EXCEPTION);
                        oCFReturnValues.setMessage(illegalAccessException.getMessage());
                        return oCFReturnValues.getReturnValues();
                    }
                }
                ++n3;
            }
            this._auth = (OCFAuthenticate)authTable.get(oCFClientHandle);
            if (this._auth.getRetStatus() == 0) {
                this._auth.incCurAuthPos();
                if (this._auth.getCurAuthPos() == this._auth.getNumberOfAuth()) {
                    if (this._auth.getGlobalErrorPos() >= 0) {
                        oCFReturnValues.setStatus(OCFConstants.OCFAUTH_FAILURE);
                        return oCFReturnValues.getReturnValues();
                    }
                    oCFCardHandle.setValidateTime();
                }
            } else {
                if (this._auth.getRetStatus() == 1) {
                    if (this._auth.getGlobalErrorPos() < 0) {
                        this._auth.setGlobalErrorPos(this._auth.getCurAuthPos());
                    }
                    this._auth.incCurAuthPos();
                    if (this._auth.getCurAuthPos() != this._auth.getNumberOfAuth()) return string2;
                    oCFReturnValues.setStatus(OCFConstants.OCFAUTH_FAILURE);
                    return oCFReturnValues.getReturnValues();
                }
                if (this._auth.getRetStatus() == 2) {
                    return string2;
                }
            }
            ++n2;
        }
        return string2;
    }

    public static OCFAuthenticate getAuth(OCFClientHandle oCFClientHandle) {
        return (OCFAuthenticate)authTable.get(oCFClientHandle);
    }

    public static void setAuth(OCFClientHandle oCFClientHandle, OCFAuthenticate oCFAuthenticate) {
        authTable.put(oCFClientHandle, oCFAuthenticate);
    }
}

