/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.Slot;

public class OCFCardHandle
implements Serializable {
    private short _mode;
    private long _card;
    private long _reader;
    private long _instance;
    private CardTerminalEvent _event;
    private String _cardName;
    private String _readerName;
    private String _pin = null;
    private String _uid = null;
    private long _timePinLastValidated;
    private Hashtable _properties;

    public OCFCardHandle() {
    }

    public OCFCardHandle(short s, long l, long l2, long l3, CardTerminalEvent cardTerminalEvent, String string, String string2) {
        this._mode = s;
        this._card = l;
        this._reader = l2;
        this._instance = l3;
        this._event = cardTerminalEvent;
        this._readerName = string2;
        this._cardName = string;
        this._properties = new Hashtable();
    }

    public Object deleteProperty(String string) {
        if (this._properties.size() == 0) {
            return null;
        }
        return this._properties.remove(string);
    }

    public boolean equals(OCFCardHandle oCFCardHandle) {
        if (oCFCardHandle == null) {
            return false;
        }
        return oCFCardHandle.getCard() == this._card && oCFCardHandle.getReader() == this._reader;
    }

    public long getCard() {
        return this._card;
    }

    public CardID getCardID() throws CardTerminalException {
        return this._event.getSlot().getCardID();
    }

    public String getCardName() {
        return this._cardName;
    }

    public CardTerminalEvent getCardTerminalEvent() {
        return this._event;
    }

    public long getInstance() {
        return this._instance;
    }

    public String getPin() {
        return this._pin;
    }

    public Object getProperty(String string) {
        return this._properties.get(string);
    }

    public long getReader() {
        return this._reader;
    }

    public String getReaderName() {
        return this._readerName;
    }

    public int getSlotID() throws CardTerminalException {
        return this._event.getSlot().getSlotID();
    }

    public SmartCard getSmartCard() throws CardTerminalException {
        return SmartCard.getSmartCard(this._event);
    }

    public long getTimeSinceLastValidation() {
        if (this._timePinLastValidated == 0L) {
            return 0L;
        }
        Date date = new Date();
        return date.getTime() - this._timePinLastValidated;
    }

    public String getUID() {
        return this._uid;
    }

    public Enumeration listProperties() {
        return this._properties.keys();
    }

    public boolean matches(long l, long l2) {
        return l == this._card && l2 == this._reader;
    }

    public boolean matchesSlotAndReader(int n, String string) {
        Slot slot = this._event.getSlot();
        System.out.println("Current slot = " + slot.getSlotID());
        System.out.println("To match slot = " + n);
        System.out.println("Current reader = " + slot.getCardTerminal().getName());
        System.out.println("To match reader = " + string);
        return slot.getSlotID() == n && slot.getCardTerminal().getName().equals(string);
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setPin(String string) {
        this._pin = string;
    }

    public void setProperty(String string, Object object) {
        this._properties.put(string, object);
    }

    public void setUID(String string) {
        this._uid = string;
    }

    public void setValidateTime() {
        Date date = new Date();
        this._timePinLastValidated = date.getTime();
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "Card Number = " + this._card;
        string = String.valueOf(string) + "\nReader Number = " + this._reader;
        string = String.valueOf(string) + "\nInstance = " + this._instance;
        string = String.valueOf(string) + "\nCardName = " + this._cardName;
        string = String.valueOf(string) + "\nReaderName = " + this._readerName;
        return string;
    }

    void updateCardNameAndCardServiceFactory(String string, long l) {
        this._cardName = string;
        this._card = l;
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

