/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMEvent;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.CIMOMImpl;
import com.sun.wbem.client.CIMOMUtils;
import com.sun.wbem.client.DeliveryHandler;
import com.sun.wbem.client.FilterActivation;
import com.sun.wbem.client.IndicationPoller;
import com.sun.wbem.client.LogFile;
import com.sun.wbem.client.PSRlogImpl;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.client.ProviderChecker;
import com.sun.wbem.client.ReadersWriter;
import com.sun.wbem.client.ServerSecurity;
import com.sun.wbem.provider.CIMProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.AttributeExp;
import com.sun.wbem.query.SelectList;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

class EventService {
    PSRlogImpl ps = null;
    CIMOMUtils cu = null;
    CIMOMImpl cimom = null;
    private IndicationPoller indicationPoller = null;
    ProviderCIMOMHandle pch = null;
    ProviderChecker provCheck = null;
    Map filterActivations = new TreeMap();
    DeliveryHandler deliveryHandler = null;
    private static int pingTime = 600000;
    static int pollInterval = 3000;
    static final String FILTERDELIVERYASSOC = "cim_indicationsubscription";
    static final String DELIVERYCLASS = "cim_indicationhandler";
    static final String RMIDELIVERYCLASS = "solaris_rmidelivery";
    static final String CIMFILTERCLASS = "cim_indicationfilter";
    static final String FILTERPROPERTY = "filter";
    static final String DELIVERYPROPERTY = "handler";
    static final String OWNERPROP = "owner";
    static final String HANDLERNAMEPROP = "name";
    static final String FILTERNAMEPROP = "name";
    static final String CCNPROP = "creationclassname";
    static final String QUERYPROP = "query";
    static final String QUERYLANGPROP = "querylanguage";
    static final String TARGETNSPROP = "sourceNameSpace";
    static final String SYSTEMCCNPROP = "systemcreationclassname";
    static final String SYSTEMNAMEPROP = "systemname";
    static final String SUBSCRIPTIONALIASPROP = "subscriptionalias";
    static EventService eventService = null;
    InstanceProvider cim_filterdelivery = new CIM_FilterDelivery();
    CIMProvider cim_filter = new CIM_Filter();
    InstanceProvider solaris_rmidelivery = new Solaris_RMIDelivery();
    String hostName;
    private ReadersWriter cfl = new ReadersWriter();
    private Map classFilterMap = new HashMap();

    public EventService(PSRlogImpl pSRlogImpl, CIMOMUtils cIMOMUtils, CIMOMImpl cIMOMImpl, ProviderCIMOMHandle providerCIMOMHandle, ProviderChecker providerChecker, Properties properties) throws Exception {
        this.ps = pSRlogImpl;
        this.cu = cIMOMUtils;
        this.cimom = cIMOMImpl;
        this.pch = providerCIMOMHandle;
        this.provCheck = providerChecker;
        this.indicationPoller = new IndicationPoller(providerCIMOMHandle);
        this.deliveryHandler = new DeliveryHandler(cIMOMImpl);
        String string = properties.getProperty("com.sun.wbem.cimom.pollInterval");
        if (string != null) {
            pollInterval = Integer.parseInt(string) * 1000;
        }
        try {
            this.activateFilters();
        }
        catch (Exception exception) {
            try {
                LogFile.add(0, "INDICATION_HANDLER_ERROR", exception.toString());
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.hostName = "";
        }
        eventService = this;
        new HandlerChecker().start();
    }

    /*
     * Unable to fully structure code
     */
    private void activateFilters() throws CIMException {
        var1_1 = this.ps.enumerateNameSpace("", true).elements();
        var2_2 = new CIMObjectPath("cim_indicationsubscription");
        while (var1_1.hasMoreElements()) {
            var3_3 = new CIMObjectPath("", (String)var1_1.nextElement());
            var3_3.setObjectName("cim_indicationfilter");
            var2_2.setNameSpace(var3_3.getNameSpace());
            var4_4 = null;
            try {
                var4_4 = this.ps.enumerateInstances(var3_3, false, false).elements();
                if (true) ** GOTO lbl55
            }
            catch (CIMException v0) {
                continue;
            }
            do {
                var5_5 = (CIMInstance)var4_4.nextElement();
                var6_6 = new CIMObjectPath(var5_5.getClassName().toLowerCase());
                var6_6.setKeys(var5_5.getKeyValuePairs());
                var6_6.setNameSpace(var3_3.getNameSpace().toLowerCase());
                var7_7 = null;
                try {
                    var7_7 = this.ps.referenceNames(var2_2, var6_6, "");
                }
                catch (CIMException v1) {
                    continue;
                }
                if (var7_7.size() == 0) continue;
                var8_8 = false;
                var9_9 = var7_7.elements();
                while (var9_9.hasMoreElements()) {
                    var10_10 = (CIMObjectPath)var9_9.nextElement();
                    var11_11 = null;
                    var12_12 = var10_10.getKeys().elements();
                    while (var12_12.hasMoreElements()) {
                        var13_13 = (CIMProperty)var12_12.nextElement();
                        if (!var13_13.getName().equalsIgnoreCase("handler")) continue;
                        try {
                            var11_11 = (CIMObjectPath)var13_13.getValue().getValue();
                        }
                        catch (NullPointerException v2) {}
                    }
                    if (this.deliveryHandler.isTransient(var11_11)) {
                        this.ps.deleteInstance((CIMObjectPath)var10_10);
                        try {
                            this.ps.deleteInstance(var11_11);
                        }
                        catch (CIMException v3) {}
                        continue;
                    }
                    var8_8 = true;
                }
                if (!var8_8) continue;
                var10_10 = new FilterActivation(var6_6, var5_5, this);
                var10_10.run();
                var10_10.getPollInfo();
                var10_10.activate();
                this.filterActivations.put(var6_6.toString(), var10_10);
lbl55:
                // 5 sources

            } while (var4_4.hasMoreElements());
        }
    }

    boolean addClassFilter(String string, FilterActivation.SubActivation subActivation, boolean bl) {
        boolean bl2;
        block4: {
            bl2 = false;
            this.cfl.writeLock();
            try {
                ArrayList arrayList = (ArrayList)this.classFilterMap.get(string);
                int n = this.getOffset(subActivation.getParentActivation().getEventType(), bl);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    arrayList.add(new ArrayList());
                    arrayList.add(new ArrayList());
                    arrayList.add(new ArrayList());
                    arrayList.add(new ArrayList());
                    arrayList.add(new ArrayList());
                    arrayList.add(new ArrayList());
                    List list = (List)arrayList.get(n);
                    list.add(subActivation);
                    this.classFilterMap.put(string, arrayList);
                    bl2 = true;
                    break block4;
                }
                List list = (List)arrayList.get(n);
                if (list.size() == 0) {
                    bl2 = true;
                }
                list.add(subActivation);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.cfl.writeUnlock();
                throw throwable;
            }
        }
        Object var6_9 = null;
        this.cfl.writeUnlock();
        return bl2;
    }

    void deliverEvent(String string, CIMInstance cIMInstance) {
        new IndicationDeliverer(string, cIMInstance).start();
    }

    List getClassFilters(String string, String string2) {
        ArrayList arrayList;
        this.cfl.readLock();
        string = string.toLowerCase();
        int n = FilterActivation.determineEventType(string2);
        try {
            List list = (List)this.classFilterMap.get(string);
            if (list == null) {
                List list2 = null;
                Object var6_7 = null;
                this.cfl.readUnlock();
                return list2;
            }
            List list3 = (List)list.get(n * 2);
            List list4 = (List)list.get(n * 2 + 1);
            ArrayList arrayList2 = new ArrayList(list3);
            arrayList2.addAll(new ArrayList(list4));
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.cfl.readUnlock();
            throw throwable;
        }
        Object var6_8 = null;
        this.cfl.readUnlock();
        return arrayList;
    }

    IndicationPoller getIndicationPoller() {
        return this.indicationPoller;
    }

    private int getOffset(int n, boolean bl) {
        if (n < 0) {
            return 0;
        }
        if (bl) {
            return n * 2;
        }
        return n * 2 + 1;
    }

    public CIMProvider getProvider(String string) throws CIMException {
        if (string.equals(FILTERDELIVERYASSOC)) {
            return this.cim_filterdelivery;
        }
        if (string.equals(RMIDELIVERYCLASS)) {
            return this.solaris_rmidelivery;
        }
        if (string.equals(CIMFILTERCLASS)) {
            return this.cim_filter;
        }
        throw new CIMProviderException("NO_INSTANCE_PROVIDER", (Object)string);
    }

    public String[] getProviderNames() {
        return new String[]{FILTERDELIVERYASSOC, RMIDELIVERYCLASS, CIMFILTERCLASS};
    }

    boolean removeClassFilter(String string, FilterActivation.SubActivation subActivation, boolean bl) {
        boolean bl2;
        block5: {
            bl2 = false;
            this.cfl.writeLock();
            try {
                int n = this.getOffset(subActivation.getParentActivation().getEventType(), bl);
                List list = (List)this.classFilterMap.get(string);
                if (list == null) {
                    boolean bl3 = false;
                    Object var7_8 = null;
                    this.cfl.writeUnlock();
                    return bl3;
                }
                List list2 = (List)list.get(n);
                list2.remove(subActivation);
                if (list2.size() == 0) {
                    bl2 = true;
                }
                int n2 = 0;
                while (n2 < 6) {
                    if (((List)list.get(n2)).size() != 0) break;
                    ++n2;
                }
                if (n2 != 6) break block5;
                this.classFilterMap.remove(string);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.cfl.writeUnlock();
                throw throwable;
            }
        }
        Object var7_9 = null;
        this.cfl.writeUnlock();
        return bl2;
    }

    private void removeDelivery(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) {
        Vector vector = null;
        try {
            LogFile.add(1, "REMOVING_HANDLER", cIMObjectPath.toString());
        }
        catch (Exception exception) {}
        try {
            vector = this.ps.referenceNames(cIMObjectPath2, cIMObjectPath, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
            try {
                this.pch.deleteInstance(cIMObjectPath3);
            }
            catch (Exception exception) {}
        }
        try {
            this.pch.deleteInstance(cIMObjectPath);
        }
        catch (CIMException cIMException) {}
    }

    static interface IndicationHandler {
        public void deliverEvent(CIMEvent var1, CIMInstance var2) throws CIMException;

        public void ping(CIMInstance var1) throws CIMException;
    }

    private class HandlerChecker
    extends Thread {
        HandlerChecker() {
        }

        private void loop() {
            CIMObjectPath cIMObjectPath;
            Object object;
            CIMObjectPath cIMObjectPath2;
            ArrayList arrayList = new ArrayList();
            Object object2 = EventService.this.filterActivations;
            synchronized (object2) {
                cIMObjectPath2 = EventService.this.filterActivations.entrySet();
                object = cIMObjectPath2.iterator();
                while (object.hasNext()) {
                    cIMObjectPath = object.next();
                    arrayList.add(cIMObjectPath.getValue());
                }
            }
            object2 = arrayList.iterator();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            cIMObjectPath2 = new CIMObjectPath(EventService.FILTERDELIVERYASSOC);
            while (object2.hasNext()) {
                object = (FilterActivation)object2.next();
                cIMObjectPath = ((FilterActivation)object).getFilterOp();
                cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
                Vector vector = null;
                try {
                    vector = EventService.this.ps.referenceNames(cIMObjectPath2, cIMObjectPath, "");
                }
                catch (CIMException cIMException) {
                    continue;
                }
                if (vector.size() == 0) continue;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string;
                    CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                    CIMObjectPath cIMObjectPath4 = null;
                    Enumeration enumeration2 = cIMObjectPath3.getKeys().elements();
                    while (enumeration2.hasMoreElements()) {
                        string = (CIMProperty)enumeration2.nextElement();
                        if (!string.getName().equalsIgnoreCase(EventService.DELIVERYPROPERTY)) continue;
                        try {
                            cIMObjectPath4 = (CIMObjectPath)string.getValue().getValue();
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    string = cIMObjectPath4.toString();
                    if (treeMap.get(string) != null) continue;
                    treeMap.put(string, "");
                    CIMInstance cIMInstance = null;
                    try {
                        cIMInstance = EventService.this.ps.getInstance(cIMObjectPath4);
                    }
                    catch (CIMException cIMException) {
                        continue;
                    }
                    IndicationHandler indicationHandler = EventService.this.deliveryHandler.getIndicationHandler(cIMInstance.getClassName());
                    try {
                        indicationHandler.ping(cIMInstance);
                    }
                    catch (CIMException cIMException) {
                        InstanceProvider instanceProvider = EventService.this.cim_filterdelivery;
                        synchronized (instanceProvider) {
                            EventService.this.removeDelivery(cIMObjectPath4, cIMObjectPath2);
                        }
                    }
                }
            }
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(pingTime);
                }
                catch (InterruptedException interruptedException) {}
                this.loop();
            }
        }
    }

    private class CIM_FilterDelivery
    implements InstanceProvider,
    Authorizable {
        public void cleanup() {
        }

        public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
            String string;
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            try {
                cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty(EventService.FILTERPROPERTY).getValue().getValue();
                cIMObjectPath3 = (CIMObjectPath)cIMInstance.getProperty(EventService.DELIVERYPROPERTY).getValue().getValue();
            }
            catch (Exception exception) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cIMInstance.setProperty(EventService.SUBSCRIPTIONALIASPROP, new CIMValue((Object)""));
            boolean bl = false;
            boolean bl2 = this.fillNameSpace(cIMObjectPath, cIMObjectPath2);
            boolean bl3 = this.fillNameSpace(cIMObjectPath, cIMObjectPath3);
            bl = bl2 | bl3;
            CIMInstance cIMInstance2 = EventService.this.ps.getInstance(cIMObjectPath2);
            CIMInstance cIMInstance3 = EventService.this.ps.getInstance(cIMObjectPath3);
            if (cIMInstance2 == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
            }
            if (cIMInstance3 == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath3);
            }
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath();
            cIMObjectPath4.setObjectName(cIMInstance.getClassName());
            cIMObjectPath4.setNameSpace(cIMObjectPath.getNameSpace());
            Vector vector = EventService.this.ps.associatorNames(cIMObjectPath4, cIMObjectPath2, EventService.DELIVERYCLASS, "", "");
            FilterActivation filterActivation = null;
            try {
                string = (String)cIMInstance3.getProperty(EventService.OWNERPROP).getValue().getValue();
            }
            catch (NullPointerException nullPointerException) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)EventService.OWNERPROP);
            }
            if (vector.size() == 0) {
                try {
                    LogFile.add(4, "DEBUG_VALUE", "Have to activate", cIMObjectPath2);
                }
                catch (Exception exception) {}
                filterActivation = new FilterActivation(cIMObjectPath2, cIMInstance2, EventService.this);
                filterActivation.run();
                filterActivation.getPollInfo();
                filterActivation.authorize(string);
                filterActivation.activate();
            }
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath2.getObjectName().toLowerCase());
            cIMObjectPath5.setNameSpace(cIMObjectPath2.getNameSpace().toLowerCase());
            cIMObjectPath5.setKeys(cIMInstance2.getKeyValuePairs());
            if (filterActivation != null) {
                Map map = EventService.this.filterActivations;
                synchronized (map) {
                    EventService.this.filterActivations.put(cIMObjectPath5.toString(), filterActivation);
                }
            }
            Map map = EventService.this.filterActivations;
            synchronized (map) {
                filterActivation = (FilterActivation)EventService.this.filterActivations.get(cIMObjectPath5.toString());
            }
            filterActivation.authorize(string);
            EventService.this.ps.addCIMElement(cIMObjectPath.getNameSpace(), cIMInstance);
            if (bl) {
                cIMObjectPath4.setKeys(cIMInstance.getKeyValuePairs());
                return cIMObjectPath4;
            }
            return null;
        }

        public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
            Object object;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            CIMObjectPath cIMObjectPath2 = null;
            while (enumeration.hasMoreElements()) {
                object = (CIMProperty)enumeration.nextElement();
                if (!object.getName().equalsIgnoreCase(EventService.FILTERPROPERTY)) continue;
                try {
                    cIMObjectPath2 = (CIMObjectPath)object.getValue().getValue();
                }
                catch (NullPointerException nullPointerException) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
            object = EventService.this.ps.associatorNames(cIMObjectPath, cIMObjectPath2, EventService.DELIVERYCLASS, "", "");
            CIMInstance cIMInstance = EventService.this.ps.getInstance(cIMObjectPath2);
            EventService.this.ps.deleteInstance(cIMObjectPath);
            if (((Vector)object).size() != 1) {
                return;
            }
            try {
                LogFile.add(4, "DEBUG_VALUE", "Have to de-activate", cIMObjectPath2);
            }
            catch (Exception exception) {}
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(cIMObjectPath2.getObjectName().toLowerCase());
            cIMObjectPath3.setNameSpace(cIMObjectPath2.getNameSpace().toLowerCase());
            cIMObjectPath3.setKeys(cIMInstance.getKeyValuePairs());
            FilterActivation filterActivation = null;
            Map map = EventService.this.filterActivations;
            synchronized (map) {
                filterActivation = (FilterActivation)EventService.this.filterActivations.remove(cIMObjectPath3.toString());
            }
            filterActivation.deactivate();
            try {
                LogFile.add(4, "DEBUG_VALUE", "Number of filterActivations left", new Integer(EventService.this.filterActivations.size()));
                LogFile.add(4, "DEBUG_VALUE", "Number of classFilters left", new Integer(EventService.this.classFilterMap.size()));
            }
            catch (Exception exception) {}
        }

        public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
            return EventService.this.ps.enumerateInstances(cIMObjectPath, false);
        }

        public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
            return EventService.this.ps.enumerateInstances(cIMObjectPath, false, bl2);
        }

        public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
            return EventService.this.ps.execQuery(cIMObjectPath, string, n, cIMClass);
        }

        private boolean fillNameSpace(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) {
            if (cIMObjectPath2.getNameSpace() == null || cIMObjectPath2.getNameSpace().length() == 0) {
                cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
                return true;
            }
            if (!cIMObjectPath2.getNameSpace().startsWith("\\")) {
                cIMObjectPath2.setNameSpace(String.valueOf(cIMObjectPath.getNameSpace()) + "\\" + cIMObjectPath2.getNameSpace());
                return true;
            }
            return false;
        }

        public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
            CIMInstance cIMInstance = EventService.this.ps.getInstance(cIMObjectPath);
            if (bl) {
                return EventService.this.cu.getLocal(cIMInstance);
            }
            return cIMInstance;
        }

        public void initialize(CIMOMHandle cIMOMHandle) {
        }

        public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }

    private class CIM_Filter
    implements InstanceProvider,
    Authorizable {
        public void cleanup() {
        }

        public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
            String string = null;
            String string2 = null;
            try {
                string = (String)cIMInstance.getProperty("name").getValue().getValue();
            }
            catch (NullPointerException nullPointerException) {}
            try {
                string2 = (String)cIMInstance.getProperty(EventService.TARGETNSPROP).getValue().getValue();
            }
            catch (NullPointerException nullPointerException) {}
            CIMObjectPath cIMObjectPath2 = null;
            if (string == null) {
                cIMInstance.setProperty("name", new CIMValue((Object)EventService.this.cu.getUniqueString()));
            }
            cIMInstance.setProperty(EventService.CCNPROP, new CIMValue((Object)EventService.CIMFILTERCLASS));
            cIMInstance.setProperty(EventService.SYSTEMCCNPROP, new CIMValue((Object)""));
            cIMInstance.setProperty(EventService.SYSTEMNAMEPROP, new CIMValue((Object)EventService.this.hostName));
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
            if (string2 != null) {
                string2 = new CIMNameSpace(".", "/" + string2).getNameSpace();
                cIMInstance.setProperty(EventService.TARGETNSPROP, new CIMValue((Object)string2));
            }
            EventService.this.ps.addCIMElement(cIMObjectPath.getNameSpace(), cIMInstance);
            return cIMObjectPath2;
        }

        public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
            EventService.this.ps.deleteInstance(cIMObjectPath);
        }

        public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
            return EventService.this.ps.enumerateInstances(cIMObjectPath, false);
        }

        public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
            return EventService.this.ps.enumerateInstances(cIMObjectPath, false, bl2);
        }

        public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
            return EventService.this.ps.execQuery(cIMObjectPath, string, n, cIMClass);
        }

        public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
            CIMInstance cIMInstance = EventService.this.ps.getInstance(cIMObjectPath);
            if (bl) {
                return EventService.this.cu.getLocal(cIMInstance);
            }
            return cIMInstance;
        }

        public void initialize(CIMOMHandle cIMOMHandle) {
        }

        public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        }
    }

    private class Solaris_RMIDelivery
    implements InstanceProvider,
    Authorizable {
        public void cleanup() {
        }

        public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
            String string = null;
            try {
                string = (String)cIMInstance.getProperty("name").getValue().getValue();
            }
            catch (NullPointerException nullPointerException) {}
            ServerSecurity serverSecurity = null;
            try {
                serverSecurity = (ServerSecurity)ServerSecurity.getRequestSession();
            }
            catch (ClassCastException classCastException) {}
            if (string != null) {
                serverSecurity = EventService.this.cimom.getServerSecurity(string);
            }
            if (serverSecurity == null) {
                throw new CIMSecurityException("NO_SUCH_SESSION", (Object)string);
            }
            if (serverSecurity.getListener() == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            cIMInstance.setProperty("name", new CIMValue((Object)new String(serverSecurity.getSessionId()), CIMDataType.getPredefinedType((int)8)));
            cIMInstance.setProperty(EventService.CCNPROP, new CIMValue((Object)new String(EventService.RMIDELIVERYCLASS)));
            cIMInstance.setProperty(EventService.SYSTEMCCNPROP, new CIMValue((Object)""));
            cIMInstance.setProperty(EventService.SYSTEMNAMEPROP, new CIMValue((Object)EventService.this.hostName));
            cIMInstance.setProperty(EventService.OWNERPROP, new CIMValue((Object)new String(serverSecurity.getUserName()), CIMDataType.getPredefinedType((int)8)));
            EventService.this.ps.addCIMElement(cIMObjectPath.getNameSpace(), cIMInstance);
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
            return cIMObjectPath2;
        }

        public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
            EventService.this.ps.deleteInstance(cIMObjectPath);
        }

        public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
            return EventService.this.ps.enumerateInstances(cIMObjectPath, false);
        }

        public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
            return EventService.this.ps.enumerateInstances(cIMObjectPath, false, bl2);
        }

        public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
            return EventService.this.ps.execQuery(cIMObjectPath, string, n, cIMClass);
        }

        public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
            CIMInstance cIMInstance = EventService.this.ps.getInstance(cIMObjectPath);
            if (bl) {
                return EventService.this.cu.getLocal(cIMInstance);
            }
            return cIMInstance;
        }

        public void initialize(CIMOMHandle cIMOMHandle) {
        }

        public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }

    private class IndicationDeliverer
    extends Thread {
        CIMInstance ci;
        String namespace;

        IndicationDeliverer(String string, CIMInstance cIMInstance) {
            this.ci = cIMInstance;
            this.namespace = string;
        }

        void deliverEvent(String string, CIMInstance cIMInstance, List list) throws Exception {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FilterActivation filterActivation = (FilterActivation)iterator.next();
                SelectList selectList = filterActivation.getParsedExp().getSelectList();
                CIMInstance cIMInstance2 = selectList == null ? new CIMInstance() : (CIMInstance)selectList.apply((CIMElement)cIMInstance);
                cIMInstance2.setClassName(cIMInstance.getClassName());
                CIMObjectPath cIMObjectPath = filterActivation.getFilterOp();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath();
                cIMObjectPath2.setObjectName(EventService.FILTERDELIVERYASSOC);
                cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
                Vector vector = EventService.this.ps.associatorNames(cIMObjectPath2, cIMObjectPath, EventService.DELIVERYCLASS, "", "");
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                    CIMInstance cIMInstance3 = EventService.this.ps.getInstance(cIMObjectPath3);
                    IndicationHandler indicationHandler = EventService.this.deliveryHandler.getIndicationHandler(cIMObjectPath3.getObjectName());
                    if (indicationHandler != null) {
                        try {
                            indicationHandler.deliverEvent(new CIMEvent(cIMInstance2), cIMInstance3);
                            continue;
                        }
                        catch (Exception exception) {
                            if (CIMOMImpl.verbose) {
                                exception.printStackTrace();
                            }
                            InstanceProvider instanceProvider = EventService.this.cim_filterdelivery;
                            synchronized (instanceProvider) {
                                EventService.this.removeDelivery(cIMObjectPath3, cIMObjectPath2);
                                continue;
                            }
                        }
                    }
                    try {
                        LogFile.add(1, "NO_HANDLER", cIMObjectPath3.getObjectName());
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void getProperty(CIMInstance cIMInstance, CIMInstance cIMInstance2, String string) {
            Vector vector = cIMInstance2.getProperties();
            cIMInstance2.setClassName(cIMInstance.getClassName());
            StringTokenizer stringTokenizer = null;
            try {
                stringTokenizer = new StringTokenizer(string, ".");
            }
            catch (Exception exception) {
                return;
            }
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = null;
            try {
                string3 = (String)stringTokenizer.nextElement();
            }
            catch (Exception exception) {}
            if (string3 == null) {
                int n;
                CIMProperty cIMProperty = cIMInstance.getProperty(string2);
                boolean bl = false;
                try {
                    Object object = cIMProperty.getValue().getValue();
                    if (object instanceof CIMInstance) {
                        bl = true;
                    }
                }
                catch (Exception exception) {}
                if ((n = vector.indexOf(cIMProperty)) == -1) {
                    vector.add(cIMProperty);
                } else if (bl) {
                    vector.remove(n);
                    vector.insertElementAt(cIMProperty, n);
                }
            } else {
                CIMProperty cIMProperty;
                CIMInstance cIMInstance3;
                int n = vector.indexOf(new CIMProperty(string2));
                if (n == -1) {
                    cIMInstance3 = new CIMInstance();
                    cIMInstance3.setProperties(new Vector());
                    cIMProperty = new CIMProperty(string2);
                    cIMProperty.setValue(new CIMValue((Object)cIMInstance3));
                    vector.add(cIMProperty);
                } else {
                    try {
                        cIMInstance3 = (CIMInstance)((CIMProperty)vector.get(n)).getValue().getValue();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                try {
                    cIMProperty = (CIMInstance)cIMInstance.getProperty(string2).getValue().getValue();
                    this.getProperty((CIMInstance)cIMProperty, cIMInstance3, string.substring(string.indexOf(".") + 1));
                }
                catch (Exception exception) {
                    return;
                }
            }
        }

        public void run() {
            block10: {
                CIMInstance cIMInstance = (CIMInstance)this.ci.getProperty("SourceInstance").getValue().getValue();
                String string = cIMInstance.getClassName();
                List list = EventService.this.getClassFilters(String.valueOf(this.namespace) + ":" + string, this.ci.getClassName());
                if (list == null) {
                    try {
                        try {
                            LogFile.add(1, "INVALID_INDICATION", this.namespace, string, this.ci.toString());
                        }
                        catch (Exception exception) {}
                    }
                    catch (Throwable throwable) {}
                    return;
                }
                Iterator iterator = list.iterator();
                ArrayList<FilterActivation> arrayList = new ArrayList<FilterActivation>();
                while (iterator.hasNext()) {
                    FilterActivation.SubActivation subActivation = (FilterActivation.SubActivation)iterator.next();
                    FilterActivation filterActivation = subActivation.getParentActivation();
                    if (arrayList.contains(filterActivation)) continue;
                    try {
                        if (subActivation.getExpression() != null && !subActivation.getExpression().apply((CIMElement)this.ci)) continue;
                        arrayList.add(filterActivation);
                    }
                    catch (CIMException cIMException) {
                        if (!CIMOMImpl.verbose) continue;
                        cIMException.printStackTrace();
                    }
                }
                try {
                    this.deliverEvent(this.namespace, this.ci, arrayList);
                }
                catch (Exception exception) {
                    if (!CIMOMImpl.verbose) break block10;
                    exception.printStackTrace();
                }
            }
        }

        private CIMInstance selectListIterator(SelectList selectList, CIMInstance cIMInstance) throws CIMException {
            Enumeration enumeration = selectList.elements();
            CIMInstance cIMInstance2 = new CIMInstance();
            cIMInstance2.setProperties(new Vector());
            while (enumeration.hasMoreElements()) {
                String string = ((AttributeExp)enumeration.nextElement()).getAttributeName();
                if (string.equals("*")) {
                    return cIMInstance;
                }
                this.getProperty(cIMInstance, cIMInstance2, string);
            }
            return cIMInstance2;
        }
    }
}

