/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.util;

import com.sun.management.viper.util.Debug;
import java.util.LinkedList;

public class ThreadPool
extends ThreadGroup {
    protected ThreadQueue threadQueue = null;
    protected int initSize = 0;
    protected int curSize = 0;
    protected int maxSize = 0;
    protected static int poolID = 0;
    protected static int threadID = 0;
    protected boolean shutdown = false;

    public ThreadPool() {
        this(1, 10);
    }

    public ThreadPool(int n) {
        this(n, 2 * n);
    }

    public ThreadPool(int n, int n2) {
        super("ThreadPool" + poolID++);
        this.initSize = n;
        this.maxSize = n2;
        this.threadQueue = new ThreadQueue();
        if (this.initSize < 0) {
            this.initSize = 1;
            this.maxSize = 10;
        }
        if (this.maxSize < 0) {
            this.maxSize = 2 * this.initSize;
        }
        if (this.initSize > this.maxSize) {
            this.maxSize = this.initSize;
        }
        int n3 = 0;
        while (n3 < this.initSize) {
            new ThreadWorker().start();
            ++n3;
        }
        this.curSize = this.initSize;
    }

    public synchronized void run(Runnable runnable) throws RuntimeException {
        this.threadQueue.push(runnable);
        if (this.threadQueue.isWaiting() && this.curSize < this.maxSize) {
            ++this.curSize;
            new ThreadWorker().start();
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.threadQueue.shutDown();
    }

    class ThreadWorker
    extends Thread {
        public ThreadWorker() {
            super((ThreadGroup)ThreadPool.this, "ThreadWorker" + threadID++);
        }

        public void run() {
            do {
                try {
                    Runnable runnable = (Runnable)ThreadPool.this.threadQueue.pop();
                    if (runnable == null) {
                        Debug.trace("ThreadPool", Debug.WARNING, "ThreadWorker de-queued a null job", null);
                        continue;
                    }
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Debug.trace("ThreadPool", Debug.INFORMATION, "ThreadWorker Problem", throwable);
                }
            } while (!ThreadPool.this.shutdown);
        }
    }

    class ThreadQueue {
        protected LinkedList elements = new LinkedList();
        protected boolean shutdown = false;
        protected static final String msg = "ThreadQueue Shutdown.";

        public synchronized boolean isWaiting() {
            return this.elements.size() > 0;
        }

        public final synchronized Object pop() throws RuntimeException {
            while (this.elements.isEmpty()) {
                try {
                    this.wait();
                }
                catch (Throwable throwable) {}
                if (!this.shutdown) continue;
                throw new RuntimeException(msg);
            }
            try {
                return this.elements.removeFirst();
            }
            catch (Throwable throwable) {
                Debug.trace("ThreadPool", Debug.ERROR, "Problem de-queuing runnable", throwable);
                return null;
            }
        }

        public final synchronized void push(Object object) throws RuntimeException {
            if (this.shutdown) {
                throw new RuntimeException(msg);
            }
            try {
                this.elements.add(object);
            }
            catch (Throwable throwable) {
                Debug.trace("ThreadPool", Debug.ERROR, "Problem en-queuing runnable", throwable);
            }
            try {
                this.notify();
            }
            catch (Throwable throwable) {}
        }

        public synchronized void shutDown() {
            this.shutdown = true;
            try {
                this.notifyAll();
            }
            catch (Throwable throwable) {}
        }
    }
}

