/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.util;

import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.QuotedStringTokenizer;
import com.sun.management.viper.util.SecureReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class CommandOption {
    public static final int BOOLEAN = 0;
    public static final int STRING = 1;
    public static final int INTEGER = 2;
    public static final int FLOAT = 3;
    protected String name = null;
    protected String description = null;
    protected String[] flags = null;
    protected int type = 0;
    protected boolean argument = false;
    protected boolean optional = true;
    protected boolean multiple = true;
    protected Vector values = new Vector(1);
    protected boolean hasDefault = false;
    protected boolean wasSet = false;
    protected boolean sensitive = false;
    protected boolean hidden = false;
    protected boolean priority = false;

    public CommandOption() {
        this(null, null, null, 0, true, true, null, false, false);
    }

    public CommandOption(String string, String string2, String string3, int n, boolean bl, boolean bl2, Object object, boolean bl3) {
        this(string, string2, new String[]{string3}, n, bl, bl2, object, bl3, false);
    }

    public CommandOption(String string, String string2, String[] stringArray, int n, boolean bl, boolean bl2, Object object, boolean bl3) {
        this(string, string2, stringArray, n, bl, bl2, object, bl3, false);
    }

    public CommandOption(String string, String string2, String[] stringArray, int n, boolean bl, boolean bl2, Object object, boolean bl3, boolean bl4) {
        this.name = string;
        this.description = string2;
        this.flags = stringArray;
        this.type = n;
        this.hidden = false;
        this.priority = bl4;
        if (n != 0) {
            this.argument = true;
            if (object != null) {
                this.hasDefault = true;
                this.values.addElement(object);
            }
        } else {
            this.hasDefault = true;
            if (object != null && object instanceof Boolean) {
                this.values.addElement(object);
            } else {
                Boolean bl5 = new Boolean(false);
                this.values.addElement(bl5);
            }
        }
        this.optional = bl;
        this.multiple = bl2;
        this.sensitive = bl3;
    }

    public void addValue(Object object) throws Exception {
        switch (this.type) {
            case 0: {
                if (object instanceof Boolean) {
                    object = this.isValidValue(object);
                    this.values.removeAllElements();
                    this.values.add(object);
                    this.wasSet = true;
                    break;
                }
                if (object != null && object instanceof String) {
                    String string = ((String)object).toLowerCase();
                    if (string.equals("y") || string.equals("yes")) {
                        object = this.isValidValue(new Boolean(true));
                        this.values.removeAllElements();
                        this.values.add(object);
                        this.wasSet = true;
                        break;
                    }
                    if (string.equals("n") || string.equals("no")) {
                        object = this.isValidValue(new Boolean(false));
                        this.values.removeAllElements();
                        this.values.add(object);
                        this.wasSet = true;
                        break;
                    }
                }
                throw new Exception(CommandOption.getMessage("Invalid argument for {0}: {1}", new String[]{this.name, object.toString()}));
            }
            case 1: {
                if (object instanceof String) {
                    object = this.isValidValue(object);
                    if (this.hasDefault) {
                        this.hasDefault = false;
                        this.values.removeAllElements();
                    }
                    this.values.addElement(object);
                    this.wasSet = true;
                    break;
                }
                throw new Exception(CommandOption.getMessage("Invalid argument for {0}: {1}", new String[]{this.name, object.toString()}));
            }
            case 2: {
                Integer n = null;
                try {
                    n = new Integer((String)object);
                }
                catch (Exception exception) {
                    throw new Exception(CommandOption.getMessage("Invalid argument for {0}: {1}", new String[]{this.name, object.toString()}));
                }
                object = this.isValidValue(n);
                if (this.hasDefault) {
                    this.hasDefault = false;
                    this.values.removeAllElements();
                }
                this.values.addElement(object);
                this.wasSet = true;
                break;
            }
            case 3: {
                Float f = null;
                try {
                    f = new Float((String)object);
                }
                catch (Exception exception) {
                    throw new Exception(CommandOption.getMessage("Invalid argument for {0}: {1}", new String[]{this.name, object.toString()}));
                }
                object = this.isValidValue(f);
                if (this.hasDefault) {
                    this.hasDefault = false;
                    this.values.removeAllElements();
                }
                this.values.addElement(object);
                this.wasSet = true;
                break;
            }
            default: {
                throw new Exception(CommandOption.getMessage("Problem parsing arguments"));
            }
        }
        if (this.values.size() > 1 && !this.multiple) {
            throw new Exception(CommandOption.getMessage("Too many arguments for {0}: {1}", new String[]{this.name, object.toString()}));
        }
    }

    public boolean allowsMultiple() {
        return this.multiple;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFlag() {
        return this.flags[0];
    }

    public String[] getFlags() {
        return this.flags;
    }

    static String getMessage(String string) {
        return CommandParser.getMessage(string);
    }

    static String getMessage(String string, Object[] objectArray) {
        return CommandParser.getMessage(string, objectArray);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        if (this.values != null && this.values.size() > 0) {
            return this.values.elementAt(0);
        }
        return null;
    }

    public Vector getValues() {
        return this.values;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public boolean hasFlag(String string) {
        int n = 0;
        while (n < this.flags.length) {
            if (this.flags[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public boolean isArgument() {
        return this.argument;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    protected Object isValidValue(Object object) throws Exception {
        return object;
    }

    public static String printFlag(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() == 1) {
            return "-" + string;
        }
        if (bl) {
            return "--" + string;
        }
        return "-" + string;
    }

    public void printUsage(PrintStream printStream) {
        this.printUsage(printStream, true);
    }

    public void printUsage(PrintStream printStream, boolean bl) {
        if (this.hidden) {
            return;
        }
        if (this.optional) {
            printStream.print("[");
        }
        printStream.print(CommandOption.printFlag(this.flags[0], bl));
        int n = 1;
        while (n < this.flags.length) {
            printStream.print(", " + CommandOption.printFlag(this.flags[n], bl));
            ++n;
        }
        if (this.argument) {
            printStream.print(" " + this.name);
        }
        if (this.multiple) {
            printStream.print(" ...");
        }
        if (this.optional) {
            printStream.print("]");
        }
        printStream.print(" ");
    }

    public void printUsageVerbose(PrintStream printStream) {
        this.printUsageVerbose(printStream, true);
    }

    public void printUsageVerbose(PrintStream printStream, boolean bl) {
        if (this.hidden) {
            return;
        }
        printStream.print("\t");
        printStream.print(CommandOption.printFlag(this.flags[0], bl));
        int n = 1;
        while (n < this.flags.length) {
            printStream.print(", " + CommandOption.printFlag(this.flags[n], bl));
            ++n;
        }
        printStream.print("\t");
        if (this.argument) {
            int n2 = this.name.length();
            printStream.print(String.valueOf(this.name) + " ");
            if (this.multiple) {
                printStream.print("...");
                n2 += 4;
            }
            if (n2 < 7) {
                printStream.print("\t");
            }
        } else {
            printStream.print("\t");
        }
        printStream.print("\t: " + this.description);
        if (!this.optional) {
            printStream.print(CommandOption.getMessage(" (required)"));
        } else {
            printStream.print(CommandOption.getMessage(" (optional)"));
        }
        printStream.println();
    }

    public boolean promptUser(InputStream inputStream, PrintStream printStream) {
        Object object;
        Object object2;
        block31: {
            if (inputStream == null || printStream == null) {
                return false;
            }
            if (this.wasSet && !this.multiple) {
                return true;
            }
            printStream.println("\n" + CommandOption.getMessage("Type '/?' for help, pressing <enter> accepts the default denoted by [ ]"));
            if (this.multiple) {
                printStream.println(CommandOption.getMessage("Enter multiple values by separating each value with a space."));
            }
            if (this.type == 0) {
                printStream.print(CommandOption.getMessage("Please enter a boolean value for: {0}", new String[]{this.name}));
                if (this.hasDefault) {
                    try {
                        object2 = (Boolean)this.getValue();
                        if (((Boolean)object2).booleanValue()) {
                            printStream.print(" " + CommandOption.getMessage("([yes] | no)"));
                            break block31;
                        }
                        printStream.print(" " + CommandOption.getMessage("(yes | [no])"));
                    }
                    catch (Exception exception) {
                        printStream.print(" " + CommandOption.getMessage("([yes] | no)"));
                    }
                } else {
                    printStream.print(" " + CommandOption.getMessage("([yes] | no)"));
                }
            } else {
                object2 = "string";
                if (this.type == 2) {
                    object2 = "integer";
                } else if (this.type == 3) {
                    object2 = "decimal";
                }
                printStream.print(CommandOption.getMessage("Please enter a " + (String)object2 + " value for: {0}", new String[]{this.name}));
                if (this.hasDefault) {
                    printStream.print(" [" + this.getValue().toString() + "]");
                }
            }
        }
        printStream.print(" :: ");
        object2 = null;
        try {
            if (this.sensitive) {
                object2 = SecureReader.readLine(inputStream);
                printStream.println();
            } else {
                object = new BufferedReader(new InputStreamReader(inputStream));
                object2 = ((BufferedReader)object).readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (object2 == null) {
            return false;
        }
        object = null;
        if (this.multiple) {
            object = new Vector();
            try {
                QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer((String)object2);
                String string = quotedStringTokenizer.nextToken();
                while (string != null) {
                    ((Vector)object).addElement(string);
                    string = quotedStringTokenizer.nextToken();
                }
                object2 = (String)((Vector)object).elementAt(0);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (((String)object2).equals("/?")) {
            printStream.println();
            this.printUsageVerbose(printStream);
            printStream.println();
            return this.promptUser(inputStream, printStream);
        }
        if (((String)object2).length() == 0) {
            if (this.hasDefault) {
                this.wasSet = true;
                return true;
            }
            printStream.println();
            this.printUsageVerbose(printStream);
            printStream.println();
            return this.promptUser(inputStream, printStream);
        }
        try {
            if (object != null) {
                int n = 0;
                while (n < ((Vector)object).size()) {
                    this.addValue(((Vector)object).elementAt(n));
                    ++n;
                }
            } else {
                this.addValue(object2);
            }
            return true;
        }
        catch (Exception exception) {
            printStream.println("");
            printStream.println(CommandOption.getMessage("Error: {0}", new String[]{exception.getMessage()}));
            this.printUsageVerbose(printStream);
            printStream.println();
            return this.promptUser(inputStream, printStream);
        }
    }

    public void reset() {
        this.values.clear();
        this.wasSet = false;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setFlag(String string) {
        this.flags[0] = string;
    }

    public void setFlags(String[] stringArray) {
        this.flags = stringArray;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public void setMultiple(boolean bl) {
        this.multiple = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public void setPriority(boolean bl) {
        this.priority = bl;
    }

    public void setSensitive(boolean bl) {
        this.sensitive = bl;
    }

    public boolean wasSet() {
        return this.wasSet;
    }
}

