/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.util;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;

public class BadgedImageFilter
extends RGBImageFilter {
    private int originX;
    private int originY;
    private Image badge;
    private PixelGrabber pg;
    private int[] badgePixels;

    public BadgedImageFilter(int n, int n2, Image image) {
        this.originX = n;
        this.originY = n2;
        this.badge = image;
        this.canFilterIndexColorModel = false;
        this.pg = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            this.pg.grabPixels();
            this.badgePixels = (int[])this.pg.getPixels();
        }
        catch (Exception exception) {
            this.badgePixels = null;
        }
    }

    public int filterRGB(int n, int n2, int n3) {
        if (n < this.originX || n >= this.originX + this.pg.getWidth()) {
            return n3;
        }
        if (n2 < this.originY || n2 >= this.originY + this.pg.getHeight()) {
            return n3;
        }
        if (this.badgePixels == null) {
            return n3;
        }
        int n4 = n - this.originX;
        int n5 = n2 - this.originY;
        int n6 = n5 * this.pg.getWidth() + n4;
        int n7 = this.badgePixels[n6];
        if ((n7 & 0xFF000000) == 0) {
            return n3;
        }
        return n7;
    }
}

