/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.services;

import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.services.Persistence;
import com.sun.management.viper.services.PersistenceException;
import com.sun.management.viper.services.ServiceList;
import com.sun.management.viper.util.ObjectInputStreamLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class PersistenceAgent {
    private ToolInfrastructure tinf = null;
    private ServiceInfrastructure sinf = null;
    private Persistence datastore = null;
    private static boolean isVerified = false;
    private static SecurityManager sm = null;
    private static Method getCallerClassMethod = null;

    public PersistenceAgent(ServiceInfrastructure serviceInfrastructure) throws PersistenceException {
        try {
            this.datastore = (Persistence)serviceInfrastructure.getServiceByName(ServiceList.PERSISTENCE);
        }
        catch (VException vException) {
            String[] stringArray = new String[]{vException.getLocalizedMessage()};
            throw new PersistenceException("InitFailed", stringArray);
        }
        this.sinf = serviceInfrastructure;
        this.initTracer();
    }

    public PersistenceAgent(ToolInfrastructure toolInfrastructure) throws PersistenceException {
        try {
            this.datastore = (Persistence)toolInfrastructure.getServiceByName(ServiceList.PERSISTENCE);
        }
        catch (VException vException) {
            String[] stringArray = new String[]{vException.getLocalizedMessage()};
            throw new PersistenceException("InitFailed", stringArray);
        }
        this.tinf = toolInfrastructure;
        this.initTracer();
    }

    private Object constructObject(byte[] byArray) throws ClassNotFoundException {
        Object object;
        Object object2 = null;
        if (byArray == null) {
            return null;
        }
        ClassLoader classLoader = null;
        if (getCallerClassMethod != null) {
            try {
                object = (Class)getCallerClassMethod.invoke((Object)sm, null);
                classLoader = ((Class)object).getClassLoader();
            }
            catch (Exception exception) {}
        }
        try {
            object = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = classLoader == null ? new ObjectInputStream((InputStream)object) : new ObjectInputStreamLoader((InputStream)object, classLoader);
            object2 = objectInputStream.readObject();
            objectInputStream.close();
            ((ByteArrayInputStream)object).close();
        }
        catch (IOException iOException) {}
        return object2;
    }

    public Object delete(String string) throws PersistenceException {
        Object object = null;
        try {
            byte[] byArray = this.datastore.delete(string);
            object = this.constructObject(byArray);
        }
        catch (RemoteException remoteException) {
            throw new PersistenceException("UnexpectedException", remoteException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return object;
    }

    protected void finalize() throws Throwable {
        if (this.tinf != null) {
            this.tinf.releaseService(this.datastore);
        }
        if (this.sinf != null) {
            this.sinf.releaseService(this.datastore);
        }
    }

    private void initTracer() {
        block3: {
            if (isVerified) break block3;
            isVerified = true;
            sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    getCallerClassMethod = sm.getClass().getMethod("getCallerClass", null);
                }
                catch (Exception exception) {}
            }
        }
    }

    public Object restore(String string) throws PersistenceException {
        Object object = null;
        try {
            byte[] byArray = this.datastore.restore(string);
            object = this.constructObject(byArray);
        }
        catch (RemoteException remoteException) {
            throw new PersistenceException("UnexpectedException", remoteException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String[] stringArray = new String[]{classNotFoundException.getMessage()};
            throw new PersistenceException("ClassNotFound", stringArray);
        }
        return object;
    }

    public Object store(Object object, String string) throws PersistenceException {
        return this.store(object, "1.0", string);
    }

    public Object store(Object object, String string, String string2) throws PersistenceException {
        Object object2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byteArrayOutputStream.flush();
            byte[] byArray = this.datastore.store(byteArrayOutputStream.toByteArray(), string, string2);
            byteArrayOutputStream.close();
            if (byArray != null) {
                try {
                    object2 = this.constructObject(byArray);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (IOException iOException) {
            throw new PersistenceException("UnexpectedException", iOException);
        }
        return object2;
    }

    public String version(String string) throws PersistenceException {
        try {
            return this.datastore.version(string);
        }
        catch (RemoteException remoteException) {
            throw new PersistenceException("UnexpectedException", remoteException);
        }
    }
}

