/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.wizard;

import com.sun.management.viper.console.gui.deck.VBaseDeck;
import com.sun.management.viper.console.gui.deck.VCard;
import com.sun.management.viper.console.gui.deck.VDeckManager;
import com.sun.management.viper.console.gui.deck.VDeckProperties;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import com.sun.management.viper.console.gui.wizard.VWizardManager;
import com.sun.management.viper.console.gui.wizard.VWizardProperties;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class VWizard
extends VBaseDeck {
    protected JButton backButton = null;
    protected JButton nextButton = null;
    protected JButton cancelButton = null;
    protected String nextString = ResourceManager.getString("Next");
    protected String finishString = ResourceManager.getString("Finish");
    protected boolean showSteps = false;
    protected boolean showAllSteps = false;
    protected String wizardTitle = null;
    protected Class imageClass = null;
    protected boolean stepsAdded = false;
    protected StepsPane stepsPane = null;

    public VWizard() {
        this((String)null);
    }

    public VWizard(String string) {
        super(string);
        try {
            this.imageClass = Class.forName("com.sun.management.viper.console.gui.wizard.VWizard");
        }
        catch (Exception exception) {}
        this.backButton = new JButton(ResourceManager.getString("Back"), ConsoleUtility.loadImageIcon("images/back16.gif", this.imageClass)){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 26);
            }
        };
        this.backButton.setFont(ResourceManager.menuFont);
        this.backButton.setMargin(new Insets(1, 4, 1, 4));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VWizard.this.moveBackward();
            }
        });
        this.nextButton = new JButton(this.nextString, ConsoleUtility.loadImageIcon("images/forward16.gif", this.imageClass)){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 26);
            }
        };
        this.nextButton.setFont(ResourceManager.menuFont);
        this.nextButton.setMargin(new Insets(1, 4, 1, 4));
        this.nextButton.setHorizontalTextPosition(2);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VWizard.this.moveForward();
            }
        });
        this.nextButton.requestDefaultFocus();
        this.cancelButton = new JButton(ResourceManager.getString("Cancel")){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 26);
            }
        };
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setMargin(new Insets(1, 4, 1, 4));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VWizard.this.cancelWizard();
            }
        });
        super.getButtonPane().add(Box.createHorizontalGlue());
        super.getButtonPane().add(this.backButton);
        super.getButtonPane().add(Box.createHorizontalStrut(5));
        super.getButtonPane().add(this.nextButton);
        super.getButtonPane().add(Box.createHorizontalStrut(10));
        super.getButtonPane().add(this.cancelButton);
        this.reset();
    }

    public void addCard(String string, VWizardCard vWizardCard) {
        super.addCard(string, vWizardCard);
        if (vWizardCard != null) {
            vWizardCard.setWizard(this);
        }
    }

    public void addWizardCard(String string, VWizardCard vWizardCard) {
        this.addCard(string, vWizardCard);
    }

    protected Dimension calculatePreferredSize() {
        Dimension dimension = this.buttonPane.getPreferredSize();
        Dimension dimension2 = this.manager.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.infoOn) {
            Dimension dimension3 = this.infoPane.getPreferredSize();
            if (dimension2.width + dimension3.width > n) {
                n = dimension2.width + dimension3.width;
            }
            n2 = dimension3.height > dimension2.height ? (n2 += dimension3.height) : (n2 += dimension2.height);
        } else {
            n2 += dimension2.height;
            if (dimension2.width > n) {
                n = dimension2.width;
            }
        }
        return new Dimension(n += 8, n2 += 20);
    }

    protected void cancelAction() {
        this.paneClosed();
    }

    public void cancelWizard() {
        Component component = this.getContainer();
        try {
            component.setVisible(false);
        }
        catch (Exception exception) {}
        this.setVisible(false);
        this.reset();
    }

    protected void defaultAction() {
        this.moveForward();
    }

    protected VDeckManager getNewManager() {
        return new VWizardManager();
    }

    protected VDeckProperties getNewProperties() {
        return new VWizardProperties();
    }

    public boolean getShowsAllSteps() {
        return this.showAllSteps;
    }

    public boolean getShowsSteps() {
        return this.showSteps;
    }

    public void moveBackward() {
        this.updateCard(this.manager.moveBackward());
        if (this.stepsPane != null) {
            this.stepsPane.moveBackward();
        }
    }

    public void moveForward() {
        this.updateCard(this.manager.moveForward());
        if (this.stepsPane != null) {
            this.stepsPane.moveForward();
        }
    }

    public void paneClosed() {
        this.cancelWizard();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        try {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("vwp.canmoveforward")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string2.equals("vwp.true")) {
                    this.nextButton.setEnabled(true);
                } else {
                    this.nextButton.setEnabled(false);
                }
            } else if (string.equals("vwp.canmovebackward")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                if (string3.equals("vwp.true")) {
                    this.backButton.setEnabled(true);
                } else {
                    this.backButton.setEnabled(false);
                }
            } else if (string.equals("vwp.finishstate")) {
                String string4 = (String)propertyChangeEvent.getNewValue();
                if (string4.equals("vwp.true")) {
                    this.nextButton.setText(this.finishString);
                } else {
                    this.nextButton.setText(this.nextString);
                }
            }
        }
        catch (Exception exception) {}
    }

    public void reset() {
        super.reset();
        if (this.stepsPane != null) {
            this.stepsPane.reset();
        }
    }

    public void setFirst(String string) {
        this.manager.setFirst(string);
        this.manager.setCurrent(string);
        this.manager.setPrevious(string, "");
    }

    public void setShowsAllSteps(boolean bl) {
        this.showAllSteps = bl;
    }

    public void setShowsSteps(boolean bl) {
        this.showSteps = bl;
    }

    protected void setupStepsPane() {
        if (!this.stepsAdded) {
            this.stepsPane = new StepsPane();
            this.addInfoComponent(ResourceManager.getString("Steps"), this.stepsPane);
            this.stepsAdded = true;
            this.validate();
            this.repaint();
        }
    }

    public void start() {
        this.infoPane.setPaintUL(this.showSteps ^ true);
        if (this.showSteps) {
            this.setupStepsPane();
        }
        super.start();
    }

    class StepsPane
    extends JPanel {
        protected Color bgColor = null;
        protected Vector panels = null;
        protected int panelIndex = 0;
        protected Component glue = null;
        protected Component lastStrut = null;

        public StepsPane() {
            this.setBorder(new EmptyBorder(10, 5, 5, 5));
            this.bgColor = new JTable().getSelectionBackground();
            this.panels = new Vector();
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout(this, 1));
            this.glue = Box.createVerticalGlue();
            try {
                int n = 1;
                String string = VWizard.this.getManager().getFirst();
                VCard vCard = VWizard.this.getManager().getCard(string);
                String string2 = vCard.getTitle();
                JLabel jLabel = new JLabel(String.valueOf(n) + ". " + string2);
                jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
                jLabel.setForeground(Color.black);
                JPanel jPanel = new JPanel(){

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                    }
                };
                jPanel.setLayout(new FlowLayout(0));
                jPanel.setBackground(this.bgColor);
                jPanel.add(jLabel);
                this.panels.addElement(jPanel);
                this.add(jPanel);
                if (VWizard.this.showAllSteps) {
                    string = VWizard.this.getManager().getNext(string);
                    while (string != null) {
                        vCard = VWizard.this.getManager().getCard(string);
                        string2 = vCard.getTitle();
                        this.addStep(string2);
                        string = VWizard.this.getManager().getNext(string);
                    }
                }
                this.add(this.glue);
            }
            catch (Throwable throwable) {}
        }

        protected void addStep(String string) {
            if (string == null) {
                return;
            }
            try {
                JLabel jLabel = new JLabel(String.valueOf(this.panels.size() + 1) + ". " + string);
                jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
                jLabel.setForeground(Color.black);
                JPanel jPanel = new JPanel(){

                    public Dimension getMaximumSize() {
                        return this.getPreferredSize();
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                    }
                };
                jPanel.setLayout(new FlowLayout(0));
                jPanel.setBackground(Color.white);
                jPanel.add(jLabel);
                this.lastStrut = Box.createVerticalStrut(5);
                this.add(this.lastStrut);
                this.panels.addElement(jPanel);
                this.add(jPanel);
            }
            catch (Throwable throwable) {}
        }

        public void moveBackward() {
            try {
                if (VWizard.this.showAllSteps) {
                    JPanel jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    jPanel.setBackground(Color.white);
                    --this.panelIndex;
                    jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    jPanel.setBackground(this.bgColor);
                } else {
                    JPanel jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    --this.panelIndex;
                    this.remove(jPanel);
                    this.remove(this.lastStrut);
                    this.panels.remove(jPanel);
                    jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    jPanel.setBackground(this.bgColor);
                }
                this.validate();
                this.repaint();
            }
            catch (Throwable throwable) {}
        }

        public void moveForward() {
            try {
                JPanel jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                jPanel.setBackground(Color.white);
                ++this.panelIndex;
                if (VWizard.this.showAllSteps) {
                    jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    jPanel.setBackground(this.bgColor);
                } else {
                    this.remove(this.glue);
                    String string = VWizard.this.getManager().getCurrent();
                    VCard vCard = VWizard.this.getManager().getCard(string);
                    String string2 = vCard.getTitle();
                    this.addStep(string2);
                    this.add(this.glue);
                    jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    jPanel.setBackground(this.bgColor);
                }
                this.validate();
                this.repaint();
            }
            catch (Throwable throwable) {}
        }

        public void reset() {
            try {
                if (VWizard.this.showAllSteps) {
                    JPanel jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    jPanel.setBackground(Color.white);
                    this.panelIndex = 0;
                    jPanel = (JPanel)this.panels.elementAt(this.panelIndex);
                    jPanel.setBackground(this.bgColor);
                } else {
                    this.removeAll();
                    JPanel jPanel = null;
                    jPanel = (JPanel)this.panels.elementAt(0);
                    jPanel.setBackground(this.bgColor);
                    this.panels = new Vector();
                    this.panels.addElement(jPanel);
                    this.panelIndex = 0;
                    this.add(jPanel);
                    this.add(this.glue);
                }
                this.validate();
                this.repaint();
            }
            catch (Throwable throwable) {}
        }
    }
}

