/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.propsheet;

import com.sun.management.viper.console.gui.deck.VBaseCard;
import com.sun.management.viper.console.gui.deck.VBaseDeck;
import com.sun.management.viper.console.gui.deck.VCard;
import com.sun.management.viper.console.gui.deck.VDeckManager;
import com.sun.management.viper.console.gui.deck.VDeckProperties;
import com.sun.management.viper.console.gui.propsheet.VPropertySheet;
import com.sun.management.viper.console.gui.propsheet.VPropertySheetManager;
import com.sun.management.viper.console.gui.propsheet.VPropertySheetProperties;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VPropertySheetEditor
extends VBaseDeck
implements ChangeListener {
    protected JTabbedPane tabPane = null;
    protected JButton okButton = null;
    protected JButton applyButton = null;
    protected JButton cancelButton = null;
    protected boolean addingCard = false;

    public VPropertySheetEditor() {
        this((String)null);
    }

    public VPropertySheetEditor(String string) {
        super(string);
        this.manager = new VPropertySheetManager();
        this.okButton = new JButton();
        this.okButton.setMargin(new Insets(1, 4, 1, 4));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VPropertySheetEditor.this.doOK();
            }
        });
        this.applyButton = new JButton();
        this.applyButton.setMargin(new Insets(1, 4, 1, 4));
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VPropertySheetEditor.this.doApply();
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.setMargin(new Insets(1, 4, 1, 4));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VPropertySheetEditor.this.doCancel();
            }
        });
        JComponent jComponent = super.getButtonPane();
        jComponent.add(this.okButton);
        jComponent.add(Box.createHorizontalStrut(5));
        jComponent.add(this.applyButton);
        jComponent.add(Box.createHorizontalStrut(5));
        jComponent.add(this.cancelButton);
        this.tabPane = new JTabbedPane();
        this.tabPane.addChangeListener(this);
        super.getContentPane().setBorder(new EmptyBorder(5, 5, 5, 5));
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.tabPane, "Center");
        this.contentPane.setShowHeader(false);
        this.reset();
    }

    public void addCard(String string, VCard vCard) {
        super.addCard(string, vCard);
        this.addingCard = true;
        this.tabPane.addTab(vCard.getTitle(), (VBaseCard)vCard);
        this.addingCard = false;
        ((VBaseCard)vCard).setBorder(new EmptyBorder(10, 10, 10, 10));
        if (vCard != null && vCard instanceof VPropertySheet) {
            ((VPropertySheet)vCard).setEditor(this);
        }
    }

    public boolean doApply() {
        try {
            if (this.manager.getCurrentCard().stop() && this.manager.apply()) {
                return true;
            }
            this.updateCard(this.manager.getCurrentCard());
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public void doCancel() {
        try {
            this.getContainer().setVisible(false);
        }
        catch (Exception exception) {}
        this.setVisible(false);
        this.reset();
    }

    public void doOK() {
        if (this.doApply()) {
            this.doCancel();
        }
    }

    protected VDeckManager getNewManager() {
        return new VPropertySheetManager();
    }

    protected VDeckProperties getNewProperties() {
        return new VPropertySheetProperties();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.contentPane.getPreferredSize();
        int n = dimension.width;
        if (this.infoOn) {
            n += this.getInfoPane().getPreferredSize().width;
        }
        Dimension dimension2 = this.getButtonPane().getPreferredSize();
        int n2 = dimension.height + dimension2.height;
        return new Dimension(n += 25, n2 += 25);
    }

    protected void installStrings() {
        this.okButton.setText(ResourceManager.getString("OK_BUTTON"));
        this.okButton.setMnemonic(ResourceManager.getString("OK_BUTTON_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("OK_BUTTON_access_name"));
        this.okButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("OK_BUTTON_access_desc"));
        this.applyButton.setText(ResourceManager.getString("APPLY_BUTTON"));
        this.applyButton.setMnemonic(ResourceManager.getString("APPLY_BUTTON_mnemonic").charAt(0));
        this.applyButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("APPLY_BUTTON_access_name"));
        this.applyButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("APPLY_BUTTON_access_desc"));
        this.cancelButton.setText(ResourceManager.getString("CANCEL_BUTTON"));
        this.cancelButton.setMnemonic(ResourceManager.getString("CANCEL_BUTTON_mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("CANCEL_BUTTON_access_name"));
        this.cancelButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("CANCEL_BUTTON_access_desc"));
    }

    public void paneClosed() {
        this.doCancel();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        try {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("vpsp.okenabled")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (string2.equals("vwp.true")) {
                    this.okButton.setEnabled(true);
                } else {
                    this.okButton.setEnabled(false);
                }
            } else if (string.equals("vpsp.applyenabled")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                if (string3.equals("vwp.true")) {
                    this.applyButton.setEnabled(true);
                } else {
                    this.applyButton.setEnabled(false);
                }
            }
        }
        catch (Exception exception) {}
    }

    public void removeCard(String string) {
        try {
            VCard vCard = this.manager.getCard(string);
            this.tabPane.remove((Component)((Object)vCard));
        }
        catch (Throwable throwable) {}
        super.removeCard(string);
    }

    public void reset() {
        super.reset();
        this.installStrings();
        if (this.tabPane.getTabCount() > 0) {
            this.tabPane.setSelectedIndex(0);
        }
        this.updateFontAndColor();
    }

    public void start() {
        super.setInfoPaneControlHasDefaultFocus();
        this.updateCard(this.manager.getCurrentCard());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.manager.getCurrentCard().stop();
            VCard vCard = (VCard)((Object)this.tabPane.getSelectedComponent());
            this.manager.setCurrentCard(vCard);
            if (!this.addingCard) {
                this.updateCard(vCard);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void updateCardContent(VCard vCard) {
        this.tabPane.setSelectedComponent((Component)((Object)vCard));
        this.tabPane.validate();
        this.tabPane.repaint();
    }

    protected void updateFontAndColor() {
        this.tabPane.setFont(ResourceManager.menuFont);
        this.tabPane.setForeground(ResourceManager.menuColor);
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.applyButton.setFont(ResourceManager.menuFont);
        this.applyButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }
}

