/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class VNavTreeCombo
extends JComboBox
implements VConsoleActionListener,
PropertyChangeListener {
    static final int OFFSET = 16;
    protected DefaultTreeModel treeModel;
    protected boolean showsRoot;
    protected TreeToListModel listModel;
    protected Vector listeners;
    protected VScopeNode outsideSel;
    protected VScopeNode previousSel;
    protected boolean doNotify;
    protected VConsoleProperties properties;
    protected static ImageIcon defaultLeaf = null;
    protected static ImageIcon defaultFolder = null;
    protected static Class imageClass = null;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public VNavTreeCombo() {
        block2: {
            this.treeModel = null;
            this.showsRoot = false;
            this.listModel = null;
            this.listeners = null;
            this.outsideSel = null;
            this.previousSel = null;
            this.doNotify = true;
            this.properties = null;
            this.setRenderer(new ListEntryRenderer());
            this.setEditor(new ListEntryEditor());
            if (imageClass != null) break block2;
            try {
                imageClass = Class.forName("com.sun.management.viper.console.gui.lf.VNavTreeCombo");
                defaultLeaf = ConsoleUtility.loadImageIcon("../images/file16.gif", imageClass);
                defaultFolder = ConsoleUtility.loadImageIcon("../images/folder16.gif", imageClass);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (vConsoleActionListener != null) {
            this.listeners.addElement(vConsoleActionListener);
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        block4: {
            if (vConsoleEvent == null) {
                return;
            }
            String string = vConsoleEvent.getID();
            if (!string.equals("vconsole.scopeselected")) break block4;
            try {
                if (this.outsideSel != null) {
                    this.previousSel = this.outsideSel;
                }
                this.outsideSel = (VScopeNode)vConsoleEvent.getPayload();
                this.treeNodeSelected(this.outsideSel);
            }
            catch (Throwable throwable) {}
        }
    }

    public VScopeNode getSelectedNode() {
        if (this.outsideSel != null) {
            return this.outsideSel;
        }
        if (this.previousSel != null) {
            return this.previousSel;
        }
        if (this.treeModel != null) {
            return (VScopeNode)this.treeModel.getRoot();
        }
        return null;
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        try {
            int n = 0;
            while (n < this.listeners.size()) {
                Object e = this.listeners.elementAt(n);
                ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
                ++n;
            }
        }
        catch (Throwable throwable) {}
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        try {
            if (string.equals("vconsole.bodyfont")) {
                super.setFont((Font)object);
                this.validate();
                this.repaint();
            } else if (string.equals("vconsole.bodycolor")) {
                super.setForeground((Color)object);
                this.validate();
                this.repaint();
            }
        }
        catch (Throwable throwable) {}
    }

    protected void selectedItemChanged() {
        ListEntry listEntry = (ListEntry)this.getSelectedItem();
        if (listEntry.node() != this.outsideSel && this.doNotify) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.scopeselected", listEntry.node());
            this.notifyListeners(vConsoleEvent);
            this.outsideSel = listEntry.node();
        }
    }

    public void setModel(DefaultTreeModel defaultTreeModel) {
        if (defaultTreeModel != null) {
            this.treeModel = defaultTreeModel;
            this.listModel = new TreeToListModel(defaultTreeModel);
            this.setModel(this.listModel);
            ((ListEntryEditor)this.getEditor()).setItem(null);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties == null) {
            return;
        }
        this.properties = vConsoleProperties;
        vConsoleProperties.addPropertyChangeListener(this);
    }

    public void setShowsRoot(boolean bl) {
        this.showsRoot = bl;
    }

    protected void treeNodeSelected(VScopeNode vScopeNode) {
        this.listModel.validate();
        if (vScopeNode == null) {
            if (this.isEditable()) {
                this.setSelectedIndex(-1);
            }
            this.validate();
            this.repaint();
            return;
        }
        int n = 0;
        while (n < this.listModel.cache.size()) {
            ListEntry listEntry = (ListEntry)this.listModel.cache.elementAt(n);
            if (listEntry.node() == vScopeNode) {
                this.setSelectedIndex(n);
                this.validate();
                this.repaint();
                return;
            }
            ++n;
        }
    }

    class TreeToListModel
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        protected DefaultTreeModel source = null;
        protected boolean invalid = true;
        protected Object currentValue = null;
        public Vector cache = new Vector();

        public TreeToListModel(DefaultTreeModel defaultTreeModel) {
            this.source = defaultTreeModel;
            defaultTreeModel.addTreeModelListener(this);
            VNavTreeCombo.this.setRenderer(new ListEntryRenderer());
        }

        void addListEntry(VScopeNode vScopeNode, int n, boolean bl) {
            this.cache.addElement(new ListEntry(vScopeNode, n, bl));
        }

        void cacheTree(VScopeNode vScopeNode, int n) {
            if (this.source.isLeaf(vScopeNode)) {
                this.addListEntry(vScopeNode, n, false);
            } else {
                int n2 = this.source.getChildCount(vScopeNode);
                int n3 = 0;
                VScopeNode vScopeNode2 = null;
                this.addListEntry(vScopeNode, n, true);
                ++n;
                n3 = 0;
                while (n3 < n2) {
                    vScopeNode2 = (VScopeNode)this.source.getChild(vScopeNode, n3);
                    this.cacheTree(vScopeNode2, n);
                    ++n3;
                }
                --n;
            }
        }

        public Object getElementAt(int n) {
            return this.cache.elementAt(n);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        public void setSelectedItem(Object object) {
            this.currentValue = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.invalid = true;
            this.validate();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.invalid = true;
            this.validate();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.invalid = true;
            this.validate();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.invalid = true;
            this.validate();
        }

        void validate() {
            if (!this.invalid) {
                return;
            }
            VScopeNode vScopeNode = VNavTreeCombo.this.outsideSel;
            this.cache = new Vector();
            this.cacheTree((VScopeNode)this.source.getRoot(), 0);
            if (this.cache.size() > 0) {
                this.currentValue = this.cache.elementAt(0);
            }
            this.invalid = false;
            VNavTreeCombo.this.doNotify = false;
            this.fireContentsChanged(this, 0, 0);
            VNavTreeCombo.this.treeNodeSelected(vScopeNode);
            VNavTreeCombo.this.doNotify = true;
        }
    }

    class ListEntry {
        protected VScopeNode node = null;
        protected int level = 0;
        protected boolean isNode = false;

        public ListEntry(VScopeNode vScopeNode, int n, boolean bl) {
            this.node = vScopeNode;
            this.level = n;
            this.isNode = bl;
        }

        public boolean isNode() {
            return this.isNode;
        }

        public int level() {
            return this.level;
        }

        public VScopeNode node() {
            return this.node;
        }
    }

    class ListEntryEditor
    extends JTextField
    implements ComboBoxEditor {
        protected VScopeNode selNode = null;

        public ListEntryEditor() {
            this.setOpaque(true);
            this.setEditable(false);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public Component getEditorComponent() {
            return this;
        }

        public Object getItem() {
            return this;
        }

        public void removeActionListener(ActionListener actionListener) {
        }

        public void selectAll() {
        }

        public void setItem(Object object) {
            try {
                if (object != null) {
                    this.selNode = ((ListEntry)object).node();
                    TreeNode[] treeNodeArray = VNavTreeCombo.this.treeModel.getPathToRoot(this.selNode);
                    String string = " /";
                    boolean bl = true;
                    if (VNavTreeCombo.this.showsRoot) {
                        bl = false;
                    }
                    int n = 1;
                    while (n < treeNodeArray.length) {
                        VScopeNode vScopeNode = (VScopeNode)treeNodeArray[n];
                        string = String.valueOf(string) + "/" + vScopeNode.getText();
                        ++n;
                    }
                    super.setText(string);
                } else {
                    super.setText("");
                }
            }
            catch (Throwable throwable) {}
        }
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ListEntry listEntry = (ListEntry)object;
            if (listEntry == null) {
                this.setText("");
                return this;
            }
            this.setText(listEntry.node().getText());
            ImageIcon imageIcon = listEntry.node().getSmallIcon();
            Image image = null;
            if (imageIcon != null) {
                image = imageIcon.getImage();
            }
            if (image == null || imageIcon.getIconWidth() <= 0) {
                if (listEntry.node().getChildCount() > 0) {
                    this.setIcon(defaultFolder);
                } else {
                    this.setIcon(defaultLeaf);
                }
            } else {
                this.setIcon(imageIcon);
            }
            Border border = n != -1 ? new EmptyBorder(0, 16 * listEntry.level(), 0, 0) : emptyBorder;
            this.setBorder(border);
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                if (n == -1) {
                    this.setOpaque(false);
                } else {
                    this.setOpaque(true);
                }
            } else {
                this.setOpaque(true);
            }
            if (bl) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            return this;
        }
    }
}

