/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;

public class VMenuBar
extends JMenuBar
implements PropertyChangeListener,
VConsoleActionListener,
Serializable {
    protected JMenu[] menuSet = null;
    protected JMenuItem[] consoleItems = null;
    protected JMenuItem[] editItems = null;
    protected JMenuItem[] actionItems = null;
    protected JMenuItem[] viewItems = null;
    protected JMenuItem[] goItems = null;
    protected JMenuItem[] helpItems = null;
    protected JMenuItem[] showItems = null;
    protected JMenuItem[] viewAsItems = null;
    protected JMenuItem[] columnsItems = null;
    protected JMenuItem[] sortByItems = null;
    protected ActionListener columnListener = null;
    protected ActionListener sortListener = null;
    protected ActionListener menuListener = null;
    protected ActionListener toggleListener = null;
    protected ActionListener iconListener = null;
    protected static int CONSOLEINDEX = 0;
    protected static int EDITINDEX = 1;
    protected static int ACTIONINDEX = 2;
    protected static int VIEWINDEX = 3;
    protected static int GOINDEX = 4;
    protected static int HELPINDEX = 5;
    protected transient VConsoleProperties properties = null;
    protected transient VScopeNode selNode = null;
    protected transient VScopeNode nodeToOpen = null;
    protected transient Vector listeners = null;
    protected transient boolean detailsMode = false;
    protected transient String sortByNameText = null;
    protected transient String sortedColumn = null;
    protected transient boolean notifyOfSort = false;
    protected JMenuBar toolMenuBar = null;
    protected JMenu[] toolMenuSet = null;
    protected Component[] toolConsoleItems = null;
    protected Component[] toolActionItems = null;
    protected Component[] toolViewItems = null;
    protected Component[] toolShowItems = null;
    protected Component[] toolViewAsItems = null;
    protected Component[] toolGoItems = null;
    protected Component[] toolHelpItems = null;

    public VMenuBar() {
        this.setBorderPainted(false);
        this.initListeners();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.scopeselected")) {
            try {
                VScopeNode vScopeNode;
                this.selNode = vScopeNode = (VScopeNode)vConsoleEvent.getPayload();
                if (vScopeNode != null && vScopeNode.getInternalRoot() != null) {
                    vScopeNode = vScopeNode.getInternalRoot();
                }
                this.actionItems[0].setEnabled(false);
                this.setMenus(vScopeNode);
            }
            catch (Throwable throwable) {
                Debug.trace("MenuBar", Debug.WARNING, "Problem handling SCOPESELECTED", throwable);
            }
        } else if (string.equals("vconsole.updatescope")) {
            try {
                VScopeNode vScopeNode = (VScopeNode)vConsoleEvent.getPayload();
                if (vScopeNode != null && vScopeNode == this.selNode) {
                    if (vScopeNode.getInternalRoot() != null) {
                        vScopeNode = vScopeNode.getInternalRoot();
                    }
                    this.setMenus(vScopeNode);
                }
            }
            catch (Throwable throwable) {
                Debug.trace("MenuBar", Debug.WARNING, "Problem handling UPDATESCOPE", throwable);
            }
        } else if (string.equals("vconsole.scopechildselected")) {
            try {
                VScopeNode vScopeNode;
                this.actionItems[0].setEnabled(false);
                this.nodeToOpen = null;
                Vector vector = (Vector)vConsoleEvent.getPayload();
                if (vector != null && vector.size() == 1 && (vScopeNode = (VScopeNode)vector.elementAt(0)).getParent() == this.selNode) {
                    this.actionItems[0].setEnabled(true);
                    this.nodeToOpen = vScopeNode;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Debug.trace("MenuBar", Debug.WARNING, "Problem handling SCOPECHILDSELECTED", throwable);
            }
            this.syncActionMenu();
        }
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(String string) {
        if (string == null) {
            return null;
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setFont(ResourceManager.menuFont);
        jCheckBoxMenuItem.setForeground(ResourceManager.menuColor);
        jCheckBoxMenuItem.setActionCommand(string);
        return jCheckBoxMenuItem;
    }

    protected void createDefaultActionMenu() {
        this.actionItems = new JMenuItem[2];
        this.actionItems[0] = this.createMenuItem("OPEN_FOLDER");
        this.actionItems[1] = this.createMenuItem("vconsole.displayproperties");
    }

    protected void createDefaultColumnsMenu() {
        this.viewItems[2] = this.createGenericMenu();
        this.columnsItems = new JMenuItem[2];
        this.columnsItems[0] = this.createCheckBoxMenuItem("");
        this.columnsItems[0].setSelected(true);
        this.columnsItems[0].setEnabled(false);
        this.columnsItems[1] = this.createCheckBoxMenuItem("");
        this.columnsItems[1].setEnabled(false);
        this.columnsItems[1].setSelected(true);
    }

    protected void createDefaultConsoleMenu() {
        this.consoleItems = new JMenuItem[10];
        this.consoleItems[0] = this.createMenuItem("vconsole.newconsole");
        this.consoleItems[1] = this.createMenuItem("vconsole.openconsole");
        this.consoleItems[2] = this.createMenuItem("vconsole.saveconsole");
        this.consoleItems[3] = this.createMenuItem("vconsole.saveconsoleas");
        this.consoleItems[4] = this.createMenuItem("vconsole.modifyconfig");
        this.consoleItems[5] = this.createMenuItem("vconsole.displaypreferences");
        this.consoleItems[6] = this.createMenuItem("vconsole.showconsolelog");
        this.consoleItems[7] = this.createMenuItem("vconsole.print");
        this.consoleItems[8] = this.createMenuItem("vconsole.closeconsole");
        this.consoleItems[9] = this.createMenuItem("vconsole.exitconsole");
    }

    protected void createDefaultEditMenu() {
        this.editItems = new JMenuItem[9];
        this.editItems[0] = this.createMenuItem("vconsole.undo");
        this.editItems[1] = this.createMenuItem("vconsole.redo");
        this.editItems[2] = this.createMenuItem("vconsole.cut");
        this.editItems[3] = this.createMenuItem("vconsole.copy");
        this.editItems[4] = this.createMenuItem("vconsole.paste");
        this.editItems[5] = this.createMenuItem("vconsole.duplicate");
        this.editItems[6] = this.createMenuItem("vconsole.rename");
        this.editItems[7] = this.createMenuItem("vconsole.delete");
        this.editItems[8] = this.createMenuItem("vconsole.selectall");
    }

    protected void createDefaultGoMenu() {
        this.goItems = new JMenuItem[2];
        this.goItems[0] = this.createMenuItem("vconsole.upscopelevel");
        this.goItems[1] = this.createMenuItem("vconsole.hometoolbox");
        this.goItems[1].removeActionListener(this.menuListener);
        this.goItems[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VMenuBar.this.properties == null) {
                    return;
                }
                VConsoleEvent vConsoleEvent = new VConsoleEvent(VMenuBar.this, "vconsole.openconsole", VMenuBar.this.properties.getProperty("vconsole.hometoolbox"));
                VMenuBar.this.notifyListeners(vConsoleEvent);
            }
        });
    }

    protected void createDefaultHelpMenu() {
        this.helpItems = new JMenuItem[5];
        this.helpItems[0] = this.createMenuItem("vconsole.showhelpoverview");
        this.helpItems[1] = this.createMenuItem("vconsole.showhelptoc");
        this.helpItems[2] = this.createMenuItem("vconsole.showhelpindex");
        this.helpItems[3] = this.createMenuItem("vconsole.showhelpsearch");
        this.helpItems[4] = this.createMenuItem("vconsole.showhelpabout");
    }

    protected void createDefaultMenuBar() {
        this.menuSet = new JMenu[6];
        this.menuSet[VMenuBar.CONSOLEINDEX] = this.createGenericMenu();
        this.createDefaultConsoleMenu();
        this.menuSet[VMenuBar.EDITINDEX] = this.createGenericMenu();
        this.createDefaultEditMenu();
        this.menuSet[VMenuBar.ACTIONINDEX] = this.createGenericMenu();
        this.createDefaultActionMenu();
        this.menuSet[VMenuBar.VIEWINDEX] = this.createGenericMenu();
        this.createDefaultViewMenu();
        this.menuSet[VMenuBar.GOINDEX] = this.createGenericMenu();
        this.createDefaultGoMenu();
        this.menuSet[VMenuBar.HELPINDEX] = this.createGenericMenu();
        this.createDefaultHelpMenu();
        this.installStrings();
        this.add(this.menuSet[CONSOLEINDEX]);
        this.add(this.menuSet[EDITINDEX]);
        this.add(this.menuSet[ACTIONINDEX]);
        this.add(this.menuSet[VIEWINDEX]);
        this.add(this.menuSet[GOINDEX]);
        this.add(this.menuSet[HELPINDEX]);
    }

    protected void createDefaultShowMenu() {
        this.viewItems[0] = this.createGenericMenu();
        this.showItems = new JMenuItem[5];
        this.showItems[0] = this.createCheckBoxMenuItem("vconsole.toolpane");
        this.showItems[0].removeActionListener(this.menuListener);
        this.showItems[0].addActionListener(this.toggleListener);
        this.showItems[1] = this.createCheckBoxMenuItem("vconsole.locationpane");
        this.showItems[1].removeActionListener(this.menuListener);
        this.showItems[1].addActionListener(this.toggleListener);
        this.showItems[2] = this.createCheckBoxMenuItem("vconsole.statuspane");
        this.showItems[2].removeActionListener(this.menuListener);
        this.showItems[2].addActionListener(this.toggleListener);
        this.showItems[3] = this.createCheckBoxMenuItem("vconsole.scopepane");
        this.showItems[3].removeActionListener(this.menuListener);
        this.showItems[3].addActionListener(this.toggleListener);
        this.showItems[4] = this.createCheckBoxMenuItem("vconsole.infopane");
        this.showItems[4].removeActionListener(this.menuListener);
        this.showItems[4].addActionListener(this.toggleListener);
    }

    protected void createDefaultSortByMenu() {
        this.viewItems[3] = this.createGenericMenu();
        this.sortByItems = new JMenuItem[3];
        this.sortByItems[0] = this.createRadioButtonMenuItem("0");
        this.sortByItems[0].setActionCommand("0");
        this.sortByItems[0].addActionListener(this.sortListener);
        this.sortByItems[1] = this.createRadioButtonMenuItem("1");
        this.sortByItems[1].setActionCommand("1");
        this.sortByItems[1].addActionListener(this.sortListener);
        this.sortByItems[2] = this.createCheckBoxMenuItem("");
        this.sortByItems[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VMenuBar.this.notifyOfSortOrder();
            }
        });
    }

    protected void createDefaultViewAsMenu() {
        this.viewItems[1] = this.createGenericMenu();
        this.viewAsItems = new JMenuItem[5];
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        jRadioButtonMenuItem = this.createRadioButtonMenuItem("large");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        this.viewAsItems[0] = jRadioButtonMenuItem;
        this.viewAsItems[0].removeActionListener(this.menuListener);
        this.viewAsItems[0].addActionListener(this.iconListener);
        jRadioButtonMenuItem = this.createRadioButtonMenuItem("small");
        buttonGroup.add(jRadioButtonMenuItem);
        this.viewAsItems[1] = jRadioButtonMenuItem;
        this.viewAsItems[1].removeActionListener(this.menuListener);
        this.viewAsItems[1].addActionListener(this.iconListener);
        jRadioButtonMenuItem = this.createRadioButtonMenuItem("list");
        buttonGroup.add(jRadioButtonMenuItem);
        this.viewAsItems[2] = jRadioButtonMenuItem;
        this.viewAsItems[2].removeActionListener(this.menuListener);
        this.viewAsItems[2].addActionListener(this.iconListener);
        jRadioButtonMenuItem = this.createRadioButtonMenuItem("details");
        buttonGroup.add(jRadioButtonMenuItem);
        this.viewAsItems[3] = jRadioButtonMenuItem;
        this.viewAsItems[3].removeActionListener(this.menuListener);
        this.viewAsItems[3].addActionListener(this.iconListener);
        this.viewAsItems[4] = this.createCheckBoxMenuItem("vconsole.clickstyle");
        this.viewAsItems[4].removeActionListener(this.menuListener);
        this.viewAsItems[4].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VMenuBar.this.properties == null) {
                    return;
                }
                if (VMenuBar.this.viewAsItems[4].isSelected()) {
                    VMenuBar.this.properties.setProperty("vconsole.clickstyle", "web");
                } else {
                    VMenuBar.this.properties.setProperty("vconsole.clickstyle", "classic");
                }
            }
        });
    }

    protected void createDefaultViewMenu() {
        this.viewItems = new JMenuItem[6];
        this.createDefaultShowMenu();
        this.createDefaultViewAsMenu();
        this.createDefaultColumnsMenu();
        this.createDefaultSortByMenu();
        this.viewItems[4] = this.createMenuItem("vconsole.showfiltercontrol");
        this.viewItems[5] = this.createMenuItem("vconsole.refresh");
    }

    protected JMenu createGenericMenu() {
        JMenu jMenu = new JMenu();
        jMenu.setFont(ResourceManager.menuFont);
        jMenu.setForeground(ResourceManager.menuColor);
        return jMenu;
    }

    protected JMenuItem createGenericMenuItem() {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setFont(ResourceManager.menuFont);
        jMenuItem.setForeground(ResourceManager.menuColor);
        jMenuItem.addActionListener(this.menuListener);
        return jMenuItem;
    }

    protected JMenuItem createMenuItem(String string) {
        if (string == null) {
            return null;
        }
        JMenuItem jMenuItem = this.createGenericMenuItem();
        jMenuItem.setActionCommand(string);
        return jMenuItem;
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(String string) {
        if (string == null) {
            return null;
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        jRadioButtonMenuItem.setFont(ResourceManager.menuFont);
        jRadioButtonMenuItem.setForeground(ResourceManager.menuColor);
        jRadioButtonMenuItem.setActionCommand(string);
        return jRadioButtonMenuItem;
    }

    public void initListeners() {
        this.columnListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (!(object instanceof JCheckBoxMenuItem)) {
                    return;
                }
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
                VMenuBar.this.toggleColumnVisibility(jCheckBoxMenuItem.getActionCommand(), jCheckBoxMenuItem.isSelected());
            }
        };
        this.sortListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (!(object instanceof JRadioButtonMenuItem)) {
                    return;
                }
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)object;
                VMenuBar.this.notifyOfSortedColumn(jRadioButtonMenuItem.getActionCommand());
            }
        };
        this.menuListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object != null && object instanceof JMenuItem) {
                    String string = ((JMenuItem)object).getActionCommand();
                    VConsoleEvent vConsoleEvent = new VConsoleEvent(VMenuBar.this, string, null);
                    VMenuBar.this.notifyListeners(vConsoleEvent);
                }
            }
        };
        this.toggleListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object != null && object instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)object;
                    String string = "false";
                    if (jMenuItem.isSelected()) {
                        string = "true";
                    }
                    if (VMenuBar.this.properties == null) {
                        return;
                    }
                    VMenuBar.this.properties.setProperty(jMenuItem.getActionCommand(), string);
                }
            }
        };
        this.iconListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object != null && object instanceof JMenuItem) {
                    if (VMenuBar.this.properties == null) {
                        return;
                    }
                    JMenuItem jMenuItem = (JMenuItem)object;
                    VMenuBar.this.properties.setProperty("vconsole.iconstyle", jMenuItem.getActionCommand());
                }
            }
        };
    }

    protected void installActionMenuStrings() {
        this.actionItems[0].setText(ResourceManager.getString("Open"));
        this.actionItems[0].setMnemonic(ResourceManager.getString("Open_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.actionItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Open_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Open_access_desc"));
        this.actionItems[1].setText(ResourceManager.getString("Properties"));
        this.actionItems[1].setMnemonic(ResourceManager.getString("Properties_mnemonic").charAt(0));
        this.actionItems[1].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Properties_accel")));
        accessibleContext = this.actionItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Properties_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Properties_access_desc"));
    }

    protected void installColumnsMenuStrings() {
        this.viewItems[2].setText(ResourceManager.getString("Columns"));
        this.viewItems[2].setMnemonic(ResourceManager.getString("Columns_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.viewItems[2].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Columns_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Columns_access_desc"));
        this.columnsItems[0].setText(ResourceManager.getString("Sort_by_Menu Name"));
        accessibleContext = this.columnsItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Sort_by_Menu Name_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Sort_by_Menu Name_access_desc"));
        this.columnsItems[1].setText(ResourceManager.getString("Sort_by_Menu Description"));
        accessibleContext = this.columnsItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Sort_by_Menu Description_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Sort_by_Menu Description_access_desc"));
    }

    protected void installConsoleMenuStrings() {
        this.consoleItems[0].setText(ResourceManager.getString("New"));
        this.consoleItems[0].setMnemonic(ResourceManager.getString("New_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.consoleItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("New_access_name"));
        this.consoleItems[0].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("New_accel")));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("New_access_desc"));
        this.consoleItems[1].setText(ResourceManager.getString("Open Toolbox"));
        this.consoleItems[1].setMnemonic(ResourceManager.getString("Open Toolbox_mnemonic").charAt(0));
        accessibleContext = this.consoleItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Open Toolbox_access_name"));
        this.consoleItems[1].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Open Toolbox_accel")));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Open Toolbox_access_desc"));
        this.consoleItems[2].setText(ResourceManager.getString("Save"));
        this.consoleItems[2].setMnemonic(ResourceManager.getString("Save_mnemonic").charAt(0));
        accessibleContext = this.consoleItems[2].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Save_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Save_access_desc"));
        this.consoleItems[3].setText(ResourceManager.getString("Save As..."));
        this.consoleItems[3].setMnemonic(ResourceManager.getString("Save As..._mnemonic").charAt(0));
        accessibleContext = this.consoleItems[3].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Save As..._access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Save As..._access_desc"));
        this.consoleItems[4].setText(ResourceManager.getString("Edit Toolbox..."));
        this.consoleItems[4].setMnemonic(ResourceManager.getString("Edit Toolbox..._mnemonic").charAt(0));
        accessibleContext = this.consoleItems[4].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Edit Toolbox..._access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Edit Toolbox..._access_desc"));
        this.consoleItems[5].setText(ResourceManager.getString("Preferences"));
        this.consoleItems[5].setMnemonic(ResourceManager.getString("Preferences_mnemonic").charAt(0));
        accessibleContext = this.consoleItems[5].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Preferences_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Preferences_access_desc"));
        this.consoleItems[6].setText(ResourceManager.getString("Console Log"));
        this.consoleItems[6].setMnemonic(ResourceManager.getString("Console Log_mnemonic").charAt(0));
        accessibleContext = this.consoleItems[6].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Console Log_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Console Log_access_desc"));
        this.consoleItems[7].setText(ResourceManager.getString("Print..."));
        this.consoleItems[7].setMnemonic(ResourceManager.getString("Print..._mnemonic").charAt(0));
        this.consoleItems[7].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Print..._accel")));
        accessibleContext = this.consoleItems[7].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Print..._access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Print..._access_desc"));
        this.consoleItems[8].setText(ResourceManager.getString("Close_Console"));
        this.consoleItems[8].setMnemonic(ResourceManager.getString("Close_Console_mnemonic").charAt(0));
        this.consoleItems[8].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Close_Console_accel")));
        accessibleContext = this.consoleItems[8].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Close_Console_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Close_Console_access_desc"));
        this.consoleItems[9].setText(ResourceManager.getString("Exit"));
        this.consoleItems[9].setMnemonic(ResourceManager.getString("Exit_mnemonic").charAt(0));
        this.consoleItems[9].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Exit_accel")));
        accessibleContext = this.consoleItems[9].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Exit_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Exit_access_desc"));
    }

    protected void installEditMenuStrings() {
        this.editItems[0].setText(ResourceManager.getString("Undo"));
        this.editItems[0].setMnemonic(ResourceManager.getString("Undo_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.editItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Undo_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Undo_access_desc"));
        this.editItems[1].setText(ResourceManager.getString("Redo"));
        this.editItems[1].setMnemonic(ResourceManager.getString("Redo_mnemonic").charAt(0));
        accessibleContext = this.editItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Redo_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Redo_access_desc"));
        this.editItems[2].setText(ResourceManager.getString("Cut"));
        this.editItems[2].setMnemonic(ResourceManager.getString("Cut_mnemonic").charAt(0));
        this.editItems[2].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Cut_accel")));
        accessibleContext = this.editItems[2].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Cut_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Cut_access_desc"));
        this.editItems[3].setText(ResourceManager.getString("Copy"));
        this.editItems[3].setMnemonic(ResourceManager.getString("Copy_mnemonic").charAt(0));
        this.editItems[3].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Copy_accel")));
        accessibleContext = this.editItems[3].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Copy_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Copy_access_desc"));
        this.editItems[4].setText(ResourceManager.getString("Paste"));
        this.editItems[4].setMnemonic(ResourceManager.getString("Paste_mnemonic").charAt(0));
        this.editItems[4].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Paste_accel")));
        accessibleContext = this.editItems[4].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Paste_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Paste_access_desc"));
        this.editItems[5].setText(ResourceManager.getString("Duplicate"));
        this.editItems[5].setMnemonic(ResourceManager.getString("Duplicate_mnemonic").charAt(0));
        accessibleContext = this.editItems[5].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Duplicate_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Duplicate_access_desc"));
        this.editItems[6].setText(ResourceManager.getString("Rename"));
        this.editItems[6].setMnemonic(ResourceManager.getString("Rename_mnemonic").charAt(0));
        accessibleContext = this.editItems[6].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Rename_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Rename_access_desc"));
        this.editItems[7].setText(ResourceManager.getString("Delete"));
        this.editItems[7].setMnemonic(ResourceManager.getString("Delete_mnemonic").charAt(0));
        this.editItems[7].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Delete_accel")));
        accessibleContext = this.editItems[7].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Delete_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Delete_access_desc"));
        this.editItems[8].setText(ResourceManager.getString("Select All"));
        this.editItems[8].setMnemonic(ResourceManager.getString("Select All_mnemonic").charAt(0));
        this.editItems[8].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Select All_accel")));
        accessibleContext = this.editItems[8].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Select All_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Select All_access_desc"));
    }

    protected void installGoMenuStrings() {
        this.goItems[0].setText(ResourceManager.getString("Up Level"));
        this.goItems[0].setMnemonic(ResourceManager.getString("Up Level_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.goItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Up Level_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Up Level_access_desc"));
        this.goItems[1].setText(ResourceManager.getString("Home"));
        this.goItems[1].setMnemonic(ResourceManager.getString("Home_mnemonic").charAt(0));
        accessibleContext = this.goItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Home_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Home_access_desc"));
    }

    protected void installHelpMenuStrings() {
        this.helpItems[0].setText(ResourceManager.getString("Overview"));
        this.helpItems[0].setMnemonic(ResourceManager.getString("Overview_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.helpItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Overview_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Overview_access_desc"));
        this.helpItems[1].setText(ResourceManager.getString("Contents"));
        this.helpItems[1].setMnemonic(ResourceManager.getString("Contents_mnemonic").charAt(0));
        accessibleContext = this.helpItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Contents_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Contents_access_desc"));
        this.helpItems[2].setText(ResourceManager.getString("Index"));
        this.helpItems[2].setMnemonic(ResourceManager.getString("Index_mnemonic").charAt(0));
        accessibleContext = this.helpItems[2].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Index_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Index_access_desc"));
        this.helpItems[3].setText(ResourceManager.getString("Search..."));
        this.helpItems[3].setMnemonic(ResourceManager.getString("Search..._mnemonic").charAt(0));
        accessibleContext = this.helpItems[3].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Search..._access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Search..._access_desc"));
        this.helpItems[4].setText(ResourceManager.getString("About Console"));
        this.helpItems[4].setMnemonic(ResourceManager.getString("About Console_mnemonic").charAt(0));
        accessibleContext = this.helpItems[4].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("About Console_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("About Console_acess_desc"));
    }

    protected void installShowMenuStrings() {
        this.viewItems[0].setText(ResourceManager.getString("Show"));
        this.viewItems[0].setMnemonic(ResourceManager.getString("Show_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.viewItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Show_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Show_access_desc"));
        this.showItems[0].setText(ResourceManager.getString("Tool bar"));
        accessibleContext = this.showItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Tool bar_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Tool bar_access_desc"));
        this.showItems[1].setText(ResourceManager.getString("Location bar"));
        accessibleContext = this.showItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Location bar_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Location bar_access_desc"));
        this.showItems[2].setText(ResourceManager.getString("Status bar"));
        accessibleContext = this.showItems[2].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Status bar_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Status bar_access_desc"));
        this.showItems[3].setText(ResourceManager.getString("Navigation"));
        accessibleContext = this.showItems[3].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Navigation_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Navigation_access_desc"));
        this.showItems[4].setText(ResourceManager.getString("Information"));
        accessibleContext = this.showItems[4].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Information_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Information_access_desc"));
    }

    protected void installSortByMenuStrings() {
        this.viewItems[3].setText(ResourceManager.getString("Sort by..."));
        this.viewItems[3].setMnemonic(ResourceManager.getString("Sort by..._mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.viewItems[3].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Sort by..._access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Sort by..._access_desc"));
        this.sortByItems[0].setText(ResourceManager.getString("Sort_by_Menu Name"));
        accessibleContext = this.sortByItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Sort_by_Menu Name_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Sort_by_Menu Name_access_desc"));
        this.sortByItems[1].setText(ResourceManager.getString("Sort_by_Menu Description"));
        accessibleContext = this.sortByItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Sort_by_Menu Description_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Sort_by_Menu Description_access_desc"));
        this.sortByItems[2].setText(ResourceManager.getString("Sort_by_Menu Descending"));
        accessibleContext = this.sortByItems[2].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Sort_by_Menu Descending_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Sort_by_Menu Descending_access_desc"));
    }

    protected void installStrings() {
        try {
            this.menuSet[CONSOLEINDEX].setText(ResourceManager.getString("Console"));
            this.menuSet[CONSOLEINDEX].setMnemonic(ResourceManager.getString("Console_mnemonic").charAt(0));
            AccessibleContext accessibleContext = this.menuSet[CONSOLEINDEX].getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("Console_access_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("Console_access_desc"));
            this.installConsoleMenuStrings();
            this.menuSet[EDITINDEX].setText(ResourceManager.getString("Edit"));
            this.menuSet[EDITINDEX].setMnemonic(ResourceManager.getString("Edit_mnemonic").charAt(0));
            accessibleContext = this.menuSet[EDITINDEX].getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("Edit_access_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("Edit_access_desc"));
            this.installEditMenuStrings();
            this.menuSet[ACTIONINDEX].setText(ResourceManager.getString("Action"));
            this.menuSet[ACTIONINDEX].setMnemonic(ResourceManager.getString("Action_mnemonic").charAt(0));
            accessibleContext = this.menuSet[ACTIONINDEX].getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("Action_access_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("Action_access_desc"));
            this.installActionMenuStrings();
            this.menuSet[VIEWINDEX].setText(ResourceManager.getString("View"));
            this.menuSet[VIEWINDEX].setMnemonic(ResourceManager.getString("View_mnemonic").charAt(0));
            accessibleContext = this.menuSet[VIEWINDEX].getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("View_access_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("View_access_desc"));
            this.installViewMenuStrings();
            this.menuSet[GOINDEX].setText(ResourceManager.getString("Go"));
            this.menuSet[GOINDEX].setMnemonic(ResourceManager.getString("Go_mnemonic").charAt(0));
            accessibleContext = this.menuSet[GOINDEX].getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("Go_access_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("Go_access_desc"));
            this.installGoMenuStrings();
            this.menuSet[HELPINDEX].setText(ResourceManager.getString("Help"));
            this.menuSet[HELPINDEX].setMnemonic(ResourceManager.getString("Help_mnemonic").charAt(0));
            accessibleContext = this.menuSet[HELPINDEX].getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("Help_access_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("Help_access_desc"));
            this.installHelpMenuStrings();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void installViewAsMenuStrings() {
        this.viewItems[1].setText(ResourceManager.getString("View As"));
        this.viewItems[1].setMnemonic(ResourceManager.getString("View As_mnemonic").charAt(0));
        AccessibleContext accessibleContext = this.viewItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("View As_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("View As_access_desc"));
        this.viewAsItems[0].setText(ResourceManager.getString("Large"));
        accessibleContext = this.viewAsItems[0].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Large_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Large_access_desc"));
        this.viewAsItems[1].setText(ResourceManager.getString("Small"));
        accessibleContext = this.viewAsItems[1].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Small_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Small_access_desc"));
        this.viewAsItems[2].setText(ResourceManager.getString("List"));
        accessibleContext = this.viewAsItems[2].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("List_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("List_access_desc"));
        this.viewAsItems[3].setText(ResourceManager.getString("Details"));
        accessibleContext = this.viewAsItems[3].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Details_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Details_access_desc"));
        this.viewAsItems[4].setText(ResourceManager.getString("Web Style"));
        accessibleContext = this.viewAsItems[4].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Web Style_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Web Style_access_desc"));
    }

    protected void installViewMenuStrings() {
        this.viewItems[4].setText(ResourceManager.getString("Filter..."));
        this.viewItems[4].setMnemonic(ResourceManager.getString("Filter_mnemonic").charAt(0));
        this.viewItems[4].setAccelerator(ConsoleUtility.getKeyStroke(ResourceManager.getString("Filter_accel")));
        AccessibleContext accessibleContext = this.viewItems[4].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Filter_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Filter_access_desc"));
        this.viewItems[5].setText(ResourceManager.getString("Refresh"));
        this.viewItems[5].setMnemonic(ResourceManager.getString("Refresh_mnemonic").charAt(0));
        accessibleContext = this.viewItems[5].getAccessibleContext();
        accessibleContext.setAccessibleName(ResourceManager.getString("Refresh_access_name"));
        accessibleContext.setAccessibleDescription(ResourceManager.getString("Refresh_access_desc"));
        this.installShowMenuStrings();
        this.installViewAsMenuStrings();
        this.installColumnsMenuStrings();
        this.installSortByMenuStrings();
    }

    protected void mergeMenus() {
        this.toolMenuSet = null;
        this.toolConsoleItems = null;
        this.toolActionItems = null;
        this.toolViewItems = null;
        this.toolShowItems = null;
        this.toolViewAsItems = null;
        this.toolGoItems = null;
        this.toolHelpItems = null;
        if (this.toolMenuBar == null) {
            return;
        }
        try {
            this.updateFontAndColor(ResourceManager.menuFont, ResourceManager.menuColor, this.toolMenuBar.getSubElements());
            this.toolMenuSet = new JMenu[this.toolMenuBar.getMenuCount()];
            int n = 0;
            while (n < this.toolMenuSet.length) {
                this.toolMenuSet[n] = this.toolMenuBar.getMenu(n);
                String string = this.toolMenuSet[n].getActionCommand();
                if (string.equals("VMenuID.CONSOLE")) {
                    this.toolConsoleItems = this.toolMenuSet[n].getMenuComponents();
                } else if (string.equals("VMenuID.ACTION")) {
                    this.toolActionItems = this.toolMenuSet[n].getMenuComponents();
                } else if (string.equals("VMenuID.VIEW")) {
                    this.toolViewItems = this.toolMenuSet[n].getMenuComponents();
                } else if (string.equals("VMenuID.SHOW")) {
                    this.toolShowItems = this.toolMenuSet[n].getMenuComponents();
                } else if (string.equals("VMenuID.VIEWAS")) {
                    this.toolViewAsItems = this.toolMenuSet[n].getMenuComponents();
                } else if (string.equals("VMenuID.GO")) {
                    this.toolGoItems = this.toolMenuSet[n].getMenuComponents();
                } else if (string.equals("VMenuID.HELP")) {
                    this.toolHelpItems = this.toolMenuSet[n].getMenuComponents();
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem merging new menus", throwable);
        }
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        if (vConsoleEvent.getID().equals("OPEN_FOLDER")) {
            vConsoleEvent.setPayload(this.nodeToOpen);
            vConsoleEvent.setID("vconsole.scopeselected");
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    protected void notifyOfSortOrder() {
        if (this.sortedColumn == null) {
            return;
        }
        try {
            String string = this.sortedColumn;
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            Integer[] integerArray = new Integer[]{new Integer(string)};
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.sortup", integerArray);
            if (this.sortByItems[2].isSelected()) {
                vConsoleEvent.setID("vconsole.sortdown");
            }
            this.notifyListeners(vConsoleEvent);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem setting sort order", throwable);
        }
    }

    protected void notifyOfSortedColumn(String string) {
        if (string == null) {
            return;
        }
        try {
            Integer[] integerArray = new Integer[]{new Integer(string)};
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.sortup", integerArray);
            if (this.sortByItems[2].isSelected()) {
                vConsoleEvent.setID("vconsole.sortdown");
            }
            if (this.sortedColumn != null) {
                String string2 = this.sortedColumn;
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                }
                if (string2.equals(string)) {
                    vConsoleEvent.setPayload(null);
                }
            }
            this.notifyListeners(vConsoleEvent);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem setting sorted column", throwable);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        String string2 = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof String) {
            string2 = (String)object;
        }
        if (string.equals("vconsole.currentselection")) {
            this.actionItems[0].setEnabled(false);
            if (string2.equals("vconsole.resultpane") && this.nodeToOpen != null) {
                this.actionItems[0].setEnabled(true);
            }
            this.syncActionMenu();
        } else if (string.equals("vconsole.scopepane")) {
            this.toggleScopePane(string2);
        } else if (string.equals("vconsole.infopane")) {
            this.toggleInfoPane(string2);
        } else if (string.equals("vconsole.iconstyle")) {
            this.setIconStyle(string2);
        } else if (string.equals("vconsole.clickstyle")) {
            this.setClickStyle(string2);
        } else if (string.equals("vconsole.upscopeenabled")) {
            this.setUpScopeEnabled(string2);
        } else if (string.equals("vconsole.propertiesenabled")) {
            this.setPropertiesEnabled(string2);
        } else if (string.equals("vconsole.iconviewsenabled")) {
            this.setIconViewsEnabled(string2);
        } else if (string.equals("vconsole.menufont") || string.equals("vconsole.menucolor")) {
            try {
                this.updateFontAndColor(ResourceManager.menuFont, ResourceManager.menuColor, this.getSubElements());
            }
            catch (Throwable throwable) {}
        } else if (string.equals("vconsole.deleteenabled")) {
            this.setDeleteEnabled(string2);
        } else if (string.equals("vconsole.toolpane")) {
            this.toggleToolPane(string2);
        } else if (string.equals("vconsole.locationpane")) {
            this.toggleLocationPane(string2);
        } else if (string.equals("vconsole.statuspane")) {
            this.toggleStatusPane(string2);
        } else if (!string.equals("vconsole.findenabled")) {
            if (string.equals("vconsole.filterenabled")) {
                this.setFilterEnabled(string2);
            } else if (string.equals("vconsole.selectallenabled")) {
                this.setSelectAllEnabled(string2);
            } else if (string.equals("vconsole.newconsoleenabled")) {
                this.setNewConsoleEnabled(string2);
            } else if (string.equals("vconsole.openconsoleenabled")) {
                this.setOpenConsoleEnabled(string2);
            } else if (string.equals("vconsole.saveconsoleenabled")) {
                this.setSaveConsoleEnabled(string2);
            } else if (string.equals("vconsole.saveconsoleasenabled")) {
                this.setSaveConsoleAsEnabled(string2);
            } else if (string.equals("vconsole.modifyconfigenabled")) {
                this.setModifyConfigEnabled(string2);
            } else if (string.equals("vconsole.printenabled")) {
                this.setPrintEnabled(string2);
            } else if (string.equals("vconsole.undoenabled")) {
                this.setUndoEnabled(string2);
            } else if (string.equals("vconsole.redoenabled")) {
                this.setRedoEnabled(string2);
            } else if (string.equals("vconsole.cutenabled")) {
                this.setCutEnabled(string2);
            } else if (string.equals("vconsole.copyenabled")) {
                this.setCopyEnabled(string2);
            } else if (string.equals("vconsole.pasteenabled")) {
                this.setPasteEnabled(string2);
            } else if (string.equals("vconsole.deleteenabled")) {
                this.setDeleteEnabled(string2);
            } else if (string.equals("vconsole.renameenabled")) {
                this.setRenameEnabled(string2);
            } else if (string.equals("vconsole.duplicateenabled")) {
                this.setDuplicateEnabled(string2);
            } else if (string.equals("vconsole.sortedcolumn")) {
                this.setSortedColumn(string2);
            } else if (string.equals("vconsole.defaultcolumnheader")) {
                try {
                    this.sortByNameText = string2;
                    this.sortByItems[0].setText(this.sortByNameText);
                }
                catch (Throwable throwable) {}
            } else if (string.equals("vconsole.hometoolbox")) {
                this.setHomeEnabled(string2);
            }
        }
    }

    protected void resetMenus() {
        if (this.toolMenuBar == null || this.toolMenuSet == null) {
            return;
        }
        try {
            this.resetToolConsoleMenu();
            this.resetToolActionMenu();
            this.resetToolViewMenu();
            this.resetToolShowMenu();
            this.resetToolViewAsMenu();
            this.resetToolGoMenu();
            this.resetToolHelpMenu();
            int n = 0;
            while (n < this.toolMenuSet.length) {
                this.toolMenuBar.add(this.toolMenuSet[n]);
                ++n;
            }
            this.toolMenuSet = null;
            this.toolMenuBar = null;
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem resetting menus", throwable);
        }
    }

    protected void resetToolActionMenu() {
        if (this.toolActionItems != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.toolMenuSet.length) {
                if (this.toolMenuSet[n2].getActionCommand().equals("VMenuID.ACTION")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < this.toolActionItems.length) {
                this.toolMenuSet[n].add(this.toolActionItems[n3]);
                ++n3;
            }
            this.toolActionItems = null;
        }
    }

    protected void resetToolConsoleMenu() {
        if (this.toolConsoleItems != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.toolMenuSet.length) {
                if (this.toolMenuSet[n2].getActionCommand().equals("VMenuID.CONSOLE")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < this.toolConsoleItems.length) {
                this.toolMenuSet[n].add(this.toolConsoleItems[n3]);
                ++n3;
            }
            this.toolConsoleItems = null;
        }
    }

    protected void resetToolGoMenu() {
        if (this.toolGoItems != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.toolMenuSet.length) {
                if (this.toolMenuSet[n2].getActionCommand().equals("VMenuID.GO")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < this.toolGoItems.length) {
                this.toolMenuSet[n].add(this.toolGoItems[n3]);
                ++n3;
            }
            this.toolGoItems = null;
        }
    }

    protected void resetToolHelpMenu() {
        if (this.toolHelpItems != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.toolMenuSet.length) {
                if (this.toolMenuSet[n2].getActionCommand().equals("VMenuID.HELP")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < this.toolHelpItems.length) {
                this.toolMenuSet[n].add(this.toolHelpItems[n3]);
                ++n3;
            }
            this.toolHelpItems = null;
        }
    }

    protected void resetToolShowMenu() {
        if (this.toolShowItems != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.toolMenuSet.length) {
                if (this.toolMenuSet[n2].getActionCommand().equals("VMenuID.SHOW")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < this.toolShowItems.length) {
                this.toolMenuSet[n].add(this.toolShowItems[n3]);
                ++n3;
            }
            this.toolShowItems = null;
        }
    }

    protected void resetToolViewAsMenu() {
        if (this.toolViewAsItems != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.toolMenuSet.length) {
                if (this.toolMenuSet[n2].getActionCommand().equals("VMenuID.VIEWAS")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < this.toolViewAsItems.length) {
                this.toolMenuSet[n].add(this.toolViewAsItems[n3]);
                ++n3;
            }
            this.toolViewAsItems = null;
        }
    }

    protected void resetToolViewMenu() {
        if (this.toolViewItems != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.toolMenuSet.length) {
                if (this.toolMenuSet[n2].getActionCommand().equals("VMenuID.VIEW")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                return;
            }
            int n3 = 0;
            while (n3 < this.toolViewItems.length) {
                this.toolMenuSet[n].add(this.toolViewItems[n3]);
                ++n3;
            }
            this.toolViewItems = null;
        }
    }

    protected void setClickStyle(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("classic")) {
            this.setItemSelected(this.viewAsItems[4], "false");
        } else {
            this.setItemSelected(this.viewAsItems[4], "true");
        }
    }

    protected void setCopyEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[3].isEnabled() ^ true : this.editItems[3].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[3], string);
            this.syncEditMenu();
        }
    }

    protected void setCutEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[2].isEnabled() ^ true : this.editItems[2].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[2], string);
            this.syncEditMenu();
        }
    }

    protected void setDeleteEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[7].isEnabled() ^ true : this.editItems[7].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[7], string);
            this.syncEditMenu();
        }
    }

    protected void setDuplicateEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[5].isEnabled() ^ true : this.editItems[5].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[5], string);
            this.syncEditMenu();
        }
    }

    protected void setFilterEnabled(String string) {
        this.setItemEnabled(this.viewItems[4], string);
    }

    protected void setHomeEnabled(String string) {
        string = string == null ? "false" : (string.trim().length() == 0 ? "false" : "true");
        this.setItemEnabled(this.goItems[1], string);
    }

    protected void setIconStyle(String string) {
        if (string == null) {
            return;
        }
        this.detailsMode = false;
        if (string.equals("large")) {
            this.viewAsItems[0].setSelected(true);
        } else if (string.equals("small")) {
            this.viewAsItems[1].setSelected(true);
        } else if (string.equals("list")) {
            this.viewAsItems[2].setSelected(true);
        } else {
            this.viewAsItems[3].setSelected(true);
            this.detailsMode = true;
        }
    }

    protected void setIconViewsEnabled(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("true") || string.equals("false")) {
            boolean bl = string.equals("true");
            int n = 0;
            while (n < 4) {
                this.viewAsItems[n].setEnabled(bl);
                ++n;
            }
        } else {
            this.viewAsItems[0].setEnabled(string.indexOf("large") != -1);
            this.viewAsItems[1].setEnabled(string.indexOf("small") != -1);
            this.viewAsItems[2].setEnabled(string.indexOf("list") != -1);
            this.viewAsItems[3].setEnabled(string.indexOf("details") != -1);
        }
    }

    protected void setItemEnabled(JMenuItem jMenuItem, String string) {
        if (jMenuItem == null || string == null) {
            return;
        }
        jMenuItem.setEnabled(string.equals("true"));
    }

    protected void setItemSelected(JMenuItem jMenuItem, String string) {
        if (jMenuItem == null || string == null) {
            return;
        }
        jMenuItem.setSelected(string.equals("true"));
    }

    protected void setMenus(VScopeNode vScopeNode) {
        boolean bl = false;
        if (this.toolMenuBar != null) {
            this.resetMenus();
            bl = true;
        }
        if (vScopeNode != null) {
            this.toolMenuBar = vScopeNode.getMenuBar();
        }
        if (this.toolMenuBar != null) {
            this.mergeMenus();
            bl = true;
        }
        if (bl) {
            this.syncMenuBar();
        }
    }

    protected void setModifyConfigEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.consoleItems[4].isEnabled() ^ true : this.consoleItems[4].isEnabled();
        if (bl) {
            this.setItemEnabled(this.consoleItems[4], string);
            this.syncConsoleMenu();
        }
    }

    protected void setNewConsoleEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.consoleItems[0].isEnabled() ^ true : this.consoleItems[0].isEnabled();
        if (bl) {
            this.setItemEnabled(this.consoleItems[0], string);
            this.syncConsoleMenu();
        }
    }

    protected void setOpenConsoleEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.consoleItems[1].isEnabled() ^ true : this.consoleItems[1].isEnabled();
        if (bl) {
            this.setItemEnabled(this.consoleItems[1], string);
            this.syncConsoleMenu();
        }
    }

    protected void setPasteEnabled(String string) {
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[4].isEnabled() ^ true : this.editItems[4].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[4], string);
            this.syncEditMenu();
        }
    }

    protected void setPrintEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.consoleItems[7].isEnabled() ^ true : this.consoleItems[7].isEnabled();
        if (bl) {
            this.setItemEnabled(this.consoleItems[7], string);
            this.syncConsoleMenu();
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
            this.createDefaultMenuBar();
            this.syncProperties();
            this.syncMenuBar();
        }
    }

    protected void setPropertiesEnabled(String string) {
        this.setItemEnabled(this.actionItems[1], string);
    }

    protected void setRedoEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[1].isEnabled() ^ true : this.editItems[1].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[1], string);
            this.syncEditMenu();
        }
    }

    protected void setRenameEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[6].isEnabled() ^ true : this.editItems[6].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[6], string);
            this.syncEditMenu();
        }
    }

    protected void setSaveConsoleAsEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.consoleItems[3].isEnabled() ^ true : this.consoleItems[3].isEnabled();
        if (bl) {
            this.setItemEnabled(this.consoleItems[3], string);
            this.syncConsoleMenu();
        }
    }

    protected void setSaveConsoleEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.consoleItems[2].isEnabled() ^ true : this.consoleItems[2].isEnabled();
        if (bl) {
            this.setItemEnabled(this.consoleItems[2], string);
            this.syncConsoleMenu();
        }
    }

    protected void setSelectAllEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[8].isEnabled() ^ true : this.editItems[8].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[8], string);
            this.syncEditMenu();
        }
    }

    protected void setSortedColumn(String string) {
        this.notifyOfSort = false;
        try {
            this.sortedColumn = string;
            if (this.sortedColumn.startsWith("+")) {
                this.sortedColumn = this.sortedColumn.substring(1);
            }
            this.syncSortByMenu();
        }
        catch (Throwable throwable) {}
        this.notifyOfSort = true;
    }

    protected void setUndoEnabled(String string) {
        if (string == null) {
            return;
        }
        boolean bl = true;
        bl = string.equals("true") ? this.editItems[0].isEnabled() ^ true : this.editItems[0].isEnabled();
        if (bl) {
            this.setItemEnabled(this.editItems[0], string);
            this.syncEditMenu();
        }
    }

    protected void setUpScopeEnabled(String string) {
        this.setItemEnabled(this.goItems[0], string);
    }

    protected void syncActionMenu() {
        try {
            this.menuSet[ACTIONINDEX].removeAll();
            if (this.actionItems[0].isEnabled()) {
                this.menuSet[ACTIONINDEX].add(this.actionItems[0]);
                this.menuSet[ACTIONINDEX].addSeparator();
            }
            if (this.toolActionItems != null) {
                int n = 0;
                while (n < this.toolActionItems.length) {
                    this.menuSet[ACTIONINDEX].add(this.toolActionItems[n]);
                    ++n;
                }
                this.menuSet[ACTIONINDEX].addSeparator();
            }
            this.menuSet[ACTIONINDEX].add(this.actionItems[1]);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing action menu", throwable);
        }
    }

    protected void syncColumnsMenu() {
        block12: {
            try {
                this.viewItems[2].removeAll();
                if (!this.detailsMode) {
                    return;
                }
                String[][] stringArray = null;
                if (this.selNode != null) {
                    stringArray = this.selNode.getColumnHeaders();
                    VScopeNode vScopeNode = this.selNode.getInternalRoot();
                    if (vScopeNode != null) {
                        stringArray = vScopeNode.getColumnHeaders();
                    }
                }
                if (stringArray == null) {
                    int n = 0;
                    while (n < this.columnsItems.length) {
                        this.viewItems[2].add(this.columnsItems[n]);
                        ++n;
                    }
                    break block12;
                }
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = this.createCheckBoxMenuItem(String.valueOf(n2));
                    jCheckBoxMenuItem.setText(stringArray[n2][0]);
                    String string = stringArray[n2][1];
                    if (string != null) {
                        try {
                            int n3 = Integer.parseInt(string);
                            if (n3 > 0) {
                                jCheckBoxMenuItem.setSelected(true);
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    jCheckBoxMenuItem.addActionListener(this.columnListener);
                    this.viewItems[2].add(jCheckBoxMenuItem);
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing columns menu", throwable);
            }
        }
    }

    protected void syncConsoleMenu() {
        try {
            this.menuSet[CONSOLEINDEX].removeAll();
            this.menuSet[CONSOLEINDEX].add(this.consoleItems[0]);
            this.menuSet[CONSOLEINDEX].add(this.consoleItems[1]);
            if (this.consoleItems[2].isEnabled()) {
                this.menuSet[CONSOLEINDEX].add(this.consoleItems[2]);
            }
            if (this.consoleItems[3].isEnabled()) {
                this.menuSet[CONSOLEINDEX].add(this.consoleItems[3]);
            }
            this.menuSet[CONSOLEINDEX].addSeparator();
            if (this.consoleItems[4].isEnabled()) {
                this.menuSet[CONSOLEINDEX].add(this.consoleItems[4]);
            }
            this.menuSet[CONSOLEINDEX].add(this.consoleItems[5]);
            this.menuSet[CONSOLEINDEX].add(this.consoleItems[6]);
            this.menuSet[CONSOLEINDEX].addSeparator();
            if (this.toolConsoleItems != null) {
                int n = 0;
                while (n < this.toolConsoleItems.length) {
                    this.menuSet[CONSOLEINDEX].add(this.toolConsoleItems[n]);
                    ++n;
                }
            }
            if (this.consoleItems[7].isEnabled()) {
                this.menuSet[CONSOLEINDEX].add(this.consoleItems[7]);
                this.menuSet[CONSOLEINDEX].addSeparator();
            } else if (this.toolConsoleItems != null) {
                this.menuSet[CONSOLEINDEX].addSeparator();
            }
            this.menuSet[CONSOLEINDEX].add(this.consoleItems[8]);
            this.menuSet[CONSOLEINDEX].add(this.consoleItems[9]);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing console menu", throwable);
        }
    }

    protected void syncEditMenu() {
        try {
            this.menuSet[EDITINDEX].removeAll();
            boolean bl = false;
            if (this.editItems[0].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[0]);
                bl = true;
            }
            if (this.editItems[1].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[1]);
                bl = true;
            }
            if (bl) {
                this.menuSet[EDITINDEX].addSeparator();
                bl = false;
            }
            if (this.editItems[2].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[2]);
                bl = true;
            }
            if (this.editItems[3].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[3]);
                bl = true;
            }
            if (this.editItems[4].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[4]);
                bl = true;
            }
            if (this.editItems[5].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[5]);
                bl = true;
            }
            if (this.editItems[6].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[6]);
                bl = true;
            }
            if (this.editItems[7].isEnabled()) {
                this.menuSet[EDITINDEX].add(this.editItems[7]);
                bl = true;
            }
            if (bl) {
                this.menuSet[EDITINDEX].addSeparator();
                bl = false;
            }
            this.menuSet[EDITINDEX].add(this.editItems[8]);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing edit menu", throwable);
        }
    }

    protected void syncGoMenu() {
        try {
            this.menuSet[GOINDEX].removeAll();
            this.menuSet[GOINDEX].add(this.goItems[0]);
            this.menuSet[GOINDEX].addSeparator();
            if (this.toolGoItems != null) {
                int n = 0;
                while (n < this.toolGoItems.length) {
                    this.menuSet[GOINDEX].add(this.toolGoItems[n]);
                    ++n;
                }
                this.menuSet[GOINDEX].addSeparator();
            }
            this.menuSet[GOINDEX].add(this.goItems[1]);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing go menu", throwable);
        }
    }

    protected void syncHelpMenu() {
        try {
            this.menuSet[HELPINDEX].removeAll();
            this.menuSet[HELPINDEX].add(this.helpItems[0]);
            this.menuSet[HELPINDEX].add(this.helpItems[1]);
            this.menuSet[HELPINDEX].add(this.helpItems[2]);
            this.menuSet[HELPINDEX].add(this.helpItems[3]);
            this.menuSet[HELPINDEX].addSeparator();
            if (this.toolHelpItems != null) {
                int n = 0;
                while (n < this.toolHelpItems.length) {
                    this.menuSet[HELPINDEX].add(this.toolHelpItems[n]);
                    ++n;
                }
                this.menuSet[HELPINDEX].addSeparator();
            }
            this.menuSet[HELPINDEX].add(this.helpItems[4]);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing help menu", throwable);
        }
    }

    protected void syncMenuBar() {
        try {
            this.syncConsoleMenu();
            this.syncActionMenu();
            this.syncViewMenu();
            this.syncGoMenu();
            this.syncHelpMenu();
            if (this.toolMenuSet != null) {
                this.removeAll();
                this.add(this.menuSet[CONSOLEINDEX]);
                this.add(this.menuSet[EDITINDEX]);
                this.add(this.menuSet[ACTIONINDEX]);
                this.add(this.menuSet[VIEWINDEX]);
                this.add(this.menuSet[GOINDEX]);
                int n = 0;
                while (n < this.toolMenuSet.length) {
                    JMenu jMenu = this.toolMenuSet[n];
                    if (jMenu.getItemCount() > 0) {
                        this.add(jMenu);
                    }
                    ++n;
                }
                this.add(this.menuSet[HELPINDEX]);
            }
            this.invalidate();
            Container container = this.getParent();
            ((Component)container).doLayout();
            ((Component)container).validate();
            container.repaint();
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing menu bar", throwable);
        }
    }

    protected void syncProperties() {
        if (this.properties == null) {
            return;
        }
        this.setModifyConfigEnabled(this.properties.getProperty("vconsole.modifyconfigenabled"));
        this.setSaveConsoleEnabled(this.properties.getProperty("vconsole.saveconsoleenabled"));
        this.setSaveConsoleAsEnabled(this.properties.getProperty("vconsole.saveconsoleasenabled"));
        this.setNewConsoleEnabled(this.properties.getProperty("vconsole.newconsoleenabled"));
        this.setOpenConsoleEnabled(this.properties.getProperty("vconsole.openconsoleenabled"));
        this.toggleScopePane(this.properties.getProperty("vconsole.scopepane"));
        this.toggleInfoPane(this.properties.getProperty("vconsole.infopane"));
        this.setIconStyle(this.properties.getProperty("vconsole.iconstyle"));
        this.setClickStyle(this.properties.getProperty("vconsole.clickstyle"));
        this.setPrintEnabled(this.properties.getProperty("vconsole.printenabled"));
        this.setDeleteEnabled(this.properties.getProperty("vconsole.deleteenabled"));
        this.setRenameEnabled(this.properties.getProperty("vconsole.renameenabled"));
        this.setDuplicateEnabled(this.properties.getProperty("vconsole.duplicateenabled"));
        this.setPasteEnabled(this.properties.getProperty("vconsole.pasteenabled"));
        this.setCopyEnabled(this.properties.getProperty("vconsole.copyenabled"));
        this.setCutEnabled(this.properties.getProperty("vconsole.cutenabled"));
        this.setRedoEnabled(this.properties.getProperty("vconsole.redoenabled"));
        this.setUndoEnabled(this.properties.getProperty("vconsole.undoenabled"));
        this.setFilterEnabled(this.properties.getProperty("vconsole.filterenabled"));
        this.setSelectAllEnabled(this.properties.getProperty("vconsole.selectallenabled"));
        this.setHomeEnabled(this.properties.getProperty("vconsole.hometoolbox"));
        this.setPropertiesEnabled("false");
        this.toggleToolPane(this.properties.getProperty("vconsole.toolpane"));
        this.toggleLocationPane(this.properties.getProperty("vconsole.locationpane"));
        this.toggleStatusPane(this.properties.getProperty("vconsole.statuspane"));
    }

    protected void syncShowMenu() {
        try {
            this.viewItems[0].removeAll();
            this.viewItems[0].add(this.showItems[0]);
            this.viewItems[0].add(this.showItems[1]);
            this.viewItems[0].add(this.showItems[2]);
            ((JMenu)this.viewItems[0]).addSeparator();
            this.viewItems[0].add(this.showItems[3]);
            this.viewItems[0].add(this.showItems[4]);
            if (this.toolShowItems == null) {
                return;
            }
            ((JMenu)this.viewItems[0]).addSeparator();
            int n = 0;
            while (n < this.toolShowItems.length) {
                this.viewItems[0].add(this.toolShowItems[n]);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing show menu", throwable);
        }
    }

    protected void syncSortByMenu() {
        this.notifyOfSort = false;
        try {
            this.viewItems[3].removeAll();
            this.sortByItems[0].setSelected(false);
            this.sortByItems[1].setSelected(false);
            this.sortByItems[2].setSelected(false);
            int n = -1;
            try {
                n = Integer.parseInt(this.sortedColumn);
                if (n < 0) {
                    n = -n;
                }
            }
            catch (Throwable throwable) {}
            this.viewItems[3].add(this.sortByItems[0]);
            if (n == 0) {
                this.sortByItems[0].setSelected(true);
            }
            if (!this.detailsMode) {
                ((JMenu)this.viewItems[3]).addSeparator();
                this.viewItems[3].add(this.sortByItems[2]);
                if (this.sortedColumn != null && this.sortedColumn.startsWith("-")) {
                    this.sortByItems[2].setSelected(true);
                } else {
                    this.sortByItems[2].setSelected(false);
                }
                this.notifyOfSort = true;
                return;
            }
            String[][] stringArray = null;
            if (this.selNode != null) {
                stringArray = this.selNode.getColumnHeaders();
                VScopeNode vScopeNode = this.selNode.getInternalRoot();
                if (vScopeNode != null) {
                    stringArray = vScopeNode.getColumnHeaders();
                }
            }
            if (stringArray == null) {
                this.viewItems[3].add(this.sortByItems[1]);
                if (n == 1) {
                    this.sortByItems[1].setSelected(true);
                }
            } else {
                int n2 = stringArray.length;
                boolean bl = false;
                int n3 = 0;
                while (n3 < n2) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = this.createRadioButtonMenuItem(String.valueOf(n3 + 1));
                    jRadioButtonMenuItem.setText(stringArray[n3][0]);
                    jRadioButtonMenuItem.addActionListener(this.sortListener);
                    String string = stringArray[n3][1];
                    if (string != null) {
                        try {
                            int n4 = Integer.parseInt(string);
                            if (n4 > 0) {
                                this.viewItems[3].add(jRadioButtonMenuItem);
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    if (n == n3 + 1) {
                        jRadioButtonMenuItem.setSelected(true);
                    }
                    ++n3;
                }
            }
            ((JMenu)this.viewItems[3]).addSeparator();
            this.viewItems[3].add(this.sortByItems[2]);
            if (this.sortedColumn != null && this.sortedColumn.startsWith("-")) {
                this.sortByItems[2].setSelected(true);
            } else {
                this.sortByItems[2].setSelected(false);
            }
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing sort by menu", throwable);
        }
        this.notifyOfSort = true;
    }

    protected void syncViewAsMenu() {
        try {
            this.viewItems[1].removeAll();
            this.viewItems[1].add(this.viewAsItems[0]);
            this.viewItems[1].add(this.viewAsItems[1]);
            this.viewItems[1].add(this.viewAsItems[2]);
            this.viewItems[1].add(this.viewAsItems[3]);
            if (this.toolViewAsItems != null) {
                ((JMenu)this.viewItems[1]).addSeparator();
                int n = 0;
                while (n < this.toolViewAsItems.length) {
                    this.viewItems[1].add(this.toolViewAsItems[n]);
                    ++n;
                }
            }
            ((JMenu)this.viewItems[1]).addSeparator();
            this.viewItems[1].add(this.viewAsItems[4]);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing view as menu", throwable);
        }
    }

    protected void syncViewMenu() {
        try {
            this.menuSet[VIEWINDEX].removeAll();
            this.menuSet[VIEWINDEX].add(this.viewItems[0]);
            this.menuSet[VIEWINDEX].add(this.viewItems[1]);
            this.menuSet[VIEWINDEX].add(this.viewItems[2]);
            this.menuSet[VIEWINDEX].add(this.viewItems[3]);
            this.menuSet[VIEWINDEX].addSeparator();
            if (this.toolViewItems != null) {
                int n = 0;
                while (n < this.toolViewItems.length) {
                    this.menuSet[VIEWINDEX].add(this.toolViewItems[n]);
                    ++n;
                }
            }
            this.menuSet[VIEWINDEX].add(this.viewItems[4]);
            this.menuSet[VIEWINDEX].addSeparator();
            this.menuSet[VIEWINDEX].add(this.viewItems[5]);
            this.viewItems[2].setEnabled(this.detailsMode);
            this.viewItems[3].setEnabled(true);
            if (this.selNode != null && this.selNode.getResultPane() != null) {
                this.viewItems[2].setEnabled(false);
                this.viewItems[3].setEnabled(false);
            }
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem sync'ing view menu", throwable);
        }
        this.syncShowMenu();
        this.syncViewAsMenu();
        this.syncColumnsMenu();
        this.syncSortByMenu();
    }

    protected void toggleColumnVisibility(String string, boolean bl) {
        if (string == null || this.selNode == null) {
            return;
        }
        try {
            int n;
            int n2 = Integer.parseInt(string);
            VScopeNode vScopeNode = this.selNode.getInternalRoot();
            if (vScopeNode == null) {
                vScopeNode = this.selNode;
            }
            String[][] stringArray = vScopeNode.getColumnHeaders();
            String string2 = stringArray[n2][1];
            if (bl) {
                try {
                    n = Integer.parseInt(string2);
                    if (n < 0) {
                        n = -n;
                    }
                    stringArray[n2][1] = String.valueOf(n);
                }
                catch (Throwable throwable) {
                    stringArray[n2][1] = null;
                }
            } else {
                try {
                    n = Integer.parseInt(string2);
                    if (n > 0) {
                        n = -n;
                    }
                    stringArray[n2][1] = String.valueOf(n);
                }
                catch (Throwable throwable) {
                    stringArray[n2][1] = "hide";
                }
            }
            try {
                if (this.sortedColumn != null) {
                    n = Integer.parseInt(this.sortedColumn);
                    if (n < 0) {
                        n = -n;
                    }
                    if (n - 1 == n2) {
                        VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.sortup", null);
                        this.notifyListeners(vConsoleEvent);
                    }
                }
            }
            catch (Throwable throwable) {}
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.updatescope", this.selNode);
            this.notifyListeners(vConsoleEvent);
        }
        catch (Throwable throwable) {
            Debug.trace("MenuBar", Debug.ERROR, "Problem toggling column visibility", throwable);
        }
    }

    protected void toggleInfoPane(String string) {
        this.setItemSelected(this.showItems[4], string);
    }

    protected void toggleLocationPane(String string) {
        this.setItemSelected(this.showItems[1], string);
    }

    protected void toggleScopePane(String string) {
        this.setItemSelected(this.showItems[3], string);
    }

    protected void toggleStatusPane(String string) {
        this.setItemSelected(this.showItems[2], string);
    }

    protected void toggleToolPane(String string) {
        this.setItemSelected(this.showItems[0], string);
    }

    protected void updateFontAndColor(Font font, Color color, MenuElement[] menuElementArray) {
        if (font == null || color == null || menuElementArray == null) {
            return;
        }
        int n = 0;
        while (n < menuElementArray.length) {
            try {
                MenuElement menuElement = menuElementArray[n];
                menuElement.getComponent().setFont(font);
                menuElement.getComponent().setForeground(color);
                this.updateFontAndColor(font, color, menuElement.getSubElements());
            }
            catch (Throwable throwable) {}
            ++n;
        }
    }
}

