/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeNode;

public class VLocationBar
extends JPanel
implements PropertyChangeListener,
VConsoleActionListener,
Serializable {
    protected VConsoleProperties properties = null;
    protected Vector listeners = null;
    protected static ImageIcon homeIcon = null;
    protected static ImageIcon disabledHome = null;
    protected AbstractButton homeButton = null;
    protected static Class imageClass = null;
    protected JComboBox tbCombo = null;
    protected JPanel buttonPanel = null;
    protected JLabel tbLabel = null;
    protected String currentTB = null;
    protected boolean dontNotify = false;
    protected transient ActionListener buttonListener = null;
    protected VScopeNode selNode = null;

    public VLocationBar() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.lf.VLocationBar");
            }
            if (homeIcon == null) {
                homeIcon = ConsoleUtility.loadImageIcon("images/Home16.gif", imageClass);
                disabledHome = ConsoleUtility.getDisabledIcon(homeIcon);
            }
        }
        catch (Exception exception) {}
        this.homeButton = new JButton(homeIcon);
        this.homeButton.setDisabledIcon(disabledHome);
        this.homeButton.setEnabled(false);
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VConsoleEvent vConsoleEvent = new VConsoleEvent(VLocationBar.this, "vconsole.openconsole", VLocationBar.this.properties.getProperty("vconsole.hometoolbox"));
                VLocationBar.this.notifyListeners(vConsoleEvent);
            }
        });
        this.tbCombo = new JComboBox(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
            }
        };
        this.tbCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                VLocationBar.this.handleTBEntry();
            }
        });
        this.tbCombo.setFont(ResourceManager.bodyFont);
        this.tbCombo.getEditor().setItem("");
        this.tbCombo.setBackground(ResourceManager.reallyLightGray);
        this.tbCombo.setMaximumRowCount(15);
        this.tbCombo.setEditable(true);
        this.layoutComponents();
        this.init();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null || vConsoleEvent.getID() == null) {
            return;
        }
        if (this.currentTB == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        try {
            if (string.equals("vconsole.scopeselected")) {
                Object object = vConsoleEvent.getPayload();
                if (object == null && this.currentTB != null) {
                    this.tbCombo.getEditor().setItem(this.currentTB);
                    return;
                }
                this.selNode = (VScopeNode)object;
                TreeNode[] treeNodeArray = this.selNode.getPath();
                String string2 = new String(this.currentTB);
                if (treeNodeArray.length > 1) {
                    string2 = String.valueOf(string2) + "#";
                }
                int n = 1;
                while (n < treeNodeArray.length) {
                    VScopeNode vScopeNode = (VScopeNode)treeNodeArray[n];
                    string2 = String.valueOf(string2) + vScopeNode.getText() + "/";
                    ++n;
                }
                this.tbCombo.getEditor().setItem(string2);
            } else if (string.equals("vconsole.updatescope")) {
                Object object = vConsoleEvent.getPayload();
                if (this.selNode == null || object != this.selNode) {
                    return;
                }
                TreeNode[] treeNodeArray = this.selNode.getPath();
                String string3 = new String(this.currentTB);
                if (treeNodeArray.length > 1) {
                    string3 = String.valueOf(string3) + "#";
                }
                int n = 1;
                while (n < treeNodeArray.length) {
                    VScopeNode vScopeNode = (VScopeNode)treeNodeArray[n];
                    string3 = String.valueOf(string3) + vScopeNode.getText() + "/";
                    ++n;
                }
                this.tbCombo.getEditor().setItem(string3);
            }
        }
        catch (Throwable throwable) {}
    }

    protected synchronized void establishHistory(String string) {
        try {
            this.dontNotify = true;
            if (this.tbCombo.getItemCount() > 0) {
                this.tbCombo.removeAllItems();
            }
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.tbCombo.addItem(string2);
            }
            if (this.currentTB == null || this.currentTB.length() == 0) {
                this.tbCombo.getEditor().setItem("");
            } else {
                this.tbCombo.getEditor().setItem(this.currentTB);
            }
            this.dontNotify = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void handleTBEntry() {
        if (this.dontNotify) {
            return;
        }
        try {
            String string = (String)this.tbCombo.getEditor().getItem();
            if (this.currentTB != null && string.startsWith(this.currentTB)) {
                return;
            }
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.openconsole", string);
            this.dontNotify = true;
            this.notifyListeners(vConsoleEvent);
        }
        catch (Throwable throwable) {}
        this.dontNotify = false;
    }

    protected void init() {
        this.installToolTips();
    }

    protected void installColor() {
        this.homeButton.setForeground(ResourceManager.menuColor);
        this.tbCombo.setForeground(ResourceManager.bodyColor);
        this.tbCombo.getEditor().getEditorComponent().setForeground(ResourceManager.bodyColor);
        this.tbLabel.setForeground(ResourceManager.labelColor);
    }

    protected void installFonts() {
        this.homeButton.setFont(ResourceManager.menuFont);
        this.tbCombo.setFont(ResourceManager.bodyFont);
        this.tbLabel.setFont(ResourceManager.labelFont);
    }

    protected void installIcons() {
        this.homeButton.setIcon(homeIcon);
        this.homeButton.setDisabledIcon(disabledHome);
    }

    protected void installStrings() {
        this.homeButton.setText(ResourceManager.getString("Location_Bar Home"));
    }

    protected void installToolTips() {
        this.homeButton.setToolTipText(ResourceManager.getString("Location_Bar Home_tooltip"));
        this.homeButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("Location_Bar Home_access_name"));
        this.homeButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("Location_Bar Home_access_desc"));
        this.tbLabel.setText(String.valueOf(ResourceManager.getString("Location_Bar Toolbox:")) + "  ");
        this.tbLabel.setDisplayedMnemonic(ResourceManager.getString("Location_Bar Toolbox:_mnemonic").charAt(0));
        this.tbLabel.getAccessibleContext().setAccessibleName(ResourceManager.getString("Location_Bar Toolbox:_access_name"));
        this.tbLabel.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("Location_Bar Toolbox:_access_desc"));
        this.tbLabel.setFont(ResourceManager.menuFont);
    }

    protected void layoutComponents() {
        this.tbLabel = new JLabel();
        this.tbLabel.setForeground(ResourceManager.sunBlue);
        this.tbLabel.setLabelFor(this.tbCombo);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.homeButton);
        jToolBar.add(Box.createHorizontalStrut(15));
        JPanel jPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.tbLabel);
        jPanel.add(this.tbCombo);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jToolBar, "West");
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "North");
        this.validate();
        this.repaint();
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null || this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        String string2 = null;
        if (object instanceof String) {
            string2 = (String)object;
        }
        if (string.equals("vconsole.hometoolbox")) {
            this.setHomeEnabled(string2);
        } else if (string.equals("vconsole.currenttoolbox")) {
            this.currentTB = string2;
            this.dontNotify = true;
            if (string2 == null || string2.equals("null")) {
                this.tbCombo.getEditor().setItem("");
            } else {
                this.tbCombo.getEditor().setItem(string2);
            }
            this.dontNotify = false;
        } else if (string.equals("vconsole.toolboxhistory")) {
            this.establishHistory(string2);
        } else if (string.equals("vconsole.buttondisplay")) {
            this.syncButtonDisplay(string2);
            this.validate();
            this.repaint();
        } else if (string.equals("vconsole.menufont") || string.equals("vconsole.bodyfont") || string.equals("vconsole.labelfont")) {
            this.installFonts();
        } else if (string.equals("vconsole.menucolor") || string.equals("vconsole.bodycolor") || string.equals("vconsole.labelcolor")) {
            this.installColor();
        }
    }

    protected void setHomeEnabled(String string) {
        if (this.homeButton != null) {
            if (string != null && !string.equals("null") && string.length() > 0) {
                this.homeButton.setEnabled(true);
            } else {
                this.homeButton.setEnabled(false);
            }
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.properties = vConsoleProperties;
            vConsoleProperties.addPropertyChangeListener(this);
            this.setHomeEnabled(vConsoleProperties.getProperty("vconsole.hometoolbox"));
            this.establishHistory(vConsoleProperties.getProperty("vconsole.toolboxhistory"));
            this.syncButtonDisplay(vConsoleProperties.getProperty("vconsole.buttondisplay"));
            this.installFonts();
            this.installColor();
            this.validate();
            this.repaint();
        }
    }

    protected void syncButtonDisplay(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("vconsole.textonly")) {
            this.uninstallIcons();
            this.installStrings();
        } else if (string.equals("vconsole.icononly")) {
            this.uninstallStrings();
            this.installIcons();
        } else if (string.equals("vconsole.textandicon")) {
            this.installIcons();
            this.installStrings();
        }
    }

    protected void uninstallIcons() {
        this.homeButton.setIcon(null);
        this.homeButton.setDisabledIcon(null);
    }

    protected void uninstallStrings() {
        this.homeButton.setText(null);
    }
}

