/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui.lf;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.lf.VAuxiliaryComponent;
import com.sun.management.viper.console.gui.lf.VInfoContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class VInfoPane
extends JPanel
implements VConsoleActionListener,
PropertyChangeListener {
    protected JPanel emptyPanel = null;
    protected Component currComp = null;
    protected JSplitPane lastPane = null;
    protected Vector layers = new Vector();
    protected Vector splitPanes = new Vector();
    protected VConsoleProperties properties = null;

    public VInfoPane() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.emptyPanel = new JPanel();
        this.emptyPanel.setBorder(new LineBorder(Color.gray, 1));
        this.emptyPanel.setBackground(Color.white);
        this.add((Component)this.emptyPanel, "Center");
        this.currComp = this.emptyPanel;
        this.validate();
        this.repaint();
    }

    protected int addContentPane(String string, Icon icon, Component component) {
        int n = -1;
        if (component == null || string == null) {
            return -1;
        }
        n = this.layers.size();
        if (this.lastPane == null) {
            this.remove(this.currComp);
            if (this.currComp == this.emptyPanel) {
                this.currComp = new VInfoContainer(string, icon, component, n, this);
                this.layers.addElement(this.currComp);
                this.add(this.currComp, "Center");
            } else {
                this.lastPane = new JSplitPane(0, true);
                this.lastPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.splitPanes.addElement(this.lastPane);
                this.lastPane.setBottomComponent(this.currComp);
                this.currComp = new VInfoContainer(string, icon, component, n, this);
                this.layers.addElement(this.currComp);
                this.lastPane.setTopComponent(this.currComp);
                this.add((Component)this.lastPane, "Center");
                this.currComp = this.lastPane;
            }
        } else {
            Component component2 = this.lastPane.getTopComponent();
            this.lastPane.setTopComponent(new JPanel());
            JSplitPane jSplitPane = new JSplitPane(0, true);
            jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            VInfoContainer vInfoContainer = new VInfoContainer(string, icon, component, n, this);
            this.layers.addElement(vInfoContainer);
            jSplitPane.setTopComponent(vInfoContainer);
            jSplitPane.setBottomComponent(component2);
            this.splitPanes.addElement(jSplitPane);
            this.lastPane.setTopComponent(jSplitPane);
            this.lastPane = jSplitPane;
        }
        this.validate();
        this.repaint();
        if (this.lastPane != null) {
            this.lastPane.invalidate();
            this.lastPane.validate();
        }
        return n;
    }

    protected int addContentPaneAsTab(String string, Icon icon, Component component, int n) {
        if (component != null && string != null && n > -1 && n < this.layers.size()) {
            VInfoContainer vInfoContainer = (VInfoContainer)this.layers.elementAt(n);
            vInfoContainer.addInfoPanel(string, icon, component);
            return n;
        }
        return -1;
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null || vConsoleEvent.getID() == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        try {
            if (string.equals("vconsole.addauxcomponent")) {
                Object object = vConsoleEvent.getPayload();
                if (!(object instanceof VAuxiliaryComponent)) {
                    return;
                }
                VAuxiliaryComponent vAuxiliaryComponent = (VAuxiliaryComponent)object;
                if (this.layers.size() < 1) {
                    this.addContentPane(vAuxiliaryComponent.getTitle(), vAuxiliaryComponent.getIcon(), vAuxiliaryComponent.getComponent());
                } else {
                    this.addContentPaneAsTab(vAuxiliaryComponent.getTitle(), vAuxiliaryComponent.getIcon(), vAuxiliaryComponent.getComponent(), 0);
                }
            } else if (string.equals("vconsole.remauxcomponent")) {
                Object object = vConsoleEvent.getPayload();
                if (!(object instanceof VAuxiliaryComponent)) {
                    return;
                }
                VAuxiliaryComponent vAuxiliaryComponent = (VAuxiliaryComponent)object;
                this.removeContentPaneAsTab(vAuxiliaryComponent.getComponent(), 0);
            }
        }
        catch (Throwable throwable) {}
    }

    protected int getLayerCount() {
        return this.layers.size();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        if (this.currComp == null || !(this.currComp instanceof VInfoContainer)) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        try {
            if (string.equals("vconsole.menufont")) {
                ((VInfoContainer)this.currComp).setFont((Font)object);
            } else if (string.equals("vconsole.menucolor")) {
                ((VInfoContainer)this.currComp).setForeground((Color)object);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void removeContentPane(int n) {
        if (n > 0 && n < this.splitPanes.size()) {
            JSplitPane jSplitPane = (JSplitPane)this.splitPanes.elementAt(n);
            Component component = jSplitPane.getTopComponent();
            JSplitPane jSplitPane2 = (JSplitPane)this.splitPanes.elementAt(n - 1);
            jSplitPane2.setTopComponent(component);
            this.splitPanes.removeElementAt(n);
            this.layers.removeElementAt(n);
            int n2 = 0;
            while (n2 < this.layers.size()) {
                Object e = this.layers.elementAt(n2);
                ((VInfoContainer)e).setLayer(n2);
                ++n2;
            }
            this.validate();
            this.repaint();
        } else if (n > 0 && n == this.splitPanes.size()) {
            JSplitPane jSplitPane = (JSplitPane)this.splitPanes.elementAt(n - 1);
            if (n == 1) {
                this.remove(jSplitPane);
                this.add(jSplitPane.getBottomComponent(), "Center");
            } else {
                JSplitPane jSplitPane3 = (JSplitPane)this.splitPanes.elementAt(n - 2);
                Component component = jSplitPane.getBottomComponent();
                jSplitPane3.setTopComponent(component);
            }
            this.splitPanes.removeElementAt(n - 1);
            this.validate();
            this.repaint();
        }
    }

    protected int removeContentPaneAsTab(Component component, int n) {
        if (component != null && n > -1 && n < this.layers.size()) {
            VInfoContainer vInfoContainer = (VInfoContainer)this.layers.elementAt(n);
            vInfoContainer.removeInfoPanel(component);
            return n;
        }
        return -1;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.properties = vConsoleProperties;
            vConsoleProperties.addPropertyChangeListener(this);
        }
    }
}

