/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VStyledTableCellRenderer;
import com.sun.management.viper.console.gui.VTable;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Keymap;

public class VTableUI
extends BasicTableUI
implements PropertyChangeListener {
    protected VTable table = null;
    protected CellRendererPane rendererPane = null;
    protected boolean isAdjusting = false;
    protected KeyListener keyListener = null;
    protected FocusListener focusListener = null;
    protected MouseInputListener mouseInputListener = null;
    protected int numIconColumns = -1;
    protected int anchorRow = -1;
    protected int anchorColumn = -1;
    protected VConsoleProperties properties = null;
    protected String selectedFlag = null;
    protected String currentSel = null;
    protected Timer enterTimer = null;
    protected int insideRow = -1;
    protected int insideCol = -1;
    protected int modifiers = 0;
    protected String iconStyle = null;
    protected String clickStyle = null;
    protected boolean webMode = false;
    protected VStyledTableCellRenderer renderer = null;

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected Dimension createTableSize(long l) {
        int n = this.table.getRowCount() * (this.table.getRowHeight() + this.table.getRowMargin());
        int n2 = this.table.getColumnModel().getColumnMargin() * this.table.getColumnCount();
        long l2 = Math.abs(l) + (long)n2;
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, n);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new VTableUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l);
    }

    protected void installDefaults() {
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        this.table.setFont(ResourceManager.bodyFont);
        this.table.setForeground(ResourceManager.bodyColor);
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent jComponent) {
        this.table = (VTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.enterTimer = new Timer(750, new insideTimerAction());
        this.enterTimer.setRepeats(false);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected int lastVisibleRow(Rectangle rectangle) {
        int n = this.table.rowAtPoint(new Point(0, rectangle.y + rectangle.height - 1));
        if (n == -1) {
            n = this.table.getRowCount() - 1;
        }
        return n;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = this.table.getColumnModel().getTotalColumnWidth();
        rectangle2.width = Math.min(rectangle2.width, n);
        graphics.setClip(rectangle2);
        this.paintGrid(graphics);
        int n2 = this.table.rowAtPoint(new Point(0, rectangle2.y));
        int n3 = this.lastVisibleRow(rectangle2);
        Rectangle rectangle3 = new Rectangle(0, 0, n, this.table.getRowHeight() + this.table.getRowMargin());
        rectangle3.y = n2 * rectangle3.height;
        int n4 = n2;
        while (n4 <= n3) {
            if (rectangle3.intersects(rectangle2)) {
                this.paintRow(graphics, n4);
            }
            rectangle3.y += rectangle3.height;
            ++n4;
        }
        graphics.setClip(rectangle);
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = this.table.getRowMargin();
        int n4 = this.table.getColumnModel().getColumnMargin();
        rectangle.setBounds(rectangle.x + n4 / 2, rectangle.y + n3 / 2, rectangle.width - n4, rectangle.height - n3);
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        rectangle.setBounds(rectangle.x - n4 / 2, rectangle.y - n3 / 2, rectangle.width + n4, rectangle.height + n3);
    }

    protected void paintGrid(Graphics graphics) {
        graphics.setColor(this.table.getGridColor());
        if (this.table.getShowHorizontalLines()) {
            this.paintHorizontalLines(graphics);
        }
        if (this.table.getShowVerticalLines()) {
            this.paintVerticalLines(graphics);
        }
    }

    protected void paintHorizontalLines(Graphics graphics) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = graphics.getClipBounds();
        int n = this.table.getRowHeight() + this.table.getRowMargin();
        int n2 = this.table.rowAtPoint(new Point(0, rectangle.y));
        int n3 = this.lastVisibleRow(rectangle);
        int n4 = n * n2 + (n - 1);
        int n5 = n2;
        while (n5 <= n3) {
            if (n4 >= rectangle2.y && n4 <= rectangle2.y + rectangle2.height) {
                graphics.drawLine(rectangle2.x, n4, rectangle2.x + rectangle2.width - 1, n4);
            }
            n4 += n;
            ++n5;
        }
    }

    protected void paintRow(Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        Rectangle rectangle2 = null;
        Dimension dimension = this.table.getIntercellSpacing();
        JTableHeader jTableHeader = this.table.getTableHeader();
        Rectangle rectangle3 = new Rectangle();
        rectangle3.height = this.table.getRowHeight() + dimension.height;
        rectangle3.y = n * rectangle3.height;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            rectangle3.width = tableColumn.getWidth() + dimension.width;
            if (rectangle3.intersects(rectangle)) {
                bl = true;
                if (jTableHeader == null || tableColumn != jTableHeader.getDraggedColumn()) {
                    this.paintCell(graphics, rectangle3, n, n2);
                } else {
                    graphics.setColor(this.table.getParent().getBackground());
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    rectangle2 = new Rectangle(rectangle3);
                    n3 = n2;
                }
            } else if (bl) break;
            rectangle3.x += rectangle3.width;
            ++n2;
        }
        if (n3 != -1 && rectangle2 != null) {
            rectangle2.x += jTableHeader.getDraggedDistance();
            graphics.setColor(this.table.getBackground());
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.setColor(this.table.getGridColor());
            int n4 = rectangle2.x;
            int n5 = rectangle2.y;
            int n6 = n4 + rectangle2.width - 1;
            int n7 = n5 + rectangle2.height - 1;
            if (this.table.getShowVerticalLines()) {
                graphics.drawLine(n6, n5, n6, n7);
            }
            if (this.table.getShowHorizontalLines()) {
                graphics.drawLine(n4, n7, n6, n7);
            }
            this.paintCell(graphics, rectangle2, n, n3);
        }
    }

    protected void paintVerticalLines(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = 0;
        int n2 = this.table.getColumnCount();
        int n3 = this.table.getIntercellSpacing().width;
        int n4 = 0;
        while (n4 <= n2) {
            if (n > 0 && n - 1 >= rectangle.x && n - 1 <= rectangle.x + rectangle.width) {
                graphics.drawLine(n - 1, rectangle.y, n - 1, rectangle.y + rectangle.height - 1);
            }
            if (n4 < n2) {
                n += this.table.getColumnModel().getColumn(n4).getWidth() + n3;
            }
            ++n4;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (!string.equals("vconsole.bodyfont") && !string.equals("vconsole.bodycolor")) {
            if (string.equals("vconsole.iconstyle")) {
                this.iconStyle = (String)propertyChangeEvent.getNewValue();
            } else if (string.equals("vconsole.clickstyle")) {
                this.clickStyle = (String)propertyChangeEvent.getNewValue();
                this.webMode = this.clickStyle.equals("web");
            } else if (string.equals("vconsole.currentselection")) {
                this.currentSel = (String)propertyChangeEvent.getNewValue();
            }
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
            this.iconStyle = vConsoleProperties.getProperty("vconsole.iconstyle");
            this.clickStyle = vConsoleProperties.getProperty("vconsole.clickstyle");
            this.webMode = this.clickStyle.equals("web");
            this.currentSel = vConsoleProperties.getProperty("vconsole.currentselection");
        }
    }

    public void setSelectedFlag(String string) {
        this.selectedFlag = string;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void updateSelection(int n, int n2, boolean bl, boolean bl2) {
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        if (rectangle != null) {
            this.table.scrollRectToVisible(rectangle);
        }
        if (this.isAdjusting) {
            this.table.setGridBoxSelected(this.anchorRow, this.anchorColumn, n, n2, true);
        } else {
            this.table.setGridCellSelected(n, n2, bl, bl2);
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            String string;
            if (keyEvent.getKeyCode() == 127 && (string = VTableUI.this.properties.getProperty("vconsole.deleteenabled")).equals("true")) {
                VTableUI.this.table.dataModel.correlateViewAction(new VConsoleEvent(VTableUI.this, "vconsole.delete", null));
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\n') {
                return;
            }
            int n = VTableUI.this.table.getSelectedRow();
            int n2 = VTableUI.this.table.getSelectedColumn();
            if (n != -1 && n2 != -1 && !VTableUI.this.table.isEditing()) {
                boolean bl = VTableUI.this.table.editCellAt(n, n2);
                VTableUI.this.table.requestFocus();
                if (!bl) {
                    return;
                }
            }
            Component component = VTableUI.this.table.getEditorComponent();
            if (VTableUI.this.table.isEditing() && component != null) {
                KeyStroke keyStroke;
                if (!(component instanceof JTextField)) {
                    return;
                }
                char c = keyEvent.getKeyChar();
                JTextField jTextField = (JTextField)component;
                Keymap keymap = jTextField.getKeymap();
                Action action = keymap.getAction(keyStroke = KeyStroke.getKeyStroke((int)c, 0));
                if (action == null) {
                    action = keymap.getDefaultAction();
                }
                if (action != null) {
                    ActionEvent actionEvent = new ActionEvent(jTextField, 1001, String.valueOf(c));
                    action.actionPerformed(actionEvent);
                    keyEvent.consume();
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (VTableUI.this.properties == null) {
                return;
            }
            if (!VTableUI.this.currentSel.equals(VTableUI.this.selectedFlag)) {
                VTableUI.this.currentSel = VTableUI.this.selectedFlag;
                VTableUI.this.table.checkPropertiesSetting();
                VTableUI.this.properties.setProperty("vconsole.currentselection", VTableUI.this.selectedFlag);
            }
            if (VTableUI.this.table.getRowCount() <= 0) {
                return;
            }
            if (VTableUI.this.table.getSelectedColumn() == -1) {
                VTableUI.this.table.setColumnSelectionInterval(0, 0);
            }
            if (VTableUI.this.table.getSelectedRow() == -1) {
                VTableUI.this.table.setRowSelectionInterval(0, 0);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected boolean phantomMousePressed = false;
        protected Component dispatchComponent;

        public void maybeShowPopup(MouseEvent mouseEvent) {
            block7: {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                int n = VTableUI.this.table.columnAtPoint(mouseEvent.getPoint());
                int n2 = VTableUI.this.table.rowAtPoint(mouseEvent.getPoint());
                Object object = VTableUI.this.table.getValueAt(n2, n);
                if (object == null) {
                    return;
                }
                if (!(object instanceof VScopeNode)) break block7;
                try {
                    VScopeNode vScopeNode = (VScopeNode)object;
                    boolean bl = mouseEvent.isShiftDown();
                    if (VTableUI.this.table.isGridCellSelected(n2, n)) {
                        bl = true;
                    }
                    if (vScopeNode.getPopupMenu() != null) {
                        VTableUI.this.table.requestFocus();
                        if (!mouseEvent.isControlDown()) {
                            VTableUI.this.table.setGridCellSelected(n2, n, false, bl);
                            VTableUI.this.table.repaint();
                        }
                        JPopupMenu jPopupMenu = vScopeNode.getPopupMenu();
                        jPopupMenu.show(VTableUI.this.table, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
                catch (Throwable throwable) {}
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (VTableUI.this.table == null) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = VTableUI.this.table.columnAtPoint(mouseEvent.getPoint());
                int n2 = VTableUI.this.table.rowAtPoint(mouseEvent.getPoint());
                if (VTableUI.this.table.getValueAt(n2, n) == null) {
                    VTableUI.this.table.clearSelection();
                    return;
                }
                boolean bl = true;
                if (VTableUI.this.iconStyle.equals("details")) {
                    boolean bl2 = bl = n == 0;
                }
                if (bl && (VTableUI.this.clickStyle.equals("web") || mouseEvent.getClickCount() == 2)) {
                    VTableUI.this.table.childOpened(VTableUI.this.table.rowAtPoint(mouseEvent.getPoint()), n);
                }
            }
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this.setValueIsAdjusting(true);
            Point point = mouseEvent.getPoint();
            int n = VTableUI.this.table.rowAtPoint(point);
            int n2 = VTableUI.this.table.columnAtPoint(point);
            if (VTableUI.this.anchorRow == -1) {
                VTableUI.this.anchorRow = n;
                VTableUI.this.anchorColumn = n2;
            }
            if (n2 == -1 || n == -1) {
                return;
            }
            VTableUI.this.updateSelection(n, n2, false, true);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.dispatchComponent = null;
            if (VTableUI.this.clickStyle.equals("web")) {
                int n = VTableUI.this.table.rowAtPoint(mouseEvent.getPoint());
                if (VTableUI.this.insideRow == n) {
                    return;
                }
                int n2 = VTableUI.this.table.columnAtPoint(mouseEvent.getPoint());
                VTableUI.this.modifiers = mouseEvent.isControlDown() ? (VTableUI.this.modifiers += 2) : (mouseEvent.isShiftDown() ? ++VTableUI.this.modifiers : 0);
                VTableUI.this.enterTimer.stop();
                VTableUI.this.insideRow = n;
                VTableUI.this.insideCol = n2;
                VTableUI.this.enterTimer.start();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.dispatchComponent = null;
            VTableUI.this.enterTimer.stop();
            if (VTableUI.this.renderer != null) {
                VTableUI.this.renderer.clearPressed();
                VTableUI.this.table.validate();
                VTableUI.this.table.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.dispatchComponent = null;
            Object var2_2 = null;
            boolean bl = false;
            if (VTableUI.this.iconStyle.equals("details")) {
                if (VTableUI.this.table.columnAtPoint(mouseEvent.getPoint()) == 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            int n = VTableUI.this.table.rowAtPoint(mouseEvent.getPoint());
            int n2 = VTableUI.this.table.columnAtPoint(mouseEvent.getPoint());
            if (VTableUI.this.clickStyle.equals("web") && bl && VTableUI.this.table.getValueAt(n, n2) != null) {
                VTableUI.this.table.setCursor(Cursor.getPredefinedCursor(12));
                if (VTableUI.this.insideRow == n || VTableUI.this.insideCol == n2) {
                    return;
                }
                VTableUI.this.modifiers = mouseEvent.isControlDown() && mouseEvent.isShiftDown() ? 3 : (mouseEvent.isShiftDown() ? 1 : (mouseEvent.isControlDown() ? 2 : 0));
                VTableUI.this.enterTimer.stop();
                VTableUI.this.insideRow = n;
                VTableUI.this.insideCol = n2;
                VTableUI.this.enterTimer.start();
            } else {
                VTableUI.this.table.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TableCellRenderer tableCellRenderer;
            if (VTableUI.this.iconStyle.equals("details") && SwingUtilities.isLeftMouseButton(mouseEvent) && VTableUI.this.table.columnAtPoint(mouseEvent.getPoint()) != 0) {
                VTableUI.this.table.clearSelection();
            }
            this.maybeShowPopup(mouseEvent);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.phantomMousePressed) {
                return;
            }
            this.phantomMousePressed = true;
            Point point = mouseEvent.getPoint();
            int n = VTableUI.this.table.rowAtPoint(point);
            int n2 = VTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            VTableUI.this.table.requestFocus();
            VTableUI.this.updateSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            if (VTableUI.this.renderer == null && (tableCellRenderer = VTableUI.this.table.getCellRenderer(0, 0)) instanceof VStyledTableCellRenderer) {
                VTableUI.this.renderer = (VStyledTableCellRenderer)tableCellRenderer;
            }
            if (VTableUI.this.renderer != null) {
                VTableUI.this.renderer.setPressed(VTableUI.this.table.rowAtPoint(mouseEvent.getPoint()), VTableUI.this.table.columnAtPoint(mouseEvent.getPoint()));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this.phantomMousePressed = false;
            this.repostEvent(mouseEvent);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
            VTableUI.this.anchorRow = -1;
            VTableUI.this.anchorColumn = -1;
            if (VTableUI.this.renderer != null) {
                VTableUI.this.renderer.clearPressed();
                VTableUI.this.table.validate();
                VTableUI.this.table.repaint();
                VTableUI.this.table.requestFocus();
            }
        }

        protected boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(VTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        protected void setValueIsAdjusting(boolean bl) {
            VTableUI.this.isAdjusting = bl;
            VTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
            TableColumnModel tableColumnModel = VTableUI.this.table.getColumnModel();
            tableColumnModel.getSelectionModel().setValueIsAdjusting(bl);
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VTableUI.this.webMode) {
                VTableUI.this.enterTimer.stop();
                boolean bl = VTableUI.this.modifiers == 2;
                boolean bl2 = VTableUI.this.modifiers == 1;
                VTableUI.this.properties.setProperty("vconsole.currentselection", VTableUI.this.selectedFlag);
                VTableUI.this.table.requestFocus();
                VTableUI.this.table.setGridCellSelected(VTableUI.this.insideRow, VTableUI.this.insideCol, bl, bl2);
            }
        }
    }
}

