/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.VStyledTableCellRenderer;
import com.sun.management.viper.console.gui.VStyledTableHeaderRenderer;
import com.sun.management.viper.console.gui.VTableUI;
import com.sun.management.viper.console.gui.deck.VBaseDeck;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class VTable
extends JTable
implements PropertyChangeListener,
VDisplayModel,
VConsoleActionListener {
    protected VConsoleModel dataModel = null;
    protected VConsoleProperties properties = null;
    protected VStyledTableCellRenderer cellRenderer = null;
    protected VStyledTableHeaderRenderer headerRenderer = null;
    protected VTableUI tableUI = null;
    protected String tableID = null;
    protected int largeRowHeight = 50;
    protected String tableState = "large";
    protected Vector selectionSet = null;
    protected int recentRowCnt = -1;
    protected int recentColCnt = -1;
    protected int recentRow = -1;
    protected int recentCol = -1;
    protected boolean detailsMode = false;
    protected boolean listMode = false;
    protected boolean maintainSelections = false;
    protected boolean noRebuild = false;
    protected int selectionMode = 2;
    protected String currentSel = null;

    public VTable() {
        this(null);
    }

    public VTable(VConsoleModel vConsoleModel) {
        this.setModel(vConsoleModel);
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            return;
        }
        try {
            int n = tableColumn.getModelIndex();
            String string = this.dataModel.getColumnName(n);
            if (tableColumn.getHeaderValue() == null) {
                tableColumn.setHeaderValue(string);
            }
            tableColumn.setCellRenderer(this.cellRenderer);
            int n2 = this.dataModel.getColumnWidth(n);
            if (n2 != -1) {
                if (n2 > 20000) {
                    tableColumn.setPreferredWidth(n2 - 20000);
                } else if (n2 > 10000) {
                    tableColumn.setPreferredWidth(n2 - 10000);
                } else {
                    tableColumn.setPreferredWidth(n2);
                }
            }
            tableColumn.setHeaderRenderer(this.headerRenderer);
            this.getColumnModel().addColumn(tableColumn);
        }
        catch (Throwable throwable) {}
    }

    public void addSelectedNode(VScopeNode vScopeNode) {
        try {
            int n;
            if (vScopeNode == null) {
                return;
            }
            if (this.selectionMode == 0) {
                this.initSelectionModel();
            }
            if ((n = this.getIndexForValue(vScopeNode)) != -1) {
                this.selectionSet.addElement(vScopeNode);
                this.notifyOfSelection();
            }
        }
        catch (Exception exception) {}
    }

    public void addSelectionInterval(int n, int n2) {
        try {
            int n3;
            if (n2 < n) {
                n3 = n;
                n = n2;
                n2 = n3;
            }
            if (this.selectionMode == 0) {
                this.initSelectionModel();
                n2 = n;
            }
            n3 = n;
            while (n3 <= n2) {
                Object object;
                Point point = this.getPointForIndex(n3);
                if (point != null && (object = this.getValueAt(point.x, point.y)) != null) {
                    this.selectionSet.addElement(object);
                }
                ++n3;
            }
            this.notifyOfSelection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void checkForPropertiesDisplay() {
        if (!this.tableID.equals(this.currentSel)) {
            return;
        }
        if (this.selectionSet.size() != 1) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)this.selectionSet.elementAt(0);
        Component component = vScopeNode.getPropsPane();
        if (component == null) {
            return;
        }
        if (component instanceof Window) {
            component.setVisible(true);
            return;
        }
        VFrame vFrame = new VFrame("");
        if (component instanceof VOptionPane) {
            ((VOptionPane)component).setContainer(vFrame);
            if (component instanceof VBaseDeck) {
                ((VBaseDeck)component).init();
            }
            vFrame.showCenter((JFrame)this.properties.getPropertyObject("vconsole.frame"));
            if (component instanceof VBaseDeck) {
                ((VBaseDeck)component).start();
            }
        } else {
            vFrame.getContentPane().setLayout(new BorderLayout());
            vFrame.getContentPane().add(component, "Center");
            Dimension dimension = component.getPreferredSize();
            ((Component)vFrame).setSize(new Dimension(dimension.width + 10, dimension.height + 50));
            vFrame.showCenter((JFrame)this.properties.getPropertyObject("vconsole.frame"));
        }
    }

    public void checkHeaderState() {
        try {
            if (this.detailsMode) {
                JScrollPane jScrollPane = (JScrollPane)this.getParent().getParent();
                this.createDefaultColumnsFromModel();
                jScrollPane.setColumnHeaderView(this.tableHeader);
            } else {
                JScrollPane jScrollPane = (JScrollPane)this.getParent().getParent();
                jScrollPane.setColumnHeaderView(null);
            }
        }
        catch (Exception exception) {}
    }

    protected void checkPropertiesSetting() {
        try {
            if (!this.tableID.equals(this.currentSel)) {
                return;
            }
            this.properties.setProperty("vconsole.propertiesenabled", "false");
            if (this.selectionSet.size() != 1) {
                return;
            }
            VScopeNode vScopeNode = (VScopeNode)this.selectionSet.elementAt(0);
            if (vScopeNode.getPropsPane() != null) {
                this.properties.setProperty("vconsole.propertiesenabled", "true");
            }
        }
        catch (Throwable throwable) {}
    }

    public void childOpened(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        try {
            if (object instanceof VScopeNode) {
                VScopeNode vScopeNode = (VScopeNode)object;
                VScopeNode vScopeNode2 = this.getSelectedNavigationNode();
                if (vScopeNode.getParent() == vScopeNode2) {
                    VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.scopeselected", object);
                    this.dataModel.correlateViewAction(vConsoleEvent);
                    return;
                }
                if (vScopeNode.getResultPane() != null) {
                    VFrame vFrame = new VFrame();
                    vFrame.setComponent(vScopeNode.getResultPane());
                    vFrame.showCenter(null);
                    return;
                }
                if (vScopeNode.getPropsPane() != null) {
                    VFrame vFrame = new VFrame();
                    vFrame.setComponent(vScopeNode.getPropsPane());
                    vFrame.showCenter(null);
                    return;
                }
                if (vScopeNode.getInternalRoot() != null) {
                    VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.newconsole", vScopeNode.getInternalRoot());
                    this.dataModel.correlateViewAction(vConsoleEvent);
                    return;
                }
                VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.scopechildopened", vScopeNode);
                this.dataModel.correlateViewAction(vConsoleEvent);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void clearSelection() {
        this.initSelectionModel();
        this.notifyOfSelection();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        try {
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            if (n == -1 && n2 == -1) {
                this.repaint();
            }
            Rectangle rectangle = this.getCellRect(0, n, false);
            Rectangle rectangle2 = this.getCellRect(this.recentRowCnt, n2, false);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            this.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
        catch (Throwable throwable) {}
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.displayproperties")) {
            this.checkForPropertiesDisplay();
        }
    }

    protected void establishHeader() {
        try {
            JScrollPane jScrollPane = (JScrollPane)this.getParent().getParent();
            Dimension dimension = jScrollPane.getSize();
            Dimension dimension2 = new Dimension(dimension.width + 1, dimension.height);
            jScrollPane.setSize(dimension2);
            jScrollPane.validate();
            jScrollPane.setSize(dimension);
            jScrollPane.repaint();
        }
        catch (Exception exception) {}
    }

    protected void establishRowHeight() {
        if (this.tableState == null) {
            return;
        }
        Font font = ResourceManager.bodyFont;
        if (font == null) {
            return;
        }
        int n = font.getSize() * 2;
        if (this.tableState.equals("large")) {
            this.setRowHeight(this.largeRowHeight + n);
        } else {
            this.setRowHeight(n);
        }
    }

    public VConsoleModel getConsoleModel() {
        return this.dataModel;
    }

    protected int getIndexForPoint(int n, int n2) {
        try {
            return n * this.recentColCnt + n2;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    protected int getIndexForValue(VScopeNode vScopeNode) {
        if (vScopeNode == null) {
            return -1;
        }
        try {
            int n = this.recentColCnt;
            if (this.detailsMode || this.listMode) {
                n = 1;
            }
            VScopeNode vScopeNode2 = (VScopeNode)vScopeNode.getParent();
            int n2 = vScopeNode2.getIndex(vScopeNode);
            VScopeNode vScopeNode3 = this.getSelectedNavigationNode();
            if (vScopeNode3 != null && vScopeNode2 == vScopeNode3.getInternalRoot()) {
                n2 += vScopeNode3.getChildCount();
            }
            return n2;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public int getIndexForViewNode(VScopeNode vScopeNode) {
        try {
            VScopeNode vScopeNode2 = this.getSelectedNavigationNode();
            int n = this.dataModel.getTrueIndexOfChild(vScopeNode2, vScopeNode);
            return this.dataModel.getSortedIndexForIndex(n);
        }
        catch (Throwable throwable) {
            Debug.trace("VTable", Debug.WARNING, "Problem in getIndexForViewNode", throwable);
            return -1;
        }
    }

    public VScopeNode getNextViewNode(VScopeNode vScopeNode) {
        try {
            int n = this.getIndexForViewNode(vScopeNode);
            int n2 = this.dataModel.getIndexForSortedIndex(++n);
            int n3 = this.dataModel.getSortedIndexForIndex(n2);
            return this.getViewNodeAtIndex(n3);
        }
        catch (Throwable throwable) {
            Debug.trace("VTable", Debug.WARNING, "Problem in getViewNodeAtIndex", throwable);
            return null;
        }
    }

    public int getNodeCount() {
        VScopeNode vScopeNode = this.getSelectedNavigationNode();
        if (vScopeNode == null) {
            return 0;
        }
        int n = vScopeNode.getChildCount();
        VScopeNode vScopeNode2 = vScopeNode.getInternalRoot();
        if (vScopeNode2 != null) {
            n += vScopeNode2.getChildCount();
        }
        return n;
    }

    protected Point getPointForIndex(int n) {
        try {
            int n2 = this.recentColCnt;
            if (this.detailsMode || this.listMode) {
                n2 = 1;
            }
            int n3 = n / n2;
            int n4 = n % n2;
            return new Point(n3, n4);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected Point getPointForValue(VScopeNode vScopeNode) {
        if (vScopeNode == null) {
            return null;
        }
        try {
            int n = this.getIndexForValue(vScopeNode);
            return this.getPointForIndex(n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public VScopeNode getPreviousViewNode(VScopeNode vScopeNode) {
        try {
            int n = this.getIndexForViewNode(vScopeNode);
            int n2 = this.dataModel.getIndexForSortedIndex(--n);
            int n3 = this.dataModel.getSortedIndexForIndex(n2);
            return this.getViewNodeAtIndex(n3);
        }
        catch (Throwable throwable) {
            Debug.trace("VTable", Debug.WARNING, "Problem in getViewNodeAtIndex", throwable);
            return null;
        }
    }

    public int[] getSelectedIndexes() {
        try {
            if (this.selectionSet == null) {
                return new int[0];
            }
            int n = this.recentColCnt;
            if (this.detailsMode || this.listMode) {
                n = 1;
            }
            int[] nArray = new int[this.selectionSet.size()];
            int n2 = 0;
            while (n2 < this.selectionSet.size()) {
                Object e = this.selectionSet.elementAt(n2);
                VScopeNode vScopeNode = (VScopeNode)e;
                nArray[n2] = this.getIndexForValue(vScopeNode);
                ++n2;
            }
            return nArray;
        }
        catch (Throwable throwable) {
            return new int[0];
        }
    }

    public VScopeNode getSelectedNavigationNode() {
        if (this.dataModel != null) {
            return this.dataModel.getSelectedNavigationNode();
        }
        return null;
    }

    public Vector getSelectedNodes() {
        if (this.selectionSet == null) {
            return null;
        }
        try {
            return (Vector)this.selectionSet.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    protected VScopeNode getValueForIndex(int n) {
        Point point = this.getPointForIndex(n);
        if (point == null) {
            return null;
        }
        return (VScopeNode)this.getValueAt(point.x, point.y);
    }

    protected VScopeNode getValueForPoint(int n, int n2) {
        try {
            if (this.detailsMode || this.listMode) {
                n2 = 0;
            }
            return (VScopeNode)this.getValueAt(n, n2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public VScopeNode getViewNodeAtIndex(int n) {
        try {
            int n2 = n;
            int n3 = 0;
            if (!this.detailsMode && !this.listMode) {
                int n4 = this.dataModel.getColumnCount();
                n3 = n % n4;
                n2 = n / n4;
            }
            Object object = this.dataModel.getValueAt(n2, n3);
            return (VScopeNode)object;
        }
        catch (Throwable throwable) {
            Debug.trace("VTable", Debug.WARNING, "Problem in getViewNodeAtIndex", throwable);
            return null;
        }
    }

    public void initHeader() {
        block2: {
            if (this.tableState == null || this.tableState.equals("details")) break block2;
            try {
                JScrollPane jScrollPane = (JScrollPane)this.getParent().getParent();
                jScrollPane.setColumnHeaderView(null);
            }
            catch (Exception exception) {}
        }
    }

    protected void initSelectionModel() {
        if (this.selectionSet == null) {
            this.selectionSet = new Vector();
        } else if (!this.maintainSelections) {
            this.selectionSet.removeAllElements();
        }
    }

    protected void initTable() {
        this.tableID = "vconsole.resultpane";
        this.tableUI = new VTableUI();
        this.tableUI.setSelectedFlag(this.tableID);
        this.tableUI.setProperties(this.properties);
        this.setUI(this.tableUI);
        this.setOpaque(false);
        this.setCellSelectionEnabled(true);
        this.setShowGrid(false);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.getTableHeader().setReorderingAllowed(false);
        this.establishRowHeight();
        this.cellRenderer = new VStyledTableCellRenderer();
        this.cellRenderer.setSelectedFlag(this.tableID);
        this.cellRenderer.setProperties(this.properties);
        this.cellRenderer.setHorizontalAlignment(2);
        this.headerRenderer = new VStyledTableHeaderRenderer();
        this.headerRenderer.setTableHeader(this.getTableHeader());
        this.setFont(ResourceManager.bodyFont);
        this.cellRenderer.setFont(ResourceManager.bodyFont);
        this.cellRenderer.setForeground(ResourceManager.bodyColor);
        this.headerRenderer.setFont(ResourceManager.labelFont);
        this.headerRenderer.setForeground(ResourceManager.labelColor);
        this.checkHeaderState();
        this.initSelectionModel();
    }

    public boolean isGridCellSelected(int n, int n2) {
        if (this.cellSelectionEnabled) {
            try {
                VScopeNode vScopeNode = this.getValueForPoint(n, n2);
                if (vScopeNode == null) {
                    return false;
                }
                return this.selectionSet.contains(vScopeNode);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.getRowSelectionAllowed() && this.isRowSelected(n) || this.getColumnSelectionAllowed() && this.isColumnSelected(n2);
    }

    public boolean isSelectedIndex(int n) {
        try {
            VScopeNode vScopeNode = this.getValueForIndex(n);
            if (vScopeNode == null || this.selectionSet == null) {
                return false;
            }
            return this.selectionSet.contains(vScopeNode);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isSelectionEmpty() {
        if (this.selectionSet == null) {
            return true;
        }
        return this.selectionSet.size() > 0;
    }

    protected void notifyOfSelection() {
        try {
            Object object;
            Vector vector = this.selectionSet;
            if (vector.size() > 0) {
                this.properties.setProperty("vconsole.deselectallenabled", "true");
                if (this.selectionMode == 0) {
                    this.properties.setProperty("vconsole.selectallenabled", "false");
                } else if (vector.size() == this.getNodeCount()) {
                    this.properties.setProperty("vconsole.selectallenabled", "false");
                } else {
                    this.properties.setProperty("vconsole.selectallenabled", "true");
                }
            } else {
                this.properties.setProperty("vconsole.deselectallenabled", "false");
                object = "true";
                if (this.selectionMode == 0) {
                    object = "false";
                }
                this.properties.setProperty("vconsole.selectallenabled", (String)object);
            }
            this.checkPropertiesSetting();
            object = new VConsoleEvent(this, "vconsole.scopechildselected", vector);
            this.dataModel.correlateViewAction((VConsoleEvent)object);
        }
        catch (Throwable throwable) {
            Debug.trace("VTable", Debug.WARNING, "Unexpected Exception", throwable);
        }
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        try {
            Object object = this.getValueAt(n, n2);
            boolean bl = false;
            if (this.selectionSet != null) {
                bl = this.selectionSet.contains(object);
            }
            boolean bl2 = this.getSelectedRow() == n;
            boolean bl3 = this.getSelectedColumn() == n2;
            boolean bl4 = n == this.recentRow && n2 == this.recentCol && this.hasFocus();
            return this.cellRenderer.getTableCellRendererComponent(this, object, bl, bl4, n, n2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block13: {
            Object object;
            String string;
            block20: {
                block19: {
                    block18: {
                        block16: {
                            String string2;
                            block17: {
                                block15: {
                                    block14: {
                                        if (propertyChangeEvent == null) {
                                            return;
                                        }
                                        string = propertyChangeEvent.getPropertyName();
                                        object = propertyChangeEvent.getNewValue();
                                        string2 = null;
                                        if (object instanceof String) {
                                            string2 = (String)object;
                                        }
                                        if (!string.equals("vconsole.currentselection")) break block14;
                                        this.currentSel = string2;
                                        this.validate();
                                        this.repaint();
                                        break block13;
                                    }
                                    if (!string.equals("vconsole.iconstyle")) break block15;
                                    this.tableState = string2;
                                    this.detailsMode = this.tableState.equals("details");
                                    this.listMode = this.tableState.equals("list");
                                    this.establishRowHeight();
                                    this.sizeWasChanged();
                                    break block13;
                                }
                                if (!string.equals("vconsole.sortedcolumn")) break block16;
                                if (!string2.equals("null")) break block17;
                                if (this.headerRenderer == null) break block13;
                                this.headerRenderer.setSorted(-1, true);
                                break block13;
                            }
                            boolean bl = string2.startsWith("+");
                            try {
                                String string3 = string2.substring(1);
                                int n = new Integer(string3);
                                if (this.headerRenderer != null) {
                                    this.headerRenderer.setSorted(n, bl);
                                }
                                break block13;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                            break block13;
                        }
                        if (!string.equals("vconsole.bodyfont")) break block18;
                        try {
                            this.setFont((Font)object);
                            this.cellRenderer.setFont((Font)object);
                            this.validate();
                            this.repaint();
                        }
                        catch (Throwable throwable) {}
                        break block13;
                    }
                    if (!string.equals("vconsole.bodycolor")) break block19;
                    try {
                        this.cellRenderer.setForeground((Color)object);
                        this.setForeground((Color)object);
                        this.validate();
                        this.repaint();
                    }
                    catch (Throwable throwable) {}
                    break block13;
                }
                if (!string.equals("vconsole.labelfont")) break block20;
                try {
                    this.headerRenderer.setFont((Font)object);
                    this.getTableHeader().validate();
                    this.getTableHeader().repaint();
                }
                catch (Throwable throwable) {}
                break block13;
            }
            if (!string.equals("vconsole.labelcolor")) break block13;
            try {
                this.headerRenderer.setForeground((Color)object);
                this.validate();
                this.repaint();
            }
            catch (Throwable throwable) {}
        }
    }

    public void removeSelectedNode(VScopeNode vScopeNode) {
        if (vScopeNode == null) {
            return;
        }
        try {
            this.selectionSet.removeElement(vScopeNode);
            this.notifyOfSelection();
        }
        catch (Exception exception) {}
    }

    public void removeSelectionInterval(int n, int n2) {
        try {
            int n3;
            if (n2 < n) {
                n3 = n;
                n = n2;
                n2 = n3;
            }
            n3 = n;
            while (n3 <= n2) {
                Point point = this.getPointForIndex(n3);
                try {
                    this.selectionSet.removeElement(this.getValueAt(point.x, point.y));
                }
                catch (Throwable throwable) {}
                ++n3;
            }
            this.notifyOfSelection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int rowAtPoint(Point point) {
        if (point == null) {
            return -1;
        }
        int n = point.y;
        int n2 = this.getRowHeight();
        int n3 = this.getIntercellSpacing().height;
        int n4 = n / (n2 += n3);
        if (n4 < 0) {
            return -1;
        }
        if (n4 >= this.recentRowCnt) {
            return -1;
        }
        return n4;
    }

    public void selectAll() {
        if (this.selectionMode == 0) {
            this.addSelectionInterval(0, 0);
        } else {
            this.selectAllSelectionModel();
        }
        this.notifyOfSelection();
    }

    public void selectAllSelectionModel() {
        try {
            this.initSelectionModel();
            if (this.selectionMode == 0) {
                this.selectionSet.addElement(this.getValueAt(0, 0));
            } else if (this.detailsMode || this.listMode) {
                int n = 0;
                while (n < this.recentRowCnt) {
                    this.selectionSet.addElement(this.getValueAt(n, 0));
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.recentRowCnt) {
                    int n2 = 0;
                    while (n2 < this.recentColCnt) {
                        Object object = this.getValueAt(n, n2);
                        if (object != null) {
                            this.selectionSet.addElement(object);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {}
        this.recentRow = 0;
        this.recentCol = 0;
    }

    public void setGridBoxSelected(int n, int n2, int n3, int n4, boolean bl) {
        try {
            int n5;
            int n6;
            int n7;
            int n8;
            if (bl) {
                this.initSelectionModel();
            }
            if (n < n3) {
                n8 = n;
                n7 = n3;
            } else {
                n8 = n3;
                n7 = n;
            }
            if (n2 < n4) {
                n6 = n2;
                n5 = n4;
            } else {
                n6 = n4;
                n5 = n2;
            }
            if (this.selectionMode == 0) {
                n5 = n6;
                n7 = n8;
            }
            int n9 = n8;
            while (n9 <= n7) {
                VScopeNode vScopeNode;
                if (n2 == n4 && (vScopeNode = this.getValueForPoint(n9, n2)) != null && !this.selectionSet.contains(vScopeNode)) {
                    this.selectionSet.addElement(vScopeNode);
                }
                int n10 = n6;
                while (n10 <= n5) {
                    VScopeNode vScopeNode2 = this.getValueForPoint(n9, n10);
                    if (vScopeNode2 != null && !this.selectionSet.contains(vScopeNode2)) {
                        this.selectionSet.addElement(vScopeNode2);
                    }
                    ++n10;
                }
                ++n9;
            }
            this.recentRow = n3;
            this.recentCol = n4;
        }
        catch (Exception exception) {}
        this.notifyOfSelection();
        this.validate();
        this.repaint();
    }

    public void setGridCellSelected(int n, int n2, boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            this.initSelectionModel();
        }
        if (this.detailsMode && n2 != 0) {
            return;
        }
        if (this.selectionMode == 0) {
            this.initSelectionModel();
            bl2 = false;
        }
        if (this.selectionSet == null) {
            this.initSelectionModel();
        }
        if (this.selectionSet.size() == 0) {
            this.recentRow = -1;
            this.recentCol = -1;
        }
        try {
            VScopeNode vScopeNode = this.getValueForPoint(n, n2);
            if (bl) {
                if (this.selectionSet.contains(vScopeNode)) {
                    this.selectionSet.remove(vScopeNode);
                } else {
                    this.selectionSet.addElement(vScopeNode);
                }
            } else if (!this.selectionSet.contains(vScopeNode)) {
                this.selectionSet.addElement(vScopeNode);
            }
            if (bl2 && (this.recentRow != n || this.recentCol != n2)) {
                int n3;
                int n4;
                int n5;
                int n6;
                if (this.recentRow < n) {
                    n6 = this.recentRow;
                    n5 = n;
                    n4 = this.recentCol;
                    n3 = n2;
                } else {
                    n6 = n;
                    n5 = this.recentRow;
                    if (this.recentRow == n) {
                        if (this.recentCol < n2) {
                            n4 = this.recentCol;
                            n3 = n2;
                        } else {
                            n4 = n2;
                            n3 = this.recentCol;
                        }
                    } else {
                        n4 = n2;
                        n3 = this.recentCol;
                    }
                }
                if (n6 != n5) {
                    int n7;
                    int n8 = n4;
                    while (n8 < this.recentColCnt) {
                        vScopeNode = this.getValueForPoint(n6, n8);
                        if (vScopeNode != null && !this.selectionSet.contains(vScopeNode)) {
                            this.selectionSet.addElement(vScopeNode);
                        }
                        ++n8;
                    }
                    while (++n6 < n5) {
                        n7 = 0;
                        while (n7 < this.recentColCnt) {
                            vScopeNode = this.getValueForPoint(n6, n7);
                            if (vScopeNode != null && !this.selectionSet.contains(vScopeNode)) {
                                this.selectionSet.addElement(vScopeNode);
                            }
                            ++n7;
                        }
                    }
                    n7 = 0;
                    while (n7 <= n3) {
                        vScopeNode = this.getValueForPoint(n6, n7);
                        if (vScopeNode != null && !this.selectionSet.contains(vScopeNode)) {
                            this.selectionSet.addElement(vScopeNode);
                        }
                        ++n7;
                    }
                } else {
                    int n9 = n4;
                    while (n9 <= n3) {
                        vScopeNode = this.getValueForPoint(n6, n9);
                        if (vScopeNode != null && !this.selectionSet.contains(vScopeNode)) {
                            this.selectionSet.addElement(vScopeNode);
                        }
                        ++n9;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.recentRow = n;
        this.recentCol = n2;
        this.notifyOfSelection();
        this.validate();
        this.repaint();
    }

    public void setModel(VConsoleModel vConsoleModel) {
        this.dataModel = vConsoleModel;
        this.selectionSet = new Vector();
        super.setModel(vConsoleModel);
        this.recentRowCnt = this.getRowCount();
        this.recentColCnt = this.getColumnCount();
        this.initTable();
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
            if (this.tableUI != null) {
                this.tableUI.setProperties(vConsoleProperties);
            }
            if (this.cellRenderer != null) {
                this.cellRenderer.setProperties(vConsoleProperties);
            }
            this.tableState = vConsoleProperties.getProperty("vconsole.iconstyle");
            this.detailsMode = this.tableState.equals("details");
            this.listMode = this.tableState.equals("list");
            this.currentSel = vConsoleProperties.getProperty("vconsole.currentselection");
            this.establishRowHeight();
            vConsoleProperties.setPropertyObject("vconsole.displaymodel", this);
        }
    }

    public void setSelectedNodes(Vector vector) {
        try {
            this.initSelectionModel();
            if (this.selectionMode == 0) {
                Object e = vector.elementAt(0);
                vector.removeAllElements();
                vector.addElement(e);
            }
            int n = 0;
            while (n < vector.size()) {
                Object e = vector.elementAt(n);
                if (e instanceof VScopeNode) {
                    int n2 = this.getIndexForValue((VScopeNode)e);
                    this.selectionSet.addElement(e);
                }
                ++n;
            }
            this.notifyOfSelection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSelectionInterval(int n, int n2) {
        this.initSelectionModel();
        this.addSelectionInterval(n, n2);
    }

    public void setSelectionMode(int n) {
        if (n == 2) {
            this.selectionMode = n;
        } else if (n == 0) {
            this.selectionMode = n;
            this.properties.setProperty("vconsole.selectallenabled", "false");
        }
    }

    public void setUI(TableUI tableUI) {
        if (this.ui != tableUI && tableUI instanceof VTableUI) {
            super.setUI(tableUI);
            this.repaint();
        }
    }

    public void sizeWasChanged() {
        this.maintainSelections = true;
        if (this.dataModel != null) {
            this.dataModel.tableWasResized();
        }
        this.maintainSelections = false;
    }

    public void suppressRebuild() {
        this.noRebuild = true;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.noRebuild) {
            this.invalidate();
            this.validate();
            this.repaint();
            this.noRebuild = false;
            return;
        }
        boolean bl = false;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
            }
            bl = true;
        } else if (tableModelEvent.getType() == 1) {
            this.vtableRowsInserted(tableModelEvent);
            bl = true;
        } else if (tableModelEvent.getType() == -1) {
            this.vtableRowsDeleted(tableModelEvent);
            bl = true;
        }
        if (bl) {
            this.recentRowCnt = this.getRowCount();
            this.recentColCnt = this.getColumnCount();
            this.checkHeaderState();
            this.initSelectionModel();
            this.establishHeader();
            return;
        }
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n2 == -1) {
            n2 = 0;
            n3 = Integer.MAX_VALUE;
        }
        int n4 = this.getRowHeight() + this.rowMargin;
        Rectangle rectangle = null;
        if (n == -1) {
            rectangle = new Rectangle(0, n2 * n4, this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int n5 = this.convertColumnIndexToView(n);
            rectangle = this.getCellRect(n2, n5, false);
        }
        if (n3 != Integer.MAX_VALUE) {
            rectangle.height = (n3 - n2 + 1) * n4;
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.resizeAndRepaint();
        }
        this.checkHeaderState();
        this.initSelectionModel();
        this.establishHeader();
    }

    protected void vtableRowsDeleted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        int n3 = tableModelEvent.getLastRow() - n2 + 1;
        int n4 = this.recentRowCnt + n3;
        int n5 = this.getRowHeight() + this.rowMargin;
        Rectangle rectangle = new Rectangle(0, n * n5, this.getColumnModel().getTotalColumnWidth(), (n4 - n) * n5);
        if (this.selectionModel != null) {
            if (n2 < 0) {
                n2 = this.recentRowCnt - 1;
            }
            this.selectionModel.removeIndexInterval(n, n2);
        }
        this.revalidate();
    }

    protected void vtableRowsInserted(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        int n3 = this.getRowHeight() + this.rowMargin;
        Rectangle rectangle = new Rectangle(0, n * n3, this.getColumnModel().getTotalColumnWidth(), (this.recentRowCnt - n) * n3);
        if (this.selectionModel != null) {
            if (n2 < 0) {
                n2 = this.recentRowCnt - 1;
            }
            int n4 = n2 - n + 1;
            this.selectionModel.insertIndexInterval(n, n4, true);
        }
        this.revalidate();
    }
}

