/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;

public class VStyledTreeCellRenderer
extends JLabel
implements TreeCellRenderer,
PropertyChangeListener {
    protected boolean selected;
    private boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected transient Icon rootIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    protected VConsoleProperties properties = null;
    protected String selectedFlag = "null";
    protected static ImageIcon defaultLeaf = null;
    protected static ImageIcon defaultFolder = null;
    protected static Class imageClass = null;
    protected String currentSel = null;

    public VStyledTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setOpaque(false);
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.VStyledTreeCellRenderer");
                defaultLeaf = ConsoleUtility.loadImageIcon("images/file16.gif", imageClass);
                defaultFolder = ConsoleUtility.loadImageIcon("images/folder16.gif", imageClass);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultLeafIcon() {
        return this.leafIcon;
    }

    public Icon getDefaultOpenIcon() {
        return this.openIcon;
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setEnabled(jTree.isEnabled());
        VScopeNode vScopeNode = null;
        try {
            vScopeNode = (VScopeNode)object;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return this;
        }
        this.hasFocus = bl4;
        this.setText(vScopeNode.getText());
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (vScopeNode != null && vScopeNode.getSmallIcon() != null) {
            ImageIcon imageIcon = vScopeNode.getSmallIcon();
            Image image = null;
            if (imageIcon != null) {
                image = imageIcon.getImage();
            }
            if (image == null || imageIcon.getIconWidth() <= 0) {
                if (vScopeNode.getChildCount() > 0) {
                    this.setIcon(defaultFolder);
                } else {
                    this.setIcon(defaultLeaf);
                }
            } else {
                this.setIcon(imageIcon);
            }
        } else if (bl3) {
            this.setIcon(defaultLeaf);
        } else {
            this.setIcon(defaultFolder);
        }
        this.setToolTipText(vScopeNode.getToolTipText());
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        Color color = null;
        if (this.currentSel == null) {
            this.currentSel = "";
        }
        if (this.selected) {
            color = this.currentSel.equals(this.selectedFlag) ? this.getBackgroundSelectionColor() : Color.lightGray;
        }
        int n = -1;
        if (color != null) {
            Icon icon = this.getIcon();
            n = this.getLabelStart();
            graphics.setColor(color);
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (n == -1) {
                n = this.getLabelStart();
            }
            graphics.setColor(this.getBorderSelectionColor());
            graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        }
        try {
            super.paint(graphics);
        }
        catch (Throwable throwable) {
            this.setIcon(null);
            super.paint(graphics);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        try {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("vconsole.currentselection")) {
                this.currentSel = (String)propertyChangeEvent.getNewValue();
            }
        }
        catch (Throwable throwable) {}
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        try {
            if (vConsoleProperties != null) {
                this.currentSel = vConsoleProperties.getProperty("vconsole.currentselection");
                vConsoleProperties.addPropertyChangeListener(this);
            }
        }
        catch (Exception exception) {}
    }

    public void setSelectedFlag(String string) {
        if (string != null) {
            this.selectedFlag = string;
        }
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }
}

