/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VOptionPaneContent
extends JPanel {
    protected JPanel emptyPanel = null;
    protected JLabel titleLabel = null;
    protected JPanel buttonPanel = null;
    protected JButton infoButton = null;
    protected VOptionPane optionPane = null;
    protected static Class imageClass = null;
    protected static ImageIcon controlIcon = null;
    protected underLinePanel headerControl = null;
    protected boolean showHeader = true;

    public VOptionPaneContent(VOptionPane vOptionPane) {
        this.optionPane = vOptionPane;
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.VOptionPaneContent");
                controlIcon = ConsoleUtility.loadImageIcon("images/Help24.gif", imageClass);
            }
        }
        catch (Exception exception) {}
        this.setLayout(new BorderLayout());
        this.headerControl = new underLinePanel();
        this.headerControl.setLayout(new BorderLayout());
        this.headerControl.setBorder(new EmptyBorder(2, 2, 1, 2));
        this.infoButton = new JButton(controlIcon);
        Dimension dimension = new Dimension(24, 24);
        this.infoButton.setMinimumSize(dimension);
        this.infoButton.setPreferredSize(dimension);
        this.infoButton.setMaximumSize(dimension);
        this.infoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    VOptionPaneContent.this.optionPane.toggleInfoPane(true);
                }
                catch (Exception exception) {}
            }
        });
        this.infoButton.setToolTipText(ResourceManager.getString("Show Help Pane"));
        this.infoButton.setCursor(Cursor.getPredefinedCursor(12));
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(ResourceManager.menuFont);
        this.titleLabel.setForeground(ResourceManager.sunBlue);
        this.titleLabel.setBorder(new EmptyBorder(3, 4, 4, 4));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.titleLabel, "East");
        this.headerControl.add((Component)this.buttonPanel, "West");
        this.add((Component)this.headerControl, "North");
        this.emptyPanel = new JPanel();
        this.emptyPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)this.emptyPanel, "Center");
        this.validate();
        this.repaint();
    }

    public void addToggleFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.infoButton.addFocusListener(focusListener);
    }

    public JComponent getContentPane() {
        return this.emptyPanel;
    }

    public Component getHeader() {
        return this.headerControl;
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void handleTab(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent);
    }

    public void setShowHeader(boolean bl) {
        this.showHeader = bl;
        if (!bl) {
            this.remove(this.headerControl);
            this.buttonPanel.remove(this.titleLabel);
        } else {
            this.buttonPanel.add((Component)this.titleLabel, "East");
            this.add((Component)this.headerControl, "North");
        }
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    public void setToggleHasDefaultFocus() {
        this.infoButton.requestDefaultFocus();
        this.infoButton.requestFocus();
    }

    public void toggleInfo(boolean bl) {
        try {
            if (bl) {
                this.buttonPanel.add((Component)this.infoButton, "West");
                if (!this.showHeader) {
                    this.add((Component)this.headerControl, "North");
                }
                this.infoButton.requestFocus();
            } else {
                this.buttonPanel.remove(this.infoButton);
                if (!this.showHeader) {
                    this.remove(this.headerControl);
                }
            }
        }
        catch (Exception exception) {}
        this.headerControl.setShowingToggle(bl);
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    class underLinePanel
    extends JPanel {
        protected boolean showingToggle = false;

        underLinePanel() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.showingToggle) {
                graphics.setColor(ResourceManager.sunBlue);
                Dimension dimension = this.getSize();
                int n = dimension.height - 1;
                graphics.drawLine(32, n, dimension.width - 4, n);
            } else {
                graphics.setColor(ResourceManager.sunBlue);
                Dimension dimension = this.getSize();
                int n = dimension.height - 1;
                graphics.drawLine(6, n, dimension.width - 4, n);
            }
        }

        public void setShowingToggle(boolean bl) {
            this.showingToggle = bl;
        }
    }
}

