/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.console.VConsole;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VSplashScreen;
import com.sun.management.viper.console.gui.help.VHelpViewer;
import com.sun.management.viper.console.gui.lf.VDefaultLF;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.tree.DefaultTreeModel;

public class VGUIConsole
extends VConsole {
    protected VHelpViewer helpViewer = null;
    protected Vector tbHistory = null;
    protected static int HISTORY_COUNT = 10;
    protected Container parentContainer = null;
    protected String consoleTitle = "VGUIConsole";

    protected void closeConsole() {
        if (this.parentContainer != null) {
            this.parentContainer.setVisible(false);
        }
        this.stopTool(this.currentTool);
        super.closeConsole();
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.scopeselected")) {
            this.properties.setProperty("vconsole.iconviewsenabled", "true");
            this.properties.setProperty("vconsole.filterenabled", "true");
            this.properties.setProperty("vconsole.findenabled", "true");
        }
        super.consoleAction(vConsoleEvent);
    }

    protected void createDialogs() {
        this.createHelpViewer();
    }

    protected void createHelpViewer() {
        this.helpViewer = new VHelpViewer();
        this.helpViewer.setProperties(this.properties);
        this.addConsoleActionListener(this.helpViewer);
        this.helpViewer.setContainer(new VFrame());
    }

    public String getConsoleTitle() {
        return this.consoleTitle;
    }

    public Container getContainer() {
        return this.parentContainer;
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    public boolean getShowingBusyState() {
        if (this.parentContainer instanceof VContainer) {
            VContainer vContainer = (VContainer)((Object)this.parentContainer);
            return vContainer.getShowingBusyState();
        }
        return false;
    }

    protected void installLookAndFeel() {
        super.setLookAndFeel(new VDefaultLF());
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(true);
        VSplashScreen vSplashScreen = new VSplashScreen("Viper GUI Console");
        vSplashScreen.setTextFont(new Font("SansSerif", 0, 20));
        vSplashScreen.show();
        try {
            VGUIConsole vGUIConsole = new VGUIConsole();
            vGUIConsole.init(null);
            VFrame vFrame = new VFrame();
            vGUIConsole.setContainer(vFrame);
            vSplashScreen.dispose();
            vFrame.showCenter(null);
            vGUIConsole.start();
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.ERROR, "Could not run standalone VGUIConsole", throwable);
        }
    }

    protected void maintainTBHistory(String string) {
        if (string == null || this.properties == null) {
            return;
        }
        try {
            String string2 = this.properties.getProperty("vconsole.toolboxhistory");
            if (string2 == null || string2.length() == 0 || string2.equals("null")) {
                string2 = "";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = stringTokenizer.countTokens();
            String string3 = new String(string);
            Vector<String> vector = new Vector<String>();
            vector.addElement(string);
            int n2 = n;
            if (n == HISTORY_COUNT) {
                n2 = n - 1;
            }
            int n3 = 0;
            while (n3 < n) {
                String string4 = stringTokenizer.nextToken();
                boolean bl = false;
                int n4 = 0;
                while (n4 < vector.size()) {
                    String string5 = (String)vector.elementAt(n4);
                    if (string4.equals(string5)) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl) {
                    vector.addElement(string4);
                    string3 = String.valueOf(string3) + "," + string4;
                }
                ++n3;
            }
            this.properties.setProperty("vconsole.toolboxhistory", string3);
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Problem in VGUIConsole.maintainTBHistory()", throwable);
        }
    }

    public void newConsole(VScopeNode vScopeNode) {
        if (this.properties == null) {
            return;
        }
        this.showBusyState(true);
        try {
            Serializable serializable;
            VConsoleActionListener vConsoleActionListener;
            Object object;
            if (vScopeNode != null && VConsole.consoleSet != null && VConsole.consoleSet.size() > 0) {
                int n = 0;
                while (n < VConsole.consoleSet.size()) {
                    object = (VGUIConsole)VConsole.consoleSet.elementAt(n);
                    vConsoleActionListener = ((VConsole)object).getModel();
                    if (vConsoleActionListener != null && (serializable = (VScopeNode)((DefaultTreeModel)((Object)vConsoleActionListener)).getRoot()) == vScopeNode) {
                        ((VGUIConsole)object).getContainer().setVisible(true);
                        this.showBusyState(false);
                        return;
                    }
                    ++n;
                }
            }
            Point point = this.parentContainer.getLocationOnScreen();
            point = new Point(point.x + 20, point.y + 20);
            object = this.getClass();
            vConsoleActionListener = (VGUIConsole)((Class)object).newInstance();
            ((VConsole)vConsoleActionListener).init(null);
            serializable = new VFrame();
            ((VGUIConsole)vConsoleActionListener).setContainer((Container)serializable);
            ((Component)serializable).setLocation(point);
            ((Component)serializable).setVisible(true);
            ((Container)serializable).validate();
            ((Component)serializable).repaint();
            if (vScopeNode != null) {
                ((VGUIConsole)vConsoleActionListener).setModel(new VConsoleModel(vScopeNode));
            }
            ((VGUIConsole)vConsoleActionListener).start();
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.ERROR, "Could not create new console", throwable);
        }
        this.showBusyState(false);
    }

    protected void parentContainerResized() {
        if (this.parentContainer != null && this.properties != null) {
            Dimension dimension = this.parentContainer.getSize();
            this.properties.setProperty("vconsole.size", dimension.width + "," + dimension.height);
        }
    }

    protected int promptUserToExitAllConsoles() {
        return JOptionPane.showConfirmDialog(this.parentContainer, ResourceManager.getString("Are you sure you want to close all consoles and exit?"), ResourceManager.getString("Exit all consoles?"), 0);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        try {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("vconsole.currenttoolbox")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.maintainTBHistory(string2);
            } else if (string.equals("vconsole.working")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                this.showBusyState(string3.equals("true"));
            }
        }
        catch (Throwable throwable) {}
    }

    public void setConsoleTitle(String string) {
        this.consoleTitle = string;
    }

    public void setContainer(Container container) {
        Object object;
        if (container == null) {
            return;
        }
        this.parentContainer = container;
        this.parentContainer.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                VGUIConsole.this.parentContainerResized();
            }
        });
        if (this.properties == null) {
            return;
        }
        try {
            object = this.properties.getProperty("vconsole.size");
            int n = ((String)object).indexOf(",");
            String string = ((String)object).substring(0, n);
            String string2 = ((String)object).substring(n + 1, ((String)object).length());
            container.setSize(new Dimension(Integer.parseInt(string), Integer.parseInt(string2)));
        }
        catch (Throwable throwable) {
            container.setSize(this.getPreferredSize());
        }
        if (container instanceof JFrame) {
            object = (JFrame)container;
            ((Frame)object).setTitle(this.getConsoleTitle());
            this.properties.setProperty("vconsole.dialogtype", "vconsole.frame");
            this.properties.setPropertyObject("vconsole.frame", container);
            ((Window)object).addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    VGUIConsole.this.closeConsole();
                }
            });
            if (this.currentLF != null) {
                ((JFrame)object).getContentPane().removeAll();
                ((JFrame)object).getContentPane().setLayout(new BorderLayout());
                ((JFrame)object).getContentPane().add(this.currentLF.getComponent(), "Center");
                ((Container)object).validate();
                ((Component)object).repaint();
            }
        } else if (container instanceof JDialog) {
            object = (JDialog)container;
            ((Dialog)object).setTitle(this.getConsoleTitle());
            this.properties.setProperty("vconsole.dialogtype", "vconsole.frame");
            this.properties.setPropertyObject("vconsole.frame", container);
            ((Window)object).addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    VGUIConsole.this.closeConsole();
                }
            });
            if (this.currentLF != null) {
                ((JDialog)object).getContentPane().removeAll();
                ((JDialog)object).getContentPane().setLayout(new BorderLayout());
                ((JDialog)object).getContentPane().add(this.currentLF.getComponent(), "Center");
                ((Container)object).validate();
                ((Component)object).repaint();
            }
        } else if (container instanceof JInternalFrame) {
            object = (JInternalFrame)container;
            ((JInternalFrame)object).setTitle(this.getConsoleTitle());
            this.properties.setProperty("vconsole.dialogtype", "vconsole.internalframe");
            this.properties.setPropertyObject("vconsole.internalframe", container);
            this.properties.setPropertyObject("vconsole.desktoppane", ((JInternalFrame)object).getDesktopPane());
            ((JInternalFrame)object).addInternalFrameListener(new InternalFrameAdapter(){

                public void windowClosing(InternalFrameEvent internalFrameEvent) {
                    VGUIConsole.this.closeConsole();
                }
            });
            if (this.currentLF != null) {
                ((JInternalFrame)object).getContentPane().removeAll();
                ((JInternalFrame)object).getContentPane().setLayout(new BorderLayout());
                ((JInternalFrame)object).getContentPane().add(this.currentLF.getComponent(), "Center");
                ((Container)object).validate();
                ((Component)object).repaint();
            }
        }
    }

    public void setModel(VConsoleModel vConsoleModel) {
        String string = "";
        try {
            Serializable serializable;
            if (vConsoleModel != null) {
                serializable = (VScopeNode)vConsoleModel.getRoot();
                string = ((VScopeNode)serializable).getText();
            }
            if (this.parentContainer != null && this.parentContainer instanceof Frame) {
                serializable = (Frame)this.parentContainer;
                String string2 = ((Frame)serializable).getTitle();
                int n = string2.indexOf(":");
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                string2 = string2.trim();
                ((Frame)serializable).setTitle(String.valueOf(string) + ": " + string2);
            }
        }
        catch (Throwable throwable) {
            Debug.trace("Console", Debug.WARNING, "Problem setting console model in VGUIConsole.", throwable);
        }
        super.setModel(vConsoleModel);
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        super.setProperties(vConsoleProperties);
        this.installLookAndFeel();
        if (this.helpViewer != null) {
            this.helpViewer.setProperties(vConsoleProperties);
        }
    }

    protected void showAboutInfo() {
    }

    public void showBusyState(boolean bl) {
        if (this.parentContainer instanceof VContainer) {
            VContainer vContainer = (VContainer)((Object)this.parentContainer);
            vContainer.showBusyState(bl);
        }
    }

    protected void showHelpIndex() {
        if (this.helpViewer == null) {
            this.createHelpViewer();
        }
        if (this.helpViewer != null) {
            this.helpViewer.showCenter(null);
            this.helpViewer.index();
        }
    }

    protected void showHelpOverview() {
        if (this.helpViewer == null) {
            this.createHelpViewer();
        }
        if (this.helpViewer != null) {
            this.helpViewer.showCenter(null);
            this.helpViewer.overview();
        }
    }

    protected void showHelpSearch() {
        if (this.helpViewer == null) {
            this.createHelpViewer();
        }
        if (this.helpViewer != null) {
            this.helpViewer.showCenter(null);
            this.helpViewer.search();
        }
    }

    protected void showHelpTOC() {
        if (this.helpViewer == null) {
            this.createHelpViewer();
        }
        if (this.helpViewer != null) {
            this.helpViewer.showCenter(null);
            this.helpViewer.toc();
        }
    }

    protected void showHelpViewer() {
        if (this.helpViewer == null) {
            this.createHelpViewer();
        }
        if (this.helpViewer != null) {
            this.helpViewer.showCenter(null);
        }
    }

    public void start() throws CriticalStopException {
        this.createDialogs();
        super.start();
    }
}

