/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDefaultFilter;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.VStyledTableHeaderRenderer;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VFindPane
extends VOptionPane
implements PropertyChangeListener,
VConsoleActionListener {
    protected VDefaultFilter defaultFilter = null;
    protected Vector listeners = null;
    protected VFilter filter = null;
    protected Action filterAction = null;
    protected JButton findButton = null;
    protected JButton closeButton = null;
    protected JButton gotoButton = null;
    protected JLabel totalItemsLabel = null;
    protected JLabel resultsLabel = null;
    protected JTextField itemField = null;
    protected JPanel cPane = null;
    protected VConsoleProperties properties = null;
    protected VDisplayModel displayModel = null;
    protected VConsoleModel dataModel = null;
    protected VScopeNode selNode = null;
    protected VScopeNode findSelection = null;
    protected JTable table = null;
    protected Vector tableData = null;
    protected String nameColumn = null;
    protected String descColumn = null;

    public VFindPane() {
        JComponent jComponent;
        JComponent jComponent2 = super.getContentPane();
        this.filterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VFindPane.this.findButton != null) {
                    VFindPane.this.findButton.doClick();
                }
            }

            public void setEnabled(boolean bl) {
                if (VFindPane.this.findButton != null) {
                    VFindPane.this.findButton.setEnabled(bl);
                }
            }
        };
        this.findButton = new JButton();
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VFilter vFilter = VFindPane.this.filter;
                VScopeNode vScopeNode = VFindPane.this.selNode;
                if (vFilter == VFindPane.this.defaultFilter) {
                    vScopeNode = null;
                }
                if (vFilter != null) {
                    Vector vector = vFilter.applyFilter(vScopeNode);
                    VFindPane.this.setFindResults(vector);
                }
            }
        });
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VFindPane.super.cancelAction();
            }
        });
        this.getButtonPane().add(this.findButton);
        this.getButtonPane().add(this.closeButton);
        this.cPane = new JPanel();
        jComponent2.setLayout(new BoxLayout(super.getContentPane(), 1));
        jComponent2.add(this.cPane);
        JPanel jPanel = new JPanel(){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.lightGray);
                graphics.fill3DRect(0, 2, this.getSize().width, 4, true);
            }
        };
        jPanel.setBorder(new EmptyBorder(2, 0, 2, 0));
        jComponent2.add(jPanel);
        this.resultsLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.resultsLabel);
        jPanel2.add(Box.createHorizontalGlue());
        jComponent2.add(jPanel2);
        jComponent2.add(Box.createVerticalStrut(5));
        this.nameColumn = ResourceManager.getString("Name");
        this.descColumn = ResourceManager.getString("Description");
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 2;
            }

            public String getColumnName(int n) {
                if (n == 0) {
                    return VFindPane.this.nameColumn;
                }
                return VFindPane.this.descColumn;
            }

            public int getRowCount() {
                try {
                    return VFindPane.this.tableData.size();
                }
                catch (Throwable throwable) {
                    return 0;
                }
            }

            public Object getValueAt(int n, int n2) {
                try {
                    VScopeNode vScopeNode = (VScopeNode)VFindPane.this.tableData.elementAt(n);
                    if (n2 != 0) {
                        return vScopeNode.getDescription();
                    }
                    return new JLabel(vScopeNode.getText(), vScopeNode.getSmallIcon(), 2);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
            }
        };
        this.table = new JTable(abstractTableModel){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                try {
                    int n = this.getSelectedRow();
                    VFindPane.this.findSelection = null;
                    VFindPane.this.gotoButton.setEnabled(false);
                    if (n == -1) {
                        return;
                    }
                    VFindPane.this.gotoButton.setEnabled(true);
                    VFindPane.this.findSelection = (VScopeNode)VFindPane.this.tableData.elementAt(n);
                }
                catch (Throwable throwable) {}
            }
        };
        this.table.setShowGrid(true);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            protected void setValue(Object object) {
                if (object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.setText(jLabel.getText());
                    this.setIcon(jLabel.getIcon());
                }
            }
        };
        VStyledTableHeaderRenderer vStyledTableHeaderRenderer = new VStyledTableHeaderRenderer();
        vStyledTableHeaderRenderer.setHorizontalAlignment(2);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn.setHeaderRenderer(vStyledTableHeaderRenderer);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        try {
            jComponent = (DefaultTableCellRenderer)tableColumn.getHeaderRenderer();
            ((JLabel)jComponent).setHorizontalAlignment(2);
        }
        catch (Exception exception) {}
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setPreferredWidth(200);
        tableColumn.setHeaderRenderer(vStyledTableHeaderRenderer);
        try {
            jComponent = (DefaultTableCellRenderer)tableColumn.getHeaderRenderer();
            ((JLabel)jComponent).setHorizontalAlignment(2);
        }
        catch (Exception exception) {}
        this.table.getTableHeader().setReorderingAllowed(false);
        jComponent = new JScrollPane(this.table);
        jComponent.setBackground(Color.white);
        ((JScrollPane)jComponent).getViewport().setBackground(Color.white);
        ((JScrollPane)jComponent).setCorner("UPPER_RIGHT_CORNER", new JPanel());
        JPanel jPanel3 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 200);
            }
        };
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBackground(Color.white);
        jPanel3.add((Component)jComponent, "Center");
        jComponent2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.gotoButton = new JButton();
        this.gotoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VFindPane.this.findSelection == null) {
                    return;
                }
                if (VFindPane.this.findSelection.getParent() != VFindPane.this.selNode) {
                    if (VFindPane.this.displayModel == null) {
                        VFindPane.this.getDisplayModel();
                    }
                    Vector<VScopeNode> vector = new Vector<VScopeNode>(1);
                    vector.addElement(VFindPane.this.findSelection);
                    VFindPane.this.displayModel.setSelectedNodes(vector);
                    if (VFindPane.this.container != null) {
                        VFindPane.this.container.setVisible(false);
                    }
                    return;
                }
                VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.scopeselected", VFindPane.this.findSelection);
                VFindPane.this.notifyListeners(vConsoleEvent);
                if (VFindPane.this.container != null) {
                    VFindPane.this.container.setVisible(false);
                }
            }
        });
        this.gotoButton.setEnabled(false);
        jPanel4.add((Component)this.gotoButton, "West");
        this.totalItemsLabel = new JLabel();
        this.totalItemsLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.itemField = new JTextField(4);
        this.itemField.setEditable(false);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)this.totalItemsLabel, "West");
        jPanel5.add((Component)this.itemField, "East");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel4, "West");
        jPanel6.add((Component)jPanel5, "East");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jPanel6, "South");
        jComponent2.add(jPanel7);
        this.defaultFilter = new VDefaultFilter();
        this.defaultFilter.setFindMode(true);
        this.defaultFilter.setOptionPane(this);
        this.defaultFilter.setFilterAction(this.filterAction);
        this.filter = this.defaultFilter;
        this.installStrings();
        this.updateFontAndColor();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        try {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.addElement(vConsoleActionListener);
            this.defaultFilter.addConsoleActionListener(vConsoleActionListener);
        }
        catch (Exception exception) {}
    }

    public void buildTestModel() {
        Vector<VScopeNode> vector = new Vector<VScopeNode>();
        int n = 0;
        while (n < 15) {
            VScopeNode vScopeNode = new VScopeNode();
            vScopeNode.setText("Test Node " + n);
            vScopeNode.setDescription("Test Node Description " + n);
            vector.addElement(vScopeNode);
            ++n;
        }
        this.setFindResults(vector);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        try {
            this.defaultFilter.consoleAction(vConsoleEvent);
            String string = vConsoleEvent.getID();
            if (string.equals("vconsole.scopeselected")) {
                VScopeNode vScopeNode = (VScopeNode)vConsoleEvent.getPayload();
                if (vScopeNode == null) {
                    this.selNode = vScopeNode;
                    return;
                }
                if (this.selNode != null && this.selNode != vScopeNode) {
                    this.filter.clearFilter();
                    this.setFindResults(null);
                }
                this.selNode = vScopeNode;
            }
        }
        catch (Exception exception) {}
    }

    public JComponent getContentPane() {
        return this.cPane;
    }

    protected void getDisplayModel() {
        if (this.properties == null) {
            return;
        }
        try {
            this.displayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
        }
        catch (Throwable throwable) {}
    }

    protected void installStrings() {
        this.gotoButton.setText(ResourceManager.getString("Go To Item"));
        this.gotoButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("Go To Item_access_name"));
        this.gotoButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("Go To Item_access_desc"));
        this.findButton.setText(ResourceManager.getString("FIND_BUTTON"));
        this.findButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("FIND_BUTTON_access_name"));
        this.findButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("FIND_BUTTON_access_desc"));
        this.closeButton.setText(ResourceManager.getString("CLOSE_BUTTON"));
        this.closeButton.getAccessibleContext().setAccessibleName(ResourceManager.getString("CLOSE_BUTTON_access_name"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString("CLOSE_BUTTON_access_desc"));
        this.resultsLabel.setText(ResourceManager.getString("Find Results"));
        this.totalItemsLabel.setText(ResourceManager.getString("Total Items:"));
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(true);
        JDialog jDialog = new JDialog(new JFrame(), "", true);
        VFindPane vFindPane = new VFindPane();
        vFindPane.buildTestModel();
        vFindPane.setContainer(jDialog);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        ((Component)jDialog).setVisible(true);
        System.exit(0);
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.menufont") || string.equals("vconsole.menucolor") || string.equals("vconsole.labelfont") || string.equals("vconsole.labelcolor") || string.equals("vconsole.bodyfont") || string.equals("vconsole.bodycolor")) {
            this.updateFontAndColor();
        }
    }

    protected void setFindResults(Vector vector) {
        this.findSelection = null;
        this.tableData = vector;
        if (this.table == null) {
            return;
        }
        this.table.clearSelection();
        try {
            ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        }
        catch (Exception exception) {}
        this.itemField.setText(" ");
        if (vector != null) {
            this.itemField.setText(" " + vector.size());
        }
        this.gotoButton.setEnabled(false);
    }

    public void setModel(VConsoleModel vConsoleModel) {
        try {
            this.dataModel = vConsoleModel;
            this.defaultFilter.setModel(vConsoleModel);
        }
        catch (Exception exception) {}
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        this.filter.setProperties(vConsoleProperties);
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
            this.getDisplayModel();
        }
    }

    protected void updateFontAndColor() {
        this.resultsLabel.setFont(ResourceManager.labelFont);
        this.resultsLabel.setForeground(ResourceManager.labelColor);
        this.totalItemsLabel.setFont(ResourceManager.labelFont);
        this.totalItemsLabel.setForeground(ResourceManager.labelColor);
        this.gotoButton.setFont(ResourceManager.menuFont);
        this.gotoButton.setForeground(ResourceManager.menuColor);
        this.table.setFont(ResourceManager.bodyFont);
        this.table.setForeground(ResourceManager.bodyColor);
        this.findButton.setFont(ResourceManager.menuFont);
        this.findButton.setForeground(ResourceManager.menuColor);
        this.closeButton.setFont(ResourceManager.menuFont);
        this.closeButton.setForeground(ResourceManager.menuColor);
    }
}

