/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBaseFilter;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.VSearch;
import com.sun.management.viper.console.gui.VSearchCriteria;
import com.sun.management.viper.console.gui.lf.VNavTreeCombo;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class VDefaultFilter
extends VBaseFilter
implements PropertyChangeListener,
VConsoleActionListener {
    protected JTextField lookForField = null;
    protected JTextField omitField = null;
    protected JRadioButton lookForAnd = new JRadioButton();
    protected JRadioButton lookForOr = new JRadioButton();
    protected JRadioButton omitAnd = null;
    protected JRadioButton omitOr = null;
    protected JCheckBox lookForMatch = null;
    protected JCheckBox omitMatch = null;
    protected VNavTreeCombo lookIn = null;
    protected Vector listeners = null;
    protected JLabel lookInLabel = null;
    protected JLabel showLabel = null;
    protected JLabel omitLabel = null;

    public VDefaultFilter() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lookForAnd);
        buttonGroup.add(this.lookForOr);
        this.lookForAnd.setSelected(true);
        this.lookForMatch = new JCheckBox();
        this.omitAnd = new JRadioButton();
        this.omitOr = new JRadioButton();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.omitAnd);
        buttonGroup.add(this.omitOr);
        this.omitAnd.setSelected(true);
        this.omitMatch = new JCheckBox();
        this.lookIn = new VNavTreeCombo();
        this.lookForField = new JTextField(15);
        this.omitField = new JTextField(15);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VDefaultFilter.this.filterControl != null) {
                    VDefaultFilter.this.filterControl.actionPerformed(null);
                }
            }
        };
        this.lookForField.addActionListener(actionListener);
        this.omitField.addActionListener(actionListener);
        this.installStrings();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    public Vector applyFilter(VScopeNode vScopeNode) {
        if (vScopeNode == null && (vScopeNode = this.lookIn.getSelectedNode()) != null) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent(this, "vconsole.scopeselected", vScopeNode);
            this.notifyListeners(vConsoleEvent);
        }
        this.filteredContents = this.returnMatches(vScopeNode);
        return this.filteredContents;
    }

    protected void clearInputFields() {
        try {
            this.lookForField.setText("");
            this.omitField.setText("");
            this.lookForAnd.setSelected(true);
            this.omitAnd.setSelected(true);
            this.lookForMatch.setSelected(false);
            this.omitMatch.setSelected(false);
        }
        catch (Throwable throwable) {}
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (this.lookIn != null) {
            this.lookIn.consoleAction(vConsoleEvent);
        }
    }

    public VSearchCriteria getSearchCriteria() {
        try {
            return new VSearchCriteria(this.lookForField.getText(), this.omitField.getText(), this.lookForMatch.isSelected(), this.omitMatch.isSelected(), this.lookForAnd.isSelected(), this.omitAnd.isSelected());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void installFilterModeStrings() {
        this.showLabel.setText(ResourceManager.getString("Show:"));
        this.omitLabel.setText(ResourceManager.getString("Omit:"));
        this.lookInLabel.setText(ResourceManager.getString("Display In:"));
    }

    protected void installFindModeStrings() {
        this.showLabel.setText(ResourceManager.getString("Look For:"));
        this.omitLabel.setText(ResourceManager.getString("Omit:"));
        this.lookInLabel.setText(ResourceManager.getString("Look In:"));
    }

    protected void installStrings() {
        this.lookForAnd.setText(ResourceManager.getString("And"));
        this.lookForOr.setText(ResourceManager.getString("Or"));
        this.lookForMatch.setText(ResourceManager.getString("Match Case"));
        this.omitAnd.setText(ResourceManager.getString("And"));
        this.omitOr.setText(ResourceManager.getString("Or"));
        this.omitMatch.setText(ResourceManager.getString("Match Case"));
    }

    protected void layoutInFilterMode() {
        this.removeAll();
        this.clearInputFields();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 12, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.lookInLabel = new JLabel();
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(this.lookInLabel);
        jPanel2.add(Box.createVerticalStrut(30));
        this.showLabel = new JLabel();
        jPanel2.add(this.showLabel);
        jPanel2.add(Box.createVerticalStrut(40));
        this.omitLabel = new JLabel();
        jPanel2.add(this.omitLabel);
        jPanel2.add(Box.createVerticalStrut(20));
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(5, 12, 0, 10));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.lookIn, "North");
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(20));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.lookForField, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(this.lookForAnd);
        jPanel6.add(this.lookForOr);
        jPanel6.add(Box.createHorizontalStrut(10));
        jPanel6.add(this.lookForMatch);
        jPanel5.add((Component)jPanel6, "Center");
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createVerticalStrut(15));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this.omitField, "North");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(this.omitAnd);
        jPanel8.add(this.omitOr);
        jPanel8.add(Box.createHorizontalStrut(10));
        jPanel8.add(this.omitMatch);
        jPanel7.add((Component)jPanel8, "Center");
        jPanel3.add(jPanel7);
        jPanel3.add(Box.createVerticalStrut(10));
        jPanel.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "North");
        this.add((Component)new JPanel(), "Center");
        this.setContextHelp();
        this.installFindModeStrings();
        this.updateFontAndColor();
        this.validate();
        this.repaint();
    }

    protected void layoutInFindMode() {
        this.removeAll();
        this.clearInputFields();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 12, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.lookInLabel = new JLabel();
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(this.lookInLabel);
        jPanel2.add(Box.createVerticalStrut(24));
        this.showLabel = new JLabel();
        jPanel2.add(this.showLabel);
        jPanel2.add(Box.createVerticalStrut(20));
        this.omitLabel = new JLabel();
        jPanel2.add(this.omitLabel);
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(5, 12, 0, 10));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.lookIn, "North");
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.lookForField, "North");
        jPanel5.add(jPanel6);
        jPanel5.add(Box.createHorizontalStrut(5));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this.lookForAnd, "North");
        jPanel5.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)this.lookForOr, "North");
        jPanel5.add(jPanel8);
        jPanel5.add(Box.createHorizontalStrut(10));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.lookForMatch, "North");
        jPanel5.add(jPanel9);
        jPanel3.add(Box.createVerticalStrut(15));
        jPanel3.add(jPanel5);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add((Component)this.omitField, "North");
        jPanel10.add(jPanel11);
        jPanel10.add(Box.createHorizontalStrut(5));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.add((Component)this.omitAnd, "North");
        jPanel10.add(jPanel12);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout());
        jPanel13.add((Component)this.omitOr, "North");
        jPanel10.add(jPanel13);
        jPanel10.add(Box.createHorizontalStrut(10));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout());
        jPanel14.add((Component)this.omitMatch, "North");
        jPanel10.add(jPanel14);
        jPanel3.add(Box.createVerticalStrut(12));
        jPanel3.add(jPanel10);
        jPanel.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "North");
        this.add((Component)new JPanel(), "Center");
        this.setContextHelp();
        this.installFindModeStrings();
        this.updateFontAndColor();
        this.validate();
        this.repaint();
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed(true);
        JDialog jDialog = new JDialog(new JFrame(), "", true);
        VDefaultFilter vDefaultFilter = new VDefaultFilter();
        vDefaultFilter.setFindMode(stringArray.length == 0);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add(vDefaultFilter);
        jDialog.pack();
        jDialog.show();
        System.exit(0);
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (this.listeners == null || vConsoleEvent == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.labelfont") || string.equals("vconsole.labelcolor")) {
            this.updateFontAndColor();
        } else if (string.equals("vconsole.bodyfont") || string.equals("vconsole.bodycolor")) {
            this.updateFontAndColor();
        }
    }

    protected Vector returnMatches(VScopeNode vScopeNode) {
        VSearchCriteria vSearchCriteria = this.getSearchCriteria();
        if (vSearchCriteria != null) {
            return VSearch.applySearch(vScopeNode, vSearchCriteria);
        }
        return null;
    }

    protected void setContextHelp() {
        if (this.optionPane == null) {
            return;
        }
        if (this.findMode) {
            this.optionPane.setHelpHTML(ContextHelpLoader.getContextHelp(ResourceManager.getString("FindHTMLHelp"), null));
        } else {
            this.optionPane.setHelpHTML(ContextHelpLoader.getContextHelp(ResourceManager.getString("FilterHTMLHelp"), null));
        }
    }

    public void setFindMode(boolean bl) {
        this.findMode = bl;
        if (this.findMode) {
            this.layoutInFindMode();
        } else {
            this.layoutInFilterMode();
        }
    }

    public void setModel(VConsoleModel vConsoleModel) {
        if (this.lookIn != null) {
            this.lookIn.setModel(vConsoleModel);
        }
    }

    public void setOptionPane(VOptionPane vOptionPane) {
        this.optionPane = vOptionPane;
        if (vOptionPane == null) {
            return;
        }
        vOptionPane.getContentPane().setLayout(new BorderLayout());
        vOptionPane.getContentPane().add((Component)this, "Center");
        if (this.findMode) {
            vOptionPane.setContentTitle(ResourceManager.getString("Find Criteria"));
            vOptionPane.setTitle(ResourceManager.getString("Find"));
        } else {
            vOptionPane.setContentTitle(ResourceManager.getString("Filter Criteria"));
            vOptionPane.setTitle(ResourceManager.getString("Filter"));
        }
        this.setContextHelp();
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
        }
    }

    protected void updateFontAndColor() {
        this.lookForAnd.setFont(ResourceManager.labelFont);
        this.lookForAnd.setForeground(ResourceManager.bodyColor);
        this.lookForOr.setFont(ResourceManager.labelFont);
        this.lookForOr.setForeground(ResourceManager.bodyColor);
        this.lookForMatch.setFont(ResourceManager.labelFont);
        this.lookForMatch.setForeground(ResourceManager.bodyColor);
        this.omitAnd.setFont(ResourceManager.labelFont);
        this.omitAnd.setForeground(ResourceManager.bodyColor);
        this.omitOr.setFont(ResourceManager.labelFont);
        this.omitOr.setForeground(ResourceManager.bodyColor);
        this.omitMatch.setFont(ResourceManager.labelFont);
        this.omitMatch.setForeground(ResourceManager.bodyColor);
        this.lookForField.setFont(ResourceManager.bodyFont);
        this.lookForField.setForeground(ResourceManager.bodyColor);
        this.omitField.setFont(ResourceManager.bodyFont);
        this.omitField.setForeground(ResourceManager.bodyColor);
        this.lookIn.setFont(ResourceManager.bodyFont);
        this.lookInLabel.setFont(ResourceManager.labelFont);
        this.lookInLabel.setForeground(ResourceManager.labelColor);
        this.showLabel.setFont(ResourceManager.labelFont);
        this.showLabel.setForeground(ResourceManager.labelColor);
        this.omitLabel.setFont(ResourceManager.labelFont);
        this.omitLabel.setForeground(ResourceManager.labelColor);
    }
}

