/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viper.console.gui;

import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VDefaultResultPane;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VTablePane;
import com.sun.management.viper.console.gui.VTreePane;
import com.sun.management.viper.console.gui.lf.VInfoPane;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.MutableTreeNode;

public class VConsoleNavigator
extends JPanel
implements Serializable,
VConsoleActionListener,
PropertyChangeListener {
    protected transient VConsoleModel consoleModel = null;
    protected VTablePane tablePane = null;
    protected VTreePane treePane = null;
    protected VInfoPane infoPane = null;
    protected Component centerPane = null;
    protected JLabel navLabel = null;
    protected JLabel infoLabel = null;
    protected JPanel navPane = null;
    protected JPanel resultPane = null;
    protected Component nodeResultPane = null;
    protected VConsoleProperties properties = null;
    protected Vector listeners = null;
    protected VScopeNode selNode = null;
    protected static VDefaultResultPane defResultPane = null;
    public static final int HORIZONTAL_LAYOUT = 10;
    public static final int VERTICAL_LAYOUT = 20;
    protected boolean infoOn = true;
    protected boolean scopeOn = true;
    protected int currentLayout = 10;
    protected JSplitPane hPane = null;
    protected JSplitPane vPane = null;
    protected Component tempVPane = null;
    protected Component tempHPane = null;
    protected int hPaneLoc = 220;
    protected int vPaneLoc = 290;
    protected int INFOHEIGHT = 130;

    public VConsoleNavigator() {
        this.addComponentListener(new resizeListener());
        this.infoPane = new VInfoPane();
        this.setLayout(new BorderLayout());
        this.hPane = new JSplitPane(1, false);
        this.vPane = new JSplitPane(0, false);
        this.vPane.setTopComponent(this.hPane);
        this.add((Component)this.vPane, "Center");
        this.addTreeView();
        this.addTableView();
        this.addInfoView();
        this.init();
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(vConsoleActionListener);
    }

    protected void addInfoView() {
        this.infoPane = new VInfoPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.infoLabel = new JLabel();
        this.infoLabel.setForeground(ResourceManager.labelColor);
        this.infoLabel.setFont(ResourceManager.labelFont);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new CompoundBorder(new LineBorder(Color.gray, 1), new EmptyBorder(2, 4, 2, 0)));
        jPanel2.setBackground(ResourceManager.reallyLightGray);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.infoLabel, "West");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.infoPane, "Center");
        this.vPane.setBottomComponent(jPanel);
    }

    protected void addTableView() {
        this.tablePane = new VTablePane();
        JTable jTable = new JTable();
        jTable.setBackground(Color.white);
        this.tablePane.setView(jTable);
        this.resultPane = new JPanel();
        this.resultPane.setLayout(new BorderLayout());
        String string = ImplResourceManager.getString((String)"SMCLoading");
        String string2 = ImplResourceManager.getString((String)"SMCWaitTxt");
        this.resultPane.add((Component)new VBusyPanel(string, string2), "Center");
        this.resultPane.setBackground(Color.white);
        this.resultPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (VConsoleNavigator.this.tablePane != null) {
                    VConsoleNavigator.this.tablePane.tableWasResized();
                }
            }
        });
        this.hPane.setRightComponent(this.resultPane);
        if (defResultPane == null) {
            defResultPane = new VDefaultResultPane();
            defResultPane.addConsoleActionListener(new VConsoleActionListener(){

                public void consoleAction(VConsoleEvent vConsoleEvent) {
                    VConsoleNavigator.this.notifyListeners(vConsoleEvent);
                }
            });
        }
    }

    protected void addTreeView() {
        this.treePane = new VTreePane();
        JTree jTree = new JTree(new Vector());
        jTree.setBackground(Color.white);
        this.treePane.setView(jTree);
        this.navPane = new JPanel();
        this.navPane.setLayout(new BorderLayout());
        this.navLabel = new JLabel();
        this.navLabel.setForeground(ResourceManager.labelColor);
        this.navLabel.setFont(ResourceManager.labelFont);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(ResourceManager.reallyLightGray);
        jPanel.setBorder(new CompoundBorder(new LineBorder(Color.gray, 1), new EmptyBorder(2, 4, 2, 0)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.navLabel, "West");
        this.navPane.add((Component)jPanel, "North");
        this.navPane.add((Component)this.treePane, "Center");
        this.navPane.setBackground(Color.white);
        this.hPane.setLeftComponent(this.navPane);
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        VScopeNode vScopeNode;
        Object object;
        String string = null;
        if (vConsoleEvent != null) {
            string = vConsoleEvent.getID();
        }
        if (string == null) {
            return;
        }
        if (string.equals("vconsole.scopeselected")) {
            this.selNode = null;
            this.treePane.setFiltered(false);
            this.tablePane.setFiltered(false);
            this.tablePane.setImage(null, -1);
            Object object2 = vConsoleEvent.getPayload();
            if (object2 != null && object2 instanceof VScopeNode) {
                Component component;
                this.selNode = (VScopeNode)object2;
                VFilter vFilter = this.selNode.getFilterControl();
                if (vFilter != null) {
                    boolean bl = vFilter.getFilterEnabled();
                    this.treePane.setFiltered(bl);
                    this.tablePane.setFiltered(bl);
                }
                if ((component = this.selNode.getResultPane()) != null) {
                    this.resultPane.removeAll();
                    this.resultPane.add(component, "Center");
                } else if (this.nodeResultPane != null) {
                    this.resultPane.removeAll();
                    this.resultPane.add((Component)this.tablePane, "Center");
                }
                this.nodeResultPane = component;
                Image image = this.selNode.getPFImage();
                if (image != null) {
                    this.tablePane.setImage(image, this.selNode.getPFImageLoc());
                }
            } else {
                this.showDefaultView();
            }
        } else if (string.equals("vconsole.updatescope")) {
            Object object3 = vConsoleEvent.getPayload();
            if (object3 != null && object3 == this.selNode) {
                Component component;
                this.treePane.setFiltered(false);
                this.tablePane.setFiltered(false);
                this.tablePane.setImage(null, -1);
                VFilter vFilter = this.selNode.getFilterControl();
                if (vFilter != null) {
                    boolean bl = vFilter.getFilterEnabled();
                    this.treePane.setFiltered(bl);
                    this.tablePane.setFiltered(bl);
                }
                if ((component = this.selNode.getResultPane()) != null) {
                    this.resultPane.removeAll();
                    this.resultPane.add(component, "Center");
                } else if (this.nodeResultPane != null) {
                    this.resultPane.removeAll();
                    this.resultPane.add((Component)this.tablePane, "Center");
                }
                this.nodeResultPane = component;
                Image image = this.selNode.getPFImage();
                if (image != null) {
                    this.tablePane.setImage(image, this.selNode.getPFImageLoc());
                }
            }
        } else if (string.equals("vconsole.filter") && (object = vConsoleEvent.getPayload()) != null && object instanceof VScopeNode && (vScopeNode = (VScopeNode)object) == this.selNode) {
            String string2;
            VFilter vFilter = vScopeNode.getFilterControl();
            boolean bl = false;
            if (vFilter != null) {
                bl = vFilter.getFilterEnabled();
            }
            if (this.properties != null && (string2 = this.properties.getProperty("vconsole.filteredstate")).equals("true")) {
                bl = true;
            }
            this.treePane.setFiltered(bl);
            this.tablePane.setFiltered(bl);
        }
        if (this.consoleModel != null) {
            this.consoleModel.consoleAction(vConsoleEvent);
        }
        if (this.infoPane != null) {
            this.infoPane.consoleAction(vConsoleEvent);
        }
        if (this.tablePane != null) {
            this.tablePane.consoleAction(vConsoleEvent);
        }
        if (this.treePane != null) {
            this.treePane.consoleAction(vConsoleEvent);
        }
        this.validate();
        this.repaint();
    }

    public boolean getInfoPaneEnabled() {
        return this.infoOn;
    }

    protected int getLayoutCase() {
        boolean bl = true;
        boolean bl2 = false;
        if (this.currentLayout == 10) {
            bl = true;
            bl2 = false;
        } else {
            bl = false;
            bl2 = true;
        }
        int n = 0;
        if (bl && this.scopeOn && this.infoOn) {
            n = 1;
        } else if (bl2 && this.scopeOn && this.infoOn) {
            n = 2;
        } else if (bl && !this.scopeOn && this.infoOn) {
            n = 3;
        } else if (bl2 && !this.scopeOn && this.infoOn) {
            n = 4;
        } else if (bl && !this.scopeOn && !this.infoOn) {
            n = 5;
        } else if (bl2 && !this.scopeOn && !this.infoOn) {
            n = 6;
        } else if (bl && this.scopeOn && !this.infoOn) {
            n = 7;
        } else if (bl2 && this.scopeOn && !this.infoOn) {
            n = 8;
        }
        return n;
    }

    public int getLayoutType() {
        return this.currentLayout;
    }

    public boolean getNavPaneEnabled() {
        return this.scopeOn;
    }

    public void init() {
        this.installStrings();
        this.hPane.setContinuousLayout(false);
        this.vPane.setContinuousLayout(false);
        this.hPane.setDividerLocation(this.hPaneLoc);
        this.vPane.setDividerLocation(this.vPaneLoc);
        this.hPane.invalidate();
        this.vPane.invalidate();
        this.hPane.validate();
        this.vPane.validate();
    }

    protected void installStrings() {
        AccessibleContext accessibleContext;
        if (this.navLabel != null) {
            this.navLabel.setText(ResourceManager.getString("Navigation"));
            this.navLabel.setDisplayedMnemonic(ResourceManager.getString("Navigation_mnemonic").charAt(0));
            accessibleContext = this.navLabel.getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("Navigation_accessible_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("Navigation_accessible_desc"));
        }
        if (this.infoLabel != null) {
            this.infoLabel.setText(ResourceManager.getString("Information"));
            this.infoLabel.setDisplayedMnemonic(ResourceManager.getString("Information_mnemonic").charAt(0));
            accessibleContext = this.infoLabel.getAccessibleContext();
            accessibleContext.setAccessibleName(ResourceManager.getString("Information_accessible_name"));
            accessibleContext.setAccessibleDescription(ResourceManager.getString("Information_accessible_desc"));
        }
    }

    public static void main(String[] stringArray) {
        Cloneable cloneable;
        ResourceManager.seed(true);
        JFrame jFrame = new JFrame();
        JDialog jDialog = new JDialog(jFrame, "Navigator Test", true);
        VConsoleNavigator vConsoleNavigator = new VConsoleNavigator();
        VScopeNode vScopeNode = new VScopeNode();
        vScopeNode.setText("Root");
        int n = 0;
        while (n < 3) {
            cloneable = new VScopeNode();
            ((VScopeNode)cloneable).setText("child " + n);
            vScopeNode.add((MutableTreeNode)((Object)cloneable));
            ++n;
        }
        cloneable = VConsoleProperties.newInstance();
        ((VConsoleProperties)cloneable).setProperty("vconsole.iconstyle", "details");
        vConsoleNavigator.setProperties((VConsoleProperties)cloneable);
        VConsoleModel vConsoleModel = new VConsoleModel(vScopeNode);
        vConsoleNavigator.setModel(vConsoleModel);
        jDialog.getContentPane().add(vConsoleNavigator);
        ((Component)jDialog).setSize(new Dimension(800, 600));
        ((Component)jDialog).setVisible(true);
        System.exit(0);
    }

    protected void modelEvent(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string == null) {
            return;
        }
        this.notifyListeners(vConsoleEvent);
    }

    protected void notifyListeners(VConsoleEvent vConsoleEvent) {
        if (vConsoleEvent == null || this.listeners == null) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            Object e = this.listeners.elementAt(n);
            ((VConsoleActionListener)e).consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        try {
            String string2 = null;
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof String) {
                string2 = (String)object;
            }
            if (string.equals("vconsole.scopepane")) {
                this.setNavPaneEnabled(string2.equals("true"));
            } else if (string.equals("vconsole.infopane")) {
                this.setInfoPaneEnabled(string2.equals("true"));
            } else if (string.equals("vconsole.layout")) {
                if (string2.equals("horizontal")) {
                    this.setLayoutType(10);
                } else if (string2.equals("vertical")) {
                    this.setLayoutType(20);
                }
            } else if (string.equals("vconsole.paintfancy")) {
                if (string2.equals("true")) {
                    this.treePane.setPaintImage(true);
                    this.tablePane.setPaintImage(true);
                } else {
                    this.treePane.setPaintImage(false);
                    this.tablePane.setPaintImage(false);
                }
            } else if (string.equals("vconsole.filteredstate")) {
                boolean bl = false;
                if (this.selNode != null) {
                    VFilter vFilter = this.selNode.getFilterControl();
                    if (vFilter != null) {
                        bl = vFilter.getFilterEnabled();
                    }
                    if (string2.equals("true")) {
                        bl = true;
                    }
                }
                this.treePane.setFiltered(bl);
                this.tablePane.setFiltered(bl);
            } else if (string.equals("vconsole.labelfont")) {
                this.navLabel.setFont((Font)object);
                this.infoLabel.setFont((Font)object);
                this.navLabel.validate();
                this.navLabel.repaint();
                this.infoLabel.validate();
                this.infoLabel.repaint();
            } else if (string.equals("vconsole.labelcolor")) {
                this.navLabel.setForeground((Color)object);
                this.infoLabel.setForeground((Color)object);
                this.navLabel.validate();
                this.navLabel.repaint();
                this.infoLabel.validate();
                this.infoLabel.repaint();
            }
        }
        catch (Throwable throwable) {}
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        if (this.navPane != null) {
            this.navPane.setBackground(color);
        }
        if (this.resultPane != null) {
            this.resultPane.setBackground(color);
        }
    }

    public void setInfoPaneEnabled(boolean bl) {
        if (this.infoOn == bl) {
            return;
        }
        switch (this.getLayoutCase()) {
            case 1: {
                this.vPaneLoc = this.vPane.getDividerLocation();
                this.tempVPane = this.vPane.getTopComponent();
                this.remove(this.vPane);
                this.add(this.tempVPane, "Center");
                this.infoOn = false;
                this.validate();
                this.repaint();
                break;
            }
            case 2: {
                this.vPaneLoc = this.vPane.getDividerLocation();
                this.tempVPane = this.vPane.getTopComponent();
                this.hPane.setRightComponent(this.tempVPane);
                this.infoOn = false;
                this.validate();
                this.repaint();
                break;
            }
            case 3: {
                this.vPaneLoc = this.vPane.getDividerLocation();
                this.tempVPane = this.vPane.getTopComponent();
                this.remove(this.vPane);
                this.add(this.tempVPane, "Center");
                this.centerPane = this.tempVPane;
                this.infoOn = false;
                this.validate();
                this.repaint();
                break;
            }
            case 4: {
                this.vPaneLoc = this.vPane.getDividerLocation();
                this.tempVPane = this.vPane.getTopComponent();
                this.remove(this.vPane);
                this.add(this.tempVPane, "Center");
                this.centerPane = this.tempVPane;
                this.infoOn = false;
                this.validate();
                this.repaint();
                break;
            }
            case 5: {
                this.remove(this.centerPane);
                this.vPane.setTopComponent(this.centerPane);
                this.add((Component)this.vPane, "Center");
                this.infoOn = true;
                this.validate();
                this.repaint();
                this.vPane.setDividerLocation(this.vPaneLoc);
                this.vPane.invalidate();
                this.vPane.validate();
                break;
            }
            case 6: {
                this.remove(this.centerPane);
                this.vPane.setTopComponent(this.centerPane);
                this.add((Component)this.vPane, "Center");
                this.infoOn = true;
                this.validate();
                this.repaint();
                this.vPane.setDividerLocation(this.vPaneLoc);
                this.vPane.invalidate();
                this.vPane.validate();
                break;
            }
            case 7: {
                this.remove(this.hPane);
                this.vPane.setTopComponent(this.hPane);
                this.add((Component)this.vPane, "Center");
                this.infoOn = true;
                this.validate();
                this.repaint();
                this.vPane.setDividerLocation(this.vPaneLoc);
                this.vPane.invalidate();
                this.vPane.validate();
                break;
            }
            case 8: {
                this.tempHPane = this.hPane.getRightComponent();
                this.vPane.setTopComponent(this.tempHPane);
                this.hPane.setRightComponent(this.vPane);
                this.infoOn = true;
                this.validate();
                this.repaint();
                this.vPane.setDividerLocation(this.vPaneLoc);
                this.vPane.invalidate();
                this.vPane.validate();
                break;
            }
            default: {
                System.err.println("Unexpected layout condition.");
            }
        }
    }

    public void setLayoutType(int n) {
        if (n == this.currentLayout) {
            return;
        }
        if (n != 10 && n != 20) {
            return;
        }
        switch (this.getLayoutCase()) {
            case 1: {
                int n2;
                int n3 = this.vPane.getDividerLocation();
                if (n3 != 0) {
                    this.vPaneLoc = n3;
                }
                if ((n2 = this.hPane.getDividerLocation()) != 0) {
                    this.hPaneLoc = n2;
                }
                this.remove(this.vPane);
                this.tempHPane = this.hPane.getRightComponent();
                this.vPane.setTopComponent(this.tempHPane);
                this.hPane.setRightComponent(this.vPane);
                this.add((Component)this.hPane, "Center");
                this.currentLayout = 20;
                this.validate();
                this.repaint();
                this.hPane.setDividerLocation(this.hPaneLoc);
                this.hPane.invalidate();
                this.hPane.validate();
                this.vPane.setDividerLocation(this.vPaneLoc);
                this.vPane.invalidate();
                this.vPane.validate();
                break;
            }
            case 2: {
                int n4;
                int n5 = this.vPane.getDividerLocation();
                if (n5 != 0) {
                    this.vPaneLoc = n5;
                }
                if ((n4 = this.hPane.getDividerLocation()) != 0) {
                    this.hPaneLoc = n4;
                }
                this.remove(this.hPane);
                this.tempVPane = this.vPane.getTopComponent();
                this.hPane.setRightComponent(this.tempVPane);
                this.vPane.setTopComponent(this.hPane);
                this.add((Component)this.vPane, "Center");
                this.currentLayout = 10;
                this.validate();
                this.repaint();
                this.vPane.setDividerLocation(this.vPaneLoc);
                this.vPane.invalidate();
                this.vPane.validate();
                this.hPane.setDividerLocation(this.hPaneLoc);
                this.hPane.invalidate();
                this.hPane.validate();
                break;
            }
            case 3: {
                this.currentLayout = 20;
                break;
            }
            case 4: {
                this.currentLayout = 10;
                break;
            }
            case 5: {
                this.currentLayout = 20;
                break;
            }
            case 6: {
                this.currentLayout = 10;
                break;
            }
            case 7: {
                this.currentLayout = 20;
                break;
            }
            case 8: {
                this.currentLayout = 10;
                break;
            }
            default: {
                System.err.println("Unexpected layout condition.");
            }
        }
    }

    public void setModel(VConsoleModel vConsoleModel) {
        this.consoleModel = vConsoleModel;
        if (vConsoleModel != null) {
            vConsoleModel.setProperties(this.properties);
            vConsoleModel.addConsoleActionListener(new VConsoleActionListener(){

                public void consoleAction(VConsoleEvent vConsoleEvent) {
                    VConsoleNavigator.this.modelEvent(vConsoleEvent);
                }
            });
        }
        if (this.treePane != null) {
            this.treePane.setModel(vConsoleModel);
            this.treePane.setProperties(this.properties);
        }
        if (this.tablePane != null) {
            this.tablePane.setModel(vConsoleModel);
            this.tablePane.setProperties(this.properties);
        }
        this.validate();
        this.repaint();
    }

    public void setNavPaneEnabled(boolean bl) {
        if (this.scopeOn == bl) {
            return;
        }
        switch (this.getLayoutCase()) {
            case 1: {
                this.hPaneLoc = this.hPane.getDividerLocation();
                this.tempHPane = this.hPane.getRightComponent();
                this.vPane.setTopComponent(this.tempHPane);
                this.scopeOn = false;
                this.validate();
                this.repaint();
                break;
            }
            case 2: {
                this.hPaneLoc = this.hPane.getDividerLocation();
                this.tempHPane = this.hPane.getRightComponent();
                this.remove(this.hPane);
                this.add(this.tempHPane, "Center");
                this.scopeOn = false;
                this.validate();
                this.repaint();
                break;
            }
            case 3: {
                this.vPaneLoc = this.vPane.getDividerLocation();
                this.tempVPane = this.vPane.getTopComponent();
                this.hPane.setRightComponent(this.tempVPane);
                this.vPane.setTopComponent(this.hPane);
                this.scopeOn = true;
                this.validate();
                this.repaint();
                this.hPane.setDividerLocation(this.hPaneLoc);
                this.hPane.invalidate();
                this.hPane.validate();
                this.vPane.setDividerLocation(this.vPaneLoc);
                this.vPane.invalidate();
                this.vPane.validate();
                break;
            }
            case 4: {
                this.remove(this.vPane);
                this.hPane.setRightComponent(this.vPane);
                this.add((Component)this.hPane, "Center");
                this.scopeOn = true;
                this.validate();
                this.repaint();
                this.hPane.setDividerLocation(this.hPaneLoc);
                this.hPane.invalidate();
                this.hPane.validate();
                break;
            }
            case 5: {
                this.remove(this.centerPane);
                this.hPane.setRightComponent(this.centerPane);
                this.add((Component)this.hPane, "Center");
                this.scopeOn = true;
                this.validate();
                this.repaint();
                this.hPane.setDividerLocation(this.hPaneLoc);
                this.hPane.invalidate();
                this.hPane.validate();
                break;
            }
            case 6: {
                this.remove(this.centerPane);
                this.hPane.setRightComponent(this.centerPane);
                this.add((Component)this.hPane, "Center");
                this.scopeOn = true;
                this.validate();
                this.repaint();
                this.hPane.setDividerLocation(this.hPaneLoc);
                this.hPane.invalidate();
                this.hPane.validate();
                break;
            }
            case 7: {
                this.tempHPane = this.hPane.getRightComponent();
                this.hPaneLoc = this.hPane.getDividerLocation();
                this.remove(this.hPane);
                this.add(this.tempHPane, "Center");
                this.centerPane = this.tempHPane;
                this.scopeOn = false;
                this.validate();
                this.repaint();
                break;
            }
            case 8: {
                this.tempHPane = this.hPane.getRightComponent();
                this.hPaneLoc = this.hPane.getDividerLocation();
                this.remove(this.hPane);
                this.add(this.tempHPane, "Center");
                this.centerPane = this.tempHPane;
                this.scopeOn = false;
                this.validate();
                this.repaint();
                break;
            }
            default: {
                System.err.println("Unexpected layout condition.");
            }
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (this.consoleModel != null) {
            this.consoleModel.setProperties(vConsoleProperties);
        }
        if (this.treePane != null) {
            this.treePane.setProperties(vConsoleProperties);
        }
        if (this.tablePane != null) {
            this.tablePane.setProperties(vConsoleProperties);
        }
        if (this.infoPane != null) {
            this.infoPane.setProperties(vConsoleProperties);
        }
        if (vConsoleProperties != null) {
            vConsoleProperties.addPropertyChangeListener(this);
            this.syncProperties();
        }
    }

    protected void showDefaultView() {
        try {
            this.resultPane.removeAll();
            this.resultPane.add((Component)defResultPane, "Center");
            this.nodeResultPane = defResultPane;
        }
        catch (Throwable throwable) {
            Debug.trace("ConsoleNavigator", Debug.WARNING, "Problem showing default view", throwable);
        }
    }

    protected void syncProperties() {
        if (this.properties == null) {
            return;
        }
        try {
            String string = this.properties.getProperty("vconsole.scopepane");
            this.setNavPaneEnabled(string.equals("true"));
            string = this.properties.getProperty("vconsole.infopane");
            this.setInfoPaneEnabled(string.equals("true"));
            string = this.properties.getProperty("vconsole.layout");
            if (string.equals("horizontal")) {
                this.setLayoutType(10);
            } else if (string.equals("vertical")) {
                this.setLayoutType(20);
            }
            string = this.properties.getProperty("vconsole.paintfancy");
            if (string.equals("true")) {
                this.tablePane.setPaintImage(true);
            }
        }
        catch (Throwable throwable) {}
    }

    class resizeListener
    extends ComponentAdapter {
        resizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n = VConsoleNavigator.this.vPane.getMaximumDividerLocation();
            int n2 = n - VConsoleNavigator.this.INFOHEIGHT;
            VConsoleNavigator.this.vPane.setDividerLocation(n2);
            VConsoleNavigator.this.vPane.invalidate();
            VConsoleNavigator.this.vPane.validate();
        }
    }
}

